/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a@\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0000\u0012\u00020\b\u0018\u00010\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u001a6\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0000\u0012\u00020\b\u0018\u00010\u0013H\u0002\u001a\u001a\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"CLOSE_LISTENER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/content/ContentManagerListener;", "EXECUTOR_KEY", "Lcom/intellij/execution/Executor;", "canReuseContent", "", "c", "Lcom/intellij/ui/content/Content;", "executionId", "", "chooseReuseContentForDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "descriptor", "preferredName", "", "reuseCondition", "Ljava/util/function/Predicate;", "createNewContent", "executor", "getContentFromManager", "getRunContentByDescriptor", "getToolWindowIdForRunner", "isAlive", "intellij.platform.execution.impl"})
public final class RunContentManagerImplKt {
    private static final Key<Executor> EXECUTOR_KEY;
    private static final Key<ContentManagerListener> CLOSE_LISTENER_KEY;

    private static final RunContentDescriptor chooseReuseContentForDescriptor(ContentManager contentManager2, RunContentDescriptor descriptor2, long executionId, String preferredName, Predicate<? super Content> reuseCondition) {
        Content content2 = null;
        if (descriptor2 != null) {
            if (descriptor2.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor2.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && contentManager2.getIndexOfContent(attachedContent) != -1 && (Intrinsics.areEqual((Object)descriptor2.getDisplayName(), (Object)attachedContent.getDisplayName()) || !attachedContent.isPinned())) {
                content2 = attachedContent;
            }
        }
        if (content2 == null) {
            content2 = RunContentManagerImplKt.getContentFromManager(contentManager2, preferredName, executionId, reuseCondition);
        }
        if (content2 == null || !RunContentManagerImpl.Companion.isTerminated(content2) || content2.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor runContentDescriptor = RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content2);
        if (runContentDescriptor == null) {
            return null;
        }
        RunContentDescriptor oldDescriptor = runContentDescriptor;
        if (oldDescriptor.isContentReuseProhibited()) {
            return null;
        }
        if (descriptor2 == null || oldDescriptor.getReusePolicy().canBeReusedBy(descriptor2)) {
            return oldDescriptor;
        }
        return null;
    }

    private static final Content getContentFromManager(ContentManager contentManager2, String preferredName, long executionId, Predicate<? super Content> reuseCondition) {
        Object v3;
        block4: {
            Object[] objectArray = contentManager2.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"contentManager.contents");
            List contents = ArraysKt.toMutableList((Object[])objectArray);
            Content first = contentManager2.getSelectedContent();
            if (first != null && contents.remove(first)) {
                contents.add(0, first);
            }
            if (preferredName != null) {
                Iterator iterator2 = contents.iterator();
                while (iterator2.hasNext()) {
                    Content c;
                    Content content2 = c = (Content)iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"c");
                    if (!RunContentManagerImplKt.canReuseContent(content2, executionId) || !Intrinsics.areEqual((Object)preferredName, (Object)c.getDisplayName())) continue;
                    return c;
                }
            }
            Iterable $this$firstOrNull$iv = contents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                Content content3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"it");
                if (!(RunContentManagerImplKt.canReuseContent(content3, executionId) && (reuseCondition == null || reuseCondition.test((Content)it)))) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    private static final boolean canReuseContent(Content c, long executionId) {
        return !c.isPinned() && RunContentManagerImpl.Companion.isTerminated(c) && (c.getExecutionId() != executionId || executionId == 0L);
    }

    private static final String getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor2) {
        Object object = descriptor2;
        if (object == null || (object = object.getContentToolWindowId()) == null) {
            String string = executor.getToolWindowId();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executor.toolWindowId");
        }
        return object;
    }

    private static final Content createNewContent(RunContentDescriptor descriptor2, Executor executor) {
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(descriptor2.getComponent(), descriptor2.getDisplayName(), true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"ContentFactory.SERVICE.g\u2026riptor.displayName, true)");
        Content content3 = content2;
        content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        Icon icon2 = descriptor2.getIcon();
        if (icon2 == null) {
            icon2 = executor.getToolWindowIcon();
        }
        content3.setIcon(icon2);
        return content3;
    }

    private static final Content getRunContentByDescriptor(ContentManager contentManager2, RunContentDescriptor descriptor2) {
        Content content2;
        block1: {
            Content[] contentArray = contentManager2.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            Content[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            Content[] contentArray2 = $this$firstOrNull$iv;
            int n = contentArray2.length;
            for (int j = 0; j < n; ++j) {
                Content element$iv;
                Content it = element$iv = contentArray2[j];
                boolean bl = false;
                Content content3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"it");
                if (!Intrinsics.areEqual((Object)descriptor2, (Object)RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content3))) continue;
                content2 = element$iv;
                break block1;
            }
            content2 = null;
        }
        return content2;
    }

    private static final boolean isAlive(ContentManager contentManager2) {
        boolean bl;
        block1: {
            Content[] contentArray = contentManager2.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            Content[] $this$any$iv = contentArray;
            boolean $i$f$any = false;
            Content[] contentArray2 = $this$any$iv;
            int n = contentArray2.length;
            for (int j = 0; j < n; ++j) {
                Content element$iv;
                Content it = element$iv = contentArray2[j];
                boolean bl2 = false;
                Content content2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"it");
                RunContentDescriptor descriptor2 = RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content2);
                if (!(descriptor2 != null && RunContentManagerImplKt.isAlive(descriptor2))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isAlive(RunContentDescriptor descriptor2) {
        ProcessHandler handler2 = descriptor2.getProcessHandler();
        return handler2 != null && !handler2.isProcessTerminated();
    }

    static {
        Key key = Key.create((String)"Executor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"Executor\")");
        EXECUTOR_KEY = key;
        Key key2 = Key.create((String)"CloseListener");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"CloseListener\")");
        CLOSE_LISTENER_KEY = key2;
    }

    public static final /* synthetic */ Content access$getRunContentByDescriptor(ContentManager contentManager2, RunContentDescriptor descriptor2) {
        return RunContentManagerImplKt.getRunContentByDescriptor(contentManager2, descriptor2);
    }

    public static final /* synthetic */ String access$getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor2) {
        return RunContentManagerImplKt.getToolWindowIdForRunner(executor, descriptor2);
    }

    public static final /* synthetic */ RunContentDescriptor access$chooseReuseContentForDescriptor(ContentManager contentManager2, RunContentDescriptor descriptor2, long executionId, String preferredName, Predicate reuseCondition) {
        return RunContentManagerImplKt.chooseReuseContentForDescriptor(contentManager2, descriptor2, executionId, preferredName, reuseCondition);
    }

    public static final /* synthetic */ Content access$createNewContent(RunContentDescriptor descriptor2, Executor executor) {
        return RunContentManagerImplKt.createNewContent(descriptor2, executor);
    }

    public static final /* synthetic */ Key access$getEXECUTOR_KEY$p() {
        return EXECUTOR_KEY;
    }

    public static final /* synthetic */ boolean access$isAlive(ContentManager contentManager2) {
        return RunContentManagerImplKt.isAlive(contentManager2);
    }

    public static final /* synthetic */ Key access$getCLOSE_LISTENER_KEY$p() {
        return CLOSE_LISTENER_KEY;
    }

    public static final /* synthetic */ boolean access$isAlive(RunContentDescriptor descriptor2) {
        return RunContentManagerImplKt.isAlive(descriptor2);
    }
}

