/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.FragmentedSettingsEditor;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public abstract class RunConfigurationFragmentedEditor<Settings extends RunConfigurationBase<?>>
extends FragmentedSettingsEditor<Settings> {
    private static final Logger LOG = Logger.getInstance(RunConfigurationFragmentedEditor.class);
    private final RunConfigurationExtensionsManager<RunConfigurationBase<?>, RunConfigurationExtensionBase<RunConfigurationBase<?>>> myExtensionsManager;
    private boolean myDefaultSettings;

    protected RunConfigurationFragmentedEditor(Settings runConfiguration, RunConfigurationExtensionsManager extensionsManager) {
        super(runConfiguration);
        this.myExtensionsManager = extensionsManager;
    }

    protected boolean isDefaultSettings() {
        return this.myDefaultSettings;
    }

    @NotNull
    protected Project getProject() {
        Project project = ((RunConfigurationBase)this.mySettings).getProject();
        if (project == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(0);
        }
        return project;
    }

    protected final List<SettingsEditorFragment<Settings, ?>> createFragments() {
        ArrayList fragments = new ArrayList(this.createRunFragments());
        for (SettingsEditorFragment wrapper2 : this.myExtensionsManager.createFragments((RunConfigurationBase)this.mySettings)) {
            fragments.add(wrapper2);
        }
        this.addRunnerSettingsEditors(fragments);
        String configId = ((RunConfigurationBase)this.mySettings).getType().getId();
        for (SettingsEditorFragment settingsEditorFragment : fragments) {
            settingsEditorFragment.setConfigId(configId);
        }
        return fragments;
    }

    private void addRunnerSettingsEditors(List<? super SettingsEditorFragment<Settings, ?>> fragments) {
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            final ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)this.mySettings));
            if (runner == null) continue;
            final SettingsEditor configEditor = ((RunConfigurationBase)this.mySettings).getRunnerSettingsEditor(runner);
            final SettingsEditor runnerEditor = runner.getSettingsEditor(executor, (RunConfiguration)this.mySettings);
            if (configEditor == null && runnerEditor == null) continue;
            JPanel component2 = new JPanel(new BorderLayout());
            component2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)executor.getStartActionText(), (boolean)false));
            if (configEditor != null) {
                component2.add((Component)configEditor.getComponent(), "Center");
            }
            if (runnerEditor != null) {
                component2.add((Component)runnerEditor.getComponent(), configEditor == null ? "Center" : "South");
            }
            RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<Settings, JComponent>(executor.getId() + ".config", executor.getStartActionText(), ExecutionBundle.message((String)"run.configuration.startup.connection.rab.title", (Object[])new Object[0]), component2, 0, settings -> false){

                @Override
                public void doReset(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    if (s == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (configEditor != null) {
                        configEditor.resetFrom((Object)s.getConfigurationSettings(runner));
                    }
                    if (runnerEditor != null) {
                        runnerEditor.resetFrom(s.getRunnerSettings(runner));
                    }
                }

                @Override
                public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    if (s == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    try {
                        if (configEditor != null) {
                            configEditor.applyTo((Object)s.getConfigurationSettings(runner));
                        }
                        if (runnerEditor != null) {
                            runnerEditor.applyTo(s.getRunnerSettings(runner));
                        }
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "s";
                    objectArray2[1] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "doReset";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applyEditorTo";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (configEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)configEditor);
            }
            if (runnerEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)runnerEditor);
            }
            fragments.add(fragment);
        }
    }

    protected abstract List<SettingsEditorFragment<Settings, ?>> createRunFragments();

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(1);
        }
        this.myDefaultSettings = s.isTemplate();
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.resetEditorFrom(s);
        }
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(2);
        }
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.applyEditorTo(s);
        }
    }

    @NotNull
    private @NotNull List<@NotNull RunConfigurationEditorFragment<?, ?>> getRunFragments() {
        List list2 = ContainerUtil.mapNotNull((Collection)this.getFragments(), fragment -> fragment instanceof RunConfigurationEditorFragment ? (RunConfigurationEditorFragment)((Object)fragment) : null);
        if (list2 == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void targetChanged(String targetName) {
        SettingsEditorFragment targetPathFragment = (SettingsEditorFragment)ContainerUtil.find((Iterable)this.getFragments(), fragment -> "target.project.path".equals(fragment.getId()));
        if (targetPathFragment != null) {
            targetPathFragment.setSelected(targetName != null);
        }
    }

    protected void initFragments(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments) {
        for (final SettingsEditorFragment<Settings, ?> fragment : fragments) {
            JComponent component2 = fragment.getEditorComponent();
            if (component2 == null) continue;
            component2.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    RunConfigurationFragmentedEditor.this.checkGotIt(fragment);
                }
            });
        }
    }

    private void checkGotIt(SettingsEditorFragment<Settings, ?> fragment) {
        if (!this.isDefaultSettings() && !fragment.isCanBeHidden() && !fragment.isTag() && StringUtil.isNotEmpty((String)fragment.getName())) {
            RunConfigurationBase clone = (RunConfigurationBase)((RunConfigurationBase)this.mySettings).clone();
            fragment.applyEditorTo((Object)clone);
            if (!fragment.isInitiallyVisible((Object)clone)) {
                JComponent component2 = fragment.getEditorComponent();
                String text2 = fragment.getName().replace("\u001b", "");
                new GotItTooltip("fragment.hidden." + fragment.getId(), ExecutionBundle.message((String)"gotIt.popup.message", (Object[])new Object[]{text2}), (Disposable)fragment).withHeader(ExecutionBundle.message((String)"gotIt.popup.title", (Object[])new Object[0])).show(component2, (Function1<? super Component, ? extends Point>)((Function1)c -> new Point(GotItTooltip.ARROW_SHIFT, c.getHeight())));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunFragments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

