/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.FragmentedSettingsUtil;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonParameterFragments<Settings extends CommonProgramRunConfigurationParameters> {
    private final List<SettingsEditorFragment<Settings, ?>> myFragments;
    private final SettingsEditorFragment<Settings, LabeledComponent<TextFieldWithBrowseButton>> myWorkingDirectory;
    private final Computable<Boolean> myHasModule;

    public CommonParameterFragments(@NotNull Project project, Computable<Boolean> hasModule) {
        if (project == null) {
            CommonParameterFragments.$$$reportNull$$$0(0);
        }
        this.myFragments = new ArrayList();
        this.myHasModule = hasModule;
        TextFieldWithBrowseButton workingDirectoryField = new TextFieldWithBrowseButton();
        workingDirectoryField.addBrowseFolderListener(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        MacrosDialog.addMacroSupport((ExtendableTextField)workingDirectoryField.getTextField(), MacrosDialog.Filters.DIRECTORY_PATH, hasModule);
        LabeledComponent field = LabeledComponent.create((JComponent)workingDirectoryField, (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        field.setLabelLocation("West");
        this.myWorkingDirectory = new SettingsEditorFragment("workingDirectory", null, null, (JComponent)field, (settings, component2) -> ((TextFieldWithBrowseButton)component2.getComponent()).setText(settings.getWorkingDirectory()), (settings, component2) -> settings.setWorkingDirectory(((TextFieldWithBrowseButton)component2.getComponent()).getText()), settings -> true);
        this.myWorkingDirectory.setRemovable(false);
        this.myFragments.add(this.myWorkingDirectory);
        this.myFragments.add(CommonParameterFragments.createEnvParameters());
    }

    @NotNull
    public SettingsEditorFragment<Settings, RawCommandLineEditor> programArguments() {
        RawCommandLineEditor programArguments = new RawCommandLineEditor();
        CommandLinePanel.setMinimumWidth((Component)programArguments, (int)400);
        String message2 = ExecutionBundle.message((String)"run.configuration.program.parameters.placeholder", (Object[])new Object[0]);
        programArguments.getEditorField().getEmptyText().setText(message2);
        programArguments.getEditorField().getAccessibleContext().setAccessibleName(message2);
        FragmentedSettingsUtil.setupPlaceholderVisibility((JBTextField)programArguments.getEditorField());
        CommonParameterFragments.setMonospaced(programArguments.getTextField());
        MacrosDialog.addMacroSupport((ExtendableTextField)programArguments.getEditorField(), MacrosDialog.Filters.ALL, this.myHasModule);
        SettingsEditorFragment parameters2 = new SettingsEditorFragment("commandLineParameters", ExecutionBundle.message((String)"run.configuration.program.parameters.name", (Object[])new Object[0]), null, (JComponent)programArguments, 100, (settings, component2) -> component2.setText(settings.getProgramParameters()), (settings, component2) -> settings.setProgramParameters(component2.getText()), settings -> true);
        parameters2.setRemovable(false);
        parameters2.setEditorGetter(editor -> editor.getEditorField());
        parameters2.setHint(ExecutionBundle.message((String)"run.configuration.program.parameters.hint", (Object[])new Object[0]));
        SettingsEditorFragment settingsEditorFragment = parameters2;
        if (settingsEditorFragment == null) {
            CommonParameterFragments.$$$reportNull$$$0(1);
        }
        return settingsEditorFragment;
    }

    public List<SettingsEditorFragment<Settings, ?>> getFragments() {
        return this.myFragments;
    }

    public <S extends InputRedirectAware> SettingsEditorFragment<S, ?> createRedirectFragment() {
        TextFieldWithBrowseButton inputFile = new TextFieldWithBrowseButton();
        inputFile.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(null, null, (ComponentWithBrowseButton)inputFile, null, FileChooserDescriptorFactory.createSingleFileDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initialFile = super.getInitialFile();
                if (initialFile != null) {
                    return initialFile;
                }
                String text2 = ((TextFieldWithBrowseButton)((LabeledComponent)CommonParameterFragments.this.myWorkingDirectory.component()).getComponent()).getText();
                return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)text2));
            }
        });
        MacrosDialog.addMacroSupport((ExtendableTextField)inputFile.getTextField(), MacrosDialog.Filters.ALL, this.myHasModule);
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)inputFile, (String)ExecutionBundle.message((String)"redirect.input.from", (Object[])new Object[0]));
        labeledComponent.setLabelLocation("West");
        SettingsEditorFragment redirectInput = new SettingsEditorFragment("redirectInput", ExecutionBundle.message((String)"redirect.input.from.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)labeledComponent, (settings, component2) -> ((TextFieldWithBrowseButton)component2.getComponent()).setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)settings.getInputRedirectOptions().getRedirectInputPath()))), (settings, component2) -> {
            String filePath = ((TextFieldWithBrowseButton)component2.getComponent()).getText();
            settings.getInputRedirectOptions().setRedirectInput(component2.isVisible() && StringUtil.isNotEmpty((String)filePath));
            settings.getInputRedirectOptions().setRedirectInputPath(StringUtil.isEmpty((String)filePath) ? null : FileUtil.toSystemIndependentName((String)filePath));
        }, settings -> StringUtil.isNotEmpty((String)settings.getInputRedirectOptions().getRedirectInputPath()));
        redirectInput.setActionHint(ExecutionBundle.message((String)"read.input.from.the.specified.file", (Object[])new Object[0]));
        return redirectInput;
    }

    public static <S extends CommonProgramRunConfigurationParameters> SettingsEditorFragment<S, ?> createEnvParameters() {
        EnvironmentVariablesComponent env = new EnvironmentVariablesComponent();
        env.setLabelLocation("West");
        CommonParameterFragments.setMonospaced(((TextFieldWithBrowseButton)env.getComponent()).getTextField());
        SettingsEditorFragment fragment = new SettingsEditorFragment("environmentVariables", ExecutionBundle.message((String)"environment.variables.fragment.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)((Object)env), (settings, c) -> env.reset((CommonProgramRunConfigurationParameters)settings), (settings, c) -> {
            if (!env.isVisible()) {
                settings.setEnvs(Collections.emptyMap());
                settings.setPassParentEnvs(true);
            } else {
                env.apply((CommonProgramRunConfigurationParameters)settings);
            }
        }, s -> true);
        fragment.setCanBeHidden(true);
        fragment.setHint(ExecutionBundle.message((String)"environment.variables.fragment.hint", (Object[])new Object[0]));
        fragment.setActionHint(ExecutionBundle.message((String)"set.custom.environment.variables.for.the.process", (Object[])new Object[0]));
        return fragment;
    }

    public static void setMonospaced(Component field) {
        field.setFont(EditorUtil.getEditorFont(JBUI.Fonts.label().getSize()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/CommonParameterFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/CommonParameterFragments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "programArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

