/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestStackTraceParser;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    public static final String HISTORY_DATE_FORMAT = "yyyy.MM.dd 'at' HH'h' mm'm' ss's'";
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    private static final Logger LOG = Logger.getInstance(SMTestRunnerResultsForm.class);
    private SMTRunnerTestTreeView myTreeView;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final List<TestResultsViewer.EventsListener> myEventListeners;
    private final Project myProject;
    private final ConsoleView myConsoleView;
    private int myTotalTestCount;
    private int myStartedTestCount;
    private int myFinishedTestCount;
    private int myFailedTestCount;
    private int myIgnoredTestCount;
    private long myStartTime;
    private long myEndTime;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories;
    private volatile boolean myTestsRunning;
    private volatile AbstractTestProxy myLastSelected;
    private volatile boolean myDisposed;
    private SMTestProxy myLastFailed;
    private final Set<Update> myRequests;
    private final Alarm myUpdateTreeRequests;

    public SMTestRunnerResultsForm(@NotNull ConsoleView consoleView, @NotNull TestConsoleProperties consoleProperties, @Nullable String splitterPropertyName) {
        if (consoleView == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(1);
        }
        super(consoleView.getComponent(), consoleView.createConsoleActions(), consoleProperties, StringUtil.notNullize((String)splitterPropertyName, (String)DEFAULT_SM_RUNNER_SPLITTER_PROPERTY), 0.2f);
        this.myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myTestsRunning = true;
        this.myDisposed = false;
        this.myRequests = Collections.synchronizedSet(new HashSet());
        this.myUpdateTreeRequests = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProject = consoleProperties.getProject();
        this.myConsoleView = consoleView;
        this.myTestsRootNode = new SMTestProxy.SMRootTestProxy(consoleProperties.isPreservePresentableName(), consoleView.getComponent());
        this.myTestsRootNode.setTestConsoleProperties(consoleProperties);
    }

    @Override
    protected ToolbarPanel createToolbarPanel() {
        return new SMTRunnerToolbarPanel(this.myProperties, this, this);
    }

    @Override
    protected JComponent createTestTreeView() {
        this.myTreeView = new SMTRunnerTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        StructureTreeModel<SMTRunnerTreeStructure> structureTreeModel = new StructureTreeModel<SMTRunnerTreeStructure>(structure, (Comparator<NodeDescriptor<?>>)IndexComparator.INSTANCE, (Disposable)this.myProject);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)structureTreeModel), true, (Disposable)this.myProject);
        this.myTreeView.setModel((TreeModel)((Object)asyncTreeModel));
        this.myTreeBuilder.setModel(structureTreeModel);
        this.myTreeBuilder.setTestsComparator(this);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        Disposer.register((Disposable)this, (Disposable)asyncTreeModel);
        TrackRunningTestUtil.installStopListeners((JTree)((Object)this.myTreeView), (Disposable)this.myProperties, testProxy -> {
            Navigatable descriptor2;
            if (testProxy == null) {
                return;
            }
            this.setLastSelected((AbstractTestProxy)testProxy);
            if (ScrollToTestSourceAction.isScrollEnabled(this) && (descriptor2 = TestsUIUtil.getOpenFileDescriptor(testProxy, this)) != null) {
                OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{descriptor2});
            }
        });
        return this.myTreeView;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener2) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener2);
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(2);
        }
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myTestsRunning = true;
        this.myLastFailed = null;
        this.setLastSelected(null);
        this.myMentionedCategories.clear();
        if (this.myEndTime != 0L) {
            this.resetTreeAndConsoleOnSubsequentTestingStarted();
            this.myEndTime = 0L;
        }
        this.myTreeBuilder.updateFromRoot();
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        boolean printTestingStartedTime = true;
        if (this.myProperties instanceof SMTRunnerConsoleProperties) {
            printTestingStartedTime = ((SMTRunnerConsoleProperties)this.myProperties).isPrintTestingStartedTime();
        }
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.myStatusLine.setIndeterminate(this.isUndefined());
        this.fireOnTestingStarted();
    }

    private void resetTreeAndConsoleOnSubsequentTestingStarted() {
        this.myTestsRootNode.testingRestarted();
        this.myConsoleView.clear();
        ProcessHandler handler2 = this.myTestsRootNode.getHandler();
        if (handler2 instanceof BaseOSProcessHandler) {
            handler2.notifyTextAvailable(((BaseOSProcessHandler)handler2).getCommandLine() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(3);
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress(true);
        this.myRequests.clear();
        this.myUpdateTreeRequests.cancelAllRequests();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel(this);
        if (this.myLastSelected == null) {
            this.selectAndNotify(this.myTestsRootNode);
        }
        this.myTestsRunning = false;
        if (TestConsoleProperties.SORT_BY_DURATION.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.setTestsComparator(this);
        }
        this.fireOnTestingFinished();
        if (testsRoot.wasTerminated() && this.myStatusLine.getStatusColor() == ColorProgressBar.GREEN) {
            this.myStatusLine.setStatusColor((Color)JBColor.LIGHT_GRAY);
        }
        if (testsRoot.isEmptySuite() && testsRoot.isTestsReporterAttached() && this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).fixEmptySuite()) {
            return;
        }
        TestsUIUtil.TestResultPresentation presentation2 = new TestsUIUtil.TestResultPresentation(testsRoot, this.myStartTime > 0L, null).getPresentation(this.myFailedTestCount, Math.max(0, this.myFinishedTestCount - this.myFailedTestCount - this.myIgnoredTestCount), this.myTotalTestCount - this.myStartedTestCount, this.myIgnoredTestCount);
        UIUtil.invokeLaterIfNeeded(() -> {
            TestsUIUtil.notifyByBalloon(this.myProperties.getProject(), testsRoot, this.myProperties, presentation2);
            this.addToHistory(testsRoot, this.myProperties, this);
        });
    }

    private void addToHistory(SMTestProxy.SMRootTestProxy root, TestConsoleProperties consoleProperties, Disposable parentDisposable) {
        RunProfile configuration2 = consoleProperties.getConfiguration();
        if (configuration2 instanceof RunConfiguration && !(consoleProperties instanceof ImportedTestConsoleProperties) && !this.myDisposed) {
            final MySaveHistoryTask backgroundable = new MySaveHistoryTask(consoleProperties, root, (RunConfiguration)configuration2);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    backgroundable.dispose();
                }
            });
            ProgressManager.getInstance().run((Task)backgroundable);
        }
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(4);
        }
        if (!testProxy.isConfig() && !"Class Configuration".equals(testProxy.getName())) {
            this.updateOnTestStarted(false);
        }
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onSuiteTreeNodeAdded(SMTestProxy testProxy) {
        if (!testProxy.isSuite()) {
            ++this.myTotalTestCount;
        }
    }

    @Override
    public void onSuiteTreeStarted(SMTestProxy suite) {
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(5);
        }
        if (Comparing.equal((Object)test, (Object)this.myLastFailed)) {
            return;
        }
        this.myLastFailed = test;
        this.updateOnTestFailed(false);
        if (test.isConfig()) {
            ++this.myStartedTestCount;
            ++this.myFinishedTestCount;
        } else if (test.isSuite()) {
            ++this.myStartedTestCount;
            this.updateTotalCount();
        }
        this.updateIconProgress(false);
        if (this.myLastSelected != null && TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.expand(test);
        }
    }

    @Override
    public void onTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(6);
        }
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        if (newSuite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(7);
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onCustomProgressTestFinished() {
        this.updateOnTestFinished(true);
    }

    @Override
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(8);
        }
        if (!test.isConfig()) {
            this.updateOnTestFinished(false);
        }
        this.updateIconProgress(false);
    }

    @Override
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
        if (suite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(9);
        }
    }

    @Override
    @NotNull
    public SMTestProxy.SMRootTestProxy getTestsRootNode() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(10);
        }
        return sMRootTestProxy;
    }

    @Override
    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    public void setFilter(@NotNull Filter filter) {
        if (filter == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(11);
        }
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.updateFromRoot();
    }

    @Override
    public boolean isRunning() {
        return this.myTestsRunning;
    }

    @Override
    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    public SMTRunnerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Override
    public boolean hasTestSuites() {
        return this.getRoot().getChildren().size() > 0;
    }

    @Override
    @NotNull
    public AbstractTestProxy getRoot() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(12);
        }
        return sMRootTestProxy;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener2) {
        this.myEventListeners.add(listener2);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                @Nullable SMTestProxy selectedProxy = (SMTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener2.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myEventListeners.clear();
        this.myDisposed = true;
    }

    protected int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    protected int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    public int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    public int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    protected int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    public Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(13);
        }
        final SMTestProxy parentSuite = newTestOrSuite.getParent();
        Update update2 = new Update(ObjectUtils.notNull((Object)parentSuite, (Object)this.getRoot())){

            public void run() {
                if (parentSuite == null || parentSuite.getParent() == null) {
                    SMTestRunnerResultsForm.this.myUpdateTreeRequests.cancelAllRequests();
                    SMTestRunnerResultsForm.this.myRequests.clear();
                    SMTestRunnerResultsForm.this.myTreeBuilder.updateFromRoot();
                } else {
                    SMTestRunnerResultsForm.this.myRequests.remove((Object)this);
                    SMTestRunnerResultsForm.this.myTreeBuilder.updateTestsSubtree(parentSuite);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            update2.run();
        } else if (!this.myDisposed && this.myRequests.add(update2)) {
            this.myUpdateTreeRequests.addRequest((Runnable)update2, 50);
        }
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && (this.myLastSelected == null || this.myLastSelected == newTestOrSuite || this.isFiltered(this.myLastSelected))) {
            this.setLastSelected(null);
            this.selectAndNotify(newTestOrSuite);
        }
    }

    private boolean isFiltered(AbstractTestProxy proxy) {
        return proxy instanceof SMTestProxy && !this.getTreeBuilder().getTreeStructure().getFilter().shouldAccept((SMTestProxy)proxy);
    }

    private void setLastSelected(AbstractTestProxy proxy) {
        this.myLastSelected = proxy;
    }

    private void fireOnTestNodeAdded(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(14);
        }
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        if (this.myTreeBuilder.isDisposed()) {
            return;
        }
        this.myTreeBuilder.select(testProxy, onDone);
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            this.myStatusLine.formatTestMessage(this.isUndefined() ? -1 : this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myIgnoredTestCount, this.myTestsRootNode.getDuration(), this.myEndTime);
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myMentionedCategories, launchedAndFinished));
        }
        if (testingFinished) {
            boolean noTestsWereRun = this.myTotalTestCount == 0 && (this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached());
            this.myStatusLine.onTestsDone(noTestsWereRun ? null : this.myTestsRootNode.getMagnitudeInfo());
            Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            this.myConsole.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)6), (Border)new SideBorder(editorBackground, 1)));
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isUndefined() {
        return this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).isUndefined();
    }

    public void performUpdate() {
        this.myTreeBuilder.updateFromRoot();
    }

    private void updateIconProgress(boolean updateWithAttention) {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount;
        }
        UIUtil.invokeLaterIfNeeded(() -> TestsUIUtil.showIconProgress(this.myProject, doneTestCount, totalTestCount, this.myFailedTestCount, updateWithAttention));
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        this.updateTotalCount();
        this.updateStatusLabel(false);
    }

    private void updateTotalCount() {
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount;
        if (this.isUndefined()) {
            this.myStatusLine.setFraction(1.0);
        } else if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    @ApiStatus.Internal
    public void setIncompleteIndexUsed() {
        this.myStatusLine.setWarning(SmRunnerBundle.message("suffix.incomplete.index.was.used", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSuite";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestOrSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsRootNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestingStarted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTestingFinished";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onTestStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTestIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteStarted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteFinished";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "_addTestOrSuite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireOnTestNodeAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySaveHistoryTask
    extends Task.Backgroundable {
        private final TestConsoleProperties myConsoleProperties;
        private SMTestProxy.SMRootTestProxy myRoot;
        private RunConfiguration myConfiguration;
        private File myOutputFile;

        MySaveHistoryTask(TestConsoleProperties consoleProperties, SMTestProxy.SMRootTestProxy root, RunConfiguration configuration2) {
            super(consoleProperties.getProject(), SmRunnerBundle.message("sm.test.runner.results.form.save.test.results.title", new Object[0]), true);
            this.myConsoleProperties = consoleProperties;
            this.myRoot = root;
            this.myConfiguration = configuration2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MySaveHistoryTask.$$$reportNull$$$0(0);
            }
            this.writeState();
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler handler2 = transformerFactory.newTransformerHandler();
                handler2.getTransformer().setOutputProperty("indent", "yes");
                handler2.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                String configurationNameIncludedDate = PathUtil.suggestFileName((String)this.myConfiguration.getName()) + " - " + new SimpleDateFormat(SMTestRunnerResultsForm.HISTORY_DATE_FORMAT).format(new Date());
                this.myOutputFile = new File(TestStateStorage.getTestHistoryRoot(this.myProject), configurationNameIncludedDate + ".xml");
                FileUtilRt.createParentDirs((File)this.myOutputFile);
                handler2.setResult(new StreamResult(new FileWriter(this.myOutputFile)));
                SMTestProxy.SMRootTestProxy root = this.myRoot;
                RunConfiguration configuration2 = this.myConfiguration;
                if (root != null && configuration2 != null) {
                    TestResultsXmlFormatter.execute(root, configuration2, this.myConsoleProperties, handler2);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info("Export to history failed", (Throwable)e);
            }
        }

        private void writeState() {
            if (this.myRoot == null) {
                return;
            }
            List<SMTestProxy> tests = this.myRoot.getAllTests();
            for (SMTestProxy proxy : tests) {
                String url = proxy.getLocationUrl();
                if (url == null || proxy.getLocator() == null) continue;
                String configurationName = this.myConfiguration != null ? this.myConfiguration.getName() : null;
                DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
                    Project project = this.getProject();
                    TestStackTraceParser info = new TestStackTraceParser(url, proxy.getStacktrace(), proxy.getErrorMessage(), proxy.getLocator(), project);
                    TestStateStorage storage2 = TestStateStorage.getInstance(project);
                    storage2.writeState(url, new TestStateStorage.Record(proxy.getMagnitude(), new Date(), configurationName == null ? 0L : (long)configurationName.hashCode(), info.getFailedLine(), info.getFailedMethodName(), info.getErrorMessage(), info.getTopLocationLine()));
                });
            }
        }

        public void onSuccess() {
            if (this.myOutputFile != null && this.myOutputFile.exists()) {
                AbstractImportTestsAction.adjustHistory(this.myProject);
                TestHistoryConfiguration.getInstance(this.myProject).registerHistoryItem(this.myOutputFile.getName(), this.myConfiguration.getName(), this.myConfiguration.getType().getId());
            }
        }

        public void dispose() {
            this.myConfiguration = null;
            this.myRoot = null;
            this.myOutputFile = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$MySaveHistoryTask", "run"));
        }
    }
}

