/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategy;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralTestEventsProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)GeneralTestEventsProcessor.class.getName());
    protected final SMTRunnerEventsListener myEventPublisher;
    protected final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    protected SMTestLocator myLocator;
    private final String myTestFrameworkName;
    protected List<SMTRunnerEventsListener> myListenerAdapters;
    protected boolean myTreeBuildBeforeStart;
    protected final List<Runnable> myBuildTreeRunnables;

    public GeneralTestEventsProcessor(@NotNull Project project, @NotNull String testFrameworkName, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy) {
        if (project == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(1);
        }
        if (testsRootProxy == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(2);
        }
        this.myLocator = null;
        this.myListenerAdapters = new CopyOnWriteArrayList<SMTRunnerEventsListener>();
        this.myTreeBuildBeforeStart = false;
        this.myBuildTreeRunnables = new ArrayList<Runnable>();
        this.myEventPublisher = (SMTRunnerEventsListener)project.getMessageBus().syncPublisher(SMTRunnerEventsListener.TEST_STATUS);
        this.myTestFrameworkName = testFrameworkName;
        this.myTestsRootProxy = testsRootProxy;
    }

    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
        this.myTestsRootProxy.setPresentation(rootName);
        this.myTestsRootProxy.setComment(comment);
        this.myTestsRootProxy.setRootLocationUrl(rootLocation);
        if (this.myLocator != null) {
            this.myTestsRootProxy.setLocator(this.myLocator);
        }
        this.myEventPublisher.onRootPresentationAdded(this.myTestsRootProxy, rootName, comment, rootLocation);
    }

    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        return new SMTestProxy(testName, false, locationHint, metaInfo, false);
    }

    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        return new SMTestProxy(suiteName, true, locationHint, metaInfo, false);
    }

    public void onSuiteTreeNodeAdded(String testName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        this.onSuiteTreeNodeAdded(false, testName, locationHint, metaInfo, id2, parentNodeId);
    }

    public void onSuiteTreeNodeAdded(boolean isSuite, String testName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy testProxy = isSuite ? this.createSuite(testName, locationHint, metaInfo, id2, parentNodeId) : this.createProxy(testName, locationHint, metaInfo, id2, parentNodeId);
            testProxy.setTreeBuildBeforeStart();
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            this.myEventPublisher.onSuiteTreeNodeAdded(testProxy, isSuite, id2, parentNodeId);
            for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
                adapter2.onSuiteTreeNodeAdded(testProxy, isSuite, id2, parentNodeId);
            }
            testProxy.getParent().setTreeBuildBeforeStart();
        });
    }

    public void onSuiteTreeStarted(String suiteName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy newSuite = this.createSuite(suiteName, locationHint, metaInfo, id2, parentNodeId);
            if (this.myLocator != null) {
                newSuite.setLocator(this.myLocator);
            }
            newSuite.setTreeBuildBeforeStart();
            this.myEventPublisher.onSuiteTreeStarted(newSuite, id2, parentNodeId);
            for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
                adapter2.onSuiteTreeStarted(newSuite, id2, parentNodeId);
            }
        });
    }

    public void onSuiteTreeEnded(String suiteName) {
        if (this.myBuildTreeRunnables.size() > 100) {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
            this.myBuildTreeRunnables.clear();
            GeneralTestEventsProcessor.processTreeBuildEvents(runnables);
        }
    }

    public void onBuildTreeEnded() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
        this.myBuildTreeRunnables.clear();
        GeneralTestEventsProcessor.processTreeBuildEvents(runnables);
        this.myEventPublisher.onBuildTreeEnded(this.myTestsRootProxy);
    }

    public final void onDurationStrategyChanged(@NotNull TestDurationStrategy durationStrategy) {
        if (durationStrategy == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(3);
        }
        this.myTestsRootProxy.setDurationStrategy(durationStrategy);
    }

    private static void processTreeBuildEvents(List<Runnable> runnables) {
        for (Runnable runnable2 : runnables) {
            runnable2.run();
        }
        runnables.clear();
    }

    public abstract void onStartTesting();

    protected void fireOnTestingStarted(SMTestProxy.SMRootTestProxy node) {
        this.myEventPublisher.onTestingStarted(node);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestingStarted(node);
        }
    }

    public abstract void onTestsCountInSuite(int var1);

    protected void fireOnTestsCountInSuite(int count) {
        this.myEventPublisher.onTestsCountInSuite(count);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestsCountInSuite(count);
        }
    }

    public abstract void onTestStarted(@NotNull TestStartedEvent var1);

    protected void fireOnTestStarted(SMTestProxy testProxy) {
        this.fireOnTestStarted(testProxy, null, null);
    }

    protected void fireOnTestStarted(SMTestProxy testProxy, @Nullable String nodeId, @Nullable String parentNodeId) {
        this.myEventPublisher.onTestStarted(testProxy, nodeId, parentNodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestStarted(testProxy, nodeId, parentNodeId);
        }
    }

    public abstract void onTestFinished(@NotNull TestFinishedEvent var1);

    protected void fireOnTestFinished(SMTestProxy testProxy) {
        this.fireOnTestFinished(testProxy, null);
    }

    protected void fireOnTestFinished(SMTestProxy testProxy, @Nullable String nodeId) {
        this.myEventPublisher.onTestFinished(testProxy, nodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestFinished(testProxy, nodeId);
        }
    }

    public abstract void onTestFailure(@NotNull TestFailedEvent var1);

    protected void fireOnTestFailed(SMTestProxy testProxy) {
        this.fireOnTestFailed(testProxy, null);
    }

    protected void fireOnTestFailed(SMTestProxy testProxy, @Nullable String nodeId) {
        this.myEventPublisher.onTestFailed(testProxy, nodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestFailed(testProxy, nodeId);
        }
    }

    public abstract void onTestIgnored(@NotNull TestIgnoredEvent var1);

    protected void fireOnTestIgnored(SMTestProxy testProxy) {
        this.fireOnTestIgnored(testProxy, null);
    }

    protected void fireOnTestIgnored(SMTestProxy testProxy, @Nullable String nodeId) {
        this.myEventPublisher.onTestIgnored(testProxy, nodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestIgnored(testProxy, nodeId);
        }
    }

    public abstract void onTestOutput(@NotNull TestOutputEvent var1);

    public abstract void onSuiteStarted(@NotNull TestSuiteStartedEvent var1);

    protected void fireOnSuiteStarted(SMTestProxy newSuite) {
        this.fireOnSuiteStarted(newSuite, null, null);
    }

    protected void fireOnSuiteStarted(SMTestProxy newSuite, @Nullable String nodeId, @Nullable String parentNodeId) {
        this.myEventPublisher.onSuiteStarted(newSuite, nodeId, parentNodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onSuiteStarted(newSuite, nodeId, parentNodeId);
        }
    }

    public abstract void onSuiteFinished(@NotNull TestSuiteFinishedEvent var1);

    protected void fireOnSuiteFinished(SMTestProxy mySuite) {
        this.fireOnSuiteFinished(mySuite, null);
    }

    protected void fireOnSuiteFinished(SMTestProxy mySuite, @Nullable String nodeId) {
        this.myEventPublisher.onSuiteFinished(mySuite, nodeId);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onSuiteFinished(mySuite, nodeId);
        }
    }

    public abstract void onUncapturedOutput(@NotNull String var1, Key var2);

    public abstract void onError(@NotNull String var1, @Nullable String var2, boolean var3);

    protected static void fireOnTestsReporterAttached(SMTestProxy.SMRootTestProxy rootNode) {
        rootNode.setTestsReporterAttached();
    }

    public void onFinishTesting() {
    }

    protected void fireOnTestingFinished(SMTestProxy.SMRootTestProxy root) {
        this.myEventPublisher.onTestingFinished(root);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onTestingFinished(root);
        }
    }

    protected void fireOnBeforeTestingFinished(@NotNull SMTestProxy.SMRootTestProxy root) {
        if (root == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(4);
        }
        this.myEventPublisher.onBeforeTestingFinished(root);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onBeforeTestingFinished(root);
        }
    }

    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myEventPublisher.onCustomProgressTestsCategory(categoryName, testCount);
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    public void onCustomProgressTestStarted() {
        this.myEventPublisher.onCustomProgressTestStarted();
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onCustomProgressTestStarted();
        }
    }

    public void onCustomProgressTestFinished() {
        this.myEventPublisher.onCustomProgressTestFinished();
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onCustomProgressTestFinished();
        }
    }

    public void onCustomProgressTestFailed() {
        this.myEventPublisher.onCustomProgressTestFailed();
        for (SMTRunnerEventsListener adapter2 : this.myListenerAdapters) {
            adapter2.onCustomProgressTestFailed();
        }
    }

    public abstract void onTestsReporterAttached();

    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(5);
        }
        this.myLocator = locator;
    }

    public void addEventsListener(@NotNull SMTRunnerEventsListener listener2) {
        if (listener2 == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(6);
        }
        this.myListenerAdapters.add(listener2);
    }

    public abstract void setPrinterProvider(@NotNull TestProxyPrinterProvider var1);

    public void dispose() {
        this.disconnectListeners();
    }

    protected void disconnectListeners() {
        this.myListenerAdapters.clear();
    }

    protected static <T> boolean isTreeComplete(Collection<T> runningTests, SMTestProxy.SMRootTestProxy rootNode) {
        if (!runningTests.isEmpty()) {
            return false;
        }
        List<? extends SMTestProxy> children2 = rootNode.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            if (sMTestProxy.isFinal() && !sMTestProxy.wasTerminated()) continue;
            return false;
        }
        return true;
    }

    protected void logProblem(String msg) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    protected void logProblem(String msg, boolean throwError) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, throwError, this.myTestFrameworkName);
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GeneralTestEventsProcessor.logProblem(log, msg, SMTestRunnerConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text2 = GeneralTestEventsProcessor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text2);
        } else {
            log.warn(text2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootProxy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durationStrategy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/GeneralTestEventsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onDurationStrategyChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnBeforeTestingFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addEventsListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

