/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;

public final class TestFrameworkActions {
    public static void installFilterAction(final TestFrameworkRunningModel model2) {
        final TestConsoleProperties properties = model2.getProperties();
        TestFrameworkPropertyListener<Boolean> propertyListener = new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value2) {
                model2.setFilter(TestFrameworkActions.getFilter(properties));
            }
        };
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_PASSED_TESTS, propertyListener, model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_IGNORED_TEST, propertyListener, model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_SUCCESSFUL_CONFIG, propertyListener, model2, true);
    }

    @NotNull
    private static Filter getFilter(TestConsoleProperties properties) {
        Filter hideIgnoredFilter;
        boolean shouldFilterPassed = TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)properties);
        Filter hidePassedFilter = shouldFilterPassed ? Filter.NOT_PASSED.or(Filter.DEFECT) : Filter.NO_FILTER;
        boolean shouldFilterIgnored = TestConsoleProperties.HIDE_IGNORED_TEST.value((AbstractProperty.AbstractPropertyContainer)properties);
        if (shouldFilterIgnored) {
            Filter ignoredFilter = Filter.IGNORED.not();
            hideIgnoredFilter = !shouldFilterPassed ? ignoredFilter.or(Filter.HAS_PASSED) : ignoredFilter;
        } else {
            hideIgnoredFilter = Filter.NO_FILTER;
        }
        boolean hideSuccessfulConfigs = TestConsoleProperties.HIDE_SUCCESSFUL_CONFIG.value((AbstractProperty.AbstractPropertyContainer)properties);
        Filter hideConfigsFilter = hideSuccessfulConfigs ? Filter.HIDE_SUCCESSFUL_CONFIGS : Filter.NO_FILTER;
        Filter filter = hidePassedFilter.and(hideIgnoredFilter).and(hideConfigsFilter);
        if (filter == null) {
            TestFrameworkActions.$$$reportNull$$$0(0);
        }
        return filter;
    }

    public static void addPropertyListener(final AbstractProperty<Boolean> property, final TestFrameworkPropertyListener<Boolean> propertyListener, TestFrameworkRunningModel model2, boolean sendValue) {
        final TestConsoleProperties properties = model2.getProperties();
        if (sendValue) {
            properties.addListenerAndSendValue(property, propertyListener);
        } else {
            properties.addListener(property, propertyListener);
        }
        Disposer.register((Disposable)model2, (Disposable)new Disposable(){

            public void dispose() {
                properties.removeListener(property, propertyListener);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestFrameworkActions", "getFilter"));
    }
}

