/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetCounterUsagesCollector;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.ide.wizard.AbstractWizardEx;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0005H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard;", "Lcom/intellij/ide/wizard/AbstractWizardEx;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "subject", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "steps", "", "Lcom/intellij/ide/wizard/AbstractWizardStepEx;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/TargetEnvironmentConfiguration;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSubject", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createSouthPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "getHelpId", "show", "Companion", "ValidationCallbackConsumer", "intellij.platform.execution.impl"})
public final class TargetEnvironmentWizard
extends AbstractWizardEx {
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentConfiguration subject;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String getHelpId() {
        return "reference.remote.target.wizard." + this.subject.getTypeId();
    }

    @NotNull
    protected Border createContentPaneBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"JBUI.Borders.empty()");
        return (Border)jBEmptyBorder;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel it = jPanel2;
        boolean bl3 = false;
        it.add((Component)super.createSouthPanel(), "Center");
        it.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
        return jPanel2;
    }

    public void show() {
        TargetCounterUsagesCollector.reportTargetCreationBegan(this.project, this.subject.getTypeId());
        super.show();
    }

    public void doCancelAction() {
        TargetCounterUsagesCollector.reportTargetCreationCancelled(this.project, this.subject.getTypeId(), this.getCurrentStep());
        super.doCancelAction();
    }

    protected void doOKAction() {
        TargetCounterUsagesCollector.reportTargetCreationSucceeded(this.project, this.subject.getTypeId());
        super.doOKAction();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TargetEnvironmentConfiguration getSubject() {
        return this.subject;
    }

    public TargetEnvironmentWizard(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull TargetEnvironmentConfiguration subject, @NotNull List<? extends AbstractWizardStepEx> steps) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        super(title, project, steps);
        this.project = project;
        this.subject = subject;
        for (final AbstractWizardStepEx abstractWizardStepEx : steps) {
            if (!(abstractWizardStepEx instanceof ValidationCallbackConsumer)) continue;
            ((ValidationCallbackConsumer)abstractWizardStepEx).accept(new Function0<Unit>(){

                public final void invoke() {
                    this.setErrorInfoAll(((ValidationCallbackConsumer)abstractWizardStepEx).doValidateAll());
                }
            });
        }
    }

    @JvmStatic
    @Nullable
    public static final <C extends TargetEnvironmentConfiguration> TargetEnvironmentWizard createWizard(@NotNull Project project, @NotNull TargetEnvironmentType<C> targetType, @Nullable LanguageRuntimeType<?> runtimeType) {
        return Companion.createWizard(project, targetType, runtimeType);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard$ValidationCallbackConsumer;", "Ljava/util/function/Consumer;", "Lkotlin/Function0;", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.platform.execution.impl"})
    public static interface ValidationCallbackConsumer
    extends Consumer<Function0<? extends Unit>> {
        @NotNull
        public List<ValidationInfo> doValidateAll();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0007J\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard$Companion;", "", "()V", "createWizard", "Lcom/intellij/execution/target/TargetEnvironmentWizard;", "C", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "targetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "runtimeType", "Lcom/intellij/execution/target/LanguageRuntimeType;", "defaultDialogInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final <C extends TargetEnvironmentConfiguration> TargetEnvironmentWizard createWizard(@NotNull Project project, @NotNull TargetEnvironmentType<C> targetType, @Nullable LanguageRuntimeType<?> runtimeType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            if (!targetType.providesNewWizard(project, runtimeType)) {
                return null;
            }
            TargetEnvironmentConfiguration config2 = (TargetEnvironmentConfiguration)targetType.createDefaultConfig();
            List list2 = targetType.createStepsForNewWizard(project, config2, runtimeType);
            if (list2 == null) {
                return null;
            }
            List steps = list2;
            String string = ExecutionBundle.message((String)"run.on.targets.wizard.title.new.target", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026wizard.title.new.target\")");
            return new TargetEnvironmentWizard(project, string, config2, steps);
        }

        @NotNull
        public final JBInsets defaultDialogInsets() {
            JBInsets jBInsets = UIUtil.getRegularPanelInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"UIUtil.getRegularPanelInsets()");
            return jBInsets;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

