/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.stateWidget;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.segmentedRunDebugWidget.StateWidgetManager;
import com.intellij.execution.stateExecutionWidget.StateWidgetProcess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/stateWidget/StateWidget;", "Lcom/intellij/execution/ExecutorRegistryImpl$ExecutorAction;", "executor", "Lcom/intellij/execution/Executor;", "process", "Lcom/intellij/execution/stateExecutionWidget/StateWidgetProcess;", "(Lcom/intellij/execution/Executor;Lcom/intellij/execution/stateExecutionWidget/StateWidgetProcess;)V", "getExecutor", "()Lcom/intellij/execution/Executor;", "getProcess", "()Lcom/intellij/execution/stateExecutionWidget/StateWidgetProcess;", "displayTextInToolbar", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
public final class StateWidget
extends ExecutorRegistryImpl.ExecutorAction {
    @NotNull
    private final Executor executor;
    @NotNull
    private final StateWidgetProcess process;

    public boolean displayTextInToolbar() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null && StateWidgetManager.Companion.getInstance(project).getExecutionsCount() == 0) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabledAndVisible(true);
            super.update(e);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            Executor executor = this.myExecutor;
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"myExecutor");
            presentation3.setText(executor.getActionName());
            return;
        }
        Presentation presentation4 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
        presentation4.setEnabledAndVisible(false);
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final StateWidgetProcess getProcess() {
        return this.process;
    }

    public StateWidget(@NotNull Executor executor, @NotNull StateWidgetProcess process2) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        super(executor);
        this.executor = executor;
        this.process = process2;
    }
}

