/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceSingleView;
import com.intellij.execution.services.ServiceTreeView;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewContributorDeleteProvider;
import com.intellij.execution.services.ServiceViewCopyProvider;
import com.intellij.execution.services.ServiceViewDeleteProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewSingleUi;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewTreeUi;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

abstract class ServiceView
extends JPanel
implements Disposable {
    private final Project myProject;
    private final ServiceViewModel myModel;
    protected final ServiceViewUi myUi;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;

    protected ServiceView(LayoutManager layout, @NotNull Project project, @NotNull ServiceViewModel model2, @NotNull ServiceViewUi ui) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ServiceView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceView.$$$reportNull$$$0(2);
        }
        super(layout);
        this.myProject = project;
        this.myModel = model2;
        this.myUi = ui;
    }

    public void dispose() {
    }

    Project getProject() {
        return this.myProject;
    }

    ServiceViewModel getModel() {
        return this.myModel;
    }

    ServiceViewUi getUi() {
        return this.myUi;
    }

    void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceView.$$$reportNull$$$0(3);
        }
        this.myModel.saveState(state);
    }

    @NotNull
    abstract List<ServiceModel.ServiceViewItem> getSelectedItems();

    abstract Promise<Void> select(@NotNull Object var1, @NotNull Class<?> var2);

    abstract Promise<Void> expand(@NotNull Object var1, @NotNull Class<?> var2);

    abstract Promise<Void> extract(@NotNull Object var1, @NotNull Class<?> var2);

    abstract void onViewSelected();

    abstract void onViewUnselected();

    boolean isGroupByServiceGroups() {
        return this.myModel.isGroupByServiceGroups();
    }

    void setGroupByServiceGroups(boolean value2) {
        this.myModel.setGroupByServiceGroups(value2);
    }

    boolean isGroupByContributor() {
        return this.myModel.isGroupByContributor();
    }

    void setGroupByContributor(boolean value2) {
        this.myModel.setGroupByContributor(value2);
    }

    abstract List<Object> getChildrenSafe(@NotNull List<Object> var1);

    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        if (autoScrollToSourceHandler == null) {
            ServiceView.$$$reportNull$$$0(4);
        }
        this.myAutoScrollToSourceHandler = autoScrollToSourceHandler;
    }

    void onViewSelected(@NotNull ServiceViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            ServiceView.$$$reportNull$$$0(5);
        }
        descriptor2.onNodeSelected();
        if (this.myAutoScrollToSourceHandler != null) {
            this.myAutoScrollToSourceHandler.onMouseClicked((Component)this);
        }
    }

    abstract void jumpToServices();

    static ServiceView createView(@NotNull Project project, @NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(6);
        }
        if (viewModel == null) {
            ServiceView.$$$reportNull$$$0(7);
        }
        if (viewState == null) {
            ServiceView.$$$reportNull$$$0(8);
        }
        ServiceView.setViewModelState(viewModel, viewState);
        ServiceView serviceView = viewModel instanceof ServiceViewModel.SingeServiceModel ? ServiceView.createSingleView(project, viewModel) : ServiceView.createTreeView(project, viewModel, viewState);
        ServiceView.setDataProvider(serviceView);
        return serviceView;
    }

    private static ServiceView createTreeView(@NotNull Project project, @NotNull ServiceViewModel model2, @NotNull ServiceViewState state) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            ServiceView.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ServiceView.$$$reportNull$$$0(11);
        }
        return new ServiceTreeView(project, model2, new ServiceViewTreeUi(state), state);
    }

    private static ServiceView createSingleView(@NotNull Project project, @NotNull ServiceViewModel model2) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(12);
        }
        if (model2 == null) {
            ServiceView.$$$reportNull$$$0(13);
        }
        return new ServiceSingleView(project, model2, new ServiceViewSingleUi());
    }

    private static void setDataProvider(final ServiceView serviceView) {
        ServiceViewOptions viewOptions = new ServiceViewOptions(){

            public boolean isGroupByContributor() {
                return serviceView.isGroupByContributor();
            }

            public boolean isGroupByServiceGroups() {
                return serviceView.isGroupByServiceGroups();
            }
        };
        serviceView.putClientProperty("DataProvider", dataId -> {
            DataProvider dataProvider;
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ServiceViewManagerImpl.getToolWindowContextHelpId();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ContainerUtil.map2Array(serviceView.getSelectedItems(), ServiceModel.ServiceViewItem::getValue);
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                List navigatables = ContainerUtil.mapNotNull(serviceView.getSelectedItems(), item -> item.getViewDescriptor().getNavigatable());
                return navigatables.toArray(new Navigatable[0]);
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                DeleteProvider deleteProvider;
                List<ServiceModel.ServiceViewItem> selection = serviceView.getSelectedItems();
                ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selection);
                DataProvider delegate2 = contributor == null ? null : contributor.getViewDescriptor(serviceView.getProject()).getDataProvider();
                DeleteProvider deleteProvider2 = deleteProvider = delegate2 == null ? null : (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(delegate2);
                if (deleteProvider == null) {
                    return new ServiceViewDeleteProvider(serviceView);
                }
                if (deleteProvider instanceof ServiceViewContributorDeleteProvider) {
                    ((ServiceViewContributorDeleteProvider)deleteProvider).setFallbackProvider(new ServiceViewDeleteProvider(serviceView));
                }
                return deleteProvider;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return new ServiceViewCopyProvider(serviceView);
            }
            if (ServiceViewActionUtils.CONTRIBUTORS_KEY.is(dataId)) {
                return serviceView.getModel().getRoots().stream().map(item -> item.getRootContributor()).collect(Collectors.toSet());
            }
            if (ServiceViewActionUtils.OPTIONS_KEY.is(dataId)) {
                return viewOptions;
            }
            List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
            ServiceModel.ServiceViewItem selectedItem = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selectedItems);
            ServiceViewDescriptor descriptor2 = selectedItem == null || selectedItem.isRemoved() ? null : selectedItem.getViewDescriptor();
            DataProvider dataProvider2 = dataProvider = descriptor2 == null ? null : descriptor2.getDataProvider();
            if (dataProvider != null) {
                return RecursionManager.doPreventingRecursion((Object)serviceView, (boolean)false, () -> dataProvider.getData(dataId));
            }
            return null;
        });
    }

    private static void setViewModelState(@NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        if (viewModel == null) {
            ServiceView.$$$reportNull$$$0(14);
        }
        if (viewState == null) {
            ServiceView.$$$reportNull$$$0(15);
        }
        viewModel.setGroupByServiceGroups(viewState.groupByServiceGroups);
        viewModel.setGroupByContributor(viewState.groupByContributor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoScrollToSourceHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewModel";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/services/ServiceView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAutoScrollToSourceHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onViewSelected";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createView";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createTreeView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createSingleView";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setViewModelState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

