/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRerunAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = event.getPresentation();
        ExecutionEnvironment environment2 = this.getEnvironment(event);
        if (environment2 != null) {
            presentation2.setText(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment2.getRunProfile().getName())}));
            presentation2.setIcon("TouchBarGeneral".equals(event.getPlace()) || ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment2.getExecutor().getIcon());
            presentation2.setEnabled(this.isEnabled(event));
            return;
        }
        presentation2.setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment2;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(1);
        }
        if ((environment2 = this.getEnvironment(event)) != null) {
            MacroManager.getInstance().cacheMacrosPreview(event.getDataContext());
            ExecutionUtil.restart((ExecutionEnvironment)environment2);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment2;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(2);
        }
        if ((environment2 = (ExecutionEnvironment)event.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            JComponent component2;
            RunContentDescriptor contentDescriptor;
            Project project = event.getProject();
            RunContentManager runContentManager = project == null ? null : RunContentManager.getInstanceIfCreated((Project)project);
            RunContentDescriptor runContentDescriptor = contentDescriptor = runContentManager == null ? null : runContentManager.getSelectedContent();
            if (contentDescriptor != null && (component2 = contentDescriptor.getComponent()) != null) {
                environment2 = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component2));
            }
        }
        return environment2;
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor2 = this.getDescriptor(event);
        ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
        ExecutionEnvironment environment2 = this.getEnvironment(event);
        Project project = FakeRerunAction.getEventProject((AnActionEvent)event);
        if (environment2 == null || project == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment2.getRunnerAndConfigurationSettings();
        return !(DumbService.isDumb((Project)project) && settings != null && !settings.getType().isDumbAware() || ExecutionManager.getInstance((Project)project).isStarting(environment2) || processHandler2 != null && processHandler2.isProcessTerminating());
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/execution/runners/FakeRerunAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

