/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ClearConsoleAction;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.DisposedPsiManagerCheck;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.MyDiffContainer;
import com.intellij.execution.impl.TokenBuffer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConsoleViewImpl
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider,
OccurenceNavigator {
    @NonNls
    private static final String CONSOLE_VIEW_POPUP_MENU = "ConsoleView.PopupMenu";
    private static final Logger LOG = Logger.getInstance(ConsoleViewImpl.class);
    private static final int DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200);
    public static final Key<ConsoleViewImpl> CONSOLE_VIEW_IN_EDITOR_VIEW = Key.create((String)"CONSOLE_VIEW_IN_EDITOR_VIEW");
    private static final Key<ConsoleViewContentType> CONTENT_TYPE = Key.create((String)"ConsoleViewContentType");
    private static final Key<Boolean> USER_INPUT_SENT = Key.create((String)"USER_INPUT_SENT");
    private static final Key<Boolean> MANUAL_HYPERLINK = Key.create((String)"MANUAL_HYPERLINK");
    private static final char BACKSPACE = '\b';
    private static boolean ourTypedHandlerInitialized;
    private final Alarm myFlushUserInputAlarm;
    private static final CharMatcher NEW_LINE_MATCHER;
    private final CommandLineFolding myCommandLineFolding;
    private final DisposedPsiManagerCheck myPsiDisposedCheck;
    private final boolean myIsViewer;
    @NotNull
    private ConsoleState myState;
    private final Alarm mySpareTimeAlarm;
    @NotNull
    private final Alarm myHeavyAlarm;
    private volatile int myHeavyUpdateTicket;
    private final Collection<ObservableConsoleView.ChangeListener> myListeners;
    private final List<AnAction> customActions;
    private final TokenBuffer myDeferredBuffer;
    private boolean myUpdateFoldingsEnabled;
    private EditorHyperlinkSupport myHyperlinks;
    private MyDiffContainer myJLayeredPane;
    private JPanel myMainPanel;
    private boolean myAllowHeavyFilters;
    private boolean myLastStickingToEnd;
    private boolean myCancelStickToEnd;
    private final Alarm myFlushAlarm;
    private final Project myProject;
    private boolean myOutputPaused;
    private EditorEx myEditor;
    private final Object LOCK;
    private String myHelpId;
    private final boolean myUsePredefinedMessageFilter;
    private final GlobalSearchScope mySearchScope;
    private final List<Filter> myCustomFilters;
    @NotNull
    private final InputFilter myInputMessageFilter;
    private volatile List<Filter> myPredefinedFilters;
    private boolean keepSlashR;
    private static final Key<String> USED_FOLDING_FQN_KEY;
    private final FlushRunnable FLUSH;
    private final ClearRunnable CLEAR;

    public ConsoleViewImpl(@NotNull Project project, boolean viewer) {
        if (project == null) {
            ConsoleViewImpl.$$$reportNull$$$0(0);
        }
        this(project, GlobalSearchScope.allScope((Project)project), viewer, true);
    }

    public ConsoleViewImpl(@NotNull Project project, @NotNull GlobalSearchScope searchScope2, boolean viewer, boolean usePredefinedMessageFilter) {
        if (project == null) {
            ConsoleViewImpl.$$$reportNull$$$0(1);
        }
        if (searchScope2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(2);
        }
        this(project, searchScope2, viewer, new ConsoleState.NotStartedStated(){

            @Override
            @NotNull
            public ConsoleState attachTo(@NotNull ConsoleViewImpl console2, @NotNull ProcessHandler processHandler2) {
                if (console2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new ConsoleViewRunningState(console2, processHandler2, this, true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "console";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processHandler";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$1";
                objectArray[2] = "attachTo";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, usePredefinedMessageFilter);
    }

    protected ConsoleViewImpl(final @NotNull Project project, @NotNull GlobalSearchScope searchScope2, boolean viewer, @NotNull ConsoleState initialState, boolean usePredefinedMessageFilter) {
        if (project == null) {
            ConsoleViewImpl.$$$reportNull$$$0(3);
        }
        if (searchScope2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(4);
        }
        if (initialState == null) {
            ConsoleViewImpl.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        this.myFlushUserInputAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myCommandLineFolding = new CommandLineFolding();
        this.mySpareTimeAlarm = new Alarm((Disposable)this);
        this.myHeavyAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.customActions = new ArrayList<AnAction>();
        this.myDeferredBuffer = new TokenBuffer(ConsoleBuffer.useCycleBuffer() && ConsoleBuffer.getCycleBufferSize() > 0 ? ConsoleBuffer.getCycleBufferSize() : Integer.MAX_VALUE);
        this.myUpdateFoldingsEnabled = true;
        this.myFlushAlarm = new Alarm((Disposable)this);
        this.LOCK = new Object();
        this.myCustomFilters = new SmartList();
        this.myPredefinedFilters = Collections.emptyList();
        this.keepSlashR = true;
        this.FLUSH = new FlushRunnable(false);
        this.CLEAR = new ClearRunnable();
        ConsoleViewImpl.initTypedHandler();
        this.myIsViewer = viewer;
        this.myState = initialState;
        this.myPsiDisposedCheck = new DisposedPsiManagerCheck(project);
        this.myProject = project;
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
        this.mySearchScope = searchScope2;
        this.myInputMessageFilter = ConsoleViewUtil.computeInputFilter(this, project, searchScope2);
        project.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){
            private long myLastStamp;

            public void enteredDumbMode() {
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                this.myLastStamp = ConsoleViewImpl.this.myEditor.getDocument().getModificationStamp();
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ConsoleViewImpl.this.myEditor == null || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
                        return;
                    }
                    DocumentEx document = ConsoleViewImpl.this.myEditor.getDocument();
                    if (this.myLastStamp != document.getModificationStamp()) {
                        ConsoleViewImpl.this.rehighlightHyperlinksAndFoldings();
                    }
                });
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme2 -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.isDisposed() || this.myEditor == null) {
                return;
            }
            MarkupModel model2 = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), project, false);
            for (RangeHighlighter tokenMarker : model2.getAllHighlighters()) {
                ConsoleViewContentType contentType = (ConsoleViewContentType)tokenMarker.getUserData(CONTENT_TYPE);
                if (contentType == null || contentType.getAttributesKey() != null || !(tokenMarker instanceof RangeHighlighterEx)) continue;
                ((RangeHighlighterEx)tokenMarker).setTextAttributes(contentType.getAttributes());
            }
        });
        if (this.myUsePredefinedMessageFilter) {
            this.updatePredefinedFilters();
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                @Override
                public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                    if (pluginDescriptor == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ConsoleViewImpl.this.updatePredefinedFilters();
                }

                @Override
                public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    if (pluginDescriptor == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    ConsoleViewImpl.this.updatePredefinedFilters();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "pluginDescriptor";
                    objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginLoaded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginUnloaded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void updatePredefinedFilters() {
        this.myPredefinedFilters = ConsoleViewUtil.computeConsoleFilters(this.myProject, this, this.mySearchScope);
    }

    private static synchronized void initTypedHandler() {
        if (ourTypedHandlerInitialized) {
            return;
        }
        EditorActionManager.getInstance();
        TypedAction typedAction = TypedAction.getInstance();
        typedAction.setupHandler((TypedActionHandler)new MyTypedHandler(typedAction.getHandler()));
        ourTypedHandlerInitialized = true;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public EditorHyperlinkSupport getHyperlinks() {
        return this.myHyperlinks;
    }

    public void scrollToEnd() {
        if (this.myEditor == null) {
            return;
        }
        EditorUtil.scrollToTheEnd(this.myEditor, true);
        this.myCancelStickToEnd = false;
    }

    public void foldImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myFlushAlarm.isEmpty()) {
            this.cancelAllFlushRequests();
            this.flushDeferredText();
        }
        FoldingModelEx model2 = this.myEditor.getFoldingModel();
        model2.runBatchFoldingOperation(() -> {
            for (FoldRegion region : model2.getAllFoldRegions()) {
                model2.removeFoldRegion(region);
            }
        });
        this.updateFoldings(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(6);
        }
        this.myState = this.myState.attachTo(this, processHandler2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.myEditor == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDeferredBuffer.clear();
        }
        if (!this.myFlushAlarm.isDisposed()) {
            this.cancelAllFlushRequests();
            this.addFlushRequest(0, this.CLEAR);
            this.cancelHeavyAlarm();
        }
    }

    public void scrollTo(final int offset) {
        if (this.myEditor == null) {
            return;
        }
        final class ScrollRunnable
        extends FlushRunnable {
            private ScrollRunnable() {
                super(true);
            }

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                int moveOffset = Math.min(offset, ConsoleViewImpl.this.myEditor.getDocument().getTextLength());
                if (ConsoleBuffer.useCycleBuffer() && moveOffset >= ConsoleViewImpl.this.myEditor.getDocument().getTextLength()) {
                    moveOffset = 0;
                }
                ConsoleViewImpl.this.myEditor.getCaretModel().moveToOffset(moveOffset);
                ConsoleViewImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }
        this.addFlushRequest(0, new ScrollRunnable());
    }

    public void requestScrollingToEnd() {
        if (this.myEditor == null) {
            return;
        }
        this.addFlushRequest(0, new FlushRunnable(true){

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor != null && !ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                    ConsoleViewImpl.this.scrollToEnd();
                }
            }
        });
    }

    private void addFlushRequest(int millis, @NotNull FlushRunnable flushRunnable) {
        if (flushRunnable == null) {
            ConsoleViewImpl.$$$reportNull$$$0(7);
        }
        flushRunnable.queue(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputPaused(boolean value2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myOutputPaused = value2;
        }
        if (!value2) {
            this.requestFlushImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputPaused() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myOutputPaused;
        }
    }

    public void setEmulateCarriageReturn(boolean emulate) {
        this.keepSlashR = emulate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDeferredOutput() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDeferredBuffer.length() > 0;
        }
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(8);
        }
        if (this.hasDeferredOutput()) {
            this.performLaterWhenNoDeferredOutput(runnable2);
        } else {
            runnable2.run();
        }
    }

    private void performLaterWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(9);
        }
        if (this.mySpareTimeAlarm.isDisposed()) {
            return;
        }
        if (this.myJLayeredPane == null) {
            this.getComponent();
        }
        this.mySpareTimeAlarm.addRequest(() -> this.performWhenNoDeferredOutput(runnable2), 100, ModalityState.stateForComponent((Component)((Object)this.myJLayeredPane)));
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myJLayeredPane = new MyDiffContainer(this.myMainPanel, this.createCompositeFilter().getUpdateMessage());
            Disposer.register((Disposable)this, (Disposable)this.myJLayeredPane);
            this.add((Component)((Object)this.myJLayeredPane), "Center");
        }
        if (this.myEditor == null) {
            this.initConsoleEditor();
            this.requestFlushImmediately();
            this.myMainPanel.add((Component)this.createCenterComponent(), "Center");
        }
        ConsoleViewImpl consoleViewImpl = this;
        if (consoleViewImpl == null) {
            ConsoleViewImpl.$$$reportNull$$$0(10);
        }
        return consoleViewImpl;
    }

    @NotNull
    protected CompositeFilter createCompositeFilter() {
        CompositeFilter compositeFilter = new CompositeFilter(this.myProject, this.myCustomFilters);
        compositeFilter.setForceUseAllFilters(true);
        this.myPredefinedFilters.forEach(arg_0 -> ((CompositeFilter)compositeFilter).addFilter(arg_0));
        CompositeFilter compositeFilter2 = compositeFilter;
        if (compositeFilter2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(11);
        }
        return compositeFilter2;
    }

    public final void addLayerToPane(@NotNull JComponent component2) {
        if (component2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(12);
        }
        this.getComponent();
        component2.setOpaque(false);
        component2.setVisible(true);
        this.myJLayeredPane.add(component2, 0);
    }

    private void initConsoleEditor() {
        this.myEditor = this.createConsoleEditor();
        this.registerConsoleEditorActions();
        this.myEditor.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)1));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(true);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(false);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isShiftDown()) {
                    return;
                }
                ConsoleViewImpl.this.updateStickToEndState(false);
            }
        };
        this.myEditor.getScrollPane().addMouseWheelListener(mouseListener);
        this.myEditor.getScrollPane().getVerticalScrollBar().addMouseListener(mouseListener);
        this.myEditor.getScrollPane().getVerticalScrollBar().addMouseMotionListener(mouseListener);
        this.myHyperlinks = EditorHyperlinkSupport.get(this.myEditor);
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            Rectangle oldR = e.getOldRectangle();
            if (oldR != null && oldR.height <= 0 && e.getNewRectangle().height > 0 && this.isStickingToEnd()) {
                this.scrollToEnd();
            }
        });
    }

    private void updateStickToEndState(boolean useImmediatePosition) {
        if (this.myEditor == null) {
            return;
        }
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        int scrollBarPosition = useImmediatePosition ? scrollBar.getValue() : this.myEditor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        boolean vscrollAtBottom = scrollBarPosition == scrollBar.getMaximum() - scrollBar.getVisibleAmount();
        boolean stickingToEnd = this.isStickingToEnd();
        if (!vscrollAtBottom && stickingToEnd) {
            this.myCancelStickToEnd = true;
        } else if (vscrollAtBottom && !stickingToEnd) {
            this.scrollToEnd();
        }
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myState = this.myState.dispose();
        if (this.myEditor != null) {
            this.cancelAllFlushRequests();
            this.mySpareTimeAlarm.cancelAllRequests();
            this.disposeEditor();
            this.myEditor.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, null);
            Object object = this.LOCK;
            synchronized (object) {
                this.myDeferredBuffer.clear();
            }
            this.myEditor = null;
            this.myHyperlinks = null;
        }
    }

    private void cancelAllFlushRequests() {
        this.myFlushAlarm.cancelAllRequests();
        this.CLEAR.clearRequested();
        this.FLUSH.clearRequested();
    }

    @TestOnly
    public void waitAllRequests() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (true) {
                try {
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    return;
                }
                catch (CancellationException cancellationException) {
                    continue;
                }
                break;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            while (true) {
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    UIUtil.dispatchAllInvocationEvents();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void disposeEditor() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            }
        });
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        List result2;
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(14);
        }
        if (contentType == null) {
            ConsoleViewImpl.$$$reportNull$$$0(15);
        }
        if ((result2 = this.myInputMessageFilter.applyFilter(text2, contentType)) == null) {
            this.print(text2, contentType, null);
        } else {
            for (Pair pair : result2) {
                if (pair.first == null) continue;
                this.print((String)pair.first, pair.second == null ? contentType : (ConsoleViewContentType)pair.second, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(16);
        }
        if (contentType == null) {
            ConsoleViewImpl.$$$reportNull$$$0(17);
        }
        text2 = StringUtil.convertLineSeparators((String)text2, (boolean)this.keepSlashR);
        boolean hasEditor = this.myEditor != null;
        Object object = this.LOCK;
        synchronized (object) {
            this.myDeferredBuffer.print(text2, contentType, info);
            if (contentType == ConsoleViewContentType.USER_INPUT) {
                this.requestFlushImmediately();
            } else if (hasEditor) {
                boolean shouldFlushNow = this.myDeferredBuffer.length() >= this.myDeferredBuffer.getCycleBufferSize();
                this.addFlushRequest(shouldFlushNow ? 0 : DEFAULT_FLUSH_DELAY, this.FLUSH);
            }
        }
    }

    private void sendUserInput(@NotNull CharSequence typedText) {
        if (typedText == null) {
            ConsoleViewImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myState.isRunning() && NEW_LINE_MATCHER.indexIn(typedText) >= 0) {
            StringBuilder textToSend = new StringBuilder();
            RangeMarker marker = this.findTokenMarker(this.myEditor.getCaretModel().getOffset() - 1);
            while (marker != null) {
                ConsoleViewContentType tokenType = ConsoleViewImpl.getTokenType(marker);
                if (tokenType != null) {
                    if (tokenType != ConsoleViewContentType.USER_INPUT || marker.getUserData(USER_INPUT_SENT) == Boolean.TRUE) break;
                    marker.putUserData(USER_INPUT_SENT, (Object)true);
                    textToSend.insert(0, marker.getDocument().getText(TextRange.create((Segment)marker)));
                }
                marker = ((RangeMarkerImpl)marker).findRangeMarkerBefore();
            }
            if (textToSend.length() != 0) {
                this.myFlushUserInputAlarm.addRequest(() -> {
                    if (this.myState.isRunning()) {
                        try {
                            this.myState.sendUserInput(textToSend.toString());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, 0);
            }
        }
    }

    protected ModalityState getStateForUpdate() {
        return null;
    }

    private void requestFlushImmediately() {
        if (this.myEditor != null) {
            this.addFlushRequest(0, this.FLUSH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentSize() {
        int length;
        Object object = this.LOCK;
        synchronized (object) {
            length = this.myDeferredBuffer.length();
        }
        return (this.myEditor == null || this.CLEAR.hasRequested() ? 0 : this.myEditor.getDocument().getTextLength()) + length;
    }

    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDeferredText() {
        List<TokenBuffer.TokenInfo> deferredTokens;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        boolean shouldStickToEnd = !this.myCancelStickToEnd && this.isStickingToEnd();
        this.myCancelStickToEnd = false;
        Ref addedTextRef = Ref.create();
        DocumentEx document = this.myEditor.getDocument();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myOutputPaused) {
                return;
            }
            deferredTokens = this.myDeferredBuffer.drain();
            if (deferredTokens.isEmpty()) {
                return;
            }
            this.cancelHeavyAlarm();
        }
        RangeMarker lastProcessedOutput = document.createRangeMarker(document.getTextLength(), document.getTextLength());
        if (!shouldStickToEnd) {
            this.myEditor.getScrollingModel().accumulateViewportChanges();
        }
        HashSet<ConsoleViewContentType> contentTypes = new HashSet<ConsoleViewContentType>();
        ArrayList<Pair> contents = new ArrayList<Pair>();
        try {
            int lineCount;
            ArrayList refinedTokens;
            int startIndex;
            int backspacePrefixLength;
            boolean startsWithCR;
            boolean bl = startsWithCR = deferredTokens.get(0) == TokenBuffer.CR_TOKEN;
            if (startsWithCR && document.getLineCount() != 0) {
                int lineStartOffset = document.getLineStartOffset(document.getLineCount() - 1);
                document.deleteString(lineStartOffset, document.getTextLength());
            }
            if ((backspacePrefixLength = ConsoleViewImpl.evaluateBackspacesInTokens(deferredTokens, startIndex = startsWithCR ? 1 : 0, refinedTokens = new ArrayList(deferredTokens.size() - startIndex))) > 0 && (lineCount = document.getLineCount()) != 0) {
                int lineStartOffset = document.getLineStartOffset(lineCount - 1);
                document.deleteString(Math.max(lineStartOffset, document.getTextLength() - backspacePrefixLength), document.getTextLength());
            }
            addedTextRef.set((Object)TokenBuffer.getRawText(refinedTokens));
            document.insertString(document.getTextLength(), (CharSequence)addedTextRef.get());
            int offset = document.getTextLength();
            int tokenLength = 0;
            for (int i2 = refinedTokens.size() - 1; i2 >= 0; --i2) {
                int start2;
                TokenBuffer.TokenInfo prevToken;
                TokenBuffer.TokenInfo token2 = (TokenBuffer.TokenInfo)refinedTokens.get(i2);
                contentTypes.add(token2.contentType);
                contents.add(new Pair((Object)token2.getText(), (Object)token2.contentType));
                TokenBuffer.TokenInfo tokenInfo = prevToken = i2 == 0 ? null : (TokenBuffer.TokenInfo)refinedTokens.get(i2 - 1);
                if (prevToken != null && token2.contentType == prevToken.contentType && token2.getHyperlinkInfo() == prevToken.getHyperlinkInfo() || (start2 = Math.max(0, offset - (tokenLength += token2.length()))) == offset) continue;
                HyperlinkInfo info = token2.getHyperlinkInfo();
                if (info != null) {
                    this.myHyperlinks.createHyperlink(start2, offset, null, info).putUserData(MANUAL_HYPERLINK, (Object)true);
                }
                this.createTokenRangeHighlighter(token2.contentType, start2, offset);
                offset = start2;
                tokenLength = 0;
            }
        }
        finally {
            if (!shouldStickToEnd) {
                this.myEditor.getScrollingModel().flushViewportChanges();
            }
        }
        if (!contentTypes.isEmpty()) {
            for (ObservableConsoleView.ChangeListener each : this.myListeners) {
                each.contentAdded(contentTypes);
            }
        }
        if (!contents.isEmpty()) {
            for (ObservableConsoleView.ChangeListener each : this.myListeners) {
                for (int i3 = contents.size() - 1; i3 >= 0; --i3) {
                    each.textAdded((String)((Pair)contents.get((int)i3)).first, (ConsoleViewContentType)((Pair)contents.get((int)i3)).second);
                }
            }
        }
        this.myPsiDisposedCheck.performCheck();
        int startLine = lastProcessedOutput.isValid() ? this.myEditor.getDocument().getLineNumber(lastProcessedOutput.getEndOffset()) : 0;
        lastProcessedOutput.dispose();
        this.highlightHyperlinksAndFoldings(startLine);
        if (shouldStickToEnd) {
            this.scrollToEnd();
        }
        this.sendUserInput((CharSequence)addedTextRef.get());
    }

    private static int evaluateBackspacesInTokens(@NotNull List<? extends TokenBuffer.TokenInfo> source, int sourceStartIndex, @NotNull List<? super TokenBuffer.TokenInfo> dest) {
        if (source == null) {
            ConsoleViewImpl.$$$reportNull$$$0(19);
        }
        if (dest == null) {
            ConsoleViewImpl.$$$reportNull$$$0(20);
        }
        int backspacesFromNextToken = 0;
        for (int i2 = source.size() - 1; i2 >= sourceStartIndex; --i2) {
            TokenBuffer.TokenInfo newToken;
            TokenBuffer.TokenInfo token2 = source.get(i2);
            if (StringUtil.containsChar((String)token2.getText(), (char)'\b') || backspacesFromNextToken > 0) {
                StringBuilder tokenTextBuilder = new StringBuilder(token2.getText().length() + backspacesFromNextToken);
                tokenTextBuilder.append(token2.getText());
                StringUtil.repeatSymbol((Appendable)tokenTextBuilder, (char)'\b', (int)backspacesFromNextToken);
                ConsoleViewImpl.normalizeBackspaceCharacters(tokenTextBuilder);
                backspacesFromNextToken = ConsoleViewImpl.getBackspacePrefixLength(tokenTextBuilder);
                String newText = tokenTextBuilder.substring(backspacesFromNextToken);
                newToken = new TokenBuffer.TokenInfo(token2.contentType, newText, token2.getHyperlinkInfo());
            } else {
                newToken = token2;
            }
            dest.add(newToken);
        }
        Collections.reverse(dest);
        return backspacesFromNextToken;
    }

    private static int getBackspacePrefixLength(@NotNull CharSequence text2) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(21);
        }
        return StringUtil.countChars((CharSequence)text2, (char)'\b', (int)0, (boolean)true);
    }

    private static void normalizeBackspaceCharacters(@NotNull StringBuilder text2) {
        int ind;
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(22);
        }
        if ((ind = StringUtil.indexOf((CharSequence)text2, (char)'\b')) < 0) {
            return;
        }
        int guardLength = 0;
        int newLength = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            boolean append;
            char ch = text2.charAt(i2);
            if (ch == '\b') {
                assert (guardLength <= newLength);
                if (guardLength == newLength) {
                    append = guardLength == 0;
                } else {
                    boolean bl = append = text2.charAt(newLength - 1) == '\b';
                    if (!append) {
                        --newLength;
                    }
                }
            } else {
                append = true;
            }
            if (!append) continue;
            text2.setCharAt(newLength, ch);
            ++newLength;
            if (ch != '\r' && ch != '\n') continue;
            guardLength = newLength;
        }
        text2.setLength(newLength);
    }

    private void createTokenRangeHighlighter(@NotNull ConsoleViewContentType contentType, int startOffset, int endOffset) {
        if (contentType == null) {
            ConsoleViewImpl.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        int layer = 1001;
        model2.addRangeHighlighterAndChangeAttributes(contentType.getAttributesKey(), startOffset, endOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)ex -> {
            if (ex.getTextAttributesKey() == null) {
                ex.setTextAttributes(contentType.getAttributes());
            }
            ex.putUserData(CONTENT_TYPE, contentType);
        }));
    }

    private boolean isDisposed() {
        return this.myProject.isDisposed() || this.myEditor == null || this.myEditor.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        DocumentEx document = this.myEditor.getDocument();
        int documentTextLength = document.getTextLength();
        if (documentTextLength > 0) {
            DocumentUtil.executeInBulk(document, true, () -> document.deleteString(0, documentTextLength));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.clearHyperlinkAndFoldings();
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        model2.removeAllHighlighters();
        this.myEditor.getInlayModel().getInlineElementsInRange(0, 0).forEach(Disposer::dispose);
    }

    private boolean isStickingToEnd() {
        int caretOffset;
        if (this.myEditor == null) {
            return this.myLastStickingToEnd;
        }
        DocumentEx document = this.myEditor.getDocument();
        this.myLastStickingToEnd = document.getLineNumber(caretOffset = this.myEditor.getCaretModel().getOffset()) >= document.getLineCount() - 1;
        return this.myLastStickingToEnd;
    }

    private void clearHyperlinkAndFoldings() {
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            if (highlighter.getUserData(MANUAL_HYPERLINK) != null) continue;
            this.myEditor.getMarkupModel().removeHighlighter(highlighter);
        }
        this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myEditor.getFoldingModel().clearFoldRegions());
        this.cancelHeavyAlarm();
    }

    private void cancelHeavyAlarm() {
        if (!this.myHeavyAlarm.isDisposed()) {
            this.myHeavyAlarm.cancelAllRequests();
            ++this.myHeavyUpdateTicket;
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(24);
        }
        if (this.myEditor == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            int offset = this.myEditor.getCaretModel().getOffset();
            final HyperlinkInfo info = this.myHyperlinks.getHyperlinkAt(offset);
            return info == null ? null : new Navigatable(){

                public void navigate(boolean requestFocus) {
                    info.navigate(ConsoleViewImpl.this.myProject);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(25);
        }
        this.myHelpId = helpId;
    }

    public void setUpdateFoldingsEnabled(boolean updateFoldingsEnabled) {
        this.myUpdateFoldingsEnabled = updateFoldingsEnabled;
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            ConsoleViewImpl.$$$reportNull$$$0(26);
        }
        this.myCustomFilters.add(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            ConsoleViewImpl.$$$reportNull$$$0(27);
        }
        this.print(hyperlinkText, ConsoleViewContentType.NORMAL_OUTPUT, info);
    }

    @NotNull
    private EditorEx createConsoleEditor() {
        EditorEx editorEx = (EditorEx)ReadAction.compute(() -> {
            EditorEx editor = this.doCreateConsoleEditor();
            LOG.assertTrue(UndoUtil.isUndoDisabledFor((Document)editor.getDocument()));
            editor.installPopupHandler(new ContextMenuPopupHandler(){

                @Override
                public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                    if (event == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return ConsoleViewImpl.this.getPopupGroup(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/ConsoleViewImpl$7", "getActionGroup"));
                }
            });
            int bufferSize = ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : 0;
            editor.getDocument().setCyclicBufferSize(bufferSize);
            editor.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, this);
            editor.getSettings().setAllowSingleLogicalLineFolding(true);
            return editor;
        });
        if (editorEx == null) {
            ConsoleViewImpl.$$$reportNull$$$0(28);
        }
        return editorEx;
    }

    @NotNull
    protected EditorEx doCreateConsoleEditor() {
        EditorEx editorEx = ConsoleViewUtil.setupConsoleEditor(this.myProject, true, false);
        if (editorEx == null) {
            ConsoleViewImpl.$$$reportNull$$$0(29);
        }
        return editorEx;
    }

    private void registerConsoleEditorActions() {
        Object[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"GotoDeclaration").getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet((Shortcut[])ArrayUtil.mergeArrays((Object[])shortcuts, (Object[])CommonShortcuts.ENTER.getShortcuts()));
        new HyperlinkNavigationAction().registerCustomShortcutSet((ShortcutSet)shortcutSet, this.myEditor.getContentComponent());
        if (!this.myIsViewer) {
            new EnterHandler().registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getContentComponent());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorPaste", new PasteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorBackSpace", new BackSpaceHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorDelete", new DeleteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorTab", new TabHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "SendEOF");
        }
    }

    private static void registerActionHandler(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            ConsoleViewImpl.$$$reportNull$$$0(30);
        }
        if (actionId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(31);
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), editor.getContentComponent());
    }

    private static void registerActionHandler(@NotNull Editor editor, @NotNull String actionId, @NotNull AnAction action2) {
        if (editor == null) {
            ConsoleViewImpl.$$$reportNull$$$0(32);
        }
        if (actionId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(33);
        }
        if (action2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(34);
        }
        Keymap keymap2 = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap2.getShortcuts(actionId);
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), editor.getContentComponent());
    }

    @NotNull
    private ActionGroup getPopupGroup(@NotNull EditorMouseEvent event) {
        if (event == null) {
            ConsoleViewImpl.$$$reportNull$$$0(35);
        }
        ActionManager actionManager = ActionManager.getInstance();
        HyperlinkInfo info = this.myHyperlinks != null ? this.myHyperlinks.getHyperlinkInfoByEvent(event) : null;
        ActionGroup group2 = null;
        if (info instanceof HyperlinkWithPopupMenuInfo) {
            group2 = ((HyperlinkWithPopupMenuInfo)info).getPopupMenuGroup(event.getMouseEvent());
        }
        if (group2 == null) {
            group2 = (ActionGroup)actionManager.getAction(CONSOLE_VIEW_POPUP_MENU);
        }
        List postProcessors = ConsoleActionsPostProcessor.EP_NAME.getExtensionList();
        AnAction[] result2 = group2.getChildren(null);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcessPopupActions((ConsoleView)this, result2);
        }
        return new DefaultActionGroup(result2);
    }

    private void highlightHyperlinksAndFoldings(int startLine) {
        boolean canHighlightHyperlinks;
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompositeFilter compositeFilter = this.createCompositeFilter();
        boolean bl = canHighlightHyperlinks = !compositeFilter.isEmpty();
        if (!canHighlightHyperlinks && !this.myUpdateFoldingsEnabled) {
            return;
        }
        DocumentEx document = this.myEditor.getDocument();
        if (document.getTextLength() == 0) {
            return;
        }
        int endLine = Math.max(0, document.getLineCount() - 1);
        if (canHighlightHyperlinks) {
            this.myHyperlinks.highlightHyperlinks((Filter)compositeFilter, startLine, endLine);
        }
        if (this.myAllowHeavyFilters && compositeFilter.isAnyHeavy() && compositeFilter.shouldRunHeavy()) {
            this.runHeavyFilters(compositeFilter, startLine, endLine);
        }
        if (this.myUpdateFoldingsEnabled) {
            this.updateFoldings(startLine, endLine);
        }
    }

    public void rehighlightHyperlinksAndFoldings() {
        if (this.myEditor == null || this.myProject.isDisposed()) {
            return;
        }
        this.clearHyperlinkAndFoldings();
        this.highlightHyperlinksAndFoldings(0);
    }

    private void runHeavyFilters(@NotNull CompositeFilter compositeFilter, int line1, int endLine) {
        if (compositeFilter == null) {
            ConsoleViewImpl.$$$reportNull$$$0(36);
        }
        int startLine = Math.max(0, line1);
        DocumentEx document = this.myEditor.getDocument();
        int startOffset = document.getLineStartOffset(startLine);
        String text2 = document.getText(new TextRange(startOffset, document.getLineEndOffset(endLine)));
        DocumentImpl documentCopy = new DocumentImpl(text2, true);
        documentCopy.setReadOnly(true);
        this.myJLayeredPane.startUpdating();
        final int currentValue = this.myHeavyUpdateTicket;
        this.myHeavyAlarm.addRequest(() -> {
            if (!compositeFilter.shouldRunHeavy()) {
                return;
            }
            try {
                compositeFilter.applyHeavyFilter(documentCopy, startOffset, startLine, additionalHighlight -> this.addFlushRequest(0, new FlushRunnable(true, (FilterMixin.AdditionalHighlight)additionalHighlight){
                    final /* synthetic */ FilterMixin.AdditionalHighlight val$additionalHighlight;
                    {
                        this.val$additionalHighlight = additionalHighlight;
                        super(adHoc);
                    }

                    @Override
                    public void doRun() {
                        if (ConsoleViewImpl.this.myHeavyUpdateTicket != currentValue) {
                            return;
                        }
                        TextAttributes additionalAttributes = this.val$additionalHighlight.getTextAttributes(null);
                        if (additionalAttributes != null) {
                            Filter.ResultItem item = (Filter.ResultItem)this.val$additionalHighlight.getResultItems().get(0);
                            ConsoleViewImpl.this.myHyperlinks.addHighlighter(item.getHighlightStartOffset(), item.getHighlightEndOffset(), additionalAttributes);
                        } else {
                            ConsoleViewImpl.this.myHyperlinks.highlightHyperlinks((Filter.Result)this.val$additionalHighlight, 0);
                        }
                    }
                }));
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
            finally {
                if (this.myHeavyAlarm.getActiveRequestCount() <= 1) {
                    UIUtil.invokeLaterIfNeeded(() -> this.myJLayeredPane.finishUpdating());
                }
            }
        }, 0);
    }

    protected void updateFoldings(int startLine, int endLine) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
            int prevLineStart;
            FoldRegion[] regions;
            DocumentEx document = this.myEditor.getDocument();
            FoldRegion existingRegion = null;
            if (startLine > 0 && (regions = FoldingUtil.getFoldRegionsAtOffset(this.myEditor, prevLineStart = document.getLineStartOffset(startLine - 1))).length == 1) {
                existingRegion = regions[0];
            }
            ConsoleFolding lastFolding = this.findFoldingByRegion(existingRegion);
            int lastStartLine = Integer.MAX_VALUE;
            if (lastFolding != null) {
                int offset = existingRegion.getStartOffset();
                if (offset == 0) {
                    lastStartLine = 0;
                } else {
                    lastStartLine = document.getLineNumber(offset);
                    if (document.getLineStartOffset(lastStartLine) != offset) {
                        ++lastStartLine;
                    }
                }
            }
            for (int line = startLine; line <= endLine; ++line) {
                ConsoleFolding next;
                ConsoleFolding consoleFolding = next = line < endLine ? this.foldingForLine(line, document) : null;
                if (next == lastFolding) continue;
                if (lastFolding != null) {
                    boolean isExpanded = false;
                    if (line > startLine && existingRegion != null && lastStartLine < startLine) {
                        isExpanded = existingRegion.isExpanded();
                        this.myEditor.getFoldingModel().removeFoldRegion(existingRegion);
                    }
                    this.addFoldRegion(document, lastFolding, lastStartLine, line - 1, isExpanded);
                }
                lastFolding = next;
                lastStartLine = line;
                existingRegion = null;
            }
        });
    }

    private void addFoldRegion(@NotNull Document document, @NotNull ConsoleFolding folding2, int startLine, int endLine, boolean isExpanded) {
        FoldRegion region;
        if (document == null) {
            ConsoleViewImpl.$$$reportNull$$$0(37);
        }
        if (folding2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(38);
        }
        ArrayList<String> toFold = new ArrayList<String>(endLine - startLine + 1);
        for (int i2 = startLine; i2 <= endLine; ++i2) {
            toFold.add(EditorHyperlinkSupport.getLineText(document, i2, false));
        }
        int oStart = document.getLineStartOffset(startLine);
        if (oStart > 0 && folding2.shouldBeAttachedToThePreviousLine()) {
            --oStart;
        }
        int oEnd = CharArrayUtil.shiftBackward((CharSequence)document.getImmutableCharSequence(), (int)(document.getLineEndOffset(endLine) - 1), (String)" \t") + 1;
        String placeholder = folding2.getPlaceholderText(this.getProject(), toFold);
        FoldRegion foldRegion = region = placeholder == null ? null : this.myEditor.getFoldingModel().addFoldRegion(oStart, oEnd, placeholder);
        if (region != null) {
            region.setExpanded(isExpanded);
            region.putUserData(USED_FOLDING_FQN_KEY, (Object)ConsoleViewImpl.getFoldingFqn(folding2));
        }
    }

    @Nullable
    @Contract(value="null -> null")
    private ConsoleFolding findFoldingByRegion(@Nullable FoldRegion region) {
        String lastFoldingFqn = (String)USED_FOLDING_FQN_KEY.get((UserDataHolder)region);
        if (lastFoldingFqn == null) {
            return null;
        }
        ConsoleFolding consoleFolding = (ConsoleFolding)ConsoleFolding.EP_NAME.getByKey((Object)lastFoldingFqn, ConsoleViewImpl.class, ConsoleViewImpl::getFoldingFqn);
        return consoleFolding != null && consoleFolding.isEnabledForConsole(this) ? consoleFolding : null;
    }

    @NotNull
    private static String getFoldingFqn(@NotNull ConsoleFolding consoleFolding) {
        if (consoleFolding == null) {
            ConsoleViewImpl.$$$reportNull$$$0(39);
        }
        String string = consoleFolding.getClass().getName();
        if (string == null) {
            ConsoleViewImpl.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Nullable
    private ConsoleFolding foldingForLine(int line, @NotNull Document document) {
        if (document == null) {
            ConsoleViewImpl.$$$reportNull$$$0(41);
        }
        String lineText = EditorHyperlinkSupport.getLineText(document, line, false);
        if (line == 0 && this.myCommandLineFolding.shouldFoldLine(this.myProject, lineText)) {
            return this.myCommandLineFolding;
        }
        for (ConsoleFolding extension2 : (ConsoleFolding[])ConsoleFolding.EP_NAME.getExtensions()) {
            if (!extension2.isEnabledForConsole(this) || !extension2.shouldFoldLine(this.myProject, lineText)) continue;
            return extension2;
        }
        return null;
    }

    private RangeMarker findTokenMarker(int offset) {
        RangeMarker[] marker = new RangeMarker[1];
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        model2.processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)m -> {
            if (ConsoleViewImpl.getTokenType(m) == null || m.getStartOffset() > offset || offset + 1 > m.getEndOffset()) {
                return true;
            }
            marker[0] = m;
            return false;
        }));
        return marker[0];
    }

    private static ConsoleViewContentType getTokenType(@Nullable RangeMarker m) {
        return m == null ? null : (ConsoleViewContentType)m.getUserData(CONTENT_TYPE);
    }

    private void type(@NotNull Editor editor, @NotNull String text2) {
        int typeOffset;
        if (editor == null) {
            ConsoleViewImpl.$$$reportNull$$$0(42);
        }
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(43);
        }
        this.flushDeferredText();
        SelectionModel selectionModel = editor.getSelectionModel();
        int lastOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset() - 1;
        RangeMarker marker = this.findTokenMarker(lastOffset);
        if (ConsoleViewImpl.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            this.print(text2, ConsoleViewContentType.USER_INPUT);
            ConsoleViewImpl.moveScrollRemoveSelection(editor, editor.getDocument().getTextLength());
            return;
        }
        String textToUse = StringUtil.convertLineSeparators((String)text2);
        if (selectionModel.hasSelection()) {
            Document document = editor.getDocument();
            int start2 = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            document.deleteString(start2, end);
            selectionModel.removeSelection();
            typeOffset = end;
        } else {
            typeOffset = editor.getCaretModel().getOffset();
        }
        this.insertUserText(typeOffset, textToUse);
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        this.getComponent();
        JComponent jComponent = this.myEditor.getContentComponent();
        if (jComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(44);
        }
        return jComponent;
    }

    public boolean hasNextOccurence() {
        return this.calcNextOccurrence(1) != null;
    }

    public boolean hasPreviousOccurence() {
        return this.calcNextOccurrence(-1) != null;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.calcNextOccurrence(1);
    }

    @Nullable
    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        if (this.myHyperlinks == null) {
            return null;
        }
        return EditorHyperlinkSupport.getNextOccurrence(this.myEditor, delta, (Consumer<? super RangeHighlighter>)((Consumer)next -> {
            int offset = next.getStartOffset();
            this.scrollTo(offset);
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(next);
            if (hyperlinkInfo instanceof BrowserHyperlinkInfo) {
                return;
            }
            if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                VisualPosition position = this.myEditor.offsetToVisualPosition(offset);
                Point point = this.myEditor.visualPositionToXY(new VisualPosition(position.getLine() + 1, position.getColumn()));
                ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint((Component)this.myEditor.getContentComponent(), point));
            } else if (hyperlinkInfo != null) {
                hyperlinkInfo.navigate(this.myProject);
            }
        }));
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.calcNextOccurrence(-1);
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
        if (string == null) {
            ConsoleViewImpl.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
        if (string == null) {
            ConsoleViewImpl.$$$reportNull$$$0(46);
        }
        return string;
    }

    public void addCustomConsoleAction(@NotNull AnAction action2) {
        if (action2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(47);
        }
        this.customActions.add(action2);
    }

    public AnAction @NotNull [] createConsoleActions() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
        prevAction.getTemplatePresentation().setText(this.getPreviousOccurenceActionName());
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
        nextAction.getTemplatePresentation().setText(this.getNextOccurenceActionName());
        ToggleUseSoftWrapsToolbarAction switchSoftWrapsAction = new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

            @Override
            protected Editor getEditor(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                return ConsoleViewImpl.this.myEditor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/ConsoleViewImpl$9", "getEditor"));
            }
        };
        ScrollToTheEndToolbarAction autoScrollToTheEndAction = new ScrollToTheEndToolbarAction(this.myEditor);
        ArrayList<Object> consoleActions = new ArrayList<Object>();
        consoleActions.add(prevAction);
        consoleActions.add(nextAction);
        consoleActions.add((Object)switchSoftWrapsAction);
        consoleActions.add((Object)autoScrollToTheEndAction);
        consoleActions.add(ActionManager.getInstance().getAction("Print"));
        consoleActions.add((Object)new ClearThisConsoleAction(this));
        consoleActions.addAll(this.customActions);
        List postProcessors = ConsoleActionsPostProcessor.EP_NAME.getExtensionList();
        AnAction[] result2 = consoleActions.toArray(AnAction.EMPTY_ARRAY);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcess((ConsoleView)this, result2);
        }
        if (result2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(48);
        }
        return result2;
    }

    public void allowHeavyFilters() {
        this.myAllowHeavyFilters = true;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(49);
        }
        if (parent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(50);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> this.myListeners.remove(listener2));
    }

    private void insertUserText(int offset, @NotNull String text2) {
        List result2;
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(51);
        }
        if ((result2 = this.myInputMessageFilter.applyFilter(text2, ConsoleViewContentType.USER_INPUT)) == null) {
            this.doInsertUserInput(offset, text2);
        } else {
            for (Pair pair : result2) {
                String chunkText = (String)pair.getFirst();
                ConsoleViewContentType chunkType = (ConsoleViewContentType)pair.getSecond();
                if (chunkType.equals(ConsoleViewContentType.USER_INPUT)) {
                    this.doInsertUserInput(offset, chunkText);
                    offset += chunkText.length();
                    continue;
                }
                this.print(chunkText, chunkType, null);
            }
        }
    }

    private void doInsertUserInput(int offset, @NotNull String text2) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(52);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorEx editor = this.myEditor;
        Document document = editor.getDocument();
        int oldDocLength = document.getTextLength();
        document.insertString(offset, (CharSequence)text2);
        int newStartOffset = Math.max(0, document.getTextLength() - oldDocLength + offset - text2.length());
        int newEndOffset = document.getTextLength() - oldDocLength + offset;
        if (this.findTokenMarker(newEndOffset) == null) {
            this.createTokenRangeHighlighter(ConsoleViewContentType.USER_INPUT, newStartOffset, newEndOffset);
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor, newEndOffset);
        this.sendUserInput(text2);
    }

    private static void moveScrollRemoveSelection(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ConsoleViewImpl.$$$reportNull$$$0(53);
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private void deleteUserText(int startOffset, int length) {
        EditorEx editor = this.myEditor;
        Document document = editor.getDocument();
        RangeMarker marker = this.findTokenMarker(startOffset);
        if (ConsoleViewImpl.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            return;
        }
        int endOffset = startOffset + length;
        if (startOffset >= 0 && endOffset >= 0 && endOffset > startOffset) {
            document.deleteString(startOffset, endOffset);
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor, startOffset);
    }

    public boolean isRunning() {
        return this.myState.isRunning();
    }

    public void addNotificationComponent(@NotNull JComponent notificationComponent) {
        if (notificationComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(54);
        }
        this.add((Component)notificationComponent, "North");
    }

    @TestOnly
    @NotNull
    ConsoleState getState() {
        ConsoleState consoleState = this.myState;
        if (consoleState == null) {
            ConsoleViewImpl.$$$reportNull$$$0(55);
        }
        return consoleState;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ConsoleViewImpl.$$$reportNull$$$0(56);
        }
        return project;
    }

    @NotNull
    public String getText() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            ConsoleViewImpl.$$$reportNull$$$0(57);
        }
        return string;
    }

    static {
        NEW_LINE_MATCHER = CharMatcher.anyOf((CharSequence)"\n\r");
        USED_FOLDING_FQN_KEY = Key.create((String)"USED_FOLDING_KEY");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushRunnable";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 43: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 30: 
            case 32: 
            case 42: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 34: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeFilter";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folding";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleFolding";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleEditor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingFqn";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFlushRequest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performLaterWhenNoDeferredOutput";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLayerToPane";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sendUserInput";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBackspacesInTokens";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBackspacePrefixLength";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBackspaceCharacters";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTokenRangeHighlighter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerActionHandler";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPopupGroup";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyFilters";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingFqn";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "foldingForLine";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addCustomConsoleAction";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "insertUserText";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "doInsertUserInput";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "moveScrollRemoveSelection";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 29: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HyperlinkNavigationAction
    extends DumbAwareAction {
        private HyperlinkNavigationAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HyperlinkNavigationAction.$$$reportNull$$$0(0);
            }
            Runnable runnable2 = ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition());
            assert (runnable2 != null);
            runnable2.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HyperlinkNavigationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition()) != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$HyperlinkNavigationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ClearRunnable
    extends FlushRunnable {
        private ClearRunnable() {
            super(false);
        }

        @Override
        public void doRun() {
            ConsoleViewImpl.this.doClear();
        }
    }

    private class FlushRunnable
    implements Runnable {
        private final AtomicBoolean requested = new AtomicBoolean();
        private final boolean adHoc;

        private FlushRunnable(boolean adHoc) {
            this.adHoc = adHoc;
        }

        void queue(long delay) {
            if (ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                return;
            }
            if (this.adHoc || this.requested.compareAndSet(false, true)) {
                ConsoleViewImpl.this.myFlushAlarm.addRequest((Runnable)this, delay, ConsoleViewImpl.this.getStateForUpdate());
            }
        }

        void clearRequested() {
            this.requested.set(false);
        }

        boolean hasRequested() {
            return this.requested.get();
        }

        @Override
        public final void run() {
            if (ConsoleViewImpl.this.isDisposed()) {
                return;
            }
            if (!StartupManagerEx.getInstanceEx(ConsoleViewImpl.this.myProject).startupActivityPassed()) {
                ConsoleViewImpl.this.addFlushRequest(DEFAULT_FLUSH_DELAY, ConsoleViewImpl.this.FLUSH);
            }
            this.clearRequested();
            this.doRun();
        }

        protected void doRun() {
            ConsoleViewImpl.this.flushDeferredText();
        }
    }

    private class CommandLineFolding
    extends ConsoleFolding {
        private CommandLineFolding() {
        }

        @Override
        public boolean shouldFoldLine(@NotNull Project project, @NotNull String line) {
            if (project == null) {
                CommandLineFolding.$$$reportNull$$$0(0);
            }
            if (line == null) {
                CommandLineFolding.$$$reportNull$$$0(1);
            }
            return line.length() >= 1000 && ConsoleViewImpl.this.myState.isCommandLine(line);
        }

        @Override
        public String getPlaceholderText(@NotNull Project project, @NotNull List<String> lines2) {
            if (project == null) {
                CommandLineFolding.$$$reportNull$$$0(2);
            }
            if (lines2 == null) {
                CommandLineFolding.$$$reportNull$$$0(3);
            }
            String text2 = lines2.get(0);
            int index2 = 0;
            if (text2.charAt(0) == '\"') {
                index2 = text2.indexOf(34, 1) + 1;
            }
            if (index2 == 0) {
                boolean nonWhiteSpaceFound = false;
                while (index2 < text2.length()) {
                    char c = text2.charAt(index2);
                    if (c != ' ' && c != '\t') {
                        nonWhiteSpaceFound = true;
                    } else if (nonWhiteSpaceFound) break;
                    ++index2;
                }
            }
            assert (index2 <= text2.length());
            return text2.substring(0, index2) + " ...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$CommandLineFolding";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldFoldLine";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPlaceholderText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TabHandler
    extends ConsoleAction {
        private TabHandler() {
        }

        @Override
        protected void execute(@NotNull ConsoleViewImpl console2, @NotNull DataContext context) {
            if (console2 == null) {
                TabHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TabHandler.$$$reportNull$$$0(1);
            }
            console2.type(console2.myEditor, "\t");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$TabHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeleteHandler
    extends ConsoleAction {
        private DeleteHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            EditorEx editor;
            if (consoleView == null) {
                DeleteHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DeleteHandler.$$$reportNull$$$0(1);
            }
            if (IncrementalSearchHandler.isHintVisible(editor = consoleView.myEditor)) {
                DeleteHandler.getDefaultActionHandler().execute((Editor)editor, null, context);
                return;
            }
            consoleView.flushDeferredText();
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else {
                consoleView.deleteUserText(editor.getCaretModel().getOffset(), 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$DeleteHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BackSpaceHandler
    extends ConsoleAction {
        private BackSpaceHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            EditorEx editor;
            if (consoleView == null) {
                BackSpaceHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BackSpaceHandler.$$$reportNull$$$0(1);
            }
            if (IncrementalSearchHandler.isHintVisible(editor = consoleView.myEditor)) {
                BackSpaceHandler.getDefaultActionHandler().execute((Editor)editor, null, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else if (editor.getCaretModel().getOffset() > 0) {
                consoleView.deleteUserText(editor.getCaretModel().getOffset() - 1, 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$BackSpaceHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PasteHandler
    extends ConsoleAction {
        private PasteHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            String text2;
            if (consoleView == null) {
                PasteHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PasteHandler.$$$reportNull$$$0(1);
            }
            if ((text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) == null) {
                return;
            }
            EditorEx editor = consoleView.myEditor;
            consoleView.type(editor, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$PasteHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EnterHandler
    extends ConsoleAction {
        private EnterHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            if (consoleView == null) {
                EnterHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EnterHandler.$$$reportNull$$$0(1);
            }
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            consoleView.flushDeferredText();
            EditorEx editor = consoleView.myEditor;
            ConsoleViewImpl.moveScrollRemoveSelection(editor, editor.getDocument().getTextLength());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$EnterHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ConsoleAction
    extends AnAction
    implements DumbAware {
        private ConsoleAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConsoleAction.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DataContext context = e.getDataContext();
            ConsoleViewImpl console2 = ConsoleAction.getRunningConsole(context);
            if (console2 != null) {
                this.execute(console2, context);
            }
        }

        protected abstract void execute(@NotNull ConsoleViewImpl var1, @NotNull DataContext var2);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ConsoleAction.$$$reportNull$$$0(1);
            }
            ConsoleViewImpl console2 = ConsoleAction.getRunningConsole(e.getDataContext());
            e.getPresentation().setEnabled(console2 != null);
        }

        @Nullable
        private static ConsoleViewImpl getRunningConsole(@NotNull DataContext context) {
            ConsoleViewImpl console2;
            Editor editor;
            if (context == null) {
                ConsoleAction.$$$reportNull$$$0(2);
            }
            if ((editor = (Editor)CommonDataKeys.EDITOR.getData(context)) != null && (console2 = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) != null && console2.myState.isRunning()) {
                return console2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$ConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRunningConsole";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTypedHandler
    extends TypedActionHandlerBase {
        private MyTypedHandler(TypedActionHandler originalAction) {
            super(originalAction);
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            ConsoleViewImpl consoleView;
            if (editor == null) {
                MyTypedHandler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyTypedHandler.$$$reportNull$$$0(1);
            }
            if ((consoleView = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) == null || !consoleView.myState.isRunning() || consoleView.myIsViewer) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
                return;
            }
            String text2 = String.valueOf(charTyped);
            consoleView.type(editor, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public static class ClearAllAction
    extends ClearConsoleAction {
    }

    private static class ClearThisConsoleAction
    extends ClearConsoleAction {
        private final ConsoleView myConsoleView;

        ClearThisConsoleAction(@NotNull ConsoleView consoleView) {
            if (consoleView == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(0);
            }
            this.myConsoleView = consoleView;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.myConsoleView.getContentSize() > 0;
            e.getPresentation().setEnabled(enabled);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(2);
            }
            this.myConsoleView.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$ClearThisConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

