/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/console/ConsoleHistoryCopyHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getOriginalHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "doCopyWithoutPrompt", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "doExecute", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.platform.lang.impl"})
public final class ConsoleHistoryCopyHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;
    @JvmField
    @NotNull
    public static final Key<Integer> PROMPT_LENGTH_MARKER;
    @NotNull
    public static final Companion Companion;

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                RichCopySettings richCopySettings = RichCopySettings.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)richCopySettings, (String)"RichCopySettings.getInstance()");
                if (!richCopySettings.isEnabled()) {
                    this.originalHandler.execute(editor, null, dataContext);
                    return;
                }
                if (Intrinsics.areEqual((Object)true, (Object)((Boolean)editor.getUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW))) ^ true) break block4;
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                if (caretModel.getAllCarets().size() == 1) break block5;
            }
            this.originalHandler.execute(editor, null, dataContext);
            return;
        }
        this.doCopyWithoutPrompt((EditorEx)editor);
    }

    /*
     * WARNING - void declaration
     */
    private final void doCopyWithoutPrompt(EditorEx editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        int start2 = selectionModel.getSelectionStart();
        SelectionModel selectionModel2 = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"editor.selectionModel");
        int end = selectionModel2.getSelectionEnd();
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        int beginLine = document.getLineNumber(start2);
        int endLine = document.getLineNumber(end);
        StringBuilder sb = new StringBuilder();
        int n = beginLine;
        int n2 = endLine;
        if (n <= n2) {
            while (true) {
                Ref r;
                void i2;
                int lineStart = document.getLineStartOffset((int)i2);
                Intrinsics.checkNotNullExpressionValue((Object)Ref.create(), (String)"Ref.create<Int>()");
                editor.getMarkupModel().processRangeHighlightersOverlappingWith(lineStart, lineStart, (Processor<? super RangeHighlighterEx>)((Processor)new Processor<RangeHighlighterEx>(r){
                    final /* synthetic */ Ref $r;

                    public final boolean process(RangeHighlighterEx it) {
                        Integer n = (Integer)it.getUserData(ConsoleHistoryCopyHandler.PROMPT_LENGTH_MARKER);
                        if (n == null) {
                            return true;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.getUserData(PROMPT_LE\u2026htersOverlappingWith true");
                        int length = n;
                        this.$r.set((Object)length);
                        return false;
                    }
                    {
                        this.$r = ref;
                    }
                }));
                if (!r.isNull()) {
                    Object object = r.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.get()");
                    lineStart += ((Number)object).intValue();
                }
                boolean bl = false;
                int rangeStart = Math.max(lineStart, start2);
                int n3 = document.getLineEndOffset((int)i2);
                boolean bl2 = false;
                int rangeEnd = Math.min(n3, end);
                if (rangeStart < rangeEnd) {
                    sb.append(document.getText(new TextRange(rangeStart, rangeEnd)));
                    if (rangeEnd < end) {
                        sb.append("\n");
                    }
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        CharSequence charSequence = sb;
        n2 = 0;
        if (charSequence.length() > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
        }
    }

    @NotNull
    public final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    public ConsoleHistoryCopyHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PROMPT_LENGTH_MARKER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Int>(\"PROMPT_LENGTH_MARKER\")");
        PROMPT_LENGTH_MARKER = key;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/console/ConsoleHistoryCopyHandler$Companion;", "", "()V", "PROMPT_LENGTH_MARKER", "Lcom/intellij/openapi/util/Key;", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

