/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesDialog
extends DialogWrapper {
    private final EnvironmentVariablesTextFieldWithBrowseButton myParent;
    private final EnvVariablesTable myUserTable;
    private final EnvVariablesTable mySystemTable;
    private final JCheckBox myIncludeSystemVarsCb;
    private final JPanel myWholePanel;

    protected EnvironmentVariablesDialog(EnvironmentVariablesTextFieldWithBrowseButton parent) {
        super((Component)((Object)parent), true);
        this.myParent = parent;
        LinkedHashMap<String, String> userMap = new LinkedHashMap<String, String>(this.myParent.getEnvs());
        TreeMap<String, String> parentMap = new TreeMap<String, String>(new GeneralCommandLine().getParentEnvironment());
        this.myParent.myParentDefaults.putAll(parentMap);
        Iterator iterator2 = userMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (!parentMap.containsKey(entry.getKey())) continue;
            parentMap.put((String)entry.getKey(), (String)entry.getValue());
            iterator2.remove();
        }
        List<EnvironmentVariable> userList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(userMap, false);
        List<EnvironmentVariable> systemList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(parentMap, true);
        this.myUserTable = new MyEnvVariablesTable(userList, true);
        this.mySystemTable = new MyEnvVariablesTable(systemList, false);
        this.myIncludeSystemVarsCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.system.title", (Object[])new Object[0]));
        this.myIncludeSystemVarsCb.setSelected(this.myParent.isPassParentEnvs());
        this.myIncludeSystemVarsCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentVariablesDialog.this.updateSysTableState();
            }
        });
        JLabel label2 = new JLabel(ExecutionBundle.message((String)"env.vars.user.title", (Object[])new Object[0]));
        label2.setLabelFor(this.myUserTable.getTableView().getComponent());
        this.myWholePanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0, gap 0, hidemode 3"));
        this.myWholePanel.add((Component)label2, "hmax pref, wrap");
        this.myWholePanel.add((Component)this.myUserTable.getComponent(), "push, grow, wrap, gaptop 5");
        this.myWholePanel.add((Component)this.myIncludeSystemVarsCb, "hmax pref, wrap, gaptop 5");
        this.myWholePanel.add((Component)this.mySystemTable.getComponent(), "push, grow, wrap, gaptop 5");
        this.updateSysTableState();
        this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "EnvironmentVariablesDialog";
    }

    private void updateSysTableState() {
        this.mySystemTable.getTableView().setEnabled(this.myIncludeSystemVarsCb.isSelected());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel2 = this.myWholePanel;
        if (jPanel2 == null) {
            EnvironmentVariablesDialog.$$$reportNull$$$0(0);
        }
        return jPanel2;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
            String name = variable.getName();
            String value2 = variable.getValue();
            if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)value2)) continue;
            if (!EnvironmentUtil.isValidName((String)name)) {
                return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.name", (Object[])new Object[]{name}));
            }
            if (EnvironmentUtil.isValidValue((String)value2)) continue;
            return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.value", (Object[])new Object[]{name, value2}));
        }
        return super.doValidate();
    }

    protected void doOKAction() {
        this.myUserTable.stopEditing();
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
        for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
            if (StringUtil.isEmpty((String)variable.getName()) && StringUtil.isEmpty((String)variable.getValue())) continue;
            envs.put(variable.getName(), variable.getValue());
        }
        for (EnvironmentVariable variable : this.mySystemTable.getEnvironmentVariables()) {
            if (!this.myParent.isModifiedSysEnv(variable)) continue;
            envs.put(variable.getName(), variable.getValue());
        }
        this.myParent.setEnvs(envs);
        this.myParent.setPassParentEnvs(this.myIncludeSystemVarsCb.isSelected());
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesDialog", "createCenterPanel"));
    }

    private class MyEnvVariablesTable
    extends EnvVariablesTable {
        private final boolean myUserList;

        MyEnvVariablesTable(List<EnvironmentVariable> list2, boolean userList) {
            this.myUserList = userList;
            TableView tableView = this.getTableView();
            tableView.setVisibleRowCount(7);
            this.setValues(list2);
            this.setPasteActionEnabled(this.myUserList);
        }

        @Nullable
        protected AnActionButtonRunnable createAddAction() {
            return this.myUserList ? super.createAddAction() : null;
        }

        @Nullable
        protected AnActionButtonRunnable createRemoveAction() {
            return this.myUserList ? super.createRemoveAction() : null;
        }

        protected AnActionButton @NotNull [] createExtraActions() {
            AnActionButton[] anActionButtonArray = this.myUserList ? super.createExtraActions() : (AnActionButton[])ArrayUtil.append((Object[])super.createExtraActions(), (Object)new AnActionButton(ActionsBundle.message((String)"action.ChangesView.Revert.text", (Object[])new Object[0]), AllIcons.Actions.Rollback){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyEnvVariablesTable.this.stopEditing();
                    List variables = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable environmentVariable : variables) {
                        if (!EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(environmentVariable)) continue;
                        environmentVariable.setValue(EnvironmentVariablesDialog.this.myParent.myParentDefaults.get(environmentVariable.getName()));
                        MyEnvVariablesTable.this.setModified();
                    }
                    MyEnvVariablesTable.this.getTableView().revalidate();
                    MyEnvVariablesTable.this.getTableView().repaint();
                }

                public boolean isEnabled() {
                    List selection = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable variable : selection) {
                        if (!EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(variable)) continue;
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/configuration/EnvironmentVariablesDialog$MyEnvVariablesTable$1", "actionPerformed"));
                }
            });
            if (anActionButtonArray == null) {
                MyEnvVariablesTable.$$$reportNull$$$0(0);
            }
            return anActionButtonArray;
        }

        protected ListTableModel createListModel() {
            return new ListTableModel(new ColumnInfo[]{new MyNameColumnInfo(), new MyValueColumnInfo()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesDialog$MyEnvVariablesTable", "createExtraActions"));
        }

        protected class MyValueColumnInfo
        extends EnvVariablesTable.ValueColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyValueColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                        component2.setFont(component2.getFont().deriveFont(1));
                        if (!hasFocus && !isSelected) {
                            component2.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
                        }
                        return component2;
                    }
                };
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return true;
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer) {
                return EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(o) ? this.myModifiedRenderer : renderer;
            }
        }

        protected class MyNameColumnInfo
        extends EnvVariablesTable.NameColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyNameColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                        component2.setEnabled(table.isEnabled() && (hasFocus || isSelected));
                        return component2;
                    }
                };
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer) {
                return o.getNameIsWriteable() ? renderer : this.myModifiedRenderer;
            }
        }
    }
}

