/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction {
    private WeakReference<JBPopup> myActivePopupRef = null;

    private static boolean isPlaceGlobal(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(0);
        }
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "NewToolbar".equals(e.getPlace()) || "StateWidgetActionBar".equals(e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()) || "TouchBarGeneral".equals(e.getPlace());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(1);
        }
        boolean enable = false;
        Icon icon2 = this.getActionIcon(e);
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation2 = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getDataContext());
            int stopCount = stoppableDescriptors.size();
            boolean bl = enable = stopCount >= 1;
            if (stopCount > 1) {
                presentation2.setText(this.getTemplatePresentation().getText() + "...");
                icon2 = IconUtil.addText(icon2, String.valueOf(stopCount));
            } else if (stopCount == 1) {
                presentation2.setText(ExecutionBundle.messagePointer((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.notNullize((String)stoppableDescriptors.get(0).getDisplayName()))}));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler2;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler3 = processHandler2 = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
                if (!processHandler2.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess()) {
                    enable = true;
                    icon2 = AllIcons.Debugger.KillProcess;
                    description = ExecutionBundle.message((String)"action.terminating.process.progress.kill.description", (Object[])new Object[0]);
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation2.setText(this.getTemplatePresentation().getText());
            } else {
                presentation2.setText(ExecutionBundle.messagePointer((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? StringUtil.notNullize((String)contentDescriptor.getDisplayName()) : runProfile.getName()))}));
            }
        }
        presentation2.setEnabled(enable);
        presentation2.setIcon(icon2);
        presentation2.setDescription(description);
    }

    protected Icon getActionIcon(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(2);
        }
        return this.getTemplatePresentation().getIcon();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        int stopCount = stoppableDescriptors.size();
        if (StopAction.isPlaceGlobal(e)) {
            Component component2;
            if (stopCount == 1) {
                ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                return;
            }
            if (e.getPlace().equals("TouchBarGeneral") && !stoppableDescriptors.isEmpty()) {
                StopAction._showStopRunningBar(stoppableDescriptors);
                return;
            }
            final Pair<List<HandlerItem>, HandlerItem> handlerItems = this.getItemsList(project, stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            HandlerItem stopAllItem = new HandlerItem(ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), this.getActionIcon(e), true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        if (item == this) continue;
                        item.stop();
                    }
                }
            };
            JBPopup activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef);
            if (activePopup != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            List items = (List)handlerItems.first;
            if (stopCount > 1) {
                items.add(stopAllItem);
            }
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new GroupedItemsListRenderer<HandlerItem>(new ListItemDescriptorAdapter<HandlerItem>(){

                @Override
                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Override
                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                @Override
                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            })).setMovable(true).setTitle(items.size() == 1 ? ExecutionBundle.message((String)"confirm.process.stop", (Object[])new Object[0]) : ExecutionBundle.message((String)"stop.process", (Object[])new Object[0])).setNamerForFiltering(o -> o.displayName).setItemsChosenCallback(valuesList -> {
                for (HandlerItem item : valuesList) {
                    item.stop();
                }
            }).addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    StopAction.this.myActivePopupRef = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/actions/StopAction$2", "onClosed"));
                }
            }).setRequestFocus(true);
            if (handlerItems.second != null) {
                builder2.setSelectedValue((Object)((HandlerItem)handlerItems.second), true);
            }
            JBPopup popup2 = builder2.createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup2);
            InputEvent inputEvent = e.getInputEvent();
            Component component3 = component2 = inputEvent != null ? inputEvent.getComponent() : null;
            if (component2 != null && ("MainToolbar".equals(e.getPlace()) || "NewToolbar".equals(e.getPlace()) || "StateWidgetActionBar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
                popup2.showUnderneathOf(component2);
            } else if (project == null) {
                popup2.showInBestPositionFor(dataContext);
            } else {
                popup2.showCenteredInCurrentWindow(project);
            }
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @Nullable
    private Pair<List<HandlerItem>, HandlerItem> getItemsList(Project project, List<? extends RunContentDescriptor> descriptors2, RunContentDescriptor toSelect2) {
        if (descriptors2.isEmpty()) {
            return null;
        }
        ArrayList<4> items = new ArrayList<4>(descriptors2.size());
        HandlerItem selected2 = null;
        for (final RunContentDescriptor runContentDescriptor : descriptors2) {
            ProcessHandler handler2 = runContentDescriptor.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(this.getDisplayName(project, runContentDescriptor), runContentDescriptor.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(runContentDescriptor);
                }
            };
            items.add(item);
            if (runContentDescriptor != toSelect2) continue;
            selected2 = item;
        }
        return Pair.create(items, selected2);
    }

    @BuildEventsNls.Title
    protected String getDisplayName(Project project, RunContentDescriptor descriptor2) {
        return descriptor2.getDisplayName();
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        RunContentDescriptor contentDescriptor;
        if (dataContext == null) {
            StopAction.$$$reportNull$$$0(4);
        }
        if ((contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext)) != null) {
            return contentDescriptor;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null ? null : RunContentManager.getInstance((Project)project).getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(@NotNull DataContext dataContext) {
        Project project;
        List<Object> runningProcesses;
        if (dataContext == null) {
            StopAction.$$$reportNull$$$0(5);
        }
        List<Object> list2 = runningProcesses = (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null ? Collections.emptyList() : ExecutionManagerImpl.getAllDescriptors(project);
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                StopAction.$$$reportNull$$$0(6);
            }
            return list3;
        }
        SmartList activeDescriptors = new SmartList();
        for (RunContentDescriptor runContentDescriptor : runningProcesses) {
            if (!StopAction.canBeStopped(runContentDescriptor)) continue;
            activeDescriptors.add(runContentDescriptor);
        }
        SmartList smartList = activeDescriptors;
        if (smartList == null) {
            StopAction.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor2) {
        @Nullable ProcessHandler processHandler2 = descriptor2 != null ? descriptor2.getProcessHandler() : null;
        return processHandler2 != null && !processHandler2.isProcessTerminated() && (!processHandler2.isProcessTerminating() || processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess());
    }

    private static void _showStopRunningBar(@NotNull List<? extends RunContentDescriptor> stoppableDescriptors) {
        if (stoppableDescriptors == null) {
            StopAction.$$$reportNull$$$0(8);
        }
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        ArrayList<Pair> descriptors2 = new ArrayList<Pair>(stoppableDescriptors.size());
        for (RunContentDescriptor runContentDescriptor : stoppableDescriptors) {
            descriptors2.add(Pair.create((Object)runContentDescriptor, () -> ApplicationManager.getApplication().invokeLater(() -> ExecutionManagerImpl.stopProcess(sd))));
        }
        TouchBarsManager.showStopRunningBar(descriptors2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stoppableDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveStoppableDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceGlobal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRecentlyStartedContentDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveStoppableDescriptors";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_showStopRunningBar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class HandlerItem {
        @Nls
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        HandlerItem(@Nls String displayName, Icon icon2, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon2;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

