/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.popup.NumericMnemonicItem;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ChooseRunConfigurationPopup
implements ExecutorProvider {
    private final Project myProject;
    @NotNull
    private final String myAddKey;
    @NotNull
    private final Executor myDefaultExecutor;
    @Nullable
    private final Executor myAlternativeExecutor;
    private Executor myCurrentExecutor;
    private boolean myEditConfiguration;
    private final RunListPopup myPopup;

    public ChooseRunConfigurationPopup(@NotNull Project project, @NotNull String addKey, @NotNull Executor defaultExecutor, @Nullable Executor alternativeExecutor) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(0);
        }
        if (addKey == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(1);
        }
        if (defaultExecutor == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myAddKey = addKey;
        this.myDefaultExecutor = defaultExecutor;
        this.myAlternativeExecutor = alternativeExecutor;
        this.myPopup = new RunListPopup(project, null, (ListPopupStep)new ConfigurationListPopupStep(this, this.myProject, this, this.myDefaultExecutor.getActionName()), null);
    }

    public void show() {
        String adText = this.getAdText(this.myAlternativeExecutor);
        if (adText != null) {
            this.myPopup.setAdText(adText);
        }
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
    }

    @Nullable
    @Nls
    private String getAdText(Executor alternateExecutor) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (alternateExecutor != null && !properties.isTrueValue(this.myAddKey)) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.hold", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("SHIFT")), alternateExecutor.getActionName()});
        }
        if (!properties.isTrueValue("run.configuration.edit.ad")) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.edit", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("F4"))});
        }
        if (!properties.isTrueValue("run.configuration.delete.ad")) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.delete", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("DELETE"))});
        }
        return null;
    }

    private void registerActions(final RunListPopup popup2) {
        popup2.registerAction("alternateExecutor", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup2.registerAction("restoreDefaultExecutor", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myDefaultExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup2.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup2.handleSelect(true);
            }
        });
        popup2.registerAction("editConfiguration", KeyStroke.getKeyStroke("F4"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myEditConfiguration = true;
                popup2.handleSelect(true);
            }
        });
        popup2.registerAction("deleteConfiguration", KeyStroke.getKeyStroke("DELETE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup2.removeSelected();
            }
        });
        popup2.registerAction("speedsearch_bksp", KeyStroke.getKeyStroke("BACK_SPACE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSearch speedSearch2 = popup2.getSpeedSearch();
                if (speedSearch2.isHoldingFilter()) {
                    speedSearch2.backspace();
                    speedSearch2.update();
                } else {
                    popup2.removeSelected();
                }
            }
        });
        for (int i2 = 0; i2 < 10; ++i2) {
            this.addNumberAction(popup2, i2);
        }
    }

    private void addNumberAction(RunListPopup popup2, int number) {
        Action action2 = ChooseRunConfigurationPopup.createNumberAction(number, popup2, this.myDefaultExecutor);
        Action action_ = ChooseRunConfigurationPopup.createNumberAction(number, popup2, this.myAlternativeExecutor);
        popup2.registerAction(number + "Action", KeyStroke.getKeyStroke(String.valueOf(number)), action2);
        popup2.registerAction(number + "Action_", KeyStroke.getKeyStroke("shift pressed " + number), action_);
        popup2.registerAction(number + "Action1", KeyStroke.getKeyStroke("NUMPAD" + number), action2);
        popup2.registerAction(number + "Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD" + number), action_);
    }

    private void updatePresentation() {
        this.myPopup.setCaption(this.getExecutor().getActionName());
    }

    private static void execute(ItemWrapper<?> itemWrapper, @Nullable Executor executor) {
        if (executor == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            itemWrapper.perform(project, executor, dataContext);
        }
    }

    private void editConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration2) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(3);
        }
        if (configuration2 == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(4);
        }
        Executor executor = this.getExecutor();
        PropertiesComponent.getInstance().setValue("run.configuration.edit.ad", Boolean.toString(true));
        if (RunDialog.editConfiguration(project, configuration2, ExecutionBundle.message((String)"dialog.title.edit.configuration.settings", (Object[])new Object[0]), executor)) {
            RunManager.getInstance((Project)project).setSelectedConfiguration(configuration2);
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration2, (Executor)executor);
        }
    }

    private static void deleteConfiguration(ChooseRunConfigurationPopup popup2, Project project, @NotNull RunnerAndConfigurationSettings configurationSettings) {
        boolean confirmed;
        RunManagerConfig runManagerConfig;
        if (configurationSettings == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(5);
        }
        if ((runManagerConfig = RunManagerImpl.getInstanceImpl(project).getConfig()).isDeletionFromPopupRequiresConfirmation()) {
            popup2.myPopup.cancel();
            confirmed = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)CommonBundle.message((String)"title.confirmation", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"are.you.sure.you.want.to.delete.0", (Object[])new Object[]{configurationSettings.getName()})).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    runManagerConfig.setDeletionFromPopupRequiresConfirmation(!isSelected);
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = ExecutionBundle.message((String)"don.t.ask.again", (Object[])new Object[0]);
                    if (string == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "getDoNotShowMessage"));
                }
            })).ask(project);
        } else {
            confirmed = true;
        }
        if (confirmed) {
            RunManager.getInstance((Project)project).removeConfiguration(configurationSettings);
        }
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myCurrentExecutor == null ? this.myDefaultExecutor : this.myCurrentExecutor;
        if (executor == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(6);
        }
        return executor;
    }

    private static Action createNumberAction(int number, ListPopupImpl listPopup, Executor executor) {
        return new MyAbstractAction(listPopup, number, executor);
    }

    @NotNull
    public static List<ItemWrapper> createSettingsList(@NotNull Project project, @NotNull ExecutorProvider executorProvider, boolean isCreateEditAction) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(7);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(8);
        }
        return ChooseRunConfigurationPopup.createSettingsList(RunManagerImpl.getInstanceImpl(project), executorProvider, isCreateEditAction, Registry.is((String)"run.popup.move.folders.to.top", (boolean)false));
    }

    public static List<ItemWrapper> createFlatSettingsList(@NotNull Project project) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(9);
        }
        return RunManagerImpl.getInstanceImpl(project).getConfigurationsGroupedByTypeAndFolder(false).values().stream().flatMap(map2 -> map2.values().stream().flatMap(settings -> settings.stream())).map(settings -> ItemWrapper.wrap(project, settings)).collect(Collectors.toList());
    }

    @TestOnly
    @NotNull
    public static List<ItemWrapper> createSettingsList(@NotNull RunManagerImpl runManager, @NotNull ExecutorProvider executorProvider, boolean isCreateEditAction, boolean isMoveFoldersToTop) {
        if (runManager == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(10);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(11);
        }
        ArrayList<ItemWrapper> result2 = new ArrayList<ItemWrapper>();
        if (isCreateEditAction) {
            result2.add(ChooseRunConfigurationPopup.createEditAction());
        }
        Project project = runManager.getProject();
        RunnerAndConfigurationSettings selectedConfiguration2 = runManager.getSelectedConfiguration();
        if (selectedConfiguration2 != null) {
            ChooseRunConfigurationPopup.addActionsForSelected(selectedConfiguration2, project, result2);
        }
        LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper> wrappedExisting = new LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper>();
        SmartList folderWrappers = new SmartList();
        for (Map<String, List<RunnerAndConfigurationSettings>> folderToConfigurations : runManager.getConfigurationsGroupedByTypeAndFolder(false).values()) {
            String folderName;
            if (isMoveFoldersToTop) {
                for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : folderToConfigurations.entrySet()) {
                    folderName = entry.getKey();
                    List<RunnerAndConfigurationSettings> configurations = entry.getValue();
                    if (folderName != null) {
                        folderWrappers.add(ChooseRunConfigurationPopup.createFolderItem(project, executorProvider, selectedConfiguration2, folderName, configurations));
                        continue;
                    }
                    for (RunnerAndConfigurationSettings configuration2 : configurations) {
                        ChooseRunConfigurationPopup.wrapAndAdd(project, configuration2, selectedConfiguration2, wrappedExisting);
                    }
                }
                continue;
            }
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : folderToConfigurations.entrySet()) {
                folderName = entry.getKey();
                if (folderName == null) continue;
                result2.add(ChooseRunConfigurationPopup.createFolderItem(project, executorProvider, selectedConfiguration2, folderName, entry.getValue()));
            }
            List<RunnerAndConfigurationSettings> configurations = folderToConfigurations.get(null);
            if (ContainerUtil.isEmpty(configurations)) continue;
            for (RunnerAndConfigurationSettings configuration3 : configurations) {
                result2.add(ChooseRunConfigurationPopup.wrapAndAdd(project, configuration3, selectedConfiguration2, wrappedExisting));
            }
        }
        if (isMoveFoldersToTop) {
            result2.addAll((Collection<ItemWrapper>)folderWrappers);
        }
        if (!DumbService.isDumb((Project)project)) {
            ChooseRunConfigurationPopup.populateWithDynamicRunners(result2, wrappedExisting, project, RunManagerEx.getInstanceEx(project), selectedConfiguration2);
        }
        if (isMoveFoldersToTop) {
            result2.addAll(wrappedExisting.values());
        }
        ArrayList<ItemWrapper> arrayList = result2;
        if (arrayList == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static ItemWrapper wrapAndAdd(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration2, @Nullable RunnerAndConfigurationSettings selectedConfiguration2, @NotNull Map<RunnerAndConfigurationSettings, ItemWrapper> wrappedExisting) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(13);
        }
        if (configuration2 == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(14);
        }
        if (wrappedExisting == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(15);
        }
        ItemWrapper wrapped = ItemWrapper.wrap(project, configuration2);
        if (configuration2 == selectedConfiguration2) {
            wrapped.setMnemonic(1);
        }
        wrappedExisting.put(configuration2, wrapped);
        ItemWrapper itemWrapper = wrapped;
        if (itemWrapper == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(16);
        }
        return itemWrapper;
    }

    @NotNull
    private static FolderWrapper createFolderItem(@NotNull Project project, @NotNull ExecutorProvider executorProvider, @Nullable RunnerAndConfigurationSettings selectedConfiguration2, @NotNull String folderName, @NotNull List<? extends RunnerAndConfigurationSettings> configurations) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(17);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(18);
        }
        if (folderName == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(19);
        }
        if (configurations == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(20);
        }
        boolean isSelected = selectedConfiguration2 != null && configurations.contains(selectedConfiguration2);
        Object value2 = folderName;
        if (isSelected) {
            value2 = (String)value2 + "  (mnemonic is to \"" + selectedConfiguration2.getName() + "\")";
        }
        FolderWrapper result2 = new FolderWrapper(project, executorProvider, (String)value2, configurations);
        if (isSelected) {
            result2.setMnemonic(1);
        }
        FolderWrapper folderWrapper = result2;
        if (folderWrapper == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(21);
        }
        return folderWrapper;
    }

    private static void addActionsForSelected(final @NotNull RunnerAndConfigurationSettings selectedConfiguration2, @NotNull Project project, @NotNull List<? super ItemWrapper> result2) {
        if (selectedConfiguration2 == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(22);
        }
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(24);
        }
        boolean isFirst = true;
        ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selectedConfiguration2.getConfiguration())) {
            ItemWrapper<ExecutionTarget> itemWrapper = new ItemWrapper<ExecutionTarget>(eachTarget, isFirst){

                @Override
                public Icon getIcon() {
                    return ((ExecutionTarget)this.getValue()).getIcon();
                }

                @Override
                public String getText() {
                    return ((ExecutionTarget)this.getValue()).getDisplayName();
                }

                @Override
                public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    ExecutionTargetManager.setActiveTarget((Project)project, (ExecutionTarget)((ExecutionTarget)this.getValue()));
                    ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)selectedConfiguration2, (Executor)executor, null, null, (DataContext)context);
                }

                @Override
                public boolean available(Executor executor) {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$8";
                    objectArray[2] = "perform";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            itemWrapper.setChecked(eachTarget.equals((Object)activeTarget));
            result2.add((ItemWrapper)itemWrapper);
            isFirst = false;
        }
    }

    @NotNull
    private static ItemWrapper<Void> createEditAction() {
        ItemWrapper<Void> result2 = new ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.EditSource;
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project, final @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (executor == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    9.$$$reportNull$$$0(2);
                }
                if (new EditConfigurationsDialog(project){

                    protected void init() {
                        this.setOKButtonText(executor.getActionName());
                        this.myExecutor = executor;
                        super.init();
                    }
                }.showAndGet()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        RunnerAndConfigurationSettings configuration2 = RunManager.getInstance((Project)project).getSelectedConfiguration();
                        if (configuration2 != null) {
                            ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration2, (Executor)executor, null, null, (DataContext)context);
                        }
                    }, project.getDisposed());
                }
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$9";
                objectArray[2] = "perform";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        result2.setMnemonic(0);
        ItemWrapper<Void> itemWrapper = result2;
        if (itemWrapper == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(25);
        }
        return itemWrapper;
    }

    private static void populateWithDynamicRunners(List<? super ItemWrapper> result2, Map<RunnerAndConfigurationSettings, ItemWrapper> existing, final Project project, final RunManager manager2, RunnerAndConfigurationSettings selectedConfiguration2) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        List producers = PreferredProducerFind.getConfigurationsFromContext((Location)context.getLocation(), (ConfigurationContext)context, (boolean)false);
        if (producers == null) {
            return;
        }
        producers.sort(ConfigurationFromContext.NAME_COMPARATOR);
        RunnerAndConfigurationSettings[] preferred = new RunnerAndConfigurationSettings[]{null};
        int i2 = 2;
        for (ConfigurationFromContext fromContext : producers) {
            ItemWrapper wrapper2;
            final RunnerAndConfigurationSettings configuration2 = fromContext.getConfigurationSettings();
            if (existing.containsKey(configuration2)) {
                wrapper2 = existing.get(configuration2);
                if (wrapper2.getMnemonic() == 1) continue;
                wrapper2.setMnemonic(i2);
                ++i2;
                continue;
            }
            if (selectedConfiguration2 != null && configuration2.equals(selectedConfiguration2)) continue;
            if (preferred[0] == null) {
                preferred[0] = configuration2;
            }
            wrapper2 = new ItemWrapper(configuration2){

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project).getConfigurationIcon(configuration2);
                }

                @Override
                public String getText() {
                    return Executor.shortenNameIfNeeded((String)configuration2.getName()) + configuration2.getConfiguration().getPresentableType();
                }

                @Override
                public boolean available(Executor executor) {
                    return ProgramRunner.getRunner((String)executor.getId(), (RunProfile)configuration2.getConfiguration()) != null;
                }

                @Override
                public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        10.$$$reportNull$$$0(2);
                    }
                    manager2.setTemporaryConfiguration(configuration2);
                    RunManager.getInstance((Project)project2).setSelectedConfiguration(configuration2);
                    ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration2, (Executor)executor, null, null, (DataContext)context);
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationPopup action2) {
                    if (project2 == null) {
                        10.$$$reportNull$$$0(3);
                    }
                    if (action2 == null) {
                        10.$$$reportNull$$$0(4);
                    }
                    return new ConfigurationActionsStep(project2, action2, configuration2, this.isDynamic());
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "action";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$10";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "perform";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getNextStep";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            wrapper2.setDynamic(true);
            wrapper2.setMnemonic(i2);
            result2.add(wrapper2);
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExecutor";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationPopup";
                break;
            }
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedExisting";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedConfiguration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAndAdd";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createFolderItem";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteConfiguration";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFlatSettingsList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndAdd";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFolderItem";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addActionsForSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FolderStep
    extends BaseListPopupStep<ConfigurationActionsStep> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myPopup;
        private final ExecutorProvider myExecutorProvider;

        private FolderStep(Project project, ExecutorProvider executorProvider, @NlsSafe String folderName, List<ConfigurationActionsStep> children2, ChooseRunConfigurationPopup popup2) {
            super(folderName, children2, new ArrayList());
            this.myProject = project;
            this.myExecutorProvider = executorProvider;
            this.myPopup = popup2;
        }

        public PopupStep onChosen(ConfigurationActionsStep selectedValue, boolean finalChoice) {
            if (finalChoice) {
                if (this.myPopup.myEditConfiguration) {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    return this.doFinalStep(() -> this.myPopup.editConfiguration(this.myProject, settings));
                }
                return this.doFinalStep(() -> {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(settings);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.myExecutorProvider.getExecutor());
                });
            }
            return selectedValue;
        }

        public Icon getIconFor(ConfigurationActionsStep aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ConfigurationActionsStep value2) {
            String string = value2.getName();
            if (string == null) {
                FolderStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean hasSubstep(ConfigurationActionsStep selectedValue) {
            return !selectedValue.getValues().isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderStep", "getTextFor"));
        }
    }

    private static final class FolderWrapper
    extends ItemWrapper<String> {
        private final Project myProject;
        private final ExecutorProvider myExecutorProvider;
        private final List<? extends RunnerAndConfigurationSettings> myConfigurations;

        private FolderWrapper(Project project, ExecutorProvider executorProvider, @Nullable String value2, List<? extends RunnerAndConfigurationSettings> configurations) {
            super(value2);
            this.myProject = project;
            this.myExecutorProvider = executorProvider;
            this.myConfigurations = configurations;
        }

        @Override
        public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
            RunManager runManager;
            RunnerAndConfigurationSettings selectedConfiguration2;
            if (project == null) {
                FolderWrapper.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                FolderWrapper.$$$reportNull$$$0(1);
            }
            if (context == null) {
                FolderWrapper.$$$reportNull$$$0(2);
            }
            if (this.myConfigurations.contains(selectedConfiguration2 = (runManager = RunManager.getInstance((Project)project)).getSelectedConfiguration())) {
                runManager.setSelectedConfiguration(selectedConfiguration2);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)selectedConfiguration2, (Executor)this.myExecutorProvider.getExecutor());
            }
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = AllIcons.Nodes.Folder;
            if (icon2 == null) {
                FolderWrapper.$$$reportNull$$$0(3);
            }
            return icon2;
        }

        @Override
        public String getText() {
            return (String)this.getValue();
        }

        @Override
        @Nullable
        public ConfigurationType getType() {
            return Registry.is((String)"run.popup.move.folders.to.top") || this.myConfigurations.isEmpty() ? null : this.myConfigurations.get(0).getType();
        }

        @Override
        public boolean hasActions() {
            return true;
        }

        @Override
        public PopupStep getNextStep(Project project, ChooseRunConfigurationPopup action2) {
            ArrayList<ConfigurationActionsStep> steps = new ArrayList<ConfigurationActionsStep>();
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations) {
                steps.add(new ConfigurationActionsStep(project, action2, runnerAndConfigurationSettings, false));
            }
            return new FolderStep(this.myProject, this.myExecutorProvider, null, steps, action2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class RunListPopup
    extends ListPopupImpl {
        RunListPopup(Project project, WizardPopup aParent, ListPopupStep aStep, Object parentValue) {
            super(project, aParent, aStep, parentValue);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        @Override
        protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
            return new RunListPopup(this.getProject(), parent, (ListPopupStep)step, parentValue);
        }

        @Override
        public boolean shouldBeShowing(Object value2) {
            if (super.shouldBeShowing(value2)) {
                return true;
            }
            if (value2 instanceof FolderWrapper && this.mySpeedSearch.isHoldingFilter()) {
                FolderWrapper folderWrapper = (FolderWrapper)value2;
                for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : folderWrapper.myConfigurations) {
                    if (!this.mySpeedSearch.shouldBeShowing(runnerAndConfigurationSettings.getName() + runnerAndConfigurationSettings.getConfiguration().getPresentableType())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (e instanceof MouseEvent && e.isShiftDown()) {
                this.handleShiftClick(handleFinalChoices, e, this);
                return;
            }
            this._handleSelect(handleFinalChoices, e);
        }

        private void _handleSelect(boolean handleFinalChoices, InputEvent e) {
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleShiftClick(boolean handleFinalChoices, InputEvent inputEvent, RunListPopup popup2) {
            ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
            popup2._handleSelect(handleFinalChoices, inputEvent);
        }

        public void removeSelected() {
            int index2;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (!propertiesComponent.isTrueValue("run.configuration.delete.ad")) {
                propertiesComponent.setValue("run.configuration.delete.ad", Boolean.toString(true));
            }
            if ((index2 = this.getSelectedIndex()) == -1) {
                return;
            }
            Object o = this.getListModel().get(index2);
            if (o instanceof ItemWrapper && ((ItemWrapper)o).canBeDeleted()) {
                ChooseRunConfigurationPopup.deleteConfiguration(ChooseRunConfigurationPopup.this, ChooseRunConfigurationPopup.this.myProject, (RunnerAndConfigurationSettings)((ItemWrapper)o).getValue());
                this.getListModel().deleteItem(o);
                List values = this.getListStep().getValues();
                values.remove(o);
                if (index2 < values.size()) {
                    this.onChildSelectedFor(values.get(index2));
                } else if (index2 - 1 >= 0) {
                    this.onChildSelectedFor(values.get(index2 - 1));
                }
            }
        }

        @Override
        protected boolean isResizable() {
            return true;
        }
    }

    private static class MyAbstractAction
    extends AbstractAction
    implements DumbAware {
        private final ListPopupImpl myListPopup;
        private final int myNumber;
        private final Executor myExecutor;

        MyAbstractAction(ListPopupImpl listPopup, int number, Executor executor) {
            this.myListPopup = listPopup;
            this.myNumber = number;
            this.myExecutor = executor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myListPopup.getSpeedSearch().isHoldingFilter()) {
                return;
            }
            for (Object item : this.myListPopup.getListStep().getValues()) {
                if (!(item instanceof ItemWrapper) || ((ItemWrapper)item).getMnemonic() != this.myNumber) continue;
                this.myListPopup.setFinalRunnable(() -> ChooseRunConfigurationPopup.execute((ItemWrapper)item, this.myExecutor));
                this.myListPopup.closeOk(null);
            }
        }
    }

    private static abstract class ActionWrapper
    extends Wrapper {
        @Nls
        private final String myName;
        private final Icon myIcon;

        private ActionWrapper(@Nls String name, Icon icon2) {
            this(name, icon2, false);
        }

        private ActionWrapper(@Nls String name, Icon icon2, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myName = name;
            this.myIcon = icon2;
        }

        public abstract void perform();

        @Override
        public String getText() {
            return this.myName;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class ConfigurationActionsStep
    extends BaseListPopupStep<ActionWrapper> {
        @NotNull
        private final RunnerAndConfigurationSettings mySettings;
        @NotNull
        private final Project myProject;

        private ConfigurationActionsStep(@NotNull Project project, ChooseRunConfigurationPopup action2, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(1);
            }
            super(null, (Object[])ConfigurationActionsStep.buildActions(project, action2, settings, dynamic));
            this.myProject = project;
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(2);
            }
            return runnerAndConfigurationSettings;
        }

        @NlsContexts.ListItem
        public String getName() {
            return Executor.shortenNameIfNeeded((String)this.mySettings.getName());
        }

        public Icon getIcon() {
            return RunManagerEx.getInstanceEx(this.myProject).getConfigurationIcon(this.mySettings);
        }

        public ListSeparator getSeparatorAbove(ActionWrapper value2) {
            return value2.addSeparatorAbove() ? new ListSeparator() : null;
        }

        private static ActionWrapper[] buildActions(final @NotNull Project project, final ChooseRunConfigurationPopup action2, final @NotNull RunnerAndConfigurationSettings settings, final boolean dynamic) {
            if (project == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(3);
            }
            if (settings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(4);
            }
            ArrayList<ActionWrapper> result2 = new ArrayList<ActionWrapper>();
            final ExecutionTarget active = ExecutionTargetManager.getActiveTarget((Project)project);
            for (final ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)settings.getConfiguration())) {
                result2.add(new ActionWrapper(eachTarget.getDisplayName(), eachTarget.getIcon()){
                    {
                        super(name, icon2);
                        this.setChecked(eachTarget.equals((Object)active));
                    }

                    @Override
                    public void perform() {
                        RunManager manager2 = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager2.setTemporaryConfiguration(settings);
                        }
                        manager2.setSelectedConfiguration(settings);
                        ExecutionTargetManager.setActiveTarget((Project)project, (ExecutionTarget)eachTarget);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)action2.getExecutor());
                    }
                });
            }
            boolean isFirst = true;
            ArrayList<Executor> allExecutors = new ArrayList<Executor>();
            for (final Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                if (executor instanceof ExecutorGroup) {
                    allExecutors.addAll(((ExecutorGroup)executor).childExecutors());
                    continue;
                }
                allExecutors.add(executor);
            }
            for (final Executor executor : allExecutors) {
                ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
                if (runner == null) continue;
                result2.add(new ActionWrapper(executor.getActionName(), executor.getIcon(), isFirst){

                    @Override
                    public void perform() {
                        RunManager manager2 = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager2.setTemporaryConfiguration(settings);
                        }
                        manager2.setSelectedConfiguration(settings);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)executor);
                    }
                });
                isFirst = false;
            }
            result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.edit", (Object[])new Object[0]), AllIcons.Actions.EditSource, true){

                @Override
                public void perform() {
                    if (dynamic) {
                        RunManager.getInstance((Project)project).setTemporaryConfiguration(settings);
                    }
                    action2.editConfiguration(project, settings);
                }
            });
            if (settings.isTemporary() || dynamic) {
                result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.save", (Object[])new Object[0]), AllIcons.Actions.MenuSaveall){

                    @Override
                    public void perform() {
                        RunManager manager2 = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager2.setTemporaryConfiguration(settings);
                        }
                        manager2.makeStable(settings);
                    }
                });
            }
            result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.delete", (Object[])new Object[0]), AllIcons.Actions.Cancel){

                @Override
                public void perform() {
                    ChooseRunConfigurationPopup.deleteConfiguration(action2, project, settings);
                }
            });
            return result2.toArray(new ActionWrapper[0]);
        }

        public PopupStep onChosen(ActionWrapper selectedValue, boolean finalChoice) {
            return this.doFinalStep(() -> selectedValue.perform());
        }

        public Icon getIconFor(ActionWrapper aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionWrapper value2) {
            String string = value2.getText();
            if (string == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ConfigurationListPopupStep
    extends BaseListPopupStep<ItemWrapper> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myAction;
        private int myDefaultConfiguration;

        private ConfigurationListPopupStep(@NotNull ChooseRunConfigurationPopup action2, @NotNull Project project, @NotNull ExecutorProvider executorProvider, @NotNull @Nls String title) {
            boolean hasMnemonics;
            if (action2 == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(1);
            }
            if (executorProvider == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(2);
            }
            if (title == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(3);
            }
            super(title, ChooseRunConfigurationPopup.createSettingsList(project, executorProvider, true));
            this.myDefaultConfiguration = -1;
            this.myProject = project;
            this.myAction = action2;
            if (-1 == this.getDefaultOptionIndex()) {
                this.myDefaultConfiguration = this.getDynamicIndex();
            }
            if (hasMnemonics = this.getValues().stream().anyMatch(wrapper2 -> wrapper2.getMnemonic() != -1)) {
                this.getValues().forEach(wrapper2 -> wrapper2.setMnemonicsEnabled(true));
            }
        }

        private int getDynamicIndex() {
            int i2 = 0;
            for (ItemWrapper wrapper2 : this.getValues()) {
                if (wrapper2.isDynamic()) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public ListSeparator getSeparatorAbove(ItemWrapper value2) {
            if (value2.addSeparatorAbove()) {
                return new ListSeparator();
            }
            List configurations = this.getValues();
            int index2 = configurations.indexOf(value2);
            if (index2 > 0 && index2 <= configurations.size() - 1) {
                ConfigurationType aboveType;
                ItemWrapper aboveConfiguration = (ItemWrapper)configurations.get(index2 - 1);
                if (aboveConfiguration != null && aboveConfiguration.isDynamic() != value2.isDynamic()) {
                    return new ListSeparator();
                }
                ConfigurationType currentType = value2.getType();
                ConfigurationType configurationType = aboveType = aboveConfiguration == null ? null : aboveConfiguration.getType();
                if (aboveType != currentType && currentType != null) {
                    return new ListSeparator();
                }
            }
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public int getDefaultOptionIndex() {
            RunnerAndConfigurationSettings currentConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (currentConfiguration == null && this.myDefaultConfiguration != -1) {
                return this.myDefaultConfiguration;
            }
            return currentConfiguration instanceof RunnerAndConfigurationSettingsImpl ? this.getValues().indexOf(ItemWrapper.wrap(this.myProject, currentConfiguration)) : -1;
        }

        public PopupStep onChosen(ItemWrapper wrapper2, boolean finalChoice) {
            Object o;
            if (this.myAction.myEditConfiguration && (o = wrapper2.getValue()) instanceof RunnerAndConfigurationSettingsImpl) {
                return this.doFinalStep(() -> this.myAction.editConfiguration(this.myProject, (RunnerAndConfigurationSettings)o));
            }
            if (finalChoice && wrapper2.available(this.myAction.getExecutor())) {
                return this.doFinalStep(() -> {
                    if (this.myAction.getExecutor() == this.myAction.myAlternativeExecutor) {
                        PropertiesComponent.getInstance().setValue(this.myAction.myAddKey, Boolean.toString(true));
                    }
                    wrapper2.perform(this.myProject, this.myAction.getExecutor(), DataManager.getInstance().getDataContext());
                });
            }
            return wrapper2.getNextStep(this.myProject, this.myAction);
        }

        public boolean isFinal(ItemWrapper wrapper2) {
            return this.myAction.myEditConfiguration || wrapper2.available(this.myAction.getExecutor()) || wrapper2.getNextStep(this.myProject, this.myAction) == FINAL_CHOICE;
        }

        public boolean hasSubstep(ItemWrapper selectedValue) {
            return selectedValue.hasActions();
        }

        @NotNull
        public String getTextFor(ItemWrapper value2) {
            String string = value2.getText();
            if (string == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(4);
            }
            return string;
        }

        public Icon getIconFor(ItemWrapper value2) {
            return value2.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ItemWrapper<T>
    extends Wrapper {
        private final T myValue;
        private boolean myDynamic;

        protected ItemWrapper(@Nullable T value2) {
            this(value2, false);
        }

        protected ItemWrapper(@Nullable T value2, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myValue = value2;
        }

        @NlsActions.ActionText
        public T getValue() {
            return this.myValue;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public void setDynamic(boolean b) {
            this.myDynamic = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWrapper)) {
                return false;
            }
            return Objects.equals(this.myValue, ((ItemWrapper)o).myValue);
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public abstract void perform(@NotNull Project var1, @NotNull Executor var2, @NotNull DataContext var3);

        @Nullable
        public ConfigurationType getType() {
            return null;
        }

        public boolean available(Executor executor) {
            return false;
        }

        public boolean hasActions() {
            return false;
        }

        public PopupStep getNextStep(Project project, ChooseRunConfigurationPopup action2) {
            return PopupStep.FINAL_CHOICE;
        }

        public static ItemWrapper wrap(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project == null) {
                ItemWrapper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ItemWrapper.$$$reportNull$$$0(1);
            }
            ItemWrapper result2 = ItemWrapper.wrap(project, settings);
            result2.setDynamic(dynamic);
            return result2;
        }

        public static ItemWrapper wrap(final @NotNull Project project, @NotNull RunnerAndConfigurationSettings settings) {
            if (project == null) {
                ItemWrapper.$$$reportNull$$$0(2);
            }
            if (settings == null) {
                ItemWrapper.$$$reportNull$$$0(3);
            }
            return new ItemWrapper<RunnerAndConfigurationSettings>(settings){

                @Override
                public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    RunnerAndConfigurationSettings config2 = (RunnerAndConfigurationSettings)this.getValue();
                    RunManager.getInstance((Project)project2).setSelectedConfiguration(config2);
                    MacroManager.getInstance().cacheMacrosPreview(context);
                    ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)config2, (Executor)executor, null, null, (DataContext)context);
                }

                @Override
                public ConfigurationType getType() {
                    return ((RunnerAndConfigurationSettings)this.getValue()).getType();
                }

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project).getConfigurationIcon((RunnerAndConfigurationSettings)this.getValue(), true);
                }

                @Override
                public String getText() {
                    return Executor.shortenNameIfNeeded((String)((RunnerAndConfigurationSettings)this.getValue()).getName()) + ((RunnerAndConfigurationSettings)this.getValue()).getConfiguration().getPresentableType();
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                @Override
                public boolean available(@NotNull Executor executor) {
                    RunnerAndConfigurationSettings value2;
                    if (executor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return (value2 = (RunnerAndConfigurationSettings)this.getValue()) != null && ProgramRunner.getRunner((String)executor.getId(), (RunProfile)value2.getConfiguration()) != null;
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationPopup action2) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (action2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return new ConfigurationActionsStep(project2, action2, (RunnerAndConfigurationSettings)this.getValue(), this.isDynamic());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "action";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "perform";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "available";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getNextStep";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        public boolean canBeDeleted() {
            return !this.isDynamic() && this.getValue() instanceof RunnerAndConfigurationSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper";
            objectArray[2] = "wrap";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Wrapper
    implements NumericMnemonicItem {
        private int myMnemonic = -1;
        private boolean myMnemonicsEnabled;
        private final boolean myAddSeparatorAbove;
        private boolean myChecked;

        protected Wrapper(boolean addSeparatorAbove) {
            this.myAddSeparatorAbove = addSeparatorAbove;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        @Override
        @Nullable
        public Character getMnemonicChar() {
            return this.myMnemonic > -1 ? Character.valueOf(Character.forDigit(this.myMnemonic, 10)) : null;
        }

        @Override
        public boolean digitMnemonicsEnabled() {
            return this.myMnemonicsEnabled;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        protected void setMnemonicsEnabled(boolean mnemonicsEnabled) {
            this.myMnemonicsEnabled = mnemonicsEnabled;
        }

        public boolean addSeparatorAbove() {
            return this.myAddSeparatorAbove;
        }

        @Nullable
        public abstract Icon getIcon();

        @NlsActions.ActionText
        public abstract String getText();

        public boolean canBeDeleted() {
            return false;
        }

        public String toString() {
            return "Wrapper[" + this.getText() + "]";
        }
    }
}

