/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints2) {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(0);
        }
        if (hints2 == null) {
            ExternalDiffTool.$$$reportNull$$$0(1);
        }
        try {
            List<DiffRequest> requests2 = ExternalDiffTool.loadRequestsUnderProgress(project, chain);
            if (requests2 == null) {
                return;
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request : requests2) {
                if (ExternalDiffTool.canShow(request)) {
                    ExternalDiffTool.showRequest(project, request);
                    continue;
                }
                showInBuiltin.add(request);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints2);
            }
        }
        catch (ProcessCanceledException requests2) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
        }
    }

    @Nullable
    private static List<DiffRequest> loadRequestsUnderProgress(@Nullable Project project, @NotNull DiffRequestChain chain) throws Throwable {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(2);
        }
        if (chain instanceof AsyncDiffRequestChain) {
            return (List)ExternalDiffTool.computeWithModalProgress(project, DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]), indicator -> {
                ListSelection<? extends DiffRequestProducer> listSelection = ((AsyncDiffRequestChain)chain).loadRequestsInBackground();
                return ExternalDiffTool.collectRequests(project, listSelection.getList(), listSelection.getSelectedIndex(), indicator);
            });
        }
        List allProducers = chain.getRequests();
        int index2 = chain.getIndex();
        return (List)ExternalDiffTool.computeWithModalProgress(project, DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]), indicator -> ExternalDiffTool.collectRequests(project, allProducers, index2, indicator));
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> allProducers, int index2, @NotNull ProgressIndicator indicator) {
        if (allProducers == null) {
            ExternalDiffTool.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(4);
        }
        if (allProducers.isEmpty()) {
            List<DiffRequest> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalDiffTool.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<DiffRequestProducer> producers = Collections.singletonList(allProducers.get(index2));
        return ExternalDiffTool.collectRequests(project, producers, indicator);
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> producers, @NotNull ProgressIndicator indicator) {
        if (producers == null) {
            ExternalDiffTool.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(7);
        }
        ArrayList<DiffRequest> requests2 = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<DiffRequestProducer> errorRequests = new ArrayList<DiffRequestProducer>();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                requests2.add(diffRequestProducer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(diffRequestProducer);
            }
        }
        if (!errorRequests.isEmpty()) {
            HtmlBuilder message2 = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(errorRequests, producer -> HtmlChunk.text((String)producer.getName())));
            new Notification("Diff", DiffBundle.message((String)"can.t.load.some.changes", (Object[])new Object[0]), message2.toString(), NotificationType.ERROR).notify(project);
        }
        ArrayList<DiffRequest> arrayList = requests2;
        if (arrayList == null) {
            ExternalDiffTool.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static <T> T computeWithModalProgress(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends Exception> computable) throws Exception {
        if (title == null) {
            ExternalDiffTool.$$$reportNull$$$0(9);
        }
        if (computable == null) {
            ExternalDiffTool.$$$reportNull$$$0(10);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(project, title, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws Exception {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return computable.convert((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffTool$1", "compute"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRequest(@Nullable Project project, @NotNull DiffRequest request) throws ExecutionException, IOException {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(11);
        }
        request.onAssigned(true);
        try {
            ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
            List contents = ((ContentDiffRequest)request).getContents();
            List titles = ((ContentDiffRequest)request).getContentTitles();
            ExternalDiffToolUtil.execute(project, settings, contents, titles, request.getTitle());
        }
        finally {
            request.onAssigned(false);
        }
    }

    public static boolean canShow(@NotNull DiffRequest request) {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(12);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content2 : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProducers";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestsUnderProgress";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectRequests";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeWithModalProgress";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

