/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.SimpleLineStatusTracker;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    private final MyThreesideViewer myViewer;
    private final Action myCancelResolveAction;
    private final Action myLeftResolveAction;
    private final Action myRightResolveAction;
    private final Action myAcceptResolveAction;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
        if (context == null) {
            TextMergeViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TextMergeViewer.$$$reportNull$$$0(1);
        }
        this.myMergeContext = context;
        this.myMergeRequest = request;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        ProxySimpleDiffRequest diffRequest = new ProxySimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest), (UserDataHolder)this.myMergeRequest);
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = new MyThreesideViewer(diffContext, (ContentDiffRequest)diffRequest);
        this.myCancelResolveAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
        this.myLeftResolveAction = this.myViewer.getResolveAction(MergeResult.LEFT);
        this.myRightResolveAction = this.myViewer.getResolveAction(MergeResult.RIGHT);
        this.myAcceptResolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(2);
        }
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output2 = mergeRequest.getOutputContent();
        List<DiffContent> list2 = Arrays.asList(left, output2, right);
        if (list2 == null) {
            TextMergeViewer.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(4);
        }
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
        List<String> list2 = titles;
        if (list2 == null) {
            TextMergeViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            TextMergeViewer.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
        components.statusPanel = init2.statusPanel;
        components.toolbarActions = init2.toolbarActions;
        components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext, this.myViewer.myContentModified);
        MergeTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            TextMergeViewer.$$$reportNull$$$0(7);
        }
        return toolbarComponents;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result2) {
        if (result2 == null) {
            TextMergeViewer.$$$reportNull$$$0(8);
        }
        switch (result2) {
            case CANCEL: {
                return this.myCancelResolveAction;
            }
            case LEFT: {
                return this.myLeftResolveAction;
            }
            case RIGHT: {
                return this.myRightResolveAction;
            }
            case RESOLVED: {
                return this.myAcceptResolveAction;
            }
        }
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MyThreesideViewer getViewer() {
        MyThreesideViewer myThreesideViewer = this.myViewer;
        if (myThreesideViewer == null) {
            TextMergeViewer.$$$reportNull$$$0(9);
        }
        return myThreesideViewer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeRequest";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContentTitles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContents";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContentTitles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolveAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        InnerChunkData(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(0);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(1);
            }
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(2);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(3);
            }
            List list2 = ThreeSide.map(side -> {
                int endLine;
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
            if (list2 == null) {
                InnerChunkData.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documents";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$InnerChunkData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$InnerChunkData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChunks";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MyThreesideViewer
    extends ThreesideTextDiffViewerEx {
        @NotNull
        private final MergeModelBase myModel;
        @NotNull
        private final ModifierProvider myModifierProvider;
        @NotNull
        private final MyInnerDiffWorker myInnerDiffWorker;
        @NotNull
        private final SimpleLineStatusTracker myLineStatusTracker;
        @NotNull
        private final TextDiffProviderBase myTextDiffProvider;
        @NotNull
        private final List<TextMergeChange> myAllMergeChanges;
        @NotNull
        private IgnorePolicy myCurrentIgnorePolicy;
        private boolean myInitialRediffStarted;
        private boolean myInitialRediffFinished;
        private boolean myContentModified;

        public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request) {
            if (context == null) {
                MyThreesideViewer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyThreesideViewer.$$$reportNull$$$0(1);
            }
            super(context, request);
            this.myAllMergeChanges = new ArrayList<TextMergeChange>();
            this.myModel = new MyMergeModel(this.getProject(), this.getEditor().getDocument());
            this.myModifierProvider = new ModifierProvider();
            this.myInnerDiffWorker = new MyInnerDiffWorker();
            this.myLineStatusTracker = new SimpleLineStatusTracker(this.getProject(), this.getEditor().getDocument(), (Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer>)((Function1)x$0 -> new MyLineStatusMarkerRenderer((LineStatusTrackerBase<?>)x$0)));
            this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), () -> {
                this.restartMergeResolveIfNeeded();
                this.myInnerDiffWorker.onSettingsChanged();
            }, (Disposable)this, (IgnorePolicy[])ContainerUtil.ar((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES}), (HighlightPolicy[])ContainerUtil.ar((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD}));
            this.myCurrentIgnorePolicy = this.myTextDiffProvider.getIgnorePolicy();
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(false), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(true), this.myPanel);
            ProxyUndoRedoAction.register(this.getProject(), this.getEditor(), this.myContentPanel);
        }

        @Override
        protected void onInit() {
            super.onInit();
            this.myModifierProvider.init();
        }

        @Override
        protected void onDispose() {
            Disposer.dispose((Disposable)this.myModel);
            this.myLineStatusTracker.release();
            this.myInnerDiffWorker.disable();
            super.onDispose();
        }

        @Override
        @NotNull
        protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory2) {
            if (factory2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(2);
            }
            List<TextEditorHolder> holders = super.createEditorHolders(factory2);
            ((TextEditorHolder)ThreeSide.BASE.select(holders)).getEditor().putUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG, true);
            List<TextEditorHolder> list2 = holders;
            if (list2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> group2 = new ArrayList<AnAction>();
            DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
            diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
            diffGroup.add((AnAction)Separator.create((String)ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, true));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.LEFT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.BASE));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.RIGHT));
            group2.add((AnAction)diffGroup);
            group2.add((AnAction)new Separator(DiffBundle.messagePointer((String)"action.Anonymous.text.apply.non.conflicting.changes", (Object[])new Object[0])));
            group2.add((AnAction)new ApplyNonConflictsAction(ThreeSide.LEFT, DiffBundle.message((String)"action.merge.apply.non.conflicts.left.text", (Object[])new Object[0])));
            group2.add((AnAction)new ApplyNonConflictsAction(ThreeSide.BASE, DiffBundle.message((String)"action.merge.apply.non.conflicts.all.text", (Object[])new Object[0])));
            group2.add((AnAction)new ApplyNonConflictsAction(ThreeSide.RIGHT, DiffBundle.message((String)"action.merge.apply.non.conflicts.right.text", (Object[])new Object[0])));
            group2.add((AnAction)new MagicResolvedConflictsAction());
            group2.add((AnAction)Separator.getInstance());
            group2.addAll(this.myTextDiffProvider.getToolbarActions());
            group2.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
            group2.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            group2.add((AnAction)this.myEditorSettingsAction);
            ArrayList<AnAction> arrayList = group2;
            if (arrayList == null) {
                MyThreesideViewer.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected List<AnAction> createEditorPopupActions() {
            ArrayList<AnAction> group2 = new ArrayList<AnAction>();
            group2.add(new ApplySelectedChangesAction(Side.LEFT));
            group2.add(new ApplySelectedChangesAction(Side.RIGHT));
            group2.add(new ResolveSelectedChangesAction(Side.LEFT));
            group2.add(new ResolveSelectedChangesAction(Side.RIGHT));
            group2.add(new IgnoreSelectedChangesSideAction(Side.LEFT));
            group2.add(new IgnoreSelectedChangesSideAction(Side.RIGHT));
            group2.add(new ResolveSelectedConflictsAction());
            group2.add(new IgnoreSelectedChangesAction());
            group2.add((AnAction)Separator.getInstance());
            group2.addAll(TextDiffViewerUtil.createEditorPopupActions());
            ArrayList<AnAction> arrayList = group2;
            if (arrayList == null) {
                MyThreesideViewer.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @Override
        @Nullable
        protected List<AnAction> createPopupActions() {
            ArrayList<AnAction> group2 = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
            group2.add((AnAction)Separator.getInstance());
            group2.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            return group2;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            if (result2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(6);
            }
            String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!(result2 != MergeResult.LEFT && result2 != MergeResult.RIGHT || MergeUtil.showConfirmDiscardChangesDialog(MyThreesideViewer.this.myPanel.getRootPane(), result2 == MergeResult.LEFT ? DiffBundle.message((String)"button.merge.resolve.accept.left", (Object[])new Object[0]) : DiffBundle.message((String)"button.merge.resolve.accept.right", (Object[])new Object[0]), MyThreesideViewer.this.myContentModified))) {
                        return;
                    }
                    if (!(result2 != MergeResult.RESOLVED || MyThreesideViewer.this.getChangesCount() <= 0 && MyThreesideViewer.this.getConflictsCount() <= 0 || ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()})).yesText(DiffBundle.message((String)"apply.changes.and.mark.resolved", (Object[])new Object[0]))).noText(DiffBundle.message((String)"continue.merge", (Object[])new Object[0]))).ask((Component)MyThreesideViewer.this.myPanel.getRootPane()))) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext, MyThreesideViewer.this.myContentModified)) {
                        return;
                    }
                    MyThreesideViewer.this.destroyChangedBlocks();
                    TextMergeViewer.this.myMergeContext.finishMerge(result2);
                }
            };
        }

        private void restartMergeResolveIfNeeded() {
            if (this.isDisposed()) {
                return;
            }
            if (this.myTextDiffProvider.getIgnorePolicy().equals((Object)this.myCurrentIgnorePolicy)) {
                return;
            }
            if (!this.myInitialRediffFinished) {
                ApplicationManager.getApplication().invokeLater(() -> this.restartMergeResolveIfNeeded());
                return;
            }
            if (this.myContentModified && Messages.showYesNoDialog((Project)this.myProject, (String)DiffBundle.message((String)"changing.highlighting.requires.the.file.merge.restart", (Object[])new Object[0]), (String)DiffBundle.message((String)"update.highlighting.settings", (Object[])new Object[0]), (String)DiffBundle.message((String)"discard.changes.and.restart.merge", (Object[])new Object[0]), (String)DiffBundle.message((String)"continue.merge", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                this.getTextSettings().setIgnorePolicy(this.myCurrentIgnorePolicy);
                return;
            }
            this.myInitialRediffFinished = false;
            this.doRediff();
        }

        private boolean setInitialOutputContent() {
            Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
            Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
            return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), DiffBundle.message((String)"message.init.merge.content.command", (Object[])new Object[0]), () -> {
                outputDocument.setText(baseDocument.getCharsSequence());
                DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
                if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                    this.myLineStatusTracker.setBaseRevision(baseDocument.getCharsSequence());
                    this.getEditor().getGutterComponentEx().setForceShowRightFreePaintersArea(true);
                }
            });
        }

        @Override
        @RequiresEdt
        public void rediff(boolean trySync) {
            if (this.myInitialRediffStarted) {
                return;
            }
            this.myInitialRediffStarted = true;
            assert (this.myAllMergeChanges.isEmpty());
            this.doRediff();
        }

        @Override
        @NotNull
        protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyThreesideViewer.$$$reportNull$$$0(7);
            }
            throw new UnsupportedOperationException();
        }

        @RequiresEdt
        private void doRediff() {
            this.myStatusPanel.setBusy(true);
            this.myInnerDiffWorker.disable();
            this.getEditor().setViewer(true);
            this.myLoadingPanel.startLoading();
            TextMergeViewer.this.myAcceptResolveAction.setEnabled(false);
            BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
                try {
                    return this.doPerformRediff((ProgressIndicator)indicator);
                }
                catch (ProcessCanceledException e) {
                    return () -> TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    return () -> TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }
            })), null, 300L, ApplicationManager.getApplication().isUnitTestMode());
        }

        @NotNull
        protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
            Runnable runnable2;
            if (indicator == null) {
                MyThreesideViewer.$$$reportNull$$$0(8);
            }
            try {
                indicator.checkCanceled();
                IgnorePolicy ignorePolicy = this.myTextDiffProvider.getIgnorePolicy();
                List contents = TextMergeViewer.this.myMergeRequest.getContents();
                List sequences = (List)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    return ContainerUtil.map((Collection)contents, content2 -> content2.getDocument().getImmutableCharSequence());
                });
                List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
                ComparisonManager manager2 = ComparisonManager.getInstance();
                List lineFragments = manager2.mergeLines((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), ignorePolicy.getComparisonPolicy(), indicator);
                List conflictTypes = ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, ignorePolicy.getComparisonPolicy()));
                FoldingModelSupport.Data foldingState = this.myFoldingModel.createState((List<? extends MergeLineFragment>)lineFragments, lineOffsets, this.getFoldingModelSettings());
                runnable2 = () -> this.apply(lineFragments, conflictTypes, foldingState, ignorePolicy);
            }
            catch (DiffTooBigException e) {
                Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
                if (runnable3 == null) {
                    MyThreesideViewer.$$$reportNull$$$0(10);
                }
                return runnable3;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                Runnable runnable4 = () -> {
                    this.clearDiffPresentation();
                    this.myPanel.setErrorContent();
                };
                if (runnable4 == null) {
                    MyThreesideViewer.$$$reportNull$$$0(11);
                }
                return runnable4;
            }
            if (runnable2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(9);
            }
            return runnable2;
        }

        @RequiresEdt
        private void apply(@NotNull List<? extends MergeLineFragment> fragments, @NotNull List<? extends MergeConflictType> conflictTypes, @Nullable FoldingModelSupport.Data foldingState, @NotNull IgnorePolicy ignorePolicy) {
            if (fragments == null) {
                MyThreesideViewer.$$$reportNull$$$0(12);
            }
            if (conflictTypes == null) {
                MyThreesideViewer.$$$reportNull$$$0(13);
            }
            if (ignorePolicy == null) {
                MyThreesideViewer.$$$reportNull$$$0(14);
            }
            if (this.isDisposed()) {
                return;
            }
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            boolean success2 = this.setInitialOutputContent();
            if (!success2) {
                fragments = Collections.emptyList();
                conflictTypes = Collections.emptyList();
                this.myPanel.addNotification(DiffNotifications.createNotification(DiffBundle.message((String)"error.cant.resolve.conflicts.in.a.read.only.file", (Object[])new Object[0])));
            }
            this.myModel.setChanges(ContainerUtil.map(fragments, f -> new LineRange(f.getStartLine(ThreeSide.BASE), f.getEndLine(ThreeSide.BASE))));
            for (int index2 = 0; index2 < fragments.size(); ++index2) {
                MergeLineFragment fragment = (MergeLineFragment)fragments.get(index2);
                MergeConflictType conflictType = conflictTypes.get(index2);
                TextMergeChange change = new TextMergeChange(index2, fragment, conflictType, TextMergeViewer.this);
                this.myAllMergeChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
            this.getEditor().setViewer(false);
            this.myLoadingPanel.stopLoading();
            TextMergeViewer.this.myAcceptResolveAction.setEnabled(true);
            this.myInnerDiffWorker.onEverythingChanged();
            this.myInitialRediffFinished = true;
            this.myContentModified = false;
            this.myCurrentIgnorePolicy = ignorePolicy;
            if (TextMergeViewer.this.myViewer.getTextSettings().isAutoApplyNonConflictedChanges() && this.hasNonConflictedChanges(ThreeSide.BASE)) {
                this.applyNonConflictedChanges(ThreeSide.BASE);
            }
        }

        @Override
        @RequiresEdt
        protected void destroyChangedBlocks() {
            super.destroyChangedBlocks();
            this.myInnerDiffWorker.stop();
            for (TextMergeChange change : this.myAllMergeChanges) {
                change.destroy();
            }
            this.myAllMergeChanges.clear();
            this.myModel.setChanges(Collections.emptyList());
        }

        @Override
        @RequiresEdt
        protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyThreesideViewer.$$$reportNull$$$0(15);
            }
            super.onBeforeDocumentChange(e);
            if (this.myInitialRediffFinished) {
                this.myContentModified = true;
            }
        }

        public void repaintDividers() {
            this.myContentPanel.repaintDividers();
        }

        private void onChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(16);
            }
            if (change.isResolved()) {
                this.onChangeRemoved(change);
            } else {
                this.onChangeAdded(change);
            }
            if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                LOG.assertTrue(ContainerUtil.and(this.getAllChanges(), TextMergeChange::isResolved));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component2 = this.getEditor().getComponent();
                    RelativePoint point = new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, JBUIScale.scale((int)5)));
                    String message2 = DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message2, point, (Disposable)this, () -> {
                        if (this.isDisposed() || this.myLoadingPanel.isLoading()) {
                            return;
                        }
                        this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }

        @NotNull
        public MergeModelBase getModel() {
            MergeModelBase mergeModelBase = this.myModel;
            if (mergeModelBase == null) {
                MyThreesideViewer.$$$reportNull$$$0(17);
            }
            return mergeModelBase;
        }

        @NotNull
        public List<TextMergeChange> getAllChanges() {
            List<TextMergeChange> list2 = this.myAllMergeChanges;
            if (list2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(18);
            }
            return list2;
        }

        @NotNull
        public List<TextMergeChange> getChanges() {
            List list2 = ContainerUtil.filter(this.myAllMergeChanges, mergeChange -> !mergeChange.isResolved());
            if (list2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(19);
            }
            return list2;
        }

        @Override
        @NotNull
        protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(20);
            }
            return new MyDividerPaintable(side);
        }

        @NotNull
        public KeyboardModifierListener getModifierProvider() {
            ModifierProvider modifierProvider = this.myModifierProvider;
            if (modifierProvider == null) {
                MyThreesideViewer.$$$reportNull$$$0(21);
            }
            return modifierProvider;
        }

        @NotNull
        public EditorEx getEditor() {
            EditorEx editorEx = this.getEditor(ThreeSide.BASE);
            if (editorEx == null) {
                MyThreesideViewer.$$$reportNull$$$0(22);
            }
            return editorEx;
        }

        public boolean executeMergeCommand(@Nullable @Nls String commandName2, boolean underBulkUpdate, @Nullable List<? extends TextMergeChange> affected, @NotNull Runnable task2) {
            if (task2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(23);
            }
            this.myContentModified = true;
            IntArrayList affectedIndexes = null;
            if (affected != null) {
                affectedIndexes = new IntArrayList(affected.size());
                for (TextMergeChange textMergeChange : affected) {
                    affectedIndexes.add(textMergeChange.getIndex());
                }
            }
            return this.myModel.executeMergeCommand(commandName2, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, (IntList)affectedIndexes, task2);
        }

        public boolean executeMergeCommand(@Nullable @Nls String commandName2, @Nullable List<? extends TextMergeChange> affected, @NotNull Runnable task2) {
            if (task2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(24);
            }
            return this.executeMergeCommand(commandName2, false, affected, task2);
        }

        @RequiresEdt
        public void markChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(25);
            }
            if (change.isResolved()) {
                return;
            }
            change.setResolved(Side.LEFT, true);
            change.setResolved(Side.RIGHT, true);
            this.onChangeResolved(change);
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        @RequiresEdt
        public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(26);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(27);
            }
            if (change.isResolved(side)) {
                return;
            }
            change.setResolved(side, true);
            if (change.isResolved()) {
                this.onChangeResolved(change);
            }
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(28);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(29);
            }
            if (!change.isConflict() || resolveChange) {
                this.markChangeResolved(change);
            } else {
                this.markChangeResolved(change, side);
            }
        }

        @RequiresWriteLock
        public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(30);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(31);
            }
            if (change.isResolved(side)) {
                return;
            }
            if (!change.isChange(side)) {
                this.markChangeResolved(change);
                return;
            }
            ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            Document sourceDocument = this.getContent(sourceSide).getDocument();
            int sourceStartLine = change.getStartLine(sourceSide);
            int sourceEndLine = change.getEndLine(sourceSide);
            List<String> newContent = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
            if (change.isConflict()) {
                boolean append = change.isOnesideAppliedConflict();
                if (append) {
                    this.myModel.appendChange(change.getIndex(), newContent);
                } else {
                    this.myModel.replaceChange(change.getIndex(), newContent);
                }
                if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                    this.markChangeResolved(change);
                } else {
                    change.markOnesideAppliedConflict();
                    this.markChangeResolved(change, side);
                }
            } else {
                this.myModel.replaceChange(change.getIndex(), newContent);
                this.markChangeResolved(change);
            }
        }

        private boolean hasNonConflictedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(32);
            }
            return ContainerUtil.exists(this.getAllChanges(), change -> !change.isConflict() && this.canResolveChangeAutomatically((TextMergeChange)change, side));
        }

        private void applyNonConflictedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(33);
            }
            this.executeMergeCommand(DiffBundle.message((String)"merge.dialog.apply.non.conflicted.changes.command", (Object[])new Object[0]), true, null, () -> {
                ArrayList<TextMergeChange> allChanges = new ArrayList<TextMergeChange>(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    if (change.isConflict()) continue;
                    this.resolveChangeAutomatically(change, side);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        private boolean hasResolvableConflictedChanges() {
            return ContainerUtil.exists(this.getAllChanges(), change -> this.canResolveChangeAutomatically((TextMergeChange)change, ThreeSide.BASE));
        }

        private void applyResolvableConflictedChanges() {
            this.executeMergeCommand(DiffBundle.message((String)"message.resolve.simple.conflicts.command", (Object[])new Object[0]), true, null, () -> {
                ArrayList<TextMergeChange> allChanges = new ArrayList<TextMergeChange>(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        public boolean canResolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(34);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(35);
            }
            if (change.isConflict()) {
                return side == ThreeSide.BASE && change.getType().canBeResolved() && !change.isResolved(Side.LEFT) && !change.isResolved(Side.RIGHT) && !this.isChangeRangeModified(change);
            }
            return !change.isResolved() && change.isChange(side) && !this.isChangeRangeModified(change);
        }

        private boolean isChangeRangeModified(@NotNull TextMergeChange change) {
            CharSequence resultContent;
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(36);
            }
            MergeLineFragment changeFragment = change.getFragment();
            int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
            int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
            DocumentContent baseDiffContent = (DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
            Document baseDocument = baseDiffContent.getDocument();
            int resultStartLine = change.getStartLine();
            int resultEndLine = change.getEndLine();
            DocumentEx resultDocument = this.getEditor().getDocument();
            CharSequence baseContent = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
            return !StringUtil.equals((CharSequence)baseContent, (CharSequence)(resultContent = DiffUtil.getLinesContent(resultDocument, resultStartLine, resultEndLine)));
        }

        public void resolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(37);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(38);
            }
            if (!this.canResolveChangeAutomatically(change, side)) {
                return;
            }
            if (change.isConflict()) {
                List texts = ThreeSide.map(it -> DiffUtil.getLinesContent(this.getEditor((ThreeSide)it).getDocument(), change.getStartLine((ThreeSide)it), change.getEndLine((ThreeSide)it)));
                CharSequence newContent = ComparisonMergeUtil.tryResolveConflict((CharSequence)texts.get(0), (CharSequence)texts.get(1), (CharSequence)texts.get(2));
                if (newContent == null) {
                    LOG.warn(String.format("Can't resolve conflicting change:\n'%s'\n'%s'\n'%s'\n", texts.get(0), texts.get(1), texts.get(2)));
                    return;
                }
                String[] newContentLines = LineTokenizer.tokenize((CharSequence)newContent, (boolean)false);
                this.myModel.replaceChange(change.getIndex(), Arrays.asList(newContentLines));
                this.markChangeResolved(change);
            } else {
                Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
                this.replaceChange(change, masterSide, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflictTypes";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignorePolicy";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 16: 
                case 25: 
                case 26: 
                case 28: 
                case 30: 
                case 34: 
                case 36: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 20: 
                case 27: 
                case 29: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditorHolders";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditorPopupActions";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doPerformRediff";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllChanges";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifierProvider";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditorHolders";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getResolveAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "performRediff";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerformRediff";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "onBeforeDocumentChange";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "onChangeResolved";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getDividerPaintable";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "executeMergeCommand";
                    break;
                }
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "markChangeResolved";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "ignoreChange";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceChange";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNonConflictedChanges";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "applyNonConflictedChanges";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "canResolveChangeAutomatically";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "isChangeRangeModified";
                    break;
                }
                case 37: 
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveChangeAutomatically";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class NavigateToChangeMarkerAction
        extends DumbAwareAction {
            private final boolean myGoToNext;

            protected NavigateToChangeMarkerAction(boolean goToNext) {
                this.myGoToNext = goToNext;
                ActionUtil.copyFrom((AnAction)this, (String)(this.myGoToNext ? "VcsShowNextChangeMarker" : "VcsShowPrevChangeMarker"));
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    NavigateToChangeMarkerAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(MyThreesideViewer.this.getTextSettings().isEnableLstGutterMarkersInMerge());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object targetRange;
                if (e == null) {
                    NavigateToChangeMarkerAction.$$$reportNull$$$0(1);
                }
                if (!MyThreesideViewer.this.myLineStatusTracker.isValid()) {
                    return;
                }
                int line = MyThreesideViewer.this.getEditor().getCaretModel().getLogicalPosition().line;
                Object r = targetRange = this.myGoToNext ? MyThreesideViewer.this.myLineStatusTracker.getNextRange(line) : MyThreesideViewer.this.myLineStatusTracker.getPrevRange(line);
                if (targetRange != null) {
                    new MyLineStatusMarkerRenderer(MyThreesideViewer.this.myLineStatusTracker).scrollAndShow(MyThreesideViewer.this.getEditor(), (Range)targetRange);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$NavigateToChangeMarkerAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class MyLineStatusMarkerRenderer
        extends LineStatusMarkerPopupRenderer {
            MyLineStatusMarkerRenderer(LineStatusTrackerBase<?> tracker2) {
                if (tracker2 == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(0);
                }
                super(tracker2);
            }

            @Override
            @Nullable
            protected MarkupEditorFilter getEditorFilter() {
                return editor -> editor == MyThreesideViewer.this.getEditor();
            }

            @Override
            public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
                if (editor == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(1);
                }
                if (range2 == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(2);
                }
                if (!this.myTracker.isValid()) {
                    return;
                }
                Document document = this.myTracker.getDocument();
                int line = Math.min(!range2.hasLines() ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
                int[] startLines = new int[]{((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, ((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
                for (ThreeSide side : ThreeSide.values()) {
                    DiffUtil.moveCaret(MyThreesideViewer.this.getEditor(side), side.select(startLines));
                }
                MyThreesideViewer.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.showAfterScroll(editor, range2);
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
                if (editor == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(3);
                }
                if (range2 == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(4);
                }
                ArrayList<AnAction> actions = new ArrayList<AnAction>();
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new MyRollbackLineStatusRangeAction(editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(this, editor, range2, mousePosition));
                ArrayList<AnAction> arrayList = actions;
                if (arrayList == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            @Override
            protected void paint(@NotNull Editor editor, @NotNull Graphics g) {
                if (editor == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(6);
                }
                if (g == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(7);
                }
                LineStatusMarkerDrawUtil.paintDefault(editor, g, this.myTracker, DefaultFlagsProvider.DEFAULT, JBUIScale.scale((int)2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tracker";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerRenderer";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerRenderer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "scrollAndShow";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarActions";
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "paint";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }

            private final class MyRollbackLineStatusRangeAction
            extends LineStatusMarkerPopupRenderer.RangeMarkerAction {
                private MyRollbackLineStatusRangeAction(@NotNull Editor editor, Range range2) {
                    if (editor == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(0);
                    }
                    if (range2 == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(1);
                    }
                    super(MyLineStatusMarkerRenderer.this, editor, range2, "Vcs.RollbackChangedLines");
                }

                @Override
                protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
                    if (editor == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(2);
                    }
                    if (range2 == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(3);
                    }
                    return true;
                }

                @Override
                protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
                    if (editor == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(4);
                    }
                    if (range2 == null) {
                        MyRollbackLineStatusRangeAction.$$$reportNull$$$0(5);
                    }
                    DiffUtil.moveCaretToLineRangeIfNeeded(editor, range2.getLine1(), range2.getLine2());
                    MyLineStatusMarkerRenderer.this.myTracker.rollbackChanges(range2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "range";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerRenderer$MyRollbackLineStatusRangeAction";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isEnabled";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        }

        public class ModifierProvider
        extends KeyboardModifierListener {
            public void init() {
                this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
            }

            @Override
            public void onModifiersChanged() {
                for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                    change.updateGutterActions(false);
                }
            }
        }

        private class MyDividerPaintable
        implements DiffDividerDrawUtil.DividerPaintable {
            @NotNull
            private final Side mySide;

            MyDividerPaintable(Side side) {
                if (side == null) {
                    MyDividerPaintable.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                if (handler2 == null) {
                    MyDividerPaintable.$$$reportNull$$$0(1);
                }
                ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                    if (!mergeChange.isChange(this.mySide)) continue;
                    boolean isResolved = mergeChange.isResolved(this.mySide);
                    if (handler2.processResolvable(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), mergeChange.getDiffType(), isResolved)) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyDividerPaintable";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ShowDiffWithBaseAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            ShowDiffWithBaseAction(ThreeSide side) {
                if (side == null) {
                    ShowDiffWithBaseAction.$$$reportNull$$$0(0);
                }
                this.mySide = side;
                String actionId = (String)this.mySide.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ShowDiffWithBaseAction.$$$reportNull$$$0(1);
                }
                DiffContent baseContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
                String baseTitle = (String)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContentTitles());
                DiffContent otherContent = (DiffContent)this.mySide.select(MyThreesideViewer.this.myRequest.getContents());
                String otherTitle = (String)this.mySide.select(MyThreesideViewer.this.myRequest.getContentTitles());
                SimpleDiffRequest request = new SimpleDiffRequest(MyThreesideViewer.this.myRequest.getTitle(), baseContent, otherContent, baseTitle, otherTitle);
                ThreeSide currentSide = MyThreesideViewer.this.getCurrentSide();
                LogicalPosition currentPosition = DiffUtil.getCaretPosition(MyThreesideViewer.this.getCurrentEditor());
                LogicalPosition resultPosition = MyThreesideViewer.this.transferPosition(currentSide, this.mySide, currentPosition);
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
                DiffManager.getInstance().showDiff(MyThreesideViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)MyThreesideViewer.this.myPanel));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ShowDiffWithBaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public class MagicResolvedConflictsAction
        extends DumbAwareAction {
            public MagicResolvedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.MagicResolveConflicts");
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MagicResolvedConflictsAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasResolvableConflictedChanges());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MagicResolvedConflictsAction.$$$reportNull$$$0(1);
                }
                MyThreesideViewer.this.applyResolvableConflictedChanges();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MagicResolvedConflictsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public class ApplyNonConflictsAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ApplyNonConflictsAction(@NotNull @Nls ThreeSide side, String text2) {
                if (side == null) {
                    ApplyNonConflictsAction.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    ApplyNonConflictsAction.$$$reportNull$$$0(1);
                }
                String id2 = (String)side.select((Object)"Diff.ApplyNonConflicts.Left", (Object)"Diff.ApplyNonConflicts", (Object)"Diff.ApplyNonConflicts.Right");
                ActionUtil.copyFrom((AnAction)this, (String)id2);
                this.mySide = side;
                this.getTemplatePresentation().setText(text2);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplyNonConflictsAction.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasNonConflictedChanges(this.mySide));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplyNonConflictsAction.$$$reportNull$$$0(3);
                }
                MyThreesideViewer.this.applyNonConflictedChanges(this.mySide);
            }

            public boolean displayTextInToolbar() {
                return true;
            }

            public boolean useSmallerFontForTextInToolbar() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplyNonConflictsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ResolveSelectedConflictsAction
        extends ApplySelectedChangesActionBase {
            ResolveSelectedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.ResolveConflict");
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(0);
                }
                return DiffBundle.message((String)"action.presentation.merge.resolve.automatically.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(1);
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(2);
                }
                return MyThreesideViewer.this.canResolveChangeAutomatically(change, ThreeSide.BASE);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(3);
                }
                if (changes == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(4);
                }
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    TextMergeChange change = changes.get(i2);
                    MyThreesideViewer.this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedConflictsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ResolveSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ResolveSelectedChangesAction(Side side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(1);
                }
                return DiffBundle.message((String)"action.presentation.merge.resolve.using.side.text", (Object[])new Object[]{this.mySide.getIndex()});
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(2);
                }
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(5);
                }
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ApplySelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ApplySelectedChangesAction(Side side) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(0);
                }
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(1);
                }
                return side != ThreeSide.BASE ? DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]) : this.getTemplatePresentation().getText();
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(2);
                }
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(5);
                }
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IgnoreSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            IgnoreSelectedChangesAction() {
                this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(0);
                }
                return DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(1);
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(2);
                }
                return !change.isResolved();
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(3);
                }
                if (changes == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(4);
                }
                for (TextMergeChange textMergeChange : changes) {
                    MyThreesideViewer.this.markChangeResolved(textMergeChange);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IgnoreSelectedChangesSideAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            IgnoreSelectedChangesSideAction(Side side) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(0);
                }
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(1);
                }
                return DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(2);
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<? extends TextMergeChange> changes) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(5);
                }
                for (TextMergeChange textMergeChange : changes) {
                    MyThreesideViewer.this.ignoreChange(textMergeChange, this.mySide, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private abstract class ApplySelectedChangesActionBase
        extends AnAction
        implements DumbAware {
            private ApplySelectedChangesActionBase() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
                }
                if (DiffUtil.isFromShortcut(e)) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                Presentation presentation2 = e.getPresentation();
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (side == null) {
                    presentation2.setEnabledAndVisible(false);
                    return;
                }
                if (!this.isVisible(side)) {
                    presentation2.setEnabledAndVisible(false);
                    return;
                }
                presentation2.setText(this.getText(side));
                presentation2.setVisible(true);
                presentation2.setEnabled(this.isSomeChangeSelected(side));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
                }
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (editor == null || side == null) {
                    return;
                }
                List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                if (selectedChanges.isEmpty()) {
                    return;
                }
                String title = DiffBundle.message((String)"message.do.in.merge.command", (Object[])new Object[]{e.getPresentation().getText()});
                MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> this.apply(side, selectedChanges));
            }

            private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
                }
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines2 -> ContainerUtil.exists(MyThreesideViewer.this.getAllChanges(), change -> this.isChangeSelected((TextMergeChange)change, (BitSet)lines2, side))));
            }

            @NotNull
            @RequiresEdt
            private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
                }
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                BitSet lines2 = DiffUtil.getSelectedLines(editor);
                List list2 = ContainerUtil.filter(MyThreesideViewer.this.getChanges(), change -> this.isChangeSelected((TextMergeChange)change, lines2, side));
                if (list2 == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
                }
                return list2;
            }

            private boolean isChangeSelected(@NotNull TextMergeChange change, @NotNull BitSet lines2, @NotNull ThreeSide side) {
                if (change == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(5);
                }
                if (lines2 == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(6);
                }
                if (side == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(7);
                }
                if (!this.isEnabled(change)) {
                    return false;
                }
                int line1 = change.getStartLine(side);
                int line2 = change.getEndLine(side);
                return DiffUtil.isSelectedByLine(lines2, line1, line2);
            }

            @Nls
            protected abstract String getText(@NotNull ThreeSide var1);

            protected abstract boolean isVisible(@NotNull ThreeSide var1);

            protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

            @RequiresWriteLock
            protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<? extends TextMergeChange> var2);

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lines";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSomeChangeSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedChanges";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "isChangeSelected";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyMergeModel
        extends MergeModelBase<TextMergeChange.State> {
            MyMergeModel(@NotNull Project project, Document document) {
                if (document == null) {
                    MyMergeModel.$$$reportNull$$$0(0);
                }
                super(project, document);
            }

            @Override
            protected void reinstallHighlighters(int index2) {
                TextMergeChange change = MyThreesideViewer.this.myAllMergeChanges.get(index2);
                change.reinstallHighlighters();
                MyThreesideViewer.this.myInnerDiffWorker.scheduleRediff(change);
            }

            @Override
            @NotNull
            protected TextMergeChange.State storeChangeState(int index2) {
                TextMergeChange change = MyThreesideViewer.this.myAllMergeChanges.get(index2);
                TextMergeChange.State state = change.storeState();
                if (state == null) {
                    MyMergeModel.$$$reportNull$$$0(1);
                }
                return state;
            }

            @Override
            protected void restoreChangeState(@NotNull TextMergeChange.State state) {
                if (state == null) {
                    MyMergeModel.$$$reportNull$$$0(2);
                }
                super.restoreChangeState(state);
                TextMergeChange change = MyThreesideViewer.this.myAllMergeChanges.get(state.myIndex);
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                if (wasResolved != change.isResolved()) {
                    MyThreesideViewer.this.onChangeResolved(change);
                }
            }

            @Override
            @Nullable
            protected TextMergeChange.State processDocumentChange(int index2, int oldLine1, int oldLine2, int shift) {
                TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index2, oldLine1, oldLine2, shift);
                TextMergeChange mergeChange = MyThreesideViewer.this.myAllMergeChanges.get(index2);
                if (mergeChange.getStartLine() == mergeChange.getEndLine() && mergeChange.getDiffType() == TextDiffType.DELETED && !mergeChange.isResolved()) {
                    TextMergeViewer.this.myViewer.markChangeResolved(mergeChange);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "storeChangeState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreChangeState";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyInnerDiffWorker {
            @NotNull
            private final Set<TextMergeChange> myScheduled = new HashSet<TextMergeChange>();
            @NotNull
            private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
            @Nullable
            private ProgressIndicator myProgress;
            private boolean myEnabled = false;

            private MyInnerDiffWorker() {
            }

            @RequiresEdt
            public void scheduleRediff(@NotNull TextMergeChange change) {
                if (change == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(0);
                }
                this.scheduleRediff(Collections.singletonList(change));
            }

            @RequiresEdt
            public void scheduleRediff(@NotNull Collection<? extends TextMergeChange> changes) {
                if (changes == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(1);
                }
                if (!this.myEnabled) {
                    return;
                }
                this.putChanges(changes);
                this.schedule();
            }

            @RequiresEdt
            public void onSettingsChanged() {
                boolean enabled;
                boolean bl = enabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                if (this.myEnabled == enabled) {
                    return;
                }
                this.myEnabled = enabled;
                this.rebuildEverything();
            }

            @RequiresEdt
            public void onEverythingChanged() {
                this.myEnabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                this.rebuildEverything();
            }

            @RequiresEdt
            public void disable() {
                this.myEnabled = false;
                this.stop();
            }

            private void rebuildEverything() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                if (this.myEnabled) {
                    this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                    this.launchRediff(true);
                } else {
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    this.myScheduled.clear();
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.setInnerFragments(null);
                    }
                }
            }

            @RequiresEdt
            public void stop() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                this.myScheduled.clear();
                this.myAlarm.cancelAllRequests();
            }

            @RequiresEdt
            private void putChanges(@NotNull Collection<? extends TextMergeChange> changes) {
                if (changes == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(2);
                }
                for (TextMergeChange textMergeChange : changes) {
                    if (textMergeChange.isResolved()) continue;
                    this.myScheduled.add(textMergeChange);
                }
            }

            @RequiresEdt
            private void schedule() {
                if (this.myProgress != null) {
                    return;
                }
                if (this.myScheduled.isEmpty()) {
                    return;
                }
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.launchRediff(false), 300);
            }

            @RequiresEdt
            private void launchRediff(boolean trySync) {
                MyThreesideViewer.this.myStatusPanel.setBusy(true);
                ArrayList<TextMergeChange> scheduled = new ArrayList<TextMergeChange>(this.myScheduled);
                this.myScheduled.clear();
                List documents = ThreeSide.map(side -> MyThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
                List data2 = ContainerUtil.map(scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
                int waitMillis = trySync ? 300 : 0;
                ProgressIndicator progress2 = BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> this.performRediff((List<? extends TextMergeChange>)scheduled, data2, (ProgressIndicator)indicator)), null, waitMillis, false);
                if (progress2.isRunning()) {
                    this.myProgress = progress2;
                }
            }

            @NotNull
            @RequiresBackgroundThread
            private Runnable performRediff(@NotNull List<? extends TextMergeChange> scheduled, @NotNull List<? extends InnerChunkData> data2, @NotNull ProgressIndicator indicator) {
                if (scheduled == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(3);
                }
                if (data2 == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(4);
                }
                if (indicator == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(5);
                }
                ComparisonPolicy comparisonPolicy = MyThreesideViewer.this.myTextDiffProvider.getIgnorePolicy().getComparisonPolicy();
                ArrayList<MergeInnerDifferences> result2 = new ArrayList<MergeInnerDifferences>(data2.size());
                for (InnerChunkData innerChunkData : data2) {
                    result2.add(DiffUtil.compareThreesideInner(innerChunkData.text, comparisonPolicy, indicator));
                }
                Runnable runnable2 = () -> {
                    if (!this.myEnabled || indicator.isCanceled()) {
                        return;
                    }
                    this.myProgress = null;
                    for (int i2 = 0; i2 < scheduled.size(); ++i2) {
                        TextMergeChange change = (TextMergeChange)scheduled.get(i2);
                        if (this.myScheduled.contains(change)) continue;
                        change.setInnerFragments((MergeInnerDifferences)result2.get(i2));
                    }
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    if (!this.myScheduled.isEmpty()) {
                        this.launchRediff(false);
                    }
                };
                if (runnable2 == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(6);
                }
                return runnable2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheduled";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performRediff";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "scheduleRediff";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "putChanges";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "performRediff";
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

