/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModelBase<S extends State>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeModelBase.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final UndoManager myUndoManager;
    @NotNull
    private final IntList myStartLines;
    @NotNull
    private final IntList myEndLines;
    @NotNull
    private final IntSet myChangesToUpdate;
    private int myBulkChangeUpdateDepth;
    private boolean myInsideCommand;
    private boolean myDisposed;

    public MergeModelBase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            MergeModelBase.$$$reportNull$$$0(0);
        }
        this.myStartLines = new IntArrayList();
        this.myEndLines = new IntArrayList();
        this.myChangesToUpdate = new IntOpenHashSet();
        this.myProject = project;
        this.myDocument = document;
        this.myUndoManager = this.myProject != null ? UndoManager.getInstance((Project)this.myProject) : UndoManager.getGlobalInstance();
        this.myDocument.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
    }

    @RequiresEdt
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        LOG.assertTrue(this.myBulkChangeUpdateDepth == 0);
        this.myStartLines.clear();
        this.myEndLines.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public int getChangesCount() {
        return this.myStartLines.size();
    }

    public int getLineStart(int index2) {
        return this.myStartLines.getInt(index2);
    }

    public int getLineEnd(int index2) {
        return this.myEndLines.getInt(index2);
    }

    public void setChanges(@NotNull List<? extends LineRange> changes) {
        if (changes == null) {
            MergeModelBase.$$$reportNull$$$0(1);
        }
        this.myStartLines.clear();
        this.myEndLines.clear();
        for (LineRange lineRange : changes) {
            this.myStartLines.add(lineRange.start);
            this.myEndLines.add(lineRange.end);
        }
    }

    @RequiresEdt
    public boolean isInsideCommand() {
        return this.myInsideCommand;
    }

    private void setLineStart(int index2, int line) {
        this.myStartLines.set(index2, line);
    }

    private void setLineEnd(int index2, int line) {
        this.myEndLines.set(index2, line);
    }

    @RequiresEdt
    public void invalidateHighlighters(int index2) {
        if (this.myBulkChangeUpdateDepth > 0) {
            this.myChangesToUpdate.add(index2);
        } else {
            this.reinstallHighlighters(index2);
        }
    }

    @RequiresEdt
    public void enterBulkChangeUpdateBlock() {
        ++this.myBulkChangeUpdateDepth;
    }

    @RequiresEdt
    public void exitBulkChangeUpdateBlock() {
        --this.myBulkChangeUpdateDepth;
        LOG.assertTrue(this.myBulkChangeUpdateDepth >= 0);
        if (this.myBulkChangeUpdateDepth == 0) {
            this.myChangesToUpdate.forEach(index2 -> this.reinstallHighlighters(index2));
            this.myChangesToUpdate.clear();
        }
    }

    @RequiresEdt
    protected abstract void reinstallHighlighters(int var1);

    @NotNull
    @RequiresEdt
    protected abstract S storeChangeState(int var1);

    @RequiresEdt
    protected void restoreChangeState(@NotNull S state) {
        if (state == null) {
            MergeModelBase.$$$reportNull$$$0(2);
        }
        this.setLineStart(((State)state).myIndex, ((State)state).myStartLine);
        this.setLineEnd(((State)state).myIndex, ((State)state).myEndLine);
    }

    @Nullable
    @RequiresEdt
    protected S processDocumentChange(int index2, int oldLine1, int oldLine2, int shift) {
        int line1 = this.getLineStart(index2);
        int line2 = this.getLineEnd(index2);
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        S oldState = rangeAffected ? (S)this.storeChangeState(index2) : null;
        this.setLineStart(index2, newRange.startLine);
        this.setLineEnd(index2, newRange.endLine);
        return oldState;
    }

    public boolean executeMergeCommand(@Nullable @NlsContexts.Command String commandName2, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @Nullable IntList affectedChanges, @NotNull Runnable task2) {
        if (confirmationPolicy == null) {
            MergeModelBase.$$$reportNull$$$0(3);
        }
        if (task2 == null) {
            MergeModelBase.$$$reportNull$$$0(4);
        }
        IntList allAffectedChanges = affectedChanges != null ? this.collectAffectedChanges(affectedChanges) : null;
        return DiffUtil.executeWriteCommand(this.myProject, this.myDocument, commandName2, commandGroupId, confirmationPolicy, underBulkUpdate, () -> {
            LOG.assertTrue(!this.myInsideCommand);
            this.myInsideCommand = true;
            this.enterBulkChangeUpdateBlock();
            try {
                this.registerUndoRedo(true, allAffectedChanges);
                try {
                    task2.run();
                }
                finally {
                    this.registerUndoRedo(false, allAffectedChanges);
                }
            }
            finally {
                this.exitBulkChangeUpdateBlock();
                this.myInsideCommand = false;
            }
        });
    }

    private void registerUndoRedo(boolean undo, @Nullable IntList affectedChanges) {
        ArrayList<S> states;
        if (this.myUndoManager == null) {
            return;
        }
        if (affectedChanges != null) {
            states = new ArrayList<S>(affectedChanges.size());
            affectedChanges.forEach(index2 -> states.add(this.storeChangeState(index2)));
        } else {
            states = new ArrayList(this.getChangesCount());
            for (int index3 = 0; index3 < this.getChangesCount(); ++index3) {
                states.add(this.storeChangeState(index3));
            }
        }
        this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(this, states, undo));
    }

    @RequiresWriteLock
    public void replaceChange(int index2, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index2);
        int outputEndLine = this.getLineEnd(index2);
        DiffUtil.applyModification(this.myDocument, outputStartLine, outputEndLine, newContent);
        if (outputStartLine == outputEndLine) {
            int newOutputEndLine = outputStartLine + newContent.size();
            this.moveChangesAfterInsertion(index2, outputStartLine, newOutputEndLine);
        }
    }

    @RequiresWriteLock
    public void appendChange(int index2, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index2);
        int outputEndLine = this.getLineEnd(index2);
        DiffUtil.applyModification(this.myDocument, outputEndLine, outputEndLine, newContent);
        int newOutputEndLine = outputEndLine + newContent.size();
        this.moveChangesAfterInsertion(index2, outputStartLine, newOutputEndLine);
    }

    private void moveChangesAfterInsertion(int index2, int newOutputStartLine, int newOutputEndLine) {
        LOG.assertTrue(this.isInsideCommand());
        if (this.getLineStart(index2) != newOutputStartLine || this.getLineEnd(index2) != newOutputEndLine) {
            this.setLineStart(index2, newOutputStartLine);
            this.setLineEnd(index2, newOutputEndLine);
            this.invalidateHighlighters(index2);
        }
        boolean beforeChange = true;
        for (int otherIndex = 0; otherIndex < this.getChangesCount(); ++otherIndex) {
            int newEndLine;
            int startLine = this.getLineStart(otherIndex);
            int endLine = this.getLineEnd(otherIndex);
            if (endLine < newOutputStartLine) continue;
            if (startLine > newOutputEndLine) break;
            if (index2 == otherIndex) {
                beforeChange = false;
                continue;
            }
            int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : newOutputEndLine;
            int n = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
            if (startLine == newStartLine && endLine == newEndLine) continue;
            this.setLineStart(otherIndex, newStartLine);
            this.setLineEnd(otherIndex, newEndLine);
            this.invalidateHighlighters(otherIndex);
        }
    }

    @NotNull
    @RequiresEdt
    private IntList collectAffectedChanges(@NotNull IntList directChanges) {
        if (directChanges == null) {
            MergeModelBase.$$$reportNull$$$0(7);
        }
        IntArrayList result2 = new IntArrayList(directChanges.size());
        int directArrayIndex = 0;
        int otherIndex = 0;
        while (directArrayIndex < directChanges.size() && otherIndex < this.getChangesCount()) {
            int directIndex = directChanges.getInt(directArrayIndex);
            if (directIndex == otherIndex) {
                result2.add(directIndex);
                ++otherIndex;
                continue;
            }
            int directStart = this.getLineStart(directIndex);
            int directEnd = this.getLineEnd(directIndex);
            int otherStart = this.getLineStart(otherIndex);
            int otherEnd = this.getLineEnd(otherIndex);
            if (otherEnd < directStart) {
                ++otherIndex;
                continue;
            }
            if (otherStart > directEnd) {
                ++directArrayIndex;
                continue;
            }
            result2.add(otherIndex);
            ++otherIndex;
        }
        LOG.assertTrue(directChanges.size() <= result2.size());
        IntArrayList intArrayList = result2;
        if (intArrayList == null) {
            MergeModelBase.$$$reportNull$$$0(8);
        }
        return intArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directChanges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreChangeState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeMergeCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedChanges";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public final int myIndex;
        public final int myStartLine;
        public final int myEndLine;

        public State(int index2, int startLine, int endLine) {
            this.myIndex = index2;
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }
    }

    private static final class MyUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final WeakReference<MergeModelBase> myModelRef;
        @NotNull
        private final List<? extends State> myStates;
        private final boolean myUndo;

        MyUndoableAction(@NotNull MergeModelBase model2, @NotNull List<? extends State> states, boolean undo) {
            if (model2 == null) {
                MyUndoableAction.$$$reportNull$$$0(0);
            }
            if (states == null) {
                MyUndoableAction.$$$reportNull$$$0(1);
            }
            super(new Document[]{model2.myDocument});
            this.myModelRef = new WeakReference<MergeModelBase>(model2);
            this.myStates = states;
            this.myUndo = undo;
        }

        public final void undo() {
            MergeModelBase model2 = (MergeModelBase)this.myModelRef.get();
            if (model2 != null && this.myUndo) {
                this.restoreStates(model2);
            }
        }

        public final void redo() {
            MergeModelBase model2 = (MergeModelBase)this.myModelRef.get();
            if (model2 != null && !this.myUndo) {
                this.restoreStates(model2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreStates(@NotNull MergeModelBase model2) {
            if (model2 == null) {
                MyUndoableAction.$$$reportNull$$$0(2);
            }
            if (model2.isDisposed()) {
                return;
            }
            if (model2.getChangesCount() == 0) {
                return;
            }
            model2.enterBulkChangeUpdateBlock();
            try {
                for (State state : this.myStates) {
                    model2.restoreChangeState(state);
                    model2.invalidateHighlighters(state.myIndex);
                }
            }
            finally {
                model2.exitBulkChangeUpdateBlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyUndoableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreStates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.enterBulkChangeUpdateBlock();
            if (MergeModelBase.this.getChangesCount() == 0) {
                return;
            }
            LineRange lineRange = DiffUtil.getAffectedLineRange(e);
            int shift = DiffUtil.countLinesShift(e);
            SmartList corruptedStates = new SmartList();
            for (int index2 = 0; index2 < MergeModelBase.this.getChangesCount(); ++index2) {
                Object oldState = MergeModelBase.this.processDocumentChange(index2, lineRange.start, lineRange.end, shift);
                if (oldState == null) continue;
                MergeModelBase.this.invalidateHighlighters(index2);
                if (MergeModelBase.this.isInsideCommand()) continue;
                corruptedStates.add(oldState);
            }
            if (MergeModelBase.this.myUndoManager != null && !corruptedStates.isEmpty()) {
                MergeModelBase.this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(MergeModelBase.this, (List<? extends State>)corruptedStates, true));
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.exitBulkChangeUpdateBlock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

