/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffChangeDiffIterable;
import com.intellij.diff.comparison.iterables.DiffFragmentsDiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.ExpandedDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.InvertedDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.RangesDiffIterable;
import com.intellij.diff.comparison.iterables.SubiterableDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DiffIterableUtil {
    @TestOnly
    private static boolean SHOULD_VERIFY_ITERABLE = false;

    @NotNull
    public static FairDiffIterable diff(int @NotNull [] data1, int @NotNull [] data2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (indicator == null) {
            DiffIterableUtil.$$$reportNull$$$0(0);
        }
        if (data1 == null) {
            DiffIterableUtil.$$$reportNull$$$0(1);
        }
        if (data2 == null) {
            DiffIterableUtil.$$$reportNull$$$0(2);
        }
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges((int[])data1, (int[])data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException e) {
            throw new DiffTooBigException();
        }
    }

    @NotNull
    public static <T> FairDiffIterable diff(T @NotNull [] data1, T @NotNull [] data2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (indicator == null) {
            DiffIterableUtil.$$$reportNull$$$0(3);
        }
        if (data1 == null) {
            DiffIterableUtil.$$$reportNull$$$0(4);
        }
        if (data2 == null) {
            DiffIterableUtil.$$$reportNull$$$0(5);
        }
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges((Object[])data1, (Object[])data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException e) {
            throw new DiffTooBigException();
        }
    }

    @NotNull
    public static <T> FairDiffIterable diff(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (objects1 == null) {
            DiffIterableUtil.$$$reportNull$$$0(6);
        }
        if (objects2 == null) {
            DiffIterableUtil.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            DiffIterableUtil.$$$reportNull$$$0(8);
        }
        return DiffIterableUtil.diff(objects1.toArray(), objects2.toArray(), indicator);
    }

    @NotNull
    public static DiffIterable create(@Nullable Diff.Change change, int length1, int length2) {
        DiffChangeDiffIterable iterable = new DiffChangeDiffIterable(change, length1, length2);
        DiffIterableUtil.verify(iterable);
        DiffChangeDiffIterable diffChangeDiffIterable = iterable;
        if (diffChangeDiffIterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(9);
        }
        return diffChangeDiffIterable;
    }

    @NotNull
    public static DiffIterable createFragments(@NotNull List<? extends DiffFragment> fragments, int length1, int length2) {
        if (fragments == null) {
            DiffIterableUtil.$$$reportNull$$$0(10);
        }
        DiffFragmentsDiffIterable iterable = new DiffFragmentsDiffIterable(fragments, length1, length2);
        DiffIterableUtil.verify(iterable);
        DiffFragmentsDiffIterable diffFragmentsDiffIterable = iterable;
        if (diffFragmentsDiffIterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(11);
        }
        return diffFragmentsDiffIterable;
    }

    @NotNull
    public static DiffIterable create(@NotNull List<? extends Range> ranges, int length1, int length2) {
        if (ranges == null) {
            DiffIterableUtil.$$$reportNull$$$0(12);
        }
        RangesDiffIterable iterable = new RangesDiffIterable(ranges, length1, length2);
        DiffIterableUtil.verify(iterable);
        RangesDiffIterable rangesDiffIterable = iterable;
        if (rangesDiffIterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(13);
        }
        return rangesDiffIterable;
    }

    @NotNull
    public static DiffIterable createUnchanged(@NotNull List<? extends Range> ranges, int length1, int length2) {
        if (ranges == null) {
            DiffIterableUtil.$$$reportNull$$$0(14);
        }
        DiffIterable invert2 = DiffIterableUtil.invert(DiffIterableUtil.create(ranges, length1, length2));
        DiffIterableUtil.verify(invert2);
        DiffIterable diffIterable = invert2;
        if (diffIterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(15);
        }
        return diffIterable;
    }

    @NotNull
    public static DiffIterable invert(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(16);
        }
        InvertedDiffIterableWrapper wrapper2 = new InvertedDiffIterableWrapper(iterable);
        DiffIterableUtil.verify(wrapper2);
        InvertedDiffIterableWrapper invertedDiffIterableWrapper = wrapper2;
        if (invertedDiffIterableWrapper == null) {
            DiffIterableUtil.$$$reportNull$$$0(17);
        }
        return invertedDiffIterableWrapper;
    }

    @NotNull
    public static FairDiffIterable fair(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(18);
        }
        if (iterable instanceof FairDiffIterable) {
            FairDiffIterable fairDiffIterable = (FairDiffIterable)iterable;
            if (fairDiffIterable == null) {
                DiffIterableUtil.$$$reportNull$$$0(19);
            }
            return fairDiffIterable;
        }
        FairDiffIterableWrapper wrapper2 = new FairDiffIterableWrapper(iterable);
        DiffIterableUtil.verifyFair(wrapper2);
        FairDiffIterableWrapper fairDiffIterableWrapper = wrapper2;
        if (fairDiffIterableWrapper == null) {
            DiffIterableUtil.$$$reportNull$$$0(20);
        }
        return fairDiffIterableWrapper;
    }

    @NotNull
    public static DiffIterable subiterable(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(21);
        }
        return new SubiterableDiffIterable(iterable, start1, end1, start2, end2);
    }

    @NotNull
    public static DiffIterable expandedIterable(@NotNull DiffIterable iterable, int offset1, int offset2, int length1, int length2) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(22);
        }
        assert (offset1 + iterable.getLength1() <= length1 && offset2 + iterable.getLength2() <= length2);
        return new ExpandedDiffIterable(iterable, offset1, offset2, length1, length2);
    }

    @NotNull
    public static Iterable<Pair<Range, Boolean>> iterateAll(final @NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(23);
        }
        Iterable<Pair<Range, Boolean>> iterable2 = () -> new Iterator<Pair<Range, Boolean>>(){
            @Nullable
            private Range lastChanged;
            @Nullable
            private Range lastUnchanged;
            @NotNull
            private final Iterator myChanges;
            @NotNull
            private final Iterator myUnchanged;
            {
                this.myChanges = iterable.changes();
                this.myUnchanged = iterable.unchanged();
                this.lastChanged = this.myChanges.hasNext() ? (Range)this.myChanges.next() : null;
                this.lastUnchanged = this.myUnchanged.hasNext() ? (Range)this.myUnchanged.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.lastChanged != null || this.lastUnchanged != null;
            }

            @Override
            public Pair<Range, Boolean> next() {
                boolean equals2;
                if (this.lastChanged == null) {
                    equals2 = true;
                } else if (this.lastUnchanged == null) {
                    equals2 = false;
                } else {
                    boolean bl = equals2 = this.lastUnchanged.start1 < this.lastChanged.start1 || this.lastUnchanged.start2 < this.lastChanged.start2;
                }
                if (equals2) {
                    Range range2 = this.lastUnchanged;
                    this.lastUnchanged = this.myUnchanged.hasNext() ? (Range)this.myUnchanged.next() : null;
                    return Pair.create((Object)range2, (Object)true);
                }
                Range range3 = this.lastChanged;
                this.lastChanged = this.myChanges.hasNext() ? (Range)this.myChanges.next() : null;
                return Pair.create((Object)range3, (Object)false);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable2 == null) {
            DiffIterableUtil.$$$reportNull$$$0(24);
        }
        return iterable2;
    }

    @TestOnly
    public static void setVerifyEnabled(boolean value2) {
        SHOULD_VERIFY_ITERABLE = value2;
    }

    private static boolean isVerifyEnabled() {
        return SHOULD_VERIFY_ITERABLE;
    }

    public static void verify(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(25);
        }
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable.iterateChanges());
        DiffIterableUtil.verify(iterable.iterateUnchanged());
        DiffIterableUtil.verifyFullCover(iterable);
    }

    public static void verifyFair(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(26);
        }
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable);
        for (Range range2 : iterable.iterateUnchanged()) {
            assert (range2.end1 - range2.start1 == range2.end2 - range2.start2);
        }
    }

    private static void verify(@NotNull Iterable<? extends Range> iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(27);
        }
        for (Range range2 : iterable) {
            assert (range2.start1 <= range2.end1);
            assert (range2.start2 <= range2.end2);
            assert (range2.start1 != range2.end1 || range2.start2 != range2.end2);
        }
    }

    private static void verifyFullCover(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(28);
        }
        int last1 = 0;
        int last2 = 0;
        Boolean lastEquals = null;
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range2 = (Range)pair.first;
            Boolean equal = (Boolean)pair.second;
            assert (last1 == range2.start1);
            assert (last2 == range2.start2);
            assert (!Comparing.equal(lastEquals, (Object)equal));
            last1 = range2.end1;
            last2 = range2.end2;
            lastEquals = equal;
        }
        assert (last1 == iterable.getLength1());
        assert (last2 == iterable.getLength2());
    }

    @NotNull
    public static <T> List<LineRangeData> extractDataRanges(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull DiffIterable iterable) {
        if (objects1 == null) {
            DiffIterableUtil.$$$reportNull$$$0(29);
        }
        if (objects2 == null) {
            DiffIterableUtil.$$$reportNull$$$0(30);
        }
        if (iterable == null) {
            DiffIterableUtil.$$$reportNull$$$0(31);
        }
        ArrayList<LineRangeData> result2 = new ArrayList<LineRangeData>();
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            int i2;
            Range range2 = (Range)pair.first;
            boolean equals2 = (Boolean)pair.second;
            ArrayList<T> data1 = new ArrayList<T>();
            ArrayList<T> data2 = new ArrayList<T>();
            for (i2 = range2.start1; i2 < range2.end1; ++i2) {
                data1.add(objects1.get(i2));
            }
            for (i2 = range2.start2; i2 < range2.end2; ++i2) {
                data2.add(objects2.get(i2));
            }
            result2.add(new LineRangeData(data1, data2, equals2));
        }
        ArrayList<LineRangeData> arrayList = result2;
        if (arrayList == null) {
            DiffIterableUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data1";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data2";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects1";
                break;
            }
            case 7: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects2";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/iterables/DiffIterableUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/iterables/DiffIterableUtil";
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnchanged";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fair";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateAll";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDataRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 32: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFragments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createUnchanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fair";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "subiterable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expandedIterable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "iterateAll";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "verify";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "verifyFair";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "verifyFullCover";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "extractDataRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineRangeData<T> {
        public final boolean equals;
        @NotNull
        public final List<T> objects1;
        @NotNull
        public final List<T> objects2;

        public LineRangeData(@NotNull List<T> objects1, @NotNull List<T> objects2, boolean equals2) {
            if (objects1 == null) {
                LineRangeData.$$$reportNull$$$0(0);
            }
            if (objects2 == null) {
                LineRangeData.$$$reportNull$$$0(1);
            }
            this.equals = equals2;
            this.objects1 = objects1;
            this.objects2 = objects2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objects1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objects2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/iterables/DiffIterableUtil$LineRangeData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ExpandChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final List<?> myObjects1;
        @NotNull
        private final List<?> myObjects2;

        public ExpandChangeBuilder(@NotNull List<?> objects1, @NotNull List<?> objects2) {
            if (objects1 == null) {
                ExpandChangeBuilder.$$$reportNull$$$0(0);
            }
            if (objects2 == null) {
                ExpandChangeBuilder.$$$reportNull$$$0(1);
            }
            super(objects1.size(), objects2.size());
            this.myObjects1 = objects1;
            this.myObjects2 = objects2;
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            Range range2 = TrimUtil.expand(this.myObjects1, this.myObjects2, start1, start2, end1, end2);
            if (!range2.isEmpty()) {
                super.addChange(range2.start1, range2.start2, range2.end1, range2.end2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objects1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objects2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/iterables/DiffIterableUtil$ExpandChangeBuilder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ChangeBuilder
    extends ChangeBuilderBase {
        @Nullable
        private Diff.Change myFirstChange;
        @Nullable
        private Diff.Change myLastChange;

        public ChangeBuilder(int length1, int length2) {
            super(length1, length2);
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            Diff.Change change = new Diff.Change(start1, start2, end1 - start1, end2 - start2, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
        }

        @NotNull
        public DiffIterable finish() {
            this.doFinish();
            DiffIterable diffIterable = DiffIterableUtil.create(this.myFirstChange, this.getLength1(), this.getLength2());
            if (diffIterable == null) {
                ChangeBuilder.$$$reportNull$$$0(0);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder", "finish"));
        }
    }

    public static abstract class ChangeBuilderBase {
        private final int myLength1;
        private final int myLength2;
        private int myIndex1 = 0;
        private int myIndex2 = 0;

        public ChangeBuilderBase(int length1, int length2) {
            this.myLength1 = length1;
            this.myLength2 = length2;
        }

        public int getIndex1() {
            return this.myIndex1;
        }

        public int getIndex2() {
            return this.myIndex2;
        }

        public int getLength1() {
            return this.myLength1;
        }

        public int getLength2() {
            return this.myLength2;
        }

        public void markEqual(int index1, int index2) {
            this.markEqual(index1, index2, 1);
        }

        public void markEqual(int index1, int index2, int count) {
            this.markEqual(index1, index2, index1 + count, index2 + count);
        }

        public void markEqual(int index1, int index2, int end1, int end2) {
            if (index1 == end1 && index2 == end2) {
                return;
            }
            assert (this.myIndex1 <= index1);
            assert (this.myIndex2 <= index2);
            assert (index1 <= end1);
            assert (index2 <= end2);
            if (this.myIndex1 != index1 || this.myIndex2 != index2) {
                this.addChange(this.myIndex1, this.myIndex2, index1, index2);
            }
            this.myIndex1 = end1;
            this.myIndex2 = end2;
        }

        protected void doFinish() {
            assert (this.myIndex1 <= this.myLength1);
            assert (this.myIndex2 <= this.myLength2);
            if (this.myLength1 != this.myIndex1 || this.myLength2 != this.myIndex2) {
                this.addChange(this.myIndex1, this.myIndex2, this.myLength1, this.myLength2);
                this.myIndex1 = this.myLength1;
                this.myIndex2 = this.myLength2;
            }
        }

        protected abstract void addChange(int var1, int var2, int var3, int var4);
    }
}

