/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartupMetricCollector;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "wasReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class StartupMetricCollector
implements StartupActivity.Background {
    private AtomicBoolean wasReported;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.wasReported.compareAndSet(false, true)) {
            return;
        }
        StartUpPerformanceService startUpPerformanceService = StartUpPerformanceService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)startUpPerformanceService, (String)"StartUpPerformanceService.getInstance()");
        Object2IntMap<String> object2IntMap = startUpPerformanceService.getMetrics();
        if (object2IntMap == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(object2IntMap, (String)"StartUpPerformanceServic\u2026tance().metrics ?: return");
        Object2IntMap<String> metrics = object2IntMap;
        FUCounterUsageLogger fUCounterUsageLogger = FUCounterUsageLogger.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fUCounterUsageLogger, (String)"FUCounterUsageLogger.getInstance()");
        FUCounterUsageLogger usageLogger = fUCounterUsageLogger;
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(metrics)) {
            FeatureUsageData usageData = new FeatureUsageData();
            Object2IntMap.Entry entry2 = entry;
            Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
            usageData.addData("duration", entry2.getIntValue());
            String eventId = (String)entry.getKey();
            if (Intrinsics.areEqual((Object)eventId, (Object)"app initialization")) {
                eventId = "appInit";
            }
            usageLogger.logEvent("startup", eventId, usageData);
        }
    }

    public StartupMetricCollector() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        this.wasReported = new AtomicBoolean(application.isUnitTestMode());
    }
}

