/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ui.icons.IconLoadMeasurer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"safeHashValue", "", "value", "writeIcons", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeServiceStats", "intellij.platform.diagnostic"})
public final class IdeIdeaFormatWriterKt {
    /*
     * WARNING - void declaration
     */
    private static final void writeIcons(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "icons";
        boolean $i$f$array = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl4 = false;
        for (IconLoadMeasurer.Counter stat : IconLoadMeasurer.getStats()) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv2 = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl5 = false;
            writer.writeStringField("name", stat.name);
            IconLoadMeasurer.Counter counter = stat;
            Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"stat");
            writer.writeNumberField("count", counter.getCount());
            writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(stat.getTotalDuration()));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    private static final String safeHashValue(String value2) {
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(new Argon2Parameters.Builder(2).build());
        byte[] result2 = new byte[20];
        String string = value2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        generator.generateBytes(byArray, result2, 0, result2.length);
        String string3 = Base64.getEncoder().withoutPadding().encodeToString(result2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().with\u2026().encodeToString(result)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeServiceStats(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator $this$obj$iv;
        Object plugin22;
        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"com/intellij/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt$writeServiceStats$StatItem", "", "name", "", "(Ljava/lang/String;)V", "app", "", "getApp", "()I", "setApp", "(I)V", "module", "getModule", "setModule", "getName", "()Ljava/lang/String;", "project", "getProject", "setProject", "intellij.platform.diagnostic"})
        public final class StatItem {
            private int app;
            private int project;
            private int module;
            @NotNull
            private final String name;

            public final int getApp() {
                return this.app;
            }

            public final void setApp(int n) {
                this.app = n;
            }

            public final int getProject() {
                return this.project;
            }

            public final void setProject(int n) {
                this.project = n;
            }

            public final int getModule() {
                return this.module;
            }

            public final void setModule(int n) {
                this.module = n;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public StatItem(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.name = name;
            }
        }
        StatItem component2 = new StatItem("component");
        StatItem service = new StatItem("service");
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getLoadedPlugins(null);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"PluginManagerCore.getLoadedPlugins(null)");
        Iterable $this$sortedBy$iv = list2;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List plugins2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)a;
                boolean bl2 = false;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"it");
                it = (IdeaPluginDescriptorImpl)b;
                Comparable comparable = (Comparable)ideaPluginDescriptorImpl.getPluginId();
                bl2 = false;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl2, (String)"it");
                PluginId pluginId = ideaPluginDescriptorImpl2.getPluginId();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)pluginId));
            }
        });
        for (Object plugin22 : plugins2) {
            StatItem statItem = service;
            int n = statItem.getApp();
            Object object = plugin22;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            }
            ContainerDescriptor containerDescriptor = ((IdeaPluginDescriptorImpl)object).getApp();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor, (String)"(plugin as IdeaPluginDescriptorImpl).app");
            statItem.setApp(n + containerDescriptor.getServices().size());
            StatItem statItem2 = service;
            int n2 = statItem2.getProject();
            ContainerDescriptor containerDescriptor2 = ((IdeaPluginDescriptorImpl)plugin22).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor2, (String)"plugin.project");
            statItem2.setProject(n2 + containerDescriptor2.getServices().size());
            StatItem statItem3 = service;
            int n3 = statItem3.getModule();
            ContainerDescriptor containerDescriptor3 = ((IdeaPluginDescriptorImpl)plugin22).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor3, (String)"plugin.module");
            statItem3.setModule(n3 + containerDescriptor3.getServices().size());
            StatItem statItem4 = component2;
            int n4 = statItem4.getApp();
            ContainerDescriptor containerDescriptor4 = ((IdeaPluginDescriptorImpl)plugin22).getApp();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor4, (String)"plugin.app");
            List<ComponentConfig> list3 = containerDescriptor4.getComponents();
            statItem4.setApp(n4 + (list3 != null ? list3.size() : 0));
            StatItem statItem5 = component2;
            int n5 = statItem5.getProject();
            ContainerDescriptor containerDescriptor5 = ((IdeaPluginDescriptorImpl)plugin22).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor5, (String)"plugin.project");
            List<ComponentConfig> list4 = containerDescriptor5.getComponents();
            statItem5.setProject(n5 + (list4 != null ? list4.size() : 0));
            StatItem statItem6 = component2;
            int n6 = statItem6.getModule();
            ContainerDescriptor containerDescriptor6 = ((IdeaPluginDescriptorImpl)plugin22).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor6, (String)"plugin.module");
            List<ComponentConfig> list5 = containerDescriptor6.getComponents();
            statItem6.setModule(n6 + (list5 != null ? list5.size() : 0));
        }
        plugin22 = writer;
        String fieldName$iv = "stats";
        boolean $i$f$obj = false;
        String string = fieldName$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        String it$iv = string;
        boolean bl4 = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl5 = false;
        writer.writeNumberField("plugin", plugins2.size());
        for (StatItem statItem : CollectionsKt.listOf((Object[])new StatItem[]{component2, service})) {
            void $this$obj$iv2;
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = statItem.getName();
            boolean $i$f$obj2 = false;
            if (fieldName$iv2 != null) {
                String string2;
                boolean bl6 = false;
                boolean bl7 = false;
                String it$iv2 = string2;
                $i$a$-let-JacksonKt$obj$1$iv = false;
                $this$obj$iv2.writeFieldName(it$iv2);
            }
            $this$obj$iv2.writeStartObject();
            boolean bl8 = false;
            writer.writeNumberField("app", statItem.getApp());
            writer.writeNumberField("project", statItem.getProject());
            writer.writeNumberField("module", statItem.getModule());
            $this$obj$iv2.writeEndObject();
        }
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "plugins";
        boolean $i$f$array = false;
        string = fieldName$iv;
        bl2 = false;
        bl3 = false;
        it$iv = string;
        boolean bl9 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl10 = false;
        Iterator iterator2 = plugins2.iterator();
        while (iterator2.hasNext()) {
            PluginAwareClassLoader classLoader;
            IdeaPluginDescriptorImpl plugin3;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = plugin3 = (IdeaPluginDescriptorImpl)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"plugin");
            ClassLoader classLoader2 = ideaPluginDescriptorImpl.getPluginClassLoader();
            if (!(classLoader2 instanceof PluginAwareClassLoader)) {
                classLoader2 = null;
            }
            if ((PluginAwareClassLoader)classLoader2 == null) {
                continue;
            }
            JsonGenerator $this$obj$iv3 = writer;
            String fieldName$iv3 = null;
            boolean $i$f$obj3 = false;
            $this$obj$iv3.writeStartObject();
            boolean bl11 = false;
            PluginId pluginId = plugin3.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
            writer.writeStringField("id", pluginId.getIdString());
            writer.writeNumberField("classCount", classLoader.getLoadedClassCount());
            writer.writeNumberField("classLoadingEdtTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getEdtTime()));
            writer.writeNumberField("classLoadingBackgroundTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getBackgroundTime()));
            $this$obj$iv3.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    public static final /* synthetic */ String access$safeHashValue(String value2) {
        return IdeIdeaFormatWriterKt.safeHashValue(value2);
    }

    public static final /* synthetic */ void access$writeServiceStats(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeServiceStats(writer);
    }

    public static final /* synthetic */ void access$writeIcons(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeIcons(writer);
    }
}

