/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleImpl
extends LogConsoleBase {
    @NlsSafe
    private final String myPath;
    @NotNull
    private final File myFile;
    @NotNull
    private final Charset myCharset;
    private FileSnapshot myOldSnapshot;

    /*
     * WARNING - void declaration
     */
    public LogConsoleImpl(Project project, @NotNull File file2, @NotNull Charset charset, long skippedContents, @NlsContexts.TabTitle @NotNull String title, boolean buildInActions, GlobalSearchScope globalSearchScope) {
        void searchScope2;
        if (file2 == null) {
            LogConsoleImpl.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            LogConsoleImpl.$$$reportNull$$$0(1);
        }
        if (title == null) {
            LogConsoleImpl.$$$reportNull$$$0(2);
        }
        super(project, LogConsoleImpl.getReader(file2, charset, skippedContents), title, buildInActions, new DefaultLogFilterModel(project), (GlobalSearchScope)searchScope2);
        this.myPath = file2.getAbsolutePath();
        this.myFile = file2;
        this.myCharset = charset;
        this.myOldSnapshot = new FileSnapshot();
    }

    @Nullable
    private static Reader getReader(@NotNull File file2, @NotNull Charset charset, long skippedContents) {
        if (file2 == null) {
            LogConsoleImpl.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            LogConsoleImpl.$$$reportNull$$$0(4);
        }
        try {
            try {
                InputStream inputStream2 = Files.newInputStream(file2.toPath(), new OpenOption[0]);
                if (file2.length() >= skippedContents) {
                    for (long skipped = 0L; skipped < skippedContents; skipped += inputStream2.skip(skippedContents - skipped)) {
                    }
                }
                return new BufferedReader(new InputStreamReader(inputStream2, charset));
            }
            catch (FileNotFoundException ignored) {
                if (FileUtilRt.createIfNotExists((File)file2)) {
                    return new BufferedReader(new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]), charset));
                }
                return null;
            }
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    public String getTooltip() {
        return this.myPath;
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    @Nullable
    protected BufferedReader updateReaderIfNeeded(@Nullable BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        FileSnapshot snapshot = new FileSnapshot();
        if (this.myOldSnapshot.rolloverDetected(snapshot)) {
            reader.close();
            reader = new BufferedReader(new InputStreamReader(Files.newInputStream(this.myFile.toPath(), new OpenOption[0]), this.myCharset));
        }
        this.myOldSnapshot = snapshot;
        return reader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getReader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FileSnapshot {
        final long length;
        final byte[] firstBytes;

        FileSnapshot() {
            this.length = LogConsoleImpl.this.myFile.length();
            byte[] bytes = new byte[20];
            try (InputStream stream = Files.newInputStream(LogConsoleImpl.this.myFile.toPath(), new OpenOption[0]);){
                stream.read(bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.firstBytes = bytes;
        }

        boolean rolloverDetected(FileSnapshot current2) {
            return current2.length < this.length || !Arrays.equals(this.firstBytes, current2.firstBytes);
        }
    }
}

