/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.ThreadInfo;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.visitors.CollectRootReasonsVisitor;
import com.intellij.diagnostic.hprof.visitors.CollectStringValuesVisitor;
import com.intellij.diagnostic.hprof.visitors.CollectThreadInfoVisitor;
import com.intellij.diagnostic.hprof.visitors.CompositeVisitor;
import com.intellij.diagnostic.hprof.visitors.CreateClassStoreVisitor;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata;", "", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "threads", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/diagnostic/hprof/classstore/ThreadInfo;", "roots", "Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "getClassStore", "()Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "setClassStore", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "getRoots", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "setRoots", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "getThreads", "remapIds", "", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "Companion", "intellij.platform.ide.impl"})
public final class HProfMetadata {
    @NotNull
    private ClassStore classStore;
    @NotNull
    private final Long2ObjectMap<ThreadInfo> threads;
    @NotNull
    private Long2ObjectMap<RootReason> roots;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void remapIds(@NotNull LongUnaryOperator remappingFunction) {
        Intrinsics.checkNotNullParameter((Object)remappingFunction, (String)"remappingFunction");
        this.classStore = this.classStore.createStoreWithRemappedIDs(remappingFunction);
        Long2ObjectOpenHashMap newRoots = new Long2ObjectOpenHashMap();
        ObjectIterator objectIterator = Long2ObjectMaps.fastIterable(this.roots).iterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry;
            Long2ObjectMap.Entry entry2 = entry = (Long2ObjectMap.Entry)objectIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
            long newKey = remappingFunction.applyAsLong(entry2.getLongKey());
            boolean bl = !newRoots.containsKey(newKey);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            newRoots.put(newKey, entry.getValue());
        }
        this.roots = (Long2ObjectMap)newRoots;
    }

    @NotNull
    public final ClassStore getClassStore() {
        return this.classStore;
    }

    public final void setClassStore(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"<set-?>");
        this.classStore = classStore;
    }

    @NotNull
    public final Long2ObjectMap<ThreadInfo> getThreads() {
        return this.threads;
    }

    @NotNull
    public final Long2ObjectMap<RootReason> getRoots() {
        return this.roots;
    }

    public final void setRoots(@NotNull Long2ObjectMap<RootReason> long2ObjectMap) {
        Intrinsics.checkNotNullParameter(long2ObjectMap, (String)"<set-?>");
        this.roots = long2ObjectMap;
    }

    public HProfMetadata(@NotNull ClassStore classStore, @NotNull Long2ObjectMap<ThreadInfo> threads, @NotNull Long2ObjectMap<RootReason> roots) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        this.classStore = classStore;
        this.threads = threads;
        this.roots = roots;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata$Companion;", "", "()V", "create", "Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final HProfMetadata create(@NotNull HProfEventBasedParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Long2ObjectOpenHashMap stringIdMap = new Long2ObjectOpenHashMap();
            Long2ObjectOpenHashMap threadsMap = new Long2ObjectOpenHashMap();
            CreateClassStoreVisitor classStoreVisitor = new CreateClassStoreVisitor((Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap));
            CollectThreadInfoVisitor threadInfoVisitor = new CollectThreadInfoVisitor((Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap), (Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap));
            CollectRootReasonsVisitor rootReasonsVisitor = new CollectRootReasonsVisitor((Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap));
            CompositeVisitor visitor = new CompositeVisitor(new CollectStringValuesVisitor((Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap)), classStoreVisitor, threadInfoVisitor, rootReasonsVisitor);
            parser.accept(visitor, "create hprof metadata");
            return new HProfMetadata(classStoreVisitor.getClassStore(), (Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap), (Long2ObjectMap<RootReason>)((Long2ObjectMap)rootReasonsVisitor.getRoots()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

