/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.AnalyzeGraph$WhenMappings;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.util.UByteList;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import com.intellij.openapi.progress.ProgressIndicator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0002J\"\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;)V", "getAnalysisContext", "()Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "config", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig;", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lit/unimi/dsi/fastutil/ints/IntSet;", "Lkotlin/collections/HashMap;", "parentList", "Lcom/intellij/diagnostic/hprof/util/IntList;", "softWeakRefHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "strongRefHistogram", "addIdToListAndSetParentIfOrphan", "", "list", "Lit/unimi/dsi/fastutil/ints/IntList;", "id", "", "parentId", "addIdToSetIfOrphan", "set", "analyze", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAndClearSoftWeakHistogram", "getAndClearStrongRefHistogram", "getParentIdForObjectId", "", "objectId", "prepareHistogramSection", "preparePerClassSection", "Lcom/intellij/diagnostic/hprof/util/PartialProgressIndicator;", "setParentForObjectId", "", "traverseInstanceGraph", "WalkGraphPhase", "intellij.platform.ide.impl"})
public class AnalyzeGraph {
    private Histogram strongRefHistogram;
    private Histogram softWeakRefHistogram;
    private final com.intellij.diagnostic.hprof.util.IntList parentList;
    private final HashMap<ClassDefinition, IntSet> nominatedInstances;
    private final AnalysisConfig config;
    @NotNull
    private final AnalysisContext analysisContext;

    private final void setParentForObjectId(long objectId, long parentId) {
        this.parentList.set((int)objectId, (int)parentId);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    @NotNull
    public String analyze(@NotNull ProgressIndicator progress2) {
        boolean bl;
        StringBuilder stringBuilder;
        boolean bl2;
        CharSequence charSequence;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        StringBuilder sb = new StringBuilder();
        Collection collection = this.analysisContext.getConfig().getPerClassOptions().getClassNames();
        boolean bl3 = false;
        boolean includePerClassSection = !collection.isEmpty();
        ProgressIndicator traverseProgress = includePerClassSection ? (ProgressIndicator)new PartialProgressIndicator(progress2, 0.0, 0.5) : progress2;
        this.traverseInstanceGraph(traverseProgress);
        AnalyzeDisposer analyzeDisposer = new AnalyzeDisposer(this.analysisContext);
        analyzeDisposer.computeDisposedObjectsIDs();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        if (histogramOptions.getIncludeByCount() || histogramOptions.getIncludeBySize()) {
            stringBuilder2 = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Histogram");
            bl2 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            stringBuilder = stringBuilder3;
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            sb.append(this.prepareHistogramSection());
        }
        if (includePerClassSection) {
            PartialProgressIndicator perClassProgress = new PartialProgressIndicator(progress2, 0.5, 0.5);
            charSequence = sb;
            String string = HeapReportUtils.INSTANCE.sectionHeader("Instances of each nominated class");
            boolean bl4 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            sb.append(this.preparePerClassSection(perClassProgress));
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTree()) {
            stringBuilder2 = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposer tree");
            bl2 = false;
            StringBuilder stringBuilder6 = stringBuilder2.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            stringBuilder = stringBuilder6;
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            sb.append(analyzeDisposer.prepareDisposerTreeSection());
        }
        if (this.config.getDisposerOptions().getIncludeDisposedObjectsSummary() || this.config.getDisposerOptions().getIncludeDisposedObjectsDetails()) {
            stringBuilder2 = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposed objects");
            bl2 = false;
            StringBuilder stringBuilder7 = stringBuilder2.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            stringBuilder = stringBuilder7;
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            sb.append(analyzeDisposer.prepareDisposedObjectsSection());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePerClassSection(PartialProgressIndicator progress2) {
        Object entry;
        StringBuilder sb = new StringBuilder();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.PerClassOptions perClassOptions = this.analysisContext.getConfig().getPerClassOptions();
        if (perClassOptions.getIncludeClassList()) {
            StringBuilder stringBuilder = sb;
            String string = "Nominated classes:";
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            Object $this$forEach$iv = perClassOptions.getClassNames();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                StringBuilder stringBuilder4;
                void totalInstances;
                void classDefinition;
                HistogramEntry histogramEntry;
                Object v1;
                Object object;
                block7: {
                    Object element$iv = iterator2.next();
                    String name = (String)element$iv;
                    boolean bl3 = false;
                    object = histogram.getEntries();
                    boolean bl4 = false;
                    Object object2 = object;
                    boolean bl5 = false;
                    Iterator iterator3 = object2.iterator();
                    while (iterator3.hasNext()) {
                        Object t = iterator3.next();
                        entry = (HistogramEntry)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)((HistogramEntry)entry).getClassDefinition().getName(), (Object)name)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((HistogramEntry)v1 == null) {
                    continue;
                }
                ClassDefinition classDefinition2 = histogramEntry.component1();
                long l = histogramEntry.component2();
                long totalBytes = histogramEntry.component3();
                String prettyName = classDefinition.getPrettyName();
                object = sb;
                String string2 = " --> [" + HeapReportUtils.INSTANCE.toShortStringAsCount((long)totalInstances) + '/' + HeapReportUtils.INSTANCE.toShortStringAsSize(totalBytes) + "] " + prettyName;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append(string2), (String)"append(value)");
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
            $this$forEach$iv = sb;
            $i$f$forEach = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$forEach$iv).append('\n'), (String)"append('\\n')");
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int counter = 0;
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Stopwatch stopwatch2 = Stopwatch.createUnstarted();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            IntSet set2;
            String className = (String)element$iv;
            boolean bl = false;
            ClassDefinition classDefinition = nav.getClassStore().get(className);
            Intrinsics.checkNotNull((Object)this.nominatedInstances.get(classDefinition));
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"nominatedInstances[classDefinition]!!");
            progress2.setFraction((double)counter / (double)this.nominatedInstances.size());
            progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress", set2.size(), classDefinition.getPrettyName()));
            stopwatch2.reset().start();
            entry = sb;
            String bl6 = "CLASS: " + classDefinition.getPrettyName() + " (" + set2.size() + " objects)";
            boolean prettyName = false;
            StringBuilder stringBuilder5 = ((StringBuilder)entry).append(bl6);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder5;
            boolean totalInstances = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
            GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.analysisContext, perClassOptions.getTreeDisplayOptions(), classDefinition);
            Iterable $this$forEach$iv2 = (Iterable)set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Integer objectId = (Integer)element$iv2;
                boolean bl9 = false;
                Integer n = objectId;
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"objectId");
                referenceRegistry.registerObject(n);
            }
            set2.clear();
            sb.append(referenceRegistry.printTree());
            if (this.config.getMetaInfoOptions().getInclude()) {
                StringBuilder stringBuilder7;
                stringBuilder = sb;
                String string = "Report for " + classDefinition.getPrettyName() + " created in " + stopwatch2;
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(string), (String)"append(value)");
                boolean bl11 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
            }
            stringBuilder = sb;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            int n = counter;
            counter = n + 1;
        }
        progress2.setFraction(1.0);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String prepareHistogramSection() {
        StringBuilder result2 = new StringBuilder();
        Histogram strongRefHistogram = this.getAndClearStrongRefHistogram();
        Histogram softWeakRefHistogram = this.getAndClearSoftWeakHistogram();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        result2.append(Histogram.Companion.prepareMergedHistogramReport(histogram, "All", strongRefHistogram, "Strong-ref", histogramOptions));
        long unreachableObjectsCount = histogram.getInstanceCount() - strongRefHistogram.getInstanceCount() - softWeakRefHistogram.getInstanceCount();
        long unreachableObjectsSize = histogram.getBytesCount() - strongRefHistogram.getBytesCount() - softWeakRefHistogram.getBytesCount();
        StringBuilder stringBuilder = result2;
        String string = "Unreachable objects: " + HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(unreachableObjectsCount) + "  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(unreachableObjectsSize);
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String traverseInstanceGraph(@NotNull ProgressIndicator progress2) {
        Iterable $this$sortedByDescending$iv;
        HistogramEntry histogramEntry;
        Collection<HistogramEntry> collection;
        void $this$mapTo$iv$iv222;
        Iterable $this$map$iv;
        Object currentObjectClass42222;
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        ClassStore classStore = this.analysisContext.getClassStore();
        com.intellij.diagnostic.hprof.util.IntList sizesList = this.analysisContext.getSizesList();
        com.intellij.diagnostic.hprof.util.IntList visitedList = this.analysisContext.getVisitedList();
        UByteList refIndexList = this.analysisContext.getRefIndexList();
        Iterator<ObjectNavigator.RootObject> roots = nav.createRootsIterator();
        this.nominatedInstances.clear();
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.nominatedInstances.put(classStore.get(it), (IntSet)new IntOpenHashSet());
        }
        progress2.setText2(DiagnosticBundle.message("analyze.graph.progress.details.collect.roots", new Object[0]));
        IntArrayList toVisit = new IntArrayList();
        IntArrayList toVisit2 = new IntArrayList();
        IntOpenHashSet rootsSet = new IntOpenHashSet();
        IntOpenHashSet frameRootsSet = new IntOpenHashSet();
        while (roots.hasNext()) {
            ObjectNavigator.RootObject rootObject = roots.next();
            int rootObjectId = (int)rootObject.getId();
            if (rootObject.getReason().getJavaFrame()) {
                frameRootsSet.add(rootObjectId);
                continue;
            }
            AnalyzeGraph.addIdToSetIfOrphan$default(this, (IntSet)rootsSet, rootObjectId, 0, 4, null);
        }
        if (this.analysisContext.getConfig().getTraverseOptions().getIncludeClassesAsRoots()) {
            classStore.forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(this, rootsSet){
                final /* synthetic */ AnalyzeGraph this$0;
                final /* synthetic */ IntOpenHashSet $rootsSet;

                public final void invoke(@NotNull ClassDefinition classDefinition) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
                    AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, (IntSet)this.$rootsSet, (int)classDefinition.getId(), 0, 4, null);
                    Object[] $this$forEach$iv = classDefinition.getObjectStaticFields();
                    boolean $i$f$forEach = false;
                    StaticField[] staticFieldArray = $this$forEach$iv;
                    int n2 = staticFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        StaticField element$iv;
                        StaticField staticField = element$iv = staticFieldArray[n];
                        boolean bl = false;
                        AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, (IntSet)this.$rootsSet, (int)staticField.getValue(), 0, 4, null);
                    }
                    $this$forEach$iv = classDefinition.getConstantFields();
                    $i$f$forEach = false;
                    staticFieldArray = $this$forEach$iv;
                    n2 = staticFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        StaticField element$iv;
                        StaticField objectId = element$iv = staticFieldArray[n];
                        boolean bl = false;
                        AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, (IntSet)this.$rootsSet, (int)objectId, 0, 4, null);
                    }
                }
                {
                    this.this$0 = analyzeGraph;
                    this.$rootsSet = intOpenHashSet;
                    super(1);
                }
            }));
        }
        toVisit.addAll((IntCollection)rootsSet);
        rootsSet.clear();
        rootsSet.trim();
        int leafCounter = 0;
        StringBuilder rootObjectId = result2;
        String string = "Roots count: " + toVisit.size();
        boolean bl = false;
        StringBuilder stringBuilder = rootObjectId.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        rootObjectId = result2;
        string = "Classes count: " + classStore.size();
        bl = false;
        StringBuilder stringBuilder3 = rootObjectId.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        progress2.setText2(DiagnosticBundle.message("analyze.graph.progress.details.traversing.instance.graph", new Object[0]));
        HashMap strongRefHistogramEntries = new HashMap();
        HashMap reachableNonStrongHistogramEntries = new HashMap();
        Int2IntOpenHashMap softReferenceIdToParentMap = new Int2IntOpenHashMap();
        Int2IntOpenHashMap weakReferenceIdToParentMap = new Int2IntOpenHashMap();
        int visitedInstancesCount = 0;
        Stopwatch stopwatch2 = Stopwatch.createStarted();
        LongArrayList references = new LongArrayList();
        int visitedCount = 0;
        int strongRefVisitedCount = 0;
        int softWeakVisitedCount = 0;
        long finalizableBytes = 0L;
        long softBytes = 0L;
        long weakBytes = 0L;
        WalkGraphPhase phase = WalkGraphPhase.StrongReferencesNonLocalVariables;
        IntArrayList cleanerObjects = new IntArrayList();
        ClassDefinition sunMiscCleanerClass = classStore.getClassIfExists("sun.misc.Cleaner");
        ClassDefinition finalizerClass = classStore.getClassIfExists("java.lang.ref.Finalizer");
        boolean onlyStrongReferences = this.config.getTraverseOptions().getOnlyStrongReferences();
        while (!toVisit.isEmpty()) {
            int n = 0;
            int n2 = toVisit.size();
            while (n < n2) {
                void i2;
                int id2 = toVisit.getInt((int)i2);
                nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                currentObjectClass42222 = nav.getClass();
                if ((Intrinsics.areEqual((Object)currentObjectClass42222, (Object)sunMiscCleanerClass) || Intrinsics.areEqual((Object)currentObjectClass42222, (Object)finalizerClass)) && phase.compareTo((Enum)WalkGraphPhase.CleanerFinalizerReferences) < 0) {
                    if (!onlyStrongReferences) {
                        cleanerObjects.add(id2);
                    }
                } else {
                    Object object;
                    ++visitedInstancesCount;
                    IntSet intSet = this.nominatedInstances.get(currentObjectClass42222);
                    Boolean bl3 = intSet != null ? Boolean.valueOf(intSet.add(id2)) : null;
                    boolean isLeaf = true;
                    nav.copyReferencesTo((LongList)references);
                    boolean currentObjectIsArray = ((ClassDefinition)currentObjectClass42222).isArray();
                    if (phase.compareTo((Enum)WalkGraphPhase.SoftReferences) < 0 && nav.getSoftReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            softReferenceIdToParentMap.put((int)nav.getSoftReferenceId(), id2);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    if (phase.compareTo((Enum)WalkGraphPhase.WeakReferences) < 0 && nav.getWeakReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            weakReferenceIdToParentMap.put((int)nav.getWeakReferenceId(), id2);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    int n3 = 0;
                    int n4 = references.size();
                    while (n3 < n4) {
                        void j;
                        int referenceId = (int)references.getLong((int)j);
                        if (this.addIdToListAndSetParentIfOrphan((IntList)toVisit2, referenceId, id2)) {
                            if (!currentObjectIsArray && j <= 254) {
                                refIndexList.set(referenceId, (int)(j + true));
                            }
                            isLeaf = false;
                        }
                        ++j;
                    }
                    visitedList.set(visitedCount++, id2);
                    int size = nav.getObjectSize();
                    int sizeDivBy4 = (size + 3) / 4;
                    if (sizeDivBy4 == 0) {
                        sizeDivBy4 = 1;
                    }
                    sizesList.set(id2, sizeDivBy4);
                    HashMap histogramEntries = null;
                    if (phase == WalkGraphPhase.StrongReferencesNonLocalVariables || phase == WalkGraphPhase.StrongReferencesLocalVariables) {
                        histogramEntries = strongRefHistogramEntries;
                        if (isLeaf) {
                            ++leafCounter;
                        }
                        ++strongRefVisitedCount;
                    } else {
                        histogramEntries = reachableNonStrongHistogramEntries;
                        switch (AnalyzeGraph$WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                            case 1: {
                                finalizableBytes += (long)size;
                                break;
                            }
                            case 2: {
                                softBytes += (long)size;
                                break;
                            }
                            default: {
                                boolean bl4 = phase == WalkGraphPhase.WeakReferences;
                                boolean bl5 = false;
                                boolean bl6 = false;
                                if (_Assertions.ENABLED && !bl4) {
                                    boolean bl7 = false;
                                    String string2 = "Assertion failed";
                                    throw (Throwable)((Object)new AssertionError((Object)string2));
                                }
                                weakBytes += (long)size;
                            }
                        }
                        ++softWeakVisitedCount;
                    }
                    Map $this$getOrPut$iv = histogramEntries;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(currentObjectClass42222);
                    if (value$iv == null) {
                        boolean bl8 = false;
                        HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry((ClassDefinition)currentObjectClass42222);
                        $this$getOrPut$iv.put(currentObjectClass42222, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size);
                }
                ++i2;
            }
            progress2.setFraction(1.0 * (double)visitedInstancesCount / (double)nav.getInstanceCount());
            toVisit.clear();
            IntArrayList tmp22 = toVisit;
            toVisit = toVisit2;
            toVisit2 = tmp22;
            block15: while (toVisit.size() == 0 && phase != WalkGraphPhase.Finished) {
                phase = WalkGraphPhase.values()[phase.ordinal() + 1];
                switch (AnalyzeGraph$WhenMappings.$EnumSwitchMapping$1[phase.ordinal()]) {
                    case 1: {
                        Iterable $this$forEach$iv2 = (Iterable)frameRootsSet;
                        boolean $i$f$forEach22 = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            Integer id3 = (Integer)element$iv;
                            boolean bl9 = false;
                            IntList intList = (IntList)toVisit;
                            Integer n5 = id3;
                            Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"id");
                            this.addIdToListAndSetParentIfOrphan(intList, n5, id3);
                        }
                        continue block15;
                    }
                    case 2: {
                        toVisit.addAll((IntList)cleanerObjects);
                        cleanerObjects.clear();
                        continue block15;
                    }
                    case 3: {
                        ObjectIterator objectIterator = softReferenceIdToParentMap.int2IntEntrySet().fastIterator();
                        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"softReferenceIdToParentM\u2026EntrySet().fastIterator()");
                        currentObjectClass42222 = (Iterator)objectIterator;
                        boolean element$iv = false;
                        Iterator $i$f$forEach22 = currentObjectClass42222;
                        while ($i$f$forEach22.hasNext()) {
                            Int2IntMap.Entry entry = (Int2IntMap.Entry)$i$f$forEach22.next();
                            IntList intList = (IntList)toVisit;
                            Int2IntMap.Entry entry2 = entry;
                            Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
                            this.addIdToListAndSetParentIfOrphan(intList, entry2.getIntKey(), entry.getIntValue());
                        }
                        softReferenceIdToParentMap.clear();
                        softReferenceIdToParentMap.trim();
                        continue block15;
                    }
                    case 4: {
                        ObjectIterator objectIterator = weakReferenceIdToParentMap.int2IntEntrySet().fastIterator();
                        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"weakReferenceIdToParentM\u2026EntrySet().fastIterator()");
                        currentObjectClass42222 = (Iterator)objectIterator;
                        boolean element$iv = false;
                        Iterator $i$f$forEach22 = currentObjectClass42222;
                        while ($i$f$forEach22.hasNext()) {
                            Int2IntMap.Entry entry22 = (Int2IntMap.Entry)$i$f$forEach22.next();
                            IntList intList = (IntList)toVisit;
                            Int2IntMap.Entry entry = entry22;
                            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                            this.addIdToListAndSetParentIfOrphan(intList, entry.getIntKey(), entry22.getIntValue());
                        }
                        weakReferenceIdToParentMap.clear();
                        weakReferenceIdToParentMap.trim();
                        continue block15;
                    }
                }
            }
        }
        boolean tmp22 = cleanerObjects.isEmpty();
        boolean entry22 = false;
        boolean $i$f$forEach22 = false;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass42222 = false;
            String currentObjectClass42222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass42222));
        }
        tmp22 = softReferenceIdToParentMap.isEmpty();
        entry22 = false;
        $i$f$forEach22 = false;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass42222 = false;
            String currentObjectClass42222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass42222));
        }
        tmp22 = weakReferenceIdToParentMap.isEmpty();
        entry22 = false;
        $i$f$forEach22 = false;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass42222 = false;
            String currentObjectClass42222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass42222));
        }
        Object tmp22 = result2;
        String entry22 = "Finalizable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(finalizableBytes);
        $i$f$forEach22 = false;
        StringBuilder stringBuilder4 = ((StringBuilder)tmp22).append(entry22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        currentObjectClass42222 = stringBuilder4;
        boolean element$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)currentObjectClass42222).append('\n'), (String)"append('\\n')");
        tmp22 = result2;
        entry22 = "Soft-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(softBytes);
        $i$f$forEach22 = false;
        StringBuilder stringBuilder5 = ((StringBuilder)tmp22).append(entry22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        currentObjectClass42222 = stringBuilder5;
        element$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)currentObjectClass42222).append('\n'), (String)"append('\\n')");
        tmp22 = result2;
        entry22 = "Weak-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(weakBytes);
        $i$f$forEach22 = false;
        StringBuilder stringBuilder6 = ((StringBuilder)tmp22).append(entry22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        currentObjectClass42222 = stringBuilder6;
        element$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)currentObjectClass42222).append('\n'), (String)"append('\\n')");
        Collection collection2 = strongRefHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"strongRefHistogramEntries\n        .values");
        tmp22 = collection2;
        AnalyzeGraph analyzeGraph = this;
        boolean $i$f$map = false;
        void $i$f$forEach22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            void it;
            HistogramVisitor.InternalHistogramEntry sizeDivBy4 = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl10 = false;
            histogramEntry = it.asHistogramEntry();
            collection.add(histogramEntry);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$sortedByDescending = false;
        boolean $this$mapTo$iv$iv222 = false;
        long l = strongRefVisitedCount;
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        analyzeGraph.strongRefHistogram = new Histogram(list2, l);
        Collection collection3 = reachableNonStrongHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"reachableNonStrongHistogramEntries\n        .values");
        $this$sortedByDescending$iv = collection3;
        analyzeGraph = this;
        $i$f$map = false;
        Iterable $this$mapTo$iv$iv222 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl11 = false;
            histogramEntry = it.asHistogramEntry();
            collection.add(histogramEntry);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$sortedByDescending = false;
        boolean $this$mapTo$iv$iv = false;
        long l2 = softWeakVisitedCount;
        List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        analyzeGraph.softWeakRefHistogram = new Histogram(list3, l2);
        Stopwatch stopwatchUpdateSizes = Stopwatch.createStarted();
        for (int index2 = visitedCount - 1; index2 >= 0; --index2) {
            int parentId;
            int id4 = visitedList.get(index2);
            if (id4 == (parentId = this.parentList.get(id4))) continue;
            com.intellij.diagnostic.hprof.util.IntList intList = sizesList;
            int n = parentId;
            intList.set(n, intList.get(n) + sizesList.get(id4));
        }
        stopwatchUpdateSizes.stop();
        if (this.config.getMetaInfoOptions().getInclude()) {
            StringBuilder stringBuilder7 = result2;
            String string3 = "Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch2;
            boolean bl12 = false;
            StringBuilder stringBuilder8 = stringBuilder7.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            Object object = stringBuilder8;
            boolean bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
            stringBuilder7 = result2;
            string3 = "Update sizes time: " + stopwatchUpdateSizes;
            bl12 = false;
            StringBuilder stringBuilder9 = stringBuilder7.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
            object = stringBuilder9;
            bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
            stringBuilder7 = result2;
            string3 = "Leaves found: " + leafCounter;
            bl12 = false;
            StringBuilder stringBuilder10 = stringBuilder7.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            object = stringBuilder10;
            bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        }
        String string4 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"result.toString()");
        return string4;
    }

    private final boolean addIdToListAndSetParentIfOrphan(IntList list2, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L) {
            this.setParentForObjectId(id2, parentId);
            list2.add(id2);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToListAndSetParentIfOrphan$default(AnalyzeGraph analyzeGraph, IntList intList, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addIdToListAndSetParentIfOrphan");
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToListAndSetParentIfOrphan(intList, n, n2);
    }

    private final boolean addIdToSetIfOrphan(IntSet set2, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L && set2.add(id2)) {
            this.setParentForObjectId(id2, parentId);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToSetIfOrphan$default(AnalyzeGraph analyzeGraph, IntSet intSet, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addIdToSetIfOrphan");
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToSetIfOrphan(intSet, n, n2);
    }

    private final Histogram getAndClearStrongRefHistogram() {
        Histogram result2 = this.strongRefHistogram;
        this.strongRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    private final Histogram getAndClearSoftWeakHistogram() {
        Histogram result2 = this.softWeakRefHistogram;
        this.softWeakRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    @NotNull
    protected final AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public AnalyzeGraph(@NotNull AnalysisContext analysisContext) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.parentList = this.analysisContext.getParentList();
        this.nominatedInstances = new HashMap();
        this.config = this.analysisContext.getConfig();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph$WalkGraphPhase;", "", "(Ljava/lang/String;I)V", "StrongReferencesNonLocalVariables", "StrongReferencesLocalVariables", "SoftReferences", "WeakReferences", "CleanerFinalizerReferences", "Finished", "intellij.platform.ide.impl"})
    public static final class WalkGraphPhase
    extends Enum<WalkGraphPhase> {
        public static final /* enum */ WalkGraphPhase StrongReferencesNonLocalVariables;
        public static final /* enum */ WalkGraphPhase StrongReferencesLocalVariables;
        public static final /* enum */ WalkGraphPhase SoftReferences;
        public static final /* enum */ WalkGraphPhase WeakReferences;
        public static final /* enum */ WalkGraphPhase CleanerFinalizerReferences;
        public static final /* enum */ WalkGraphPhase Finished;
        private static final /* synthetic */ WalkGraphPhase[] $VALUES;

        static {
            WalkGraphPhase[] walkGraphPhaseArray = new WalkGraphPhase[6];
            WalkGraphPhase[] walkGraphPhaseArray2 = walkGraphPhaseArray;
            walkGraphPhaseArray[0] = StrongReferencesNonLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[1] = StrongReferencesLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[2] = SoftReferences = new WalkGraphPhase();
            walkGraphPhaseArray[3] = WeakReferences = new WalkGraphPhase();
            walkGraphPhaseArray[4] = CleanerFinalizerReferences = new WalkGraphPhase();
            walkGraphPhaseArray[5] = Finished = new WalkGraphPhase();
            $VALUES = walkGraphPhaseArray;
        }

        public static WalkGraphPhase[] values() {
            return (WalkGraphPhase[])$VALUES.clone();
        }

        public static WalkGraphPhase valueOf(String string) {
            return Enum.valueOf(WalkGraphPhase.class, string);
        }
    }
}

