/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;)V", "computeDisposedObjectsIDs", "", "getInstancesListInPriorityOrder", "", "Lit/unimi/dsi/fastutil/longs/LongList;", "classToLeakedIdsList", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "disposedDominatorReportEntries", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "prepareDisposedObjectsSection", "", "prepareDisposerTreeSection", "printDisposerTreeReportLine", "buffer", "Lcom/intellij/diagnostic/hprof/util/TruncatingPrintBuffer;", "mapping", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "groupedObjects", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "Companion", "DisposedDominatorReportEntry", "Grouping", "InstanceStats", "intellij.platform.ide.impl"})
public final class AnalyzeDisposer {
    private final AnalysisContext analysisContext;
    @NotNull
    private static final Set<String> TOP_REPORTED_CLASSES;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareDisposerTreeSection() {
        boolean bl;
        String string;
        Object element$iv;
        if (!this.analysisContext.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            return "";
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        StringBuilder result2 = new StringBuilder();
        nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        boolean bl2 = !nav.isNull();
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        nav.goToInstanceField("com.intellij.openapi.util.ObjectTree", "myObject2NodeMap");
        nav.goToInstanceField("it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap", "value");
        HashMap groupingToObjectStats = new HashMap();
        int maxTreeDepth = 200;
        HashSet<ClassDefinition> tooDeepObjectClasses = new HashSet<ClassDefinition>();
        Object $this$forEach$iv = (Iterable)nav.getReferencesCopy();
        boolean $i$f$forEach4 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            ClassDefinition classDefinition;
            long parentId;
            element$iv = iterator2.next();
            Long it = (Long)element$iv;
            boolean bl6 = false;
            Long l = it;
            if (l != null && l == 0L) continue;
            Long l2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"it");
            ObjectNavigator.goTo$default(nav, l2, null, 2, null);
            long objectNodeParentId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myParent");
            long objectNodeObjectId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myObject");
            ObjectNavigator.goTo$default(nav, objectNodeParentId, null, 2, null);
            long l3 = parentId = nav.isNull() ? 0L : nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myObject");
            if (parentId == 0L) {
                classDefinition = null;
            } else {
                ObjectNavigator.goTo$default(nav, parentId, null, 2, null);
                classDefinition = nav.getClass();
            }
            ClassDefinition parentClass = classDefinition;
            ObjectNavigator.goTo$default(nav, objectNodeObjectId, null, 2, null);
            ClassDefinition objectClass = nav.getClass();
            ClassDefinition rootClass = null;
            long rootId = 0L;
            if (parentId == 0L) {
                rootClass = objectClass;
                rootId = objectNodeObjectId;
            } else {
                long rootObjectNodeId = objectNodeParentId;
                long rootObjectId = 0L;
                int iterationCount = 0;
                do {
                    ObjectNavigator.goTo$default(nav, rootObjectNodeId, null, 2, null);
                    rootObjectNodeId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myParent");
                    rootObjectId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myObject");
                } while (rootObjectNodeId != 0L && ++iterationCount < maxTreeDepth);
                if (iterationCount >= maxTreeDepth) {
                    tooDeepObjectClasses.add(objectClass);
                    rootId = parentId;
                    ClassDefinition classDefinition2 = parentClass;
                    Intrinsics.checkNotNull((Object)classDefinition2);
                    rootClass = classDefinition2;
                } else {
                    ObjectNavigator.goTo$default(nav, rootObjectId, null, 2, null);
                    rootId = rootObjectId;
                    rootClass = nav.getClass();
                }
            }
            Map map2 = groupingToObjectStats;
            Grouping key$iv = new Grouping(objectClass, parentClass, rootClass);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl7 = false;
                InstanceStats answer$iv = new InstanceStats();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((InstanceStats)object).registerObject(parentId, rootId);
        }
        $this$forEach$iv = new TruncatingPrintBuffer(400, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

            @NotNull
            public final StringBuilder invoke(@Nullable String p1) {
                StringBuilder stringBuilder = (StringBuilder)this.receiver;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(p1);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }
        }));
        $i$f$forEach4 = false;
        boolean bl8 = false;
        Throwable throwable = null;
        try {
            void $this$forEach$iv2;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Sequence $this$sortedByDescending$iv;
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)$this$forEach$iv;
            boolean bl9 = false;
            Set set2 = groupingToObjectStats.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"groupingToObjectStats\n        .entries");
            Sequence bl6 = CollectionsKt.asSequence((Iterable)set2);
            boolean $i$f$sortedByDescending = false;
            boolean bl10 = false;
            $this$sortedByDescending$iv = SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(((InstanceStats)it.getValue()).objectCount());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ((InstanceStats)it.getValue()).objectCount();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$groupBy = false;
            string = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl11 = false;
                ClassDefinition key$iv$iv = ((Grouping)it.getKey()).getRootClass();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl12 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach2 = false;
            string = $this$forEach$iv2;
            bl = false;
            Iterator iterator3 = string.entrySet().iterator();
            while (iterator3.hasNext()) {
                void rootClass;
                Map.Entry element$iv2;
                Map.Entry $dstr$rootClass$entries = element$iv2 = iterator3.next();
                boolean bl13 = false;
                Object object = $dstr$rootClass$entries;
                boolean bl14 = false;
                ClassDefinition $this$getOrPut$iv$iv$iv = (ClassDefinition)object.getKey();
                object = $dstr$rootClass$entries;
                bl14 = false;
                List entries2 = (List)object.getValue();
                buffer.println("Root: " + rootClass.getName());
                object = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                    public final void invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        ((TruncatingPrintBuffer)this.receiver).println(p1);
                    }
                }));
                bl14 = false;
                boolean bl15 = false;
                Throwable throwable2 = null;
                try {
                    TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)object;
                    boolean bl16 = false;
                    Iterable $this$forEach$iv3 = entries2;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        void mapping2;
                        Map.Entry $dstr$mapping$groupedObjects = (Map.Entry)element$iv3;
                        boolean bl17 = false;
                        Map.Entry entry = $dstr$mapping$groupedObjects;
                        boolean bl18 = false;
                        Grouping grouping = (Grouping)entry.getKey();
                        entry = $dstr$mapping$groupedObjects;
                        bl18 = false;
                        InstanceStats groupedObjects = (InstanceStats)entry.getValue();
                        void v8 = mapping2;
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"mapping");
                        InstanceStats instanceStats = groupedObjects;
                        Intrinsics.checkNotNullExpressionValue((Object)instanceStats, (String)"groupedObjects");
                        this.printDisposerTreeReportLine(buffer2, (Grouping)v8, instanceStats);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                buffer.println();
            }
            buffer = Unit.INSTANCE;
        }
        catch (Throwable buffer) {
            throwable = buffer;
            throw buffer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)throwable);
        }
        if (tooDeepObjectClasses.size() > 0) {
            $this$forEach$iv = result2;
            String $i$f$forEach4 = "Skipped analysis of objects too deep in disposer tree:";
            boolean bl19 = false;
            StringBuilder stringBuilder = ((StringBuilder)$this$forEach$iv).append($i$f$forEach4);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$forEach$iv = tooDeepObjectClasses;
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv.iterator();
            while (iterator4.hasNext()) {
                element$iv = iterator4.next();
                ClassDefinition it = (ClassDefinition)element$iv;
                boolean bl20 = false;
                StringBuilder stringBuilder2 = result2;
                string = " * " + nav.getClassStore().getShortPrettyNameForClass(it);
                bl = false;
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
        }
        String string3 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result.toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final void printDisposerTreeReportLine(TruncatingPrintBuffer buffer, Grouping mapping2, InstanceStats groupedObjects) {
        void sourceClass;
        void parentClass;
        Grouping grouping = mapping2;
        ClassDefinition classDefinition = grouping.component1();
        ClassDefinition classDefinition2 = grouping.component2();
        ClassDefinition rootClass = grouping.component3();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int objectCount = groupedObjects.objectCount();
        int parentCount = groupedObjects.parentCount();
        if (parentClass != null && objectCount == parentCount) {
            return;
        }
        String parentString = null;
        if (parentClass == null) {
            parentString = "(no parent)";
        } else {
            String parentClassName = nav.getClassStore().getShortPrettyNameForClass((ClassDefinition)parentClass);
            int rootCount = groupedObjects.rootCount();
            parentString = Intrinsics.areEqual((Object)rootClass, (Object)parentClass) ^ true || rootCount != parentCount ? "<-- " + parentCount + ' ' + parentClassName + " [...] " + rootCount : "<-- " + parentCount;
        }
        String sourceClassName = nav.getClassStore().getShortPrettyNameForClass((ClassDefinition)sourceClass);
        StringBuilder stringBuilder = new StringBuilder().append("  ");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%6d";
        Object[] objectArray = new Object[]{objectCount};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        buffer.println(stringBuilder.append(string2).append(' ').append(sourceClassName).append(' ').append(parentString).toString());
    }

    public final void computeDisposedObjectsIDs() {
        IntOpenHashSet disposedObjectsIDs = this.analysisContext.getDisposedObjectsIDs();
        disposedObjectsIDs.clear();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntList parentList = this.analysisContext.getParentList();
        if (!nav.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            return;
        }
        nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        boolean bl = !nav.isNull();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        nav.goToInstanceField("com.intellij.openapi.util.ObjectTree", "myDisposedObjects");
        nav.goToInstanceField("com.intellij.util.containers.WeakHashMap", "myMap");
        nav.goToInstanceField("com.intellij.util.containers.RefHashMap$MyMap", "_set");
        ClassDefinition weakKeyClass = nav.getClassStore().get("com.intellij.util.containers.WeakHashMap$WeakKey");
        Iterable $this$forEach$iv = (Iterable)nav.getReferencesCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int leakId;
            Long it = (Long)element$iv;
            boolean bl5 = false;
            Long l = it;
            if (l != null && l == 0L) continue;
            Long l2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"it");
            nav.goTo(l2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            if (Intrinsics.areEqual((Object)nav.getClass(), (Object)weakKeyClass) ^ true) continue;
            nav.goToInstanceField("com.intellij.util.containers.WeakHashMap$WeakKey", "referent");
            if (nav.getId() == 0L || parentList.get(leakId = (int)nav.getId()) == 0) continue;
            disposedObjectsIDs.add(leakId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareDisposedObjectsSection() {
        boolean bl;
        Object leakClass;
        StringBuilder result2 = new StringBuilder();
        HashMap<ClassDefinition, LongList> leakedInstancesByClass = new HashMap<ClassDefinition, LongList>();
        Object2IntOpenHashMap countByClass = new Object2IntOpenHashMap();
        int totalCount = 0;
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntOpenHashSet disposedObjectsIDs = this.analysisContext.getDisposedObjectsIDs();
        AnalysisConfig.DisposerOptions disposerOptions = this.analysisContext.getConfig().getDisposerOptions();
        Iterable $this$forEach$iv = (Iterable)disposedObjectsIDs;
        boolean $i$f$forEach22 = false;
        for (Object element$iv232 : $this$forEach$iv) {
            Integer it = (Integer)element$iv232;
            boolean bl2 = false;
            nav.goTo(it.intValue(), ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            leakClass = nav.getClass();
            long leakId = nav.getId();
            ((LongList)leakedInstancesByClass.computeIfAbsent((ClassDefinition)leakClass, prepareDisposedObjectsSection.1.1.INSTANCE)).add(leakId);
            countByClass.put(leakClass, countByClass.getInt(leakClass) + 1);
            int n = totalCount;
            totalCount = n + 1;
        }
        $i$f$forEach22 = false;
        List entries2 = new ArrayList();
        countByClass.object2IntEntrySet().fastForEach((Consumer)new Consumer<Object2IntMap.Entry<ClassDefinition>>(entries2){
            final /* synthetic */ List $entries;

            public final void accept(Object2IntMap.Entry<ClassDefinition> it) {
                Object object = it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.key");
                Object2IntMap.Entry<ClassDefinition> entry = it;
                Intrinsics.checkNotNullExpressionValue(entry, (String)"it");
                @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposedObjectsSection$TObjectIntMapEntry", "T", "", "key", "value", "", "(Ljava/lang/Object;I)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "()I", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposedObjectsSection$TObjectIntMapEntry;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
                public final class TObjectIntMapEntry<T> {
                    private final T key;
                    private final int value;

                    public final T getKey() {
                        return this.key;
                    }

                    public final int getValue() {
                        return this.value;
                    }

                    public TObjectIntMapEntry(T key, int value2) {
                        this.key = key;
                        this.value = value2;
                    }

                    public final T component1() {
                        return this.key;
                    }

                    public final int component2() {
                        return this.value;
                    }

                    @NotNull
                    public final TObjectIntMapEntry<T> copy(T key, int value2) {
                        return new TObjectIntMapEntry<T>(key, value2);
                    }

                    public static /* synthetic */ TObjectIntMapEntry copy$default(TObjectIntMapEntry tObjectIntMapEntry, Object object, int n, int n2, Object object2) {
                        if ((n2 & 1) != 0) {
                            object = tObjectIntMapEntry.key;
                        }
                        if ((n2 & 2) != 0) {
                            n = tObjectIntMapEntry.value;
                        }
                        return tObjectIntMapEntry.copy(object, n);
                    }

                    @NotNull
                    public String toString() {
                        return "TObjectIntMapEntry(key=" + this.key + ", value=" + this.value + ")";
                    }

                    public int hashCode() {
                        T t = this.key;
                        return (t != null ? t.hashCode() : 0) * 31 + Integer.hashCode(this.value);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof TObjectIntMapEntry)) break block3;
                                TObjectIntMapEntry tObjectIntMapEntry = (TObjectIntMapEntry)object;
                                if (!Intrinsics.areEqual(this.key, tObjectIntMapEntry.key) || this.value != tObjectIntMapEntry.value) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                this.$entries.add(new TObjectIntMapEntry<Object>(object, entry.getIntValue()));
            }
            {
                this.$entries = list2;
            }
        });
        if (disposerOptions.getIncludeDisposedObjectsSummary()) {
            Object element$iv232;
            Closeable $i$f$forEach22 = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

                @NotNull
                public final StringBuilder invoke(@Nullable String p1) {
                    StringBuilder stringBuilder = (StringBuilder)this.receiver;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(p1);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    return StringsKt.appendln((StringBuilder)stringBuilder2);
                }
            }));
            boolean bl3 = false;
            boolean element$iv232 = false;
            element$iv232 = null;
            try {
                void $this$forEach$iv2;
                Object $this$partition$iv;
                Iterable $this$sortedByDescending$iv;
                TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)$i$f$forEach22;
                boolean bl4 = false;
                buffer.println("Count of disposed-but-strong-referenced objects: " + totalCount);
                leakClass = entries2;
                boolean $i$f$sortedByDescending = false;
                boolean bl5 = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        TObjectIntMapEntry it = (TObjectIntMapEntry)b;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getValue());
                        it = (TObjectIntMapEntry)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getValue();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
                boolean $i$f$partition = false;
                ArrayList first$iv232 = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    TObjectIntMapEntry tObjectIntMapEntry = (TObjectIntMapEntry)element$iv;
                    boolean bl6 = false;
                    if (TOP_REPORTED_CLASSES.contains(((ClassDefinition)tObjectIntMapEntry.getKey()).getName())) {
                        first$iv232.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                $this$partition$iv = new Pair(first$iv232, second$iv);
                $i$f$partition = false;
                boolean first$iv232 = false;
                Pair it = $this$partition$iv;
                boolean bl7 = false;
                $this$partition$iv = CollectionsKt.plus((Collection)((Collection)it.getFirst()), (Iterable)((Iterable)it.getSecond()));
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    TObjectIntMapEntry entry = (TObjectIntMapEntry)element$iv;
                    boolean bl8 = false;
                    buffer.println("  " + entry.getValue() + ' ' + ((ClassDefinition)entry.getKey()).getPrettyName());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                element$iv232 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$forEach22, element$iv232);
            }
            StringsKt.appendln((StringBuilder)result2);
        }
        GCRootPathsTree disposedTree = new GCRootPathsTree(this.analysisContext, AnalysisConfig.TreeDisplayOptions.Companion.all$default(AnalysisConfig.TreeDisplayOptions.Companion, false, false, false, 7, null), null);
        IntIterator intIterator = disposedObjectsIDs.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"disposedObjectsIDs.iterator()");
        IntIterator iterator2 = intIterator;
        while (iterator2.hasNext()) {
            disposedTree.registerObject(iterator2.nextInt());
        }
        Map<ClassDefinition, List<GCRootPathsTree.RegularNode>> disposedDominatorNodesByClass = disposedTree.getDisposedDominatorNodes();
        long allDominatorsCount = 0L;
        long allDominatorsSubgraphSize = 0L;
        boolean $i$f$forEach3 = false;
        List disposedDominatorClassSizeList = new ArrayList();
        Object $this$forEach$iv3 = disposedDominatorNodesByClass;
        boolean $i$f$forEach4 = false;
        Object object = $this$forEach$iv3;
        boolean entry = false;
        Iterator<Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>>> bl8 = object.entrySet().iterator();
        while (bl8.hasNext()) {
            void classDefinition;
            Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>> entry2;
            Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>> $dstr$classDefinition$nodeList = entry2 = bl8.next();
            bl = false;
            Object object2 = $dstr$classDefinition$nodeList;
            boolean bl2 = false;
            ClassDefinition classDefinition2 = object2.getKey();
            object2 = $dstr$classDefinition$nodeList;
            bl2 = false;
            List<GCRootPathsTree.RegularNode> nodeList = object2.getValue();
            long dominatorClassSubgraphSize = 0L;
            long dominatorClassInstanceCount = 0L;
            Iterable $this$forEach$iv4 = nodeList;
            boolean $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv4) {
                GCRootPathsTree.RegularNode it = (GCRootPathsTree.RegularNode)element$iv2;
                boolean bl10 = false;
                dominatorClassInstanceCount += (long)it.getInstances().size();
                dominatorClassSubgraphSize += (long)it.getTotalSizeInDwords() * (long)4;
            }
            allDominatorsCount += dominatorClassInstanceCount;
            allDominatorsSubgraphSize += dominatorClassSubgraphSize;
            disposedDominatorClassSizeList.add(new DisposedDominatorReportEntry((ClassDefinition)classDefinition, dominatorClassInstanceCount, dominatorClassSubgraphSize));
        }
        if (disposerOptions.getIncludeDisposedObjectsSummary()) {
            $this$forEach$iv3 = new TruncatingPrintBuffer(30, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

                @NotNull
                public final StringBuilder invoke(@Nullable String p1) {
                    StringBuilder stringBuilder = (StringBuilder)this.receiver;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(p1);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    return StringsKt.appendln((StringBuilder)stringBuilder2);
                }
            }));
            boolean bl11 = false;
            boolean bl12 = false;
            object = null;
            try {
                TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)$this$forEach$iv3;
                boolean bl13 = false;
                buffer.println("Disposed-but-strong-referenced dominator object count: " + allDominatorsCount);
                buffer.println("Disposed-but-strong-referenced dominator sub-graph size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(allDominatorsSubgraphSize));
                Iterable iterable = disposedDominatorClassSizeList;
                boolean $i$f$sortedByDescending = false;
                bl = false;
                Iterable iterable2 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getSize());
                        it = (DisposedDominatorReportEntry)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = it.getSize();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                });
                boolean $i$f$forEach6 = false;
                for (Object element$iv3 : iterable2) {
                    DisposedDominatorReportEntry entry2 = (DisposedDominatorReportEntry)element$iv3;
                    boolean bl14 = false;
                    buffer.println("  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry2.getSize()) + " - " + HeapReportUtils.INSTANCE.toShortStringAsCount(entry2.getCount()) + ' ' + entry2.getClassDefinition().getName());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv3, (Throwable)object);
            }
            StringsKt.appendln((StringBuilder)result2);
        }
        if (disposerOptions.getIncludeDisposedObjectsDetails()) {
            List<LongList> instancesListInOrder = this.getInstancesListInPriorityOrder(leakedInstancesByClass, disposedDominatorClassSizeList);
            Closeable closeable = new TruncatingPrintBuffer(700, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

                @NotNull
                public final StringBuilder invoke(@Nullable String p1) {
                    StringBuilder stringBuilder = (StringBuilder)this.receiver;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(p1);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    return StringsKt.appendln((StringBuilder)stringBuilder2);
                }
            }));
            boolean bl15 = false;
            boolean bl16 = false;
            Throwable throwable = null;
            try {
                void $this$forEach$iv6;
                TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
                boolean bl3 = false;
                Iterable $i$f$forEach6 = instancesListInOrder;
                boolean $i$f$forEach7 = false;
                for (Object element$iv : $this$forEach$iv6) {
                    void $this$forEach$iv2;
                    LongList instances = (LongList)element$iv;
                    boolean bl18 = false;
                    ObjectNavigator.goTo$default(nav, instances.getLong(0), null, 2, null);
                    buffer.println("Disposed but still strong-referenced objects: " + instances.size() + ' ' + nav.getClass().getPrettyName() + ", most common paths from GC-roots:");
                    GCRootPathsTree gcRootPathsTree = new GCRootPathsTree(this.analysisContext, disposerOptions.getDisposedObjectsDetailsTreeDisplayOptions(), nav.getClass());
                    Iterable $this$forEach$iv7 = (Iterable)instances;
                    boolean $i$f$forEach8 = false;
                    for (Object element$iv4 : $this$forEach$iv7) {
                        Long leakId = (Long)element$iv4;
                        boolean bl19 = false;
                        gcRootPathsTree.registerObject((int)leakId.longValue());
                    }
                    $this$forEach$iv7 = StringsKt.lineSequence((CharSequence)gcRootPathsTree.printTree());
                    TruncatingPrintBuffer truncatingPrintBuffer = buffer;
                    boolean $i$f$forEach9 = false;
                    for (Object element$iv5 : $this$forEach$iv2) {
                        String p1 = (String)element$iv5;
                        boolean bl20 = false;
                        truncatingPrintBuffer.println(p1);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LongList> getInstancesListInPriorityOrder(HashMap<ClassDefinition, LongList> classToLeakedIdsList, List<DisposedDominatorReportEntry> disposedDominatorReportEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        ClassDefinition classDefinition;
        Collection<ClassDefinition> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$sortedByDescending$iv2;
        Object result$iv;
        boolean bl = false;
        List result2 = new ArrayList();
        HashMap classToLeakedIdsListCopy = new HashMap(classToLeakedIdsList);
        Iterable $this$forEach$iv = TOP_REPORTED_CLASSES;
        boolean $i$f$forEach22 = false;
        for (Object element$iv22 : $this$forEach$iv) {
            Iterator $this$forEach$iv2;
            Map $this$filterKeys$iv;
            String topClassName = (String)element$iv22;
            boolean bl2 = false;
            Map map2 = classToLeakedIdsListCopy;
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            void var14_31 = $this$filterKeys$iv;
            boolean bl3 = false;
            for (Map.Entry entry$iv : var14_31.entrySet()) {
                ClassDefinition it = (ClassDefinition)entry$iv.getKey();
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)topClassName)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = (Map)result$iv;
            boolean $i$f$forEach = false;
            result$iv = $this$forEach$iv2;
            boolean bl5 = false;
            Iterator iterator2 = result$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void classDefinition2;
                LongList list2;
                Map.Entry element$iv;
                Map.Entry $dstr$classDefinition$list = element$iv = iterator2.next();
                boolean bl6 = false;
                Map.Entry entry = $dstr$classDefinition$list;
                boolean bl7 = false;
                ClassDefinition classDefinition3 = (ClassDefinition)entry.getKey();
                entry = $dstr$classDefinition$list;
                bl7 = false;
                LongList longList = list2 = (LongList)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)longList, (String)"list");
                result2.add(longList);
                classToLeakedIdsListCopy.remove(classDefinition2);
            }
        }
        Set set2 = classToLeakedIdsListCopy.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"classToLeakedIdsListCopy\n        .entries");
        Iterable $i$f$forEach22 = set2;
        boolean $i$f$sortedByDescending = false;
        boolean element$iv22 = false;
        $this$sortedByDescending$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((LongList)it.getValue()).size());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((LongList)it.getValue()).size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$map22 = false;
        void element$iv22 = $this$map$iv2;
        Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            result$iv = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv322;
            boolean bl8 = false;
            classDefinition = (ClassDefinition)it.getKey();
            collection.add(classDefinition);
        }
        collection = (List)destination$iv$iv322;
        Collection collection2 = collection;
        ArrayDeque classOrderByInstanceCount = new ArrayDeque(collection2);
        Iterable $i$f$map22 = disposedDominatorReportEntries;
        boolean $i$f$sortedByDescending2 = false;
        boolean destination$iv$iv322 = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getSize());
                it = (DisposedDominatorReportEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getSize();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        boolean $i$f$map = false;
        void destination$iv$iv322 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisposedDominatorReportEntry bl8 = (DisposedDominatorReportEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            classDefinition = it.getClassDefinition();
            collection.add(classDefinition);
        }
        Collection<ClassDefinition> collection3 = collection = (List)destination$iv$iv;
        ArrayDeque classOrderByByteCount = new ArrayDeque(collection3);
        boolean nextByInstanceCount = true;
        while (!classOrderByInstanceCount.isEmpty() || !classOrderByByteCount.isEmpty()) {
            ArrayDeque nextCollection;
            ArrayDeque arrayDeque = nextCollection = nextByInstanceCount ? classOrderByInstanceCount : classOrderByByteCount;
            if (!nextCollection.isEmpty()) {
                LongList list3;
                ClassDefinition nextClass = (ClassDefinition)nextCollection.removeFirst();
                if ((LongList)classToLeakedIdsListCopy.remove(nextClass) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"classToLeakedIdsListCopy\u2026ve(nextClass) ?: continue");
                result2.add(list3);
            }
            nextByInstanceCount = !nextByInstanceCount;
        }
        return result2;
    }

    public AnalyzeDisposer(@NotNull AnalysisContext analysisContext) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
    }

    static {
        Companion = new Companion(null);
        TOP_REPORTED_CLASSES = SetsKt.setOf((Object)"com.intellij.openapi.project.impl.ProjectImpl");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "", "childClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "parentClass", "rootClass", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "getChildClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getParentClass", "getRootClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Grouping {
        @NotNull
        private final ClassDefinition childClass;
        @Nullable
        private final ClassDefinition parentClass;
        @NotNull
        private final ClassDefinition rootClass;

        @NotNull
        public final ClassDefinition getChildClass() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition getParentClass() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition getRootClass() {
            return this.rootClass;
        }

        public Grouping(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkNotNullParameter((Object)childClass, (String)"childClass");
            Intrinsics.checkNotNullParameter((Object)rootClass, (String)"rootClass");
            this.childClass = childClass;
            this.parentClass = parentClass;
            this.rootClass = rootClass;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition component2() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition component3() {
            return this.rootClass;
        }

        @NotNull
        public final Grouping copy(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkNotNullParameter((Object)childClass, (String)"childClass");
            Intrinsics.checkNotNullParameter((Object)rootClass, (String)"rootClass");
            return new Grouping(childClass, parentClass, rootClass);
        }

        public static /* synthetic */ Grouping copy$default(Grouping grouping, ClassDefinition classDefinition, ClassDefinition classDefinition2, ClassDefinition classDefinition3, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = grouping.childClass;
            }
            if ((n & 2) != 0) {
                classDefinition2 = grouping.parentClass;
            }
            if ((n & 4) != 0) {
                classDefinition3 = grouping.rootClass;
            }
            return grouping.copy(classDefinition, classDefinition2, classDefinition3);
        }

        @NotNull
        public String toString() {
            return "Grouping(childClass=" + this.childClass + ", parentClass=" + this.parentClass + ", rootClass=" + this.rootClass + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.childClass;
            ClassDefinition classDefinition2 = this.parentClass;
            ClassDefinition classDefinition3 = this.rootClass;
            return ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + (classDefinition2 != null ? ((Object)classDefinition2).hashCode() : 0)) * 31 + (classDefinition3 != null ? ((Object)classDefinition3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Grouping)) break block3;
                    Grouping grouping = (Grouping)object;
                    if (!Intrinsics.areEqual((Object)this.childClass, (Object)grouping.childClass) || !Intrinsics.areEqual((Object)this.parentClass, (Object)grouping.parentClass) || !Intrinsics.areEqual((Object)this.rootClass, (Object)grouping.rootClass)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "", "()V", "parentIds", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "rootIds", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "objectCount", "", "parentCount", "registerObject", "", "parentId", "", "rootId", "rootCount", "intellij.platform.ide.impl"})
    public static final class InstanceStats {
        private final LongArrayList parentIds = new LongArrayList();
        private final LongOpenHashSet rootIds = new LongOpenHashSet();

        public final int parentCount() {
            return new LongOpenHashSet((LongCollection)this.parentIds).size();
        }

        public final int rootCount() {
            return this.rootIds.size();
        }

        public final int objectCount() {
            return this.parentIds.size();
        }

        public final void registerObject(long parentId, long rootId) {
            this.parentIds.add(parentId);
            this.rootIds.add(rootId);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "count", "", "size", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;JJ)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getCount", "()J", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class DisposedDominatorReportEntry {
        @NotNull
        private final ClassDefinition classDefinition;
        private final long count;
        private final long size;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        public DisposedDominatorReportEntry(@NotNull ClassDefinition classDefinition, long count, long size) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.count = count;
            this.size = size;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final long component2() {
            return this.count;
        }

        public final long component3() {
            return this.size;
        }

        @NotNull
        public final DisposedDominatorReportEntry copy(@NotNull ClassDefinition classDefinition, long count, long size) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new DisposedDominatorReportEntry(classDefinition, count, size);
        }

        public static /* synthetic */ DisposedDominatorReportEntry copy$default(DisposedDominatorReportEntry disposedDominatorReportEntry, ClassDefinition classDefinition, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = disposedDominatorReportEntry.classDefinition;
            }
            if ((n & 2) != 0) {
                l = disposedDominatorReportEntry.count;
            }
            if ((n & 4) != 0) {
                l2 = disposedDominatorReportEntry.size;
            }
            return disposedDominatorReportEntry.copy(classDefinition, l, l2);
        }

        @NotNull
        public String toString() {
            return "DisposedDominatorReportEntry(classDefinition=" + this.classDefinition + ", count=" + this.count + ", size=" + this.size + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            return ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + Long.hashCode(this.count)) * 31 + Long.hashCode(this.size);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DisposedDominatorReportEntry)) break block3;
                    DisposedDominatorReportEntry disposedDominatorReportEntry = (DisposedDominatorReportEntry)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)disposedDominatorReportEntry.classDefinition) || this.count != disposedDominatorReportEntry.count || this.size != disposedDominatorReportEntry.size) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Companion;", "", "()V", "TOP_REPORTED_CLASSES", "", "", "getTOP_REPORTED_CLASSES", "()Ljava/util/Set;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Set<String> getTOP_REPORTED_CLASSES() {
            return TOP_REPORTED_CLASSES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

