/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.IdeaFreezeReporter;
import com.intellij.diagnostic.JBRCrash;
import com.intellij.diagnostic.JitWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerformanceWatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PerformanceWatcher.class);
    private static final int TOLERABLE_LATENCY = 100;
    private static final String THREAD_DUMPS_PREFIX = "threadDumps-";
    static final String DUMP_PREFIX = "threadDump-";
    private static final String DURATION_FILE_NAME = ".duration";
    private static final String PID_FILE_NAME = ".pid";
    private ScheduledFuture<?> myThread;
    private final File myLogDir = new File(PathManager.getLogPath());
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private volatile long myLastSampling = System.nanoTime();
    private int myActiveEvents;
    private static final long ourIdeStart = System.currentTimeMillis();
    private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Performance Checker", (int)1);
    private FreezeCheckerTask myCurrentEDTEventChecker;
    private static final boolean SHOULD_WATCH = PerformanceWatcher.shouldWatch();
    private final JitWatcher myJitWatcher = new JitWatcher();

    @NotNull
    public static PerformanceWatcher getInstance() {
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        PerformanceWatcher performanceWatcher = (PerformanceWatcher)ApplicationManager.getApplication().getService(PerformanceWatcher.class);
        if (performanceWatcher == null) {
            PerformanceWatcher.$$$reportNull$$$0(0);
        }
        return performanceWatcher;
    }

    public PerformanceWatcher() {
        if (!PerformanceWatcher.shouldWatch()) {
            return;
        }
        final AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.setNewThreadListener((BiConsumer)new BiConsumer<Thread, Runnable>(){
            private final int ourReasonableThreadPoolSize = RegistryManager.getInstance().intValue("core.pooled.threads");

            @Override
            public void accept(Thread thread, Runnable runnable2) {
                if (service.getBackendPoolExecutorSize() > this.ourReasonableThreadPoolSize && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                    File file2 = PerformanceWatcher.this.dumpThreads("newPooledThread/", true);
                    LOG.info("Not enough pooled threads" + (String)(file2 != null ? "; dumped threads into file '" + file2.getPath() + "'" : ""));
                }
            }
        });
        PerformanceWatcher.reportCrashesIfAny();
        PerformanceWatcher.cleanOldFiles(this.myLogDir, 0);
        this.myThread = this.myExecutor.scheduleWithFixedDelay(this::samplePerformance, PerformanceWatcher.getSamplingInterval(), PerformanceWatcher.getSamplingInterval(), TimeUnit.MILLISECONDS);
    }

    private static void reportCrashesIfAny() {
        File systemDir = new File(PathManager.getSystemPath());
        try {
            File appInfoFile = new File(systemDir, ".appinfo");
            File pidFile = new File(systemDir, PID_FILE_NAME);
            if (SystemInfo.isJetBrainsJvm && appInfoFile.isFile() && pidFile.isFile()) {
                String pid2 = FileUtil.loadFile((File)pidFile);
                File[] crashFiles = new File(SystemProperties.getUserHome()).listFiles(file2 -> file2.getName().startsWith("java_error_in") && file2.getName().endsWith(pid2 + ".log") && file2.isFile());
                if (crashFiles != null) {
                    for (File file3 : crashFiles) {
                        if (file3.lastModified() <= appInfoFile.lastModified()) continue;
                        if (file3.length() > 0x500000L) {
                            LOG.info("Crash file " + file3 + " is too big to report");
                            break;
                        }
                        String content2 = FileUtil.loadFile((File)file3);
                        if (content2.contains("fuck_the_regulations")) break;
                        Attachment attachment = new Attachment("crash.txt", content2);
                        attachment.setIncluded(true);
                        Object[] attachments = new Attachment[]{attachment};
                        File extraLog = PerformanceWatcher.findExtraLogFile(pid2, appInfoFile.lastModified());
                        if (extraLog != null) {
                            Attachment extraAttachment = new Attachment("jbr_err.txt", FileUtil.loadFile((File)extraLog));
                            extraAttachment.setIncluded(true);
                            attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)extraAttachment);
                        }
                        String message2 = StringUtil.substringBefore((String)content2, (String)"---------------  P R O C E S S  ---------------");
                        IdeaLoggingEvent event = LogMessage.createEvent(new JBRCrash(), message2, (Attachment[])attachments);
                        IdeaFreezeReporter.setAppInfo(event, FileUtil.loadFile((File)appInfoFile));
                        IdeaFreezeReporter.report(event);
                        LifecycleUsageTriggerCollector.onCrashDetected();
                        break;
                    }
                }
            }
            IdeaFreezeReporter.saveAppInfo(systemDir, true);
            FileUtil.writeToFile((File)new File(systemDir, PID_FILE_NAME), (String)OSProcessUtil.getApplicationPid());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Nullable
    private static File findExtraLogFile(String pid2, long lastModified) {
        if (!SystemInfo.isMac) {
            return null;
        }
        String logFileName = "jbr_err_pid" + pid2 + ".log";
        List<File> candidates = List.of(new File(SystemProperties.getUserHome(), logFileName), new File(logFileName));
        return (File)ContainerUtil.find(candidates, file2 -> file2.isFile() && file2.lastModified() > lastModified);
    }

    @NotNull
    private static IdePerformanceListener getPublisher() {
        IdePerformanceListener idePerformanceListener = (IdePerformanceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(IdePerformanceListener.TOPIC);
        if (idePerformanceListener == null) {
            PerformanceWatcher.$$$reportNull$$$0(1);
        }
        return idePerformanceListener;
    }

    private static int getMaxAttempts() {
        return RegistryManager.getInstance().intValue("performance.watcher.unresponsive.max.attempts.before.log");
    }

    public void processUnfinishedFreeze(@NotNull BiConsumer<? super File, ? super Integer> consumer2) {
        File[] files2;
        if (consumer2 == null) {
            PerformanceWatcher.$$$reportNull$$$0(2);
        }
        if ((files2 = this.myLogDir.listFiles()) != null) {
            Arrays.stream(files2).filter(file2 -> file2.getName().startsWith(THREAD_DUMPS_PREFIX)).filter(file2 -> Files.exists(file2.toPath().resolve(DURATION_FILE_NAME), new LinkOption[0])).findFirst().ifPresent(f -> {
                File marker = new File((File)f, DURATION_FILE_NAME);
                try {
                    String s = FileUtil.loadFile((File)marker);
                    PerformanceWatcher.cleanup(f);
                    consumer2.accept((File)f, (Integer)Integer.parseInt(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private static void cleanOldFiles(File dir, int level) {
        Object[] children2 = dir.listFiles((dir1, name) -> level > 0 || name.startsWith(THREAD_DUMPS_PREFIX));
        if (children2 == null) {
            return;
        }
        Arrays.sort(children2);
        for (int i2 = 0; i2 < children2.length; ++i2) {
            Object child2 = children2[i2];
            if (i2 < children2.length - 100 || PerformanceWatcher.ageInDays((File)child2) > 10L) {
                FileUtil.delete((File)child2);
                continue;
            }
            if (level >= 3) continue;
            PerformanceWatcher.cleanOldFiles((File)child2, level + 1);
        }
    }

    private static long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
        this.myExecutor.shutdownNow();
    }

    private static boolean shouldWatch() {
        Application application = ApplicationManager.getApplication();
        return application != null && !application.isHeadlessEnvironment() && PerformanceWatcher.getUnresponsiveInterval() != 0 && PerformanceWatcher.getMaxAttempts() != 0;
    }

    private void samplePerformance() {
        long current2 = System.nanoTime();
        this.myLastSampling = current2;
        for (long diffMs = TimeUnit.NANOSECONDS.toMillis(current2 - this.myLastSampling) - (long)PerformanceWatcher.getSamplingInterval(); diffMs >= 0L; diffMs -= (long)PerformanceWatcher.getSamplingInterval()) {
            this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diffMs);
        }
        this.myJitWatcher.checkJitState();
        SwingUtilities.invokeLater(() -> {
            long latencyMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - current2);
            this.mySwingApdex = this.mySwingApdex.withEvent(100L, latencyMs);
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            PerformanceWatcher.getPublisher().uiResponded(latencyMs);
        });
    }

    @NotNull
    public static String printStacktrace(@NotNull String headerMsg, @NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (headerMsg == null) {
            PerformanceWatcher.$$$reportNull$$$0(3);
        }
        if (thread == null) {
            PerformanceWatcher.$$$reportNull$$$0(4);
        }
        if (stackTrace == null) {
            PerformanceWatcher.$$$reportNull$$$0(5);
        }
        StringBuilder trace = new StringBuilder(headerMsg + thread + " (" + (thread.isAlive() ? "alive" : "dead") + ") " + thread.getState() + "\n--- its stacktrace:\n");
        for (StackTraceElement stackTraceElement : stackTrace) {
            trace.append(" at ").append(stackTraceElement).append("\n");
        }
        trace.append("---\n");
        String string = trace.toString();
        if (string == null) {
            PerformanceWatcher.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static int getSamplingInterval() {
        return RegistryManager.getInstance().intValue("performance.watcher.sampling.interval.ms");
    }

    static int getDumpInterval() {
        return PerformanceWatcher.getSamplingInterval() * PerformanceWatcher.getMaxAttempts();
    }

    static int getUnresponsiveInterval() {
        return RegistryManager.getInstance().intValue("performance.watcher.unresponsive.interval.ms");
    }

    static int getMaxDumpDuration() {
        return RegistryManager.getInstance().intValue("performance.watcher.dump.duration.s") * 1000;
    }

    private static String buildName() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    private static String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static void cleanup(File dir) {
        FileUtil.delete((File)new File(dir, DURATION_FILE_NAME));
    }

    public void edtEventStarted() {
        long start2 = System.nanoTime();
        ++this.myActiveEvents;
        if (SHOULD_WATCH) {
            this.finishTracking();
            this.startTracking(start2);
        }
    }

    public void edtEventFinished() {
        --this.myActiveEvents;
        this.finishTracking();
        if (SHOULD_WATCH && this.myActiveEvents > 0) {
            this.startTracking(System.nanoTime());
        }
    }

    private void startTracking(long start2) {
        int delay = PerformanceWatcher.getUnresponsiveInterval();
        if (delay > 0) {
            this.myCurrentEDTEventChecker = new FreezeCheckerTask(start2, delay);
        }
    }

    private void finishTracking() {
        FreezeCheckerTask currentChecker = this.myCurrentEDTEventChecker;
        if (currentChecker != null) {
            currentChecker.stop();
            this.myCurrentEDTEventChecker = null;
        }
    }

    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            PerformanceWatcher.$$$reportNull$$$0(7);
        }
        return this.dumpThreads(pathPrefix, millis, ThreadDumper.getThreadInfos(), null);
    }

    @Nullable
    private File dumpThreads(@NotNull String pathPrefix, boolean millis, ThreadInfo[] threadInfos, @Nullable FreezeCheckerTask task2) {
        if (pathPrefix == null) {
            PerformanceWatcher.$$$reportNull$$$0(8);
        }
        if (!PerformanceWatcher.shouldWatch()) {
            return null;
        }
        if (!((String)pathPrefix).contains("/")) {
            pathPrefix = THREAD_DUMPS_PREFIX + (String)pathPrefix + "-" + PerformanceWatcher.formatTime(ourIdeStart) + "-" + PerformanceWatcher.buildName() + "/";
        } else if (!((String)pathPrefix).startsWith(THREAD_DUMPS_PREFIX)) {
            pathPrefix = THREAD_DUMPS_PREFIX + (String)pathPrefix;
        }
        long now = System.currentTimeMillis();
        Object suffix = millis ? "-" + now : "";
        File file2 = new File(this.myLogDir, (String)pathPrefix + DUMP_PREFIX + PerformanceWatcher.formatTime(now) + (String)suffix + ".txt");
        File dir = file2.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        this.checkMemoryUsage(file2);
        ThreadDump threadDump = ThreadDumper.getThreadDumpInfo((ThreadInfo[])threadInfos);
        try {
            FileUtil.writeToFile((File)file2, (String)threadDump.getRawDump());
            if (task2 != null) {
                FileUtil.writeToFile((File)new File(dir, DURATION_FILE_NAME), (String)String.valueOf(TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - task2.myFreezeStart)));
                PerformanceWatcher.getPublisher().dumpedThreads(file2, threadDump);
            }
        }
        catch (IOException e) {
            LOG.info("failed to write thread dump file: " + e.getMessage());
        }
        return file2;
    }

    private void checkMemoryUsage(File file2) {
        String jitProblem;
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        long freeMemory = maxMemory - usedMemory;
        Object diagnosticInfo = "";
        if (freeMemory < maxMemory / 5L) {
            diagnosticInfo = "High memory usage (free " + freeMemory / 1024L / 1024L + " of " + maxMemory / 1024L / 1024L + " MB)";
        }
        if ((jitProblem = this.getJitProblem()) != null) {
            if (!((String)diagnosticInfo).isEmpty()) {
                diagnosticInfo = (String)diagnosticInfo + ", ";
            }
            diagnosticInfo = (String)diagnosticInfo + jitProblem;
        }
        if (!((String)diagnosticInfo).isEmpty()) {
            LOG.info((String)diagnosticInfo + " while dumping threads to " + file2);
        }
    }

    @Nullable
    String getJitProblem() {
        return this.myJitWatcher.getJitProblem();
    }

    public static void dumpThreadsToConsole(@NonNls String message2) {
        System.err.println(message2);
        System.err.println(ThreadDumper.dumpThreadsToString());
    }

    @NotNull
    static List<StackTraceElement> getStacktraceCommonPart(@NotNull List<StackTraceElement> commonPart, StackTraceElement @NotNull [] stackTraceElements) {
        if (commonPart == null) {
            PerformanceWatcher.$$$reportNull$$$0(9);
        }
        if (stackTraceElements == null) {
            PerformanceWatcher.$$$reportNull$$$0(10);
        }
        for (int i2 = 0; i2 < commonPart.size() && i2 < stackTraceElements.length; ++i2) {
            StackTraceElement el2;
            StackTraceElement el1 = commonPart.get(commonPart.size() - i2 - 1);
            if (PerformanceWatcher.compareStackTraceElements(el1, el2 = stackTraceElements[stackTraceElements.length - i2 - 1])) continue;
            List<StackTraceElement> list2 = commonPart.subList(commonPart.size() - i2, commonPart.size());
            if (list2 == null) {
                PerformanceWatcher.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<StackTraceElement> list3 = commonPart;
        if (list3 == null) {
            PerformanceWatcher.$$$reportNull$$$0(12);
        }
        return list3;
    }

    static boolean compareStackTraceElements(StackTraceElement el1, StackTraceElement el2) {
        if (el1 == el2) {
            return true;
        }
        return el1.getClassName().equals(el2.getClassName()) && Objects.equals(el1.getMethodName(), el2.getMethodName()) && Objects.equals(el1.getFileName(), el2.getFileName());
    }

    public void clearFreezeStacktraces() {
        if (this.myCurrentEDTEventChecker != null) {
            this.myCurrentEDTEventChecker.stopDumping();
        }
    }

    @NotNull
    public static Snapshot takeSnapshot() {
        return PerformanceWatcher.getInstance().new Snapshot();
    }

    ScheduledExecutorService getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerMsg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonPart";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "printStacktrace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStacktraceCommonPart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processUnfinishedFreeze";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printStacktrace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreads";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStacktraceCommonPart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FreezeCheckerTask {
        private final AtomicReference<CheckerState> myState = new AtomicReference<CheckerState>(CheckerState.CHECKING);
        private final Future<?> myFuture;
        private final long myFreezeStart;
        private String myFreezeFolder;
        private volatile SamplingTask myDumpTask;

        FreezeCheckerTask(long start2, int delay) {
            this.myFuture = !PerformanceWatcher.this.myExecutor.isShutdown() ? PerformanceWatcher.this.myExecutor.schedule(this::edtFrozen, (long)delay, TimeUnit.MILLISECONDS) : null;
            this.myFreezeStart = start2;
        }

        void stop() {
            if (this.myFuture == null) {
                return;
            }
            this.myFuture.cancel(false);
            if (this.myState.getAndSet(CheckerState.FINISHED) == CheckerState.FREEZE) {
                long end = System.nanoTime();
                this.stopDumping();
                try {
                    PerformanceWatcher.this.myExecutor.submit(() -> this.edtResponds(end)).get();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }

        private void edtFrozen() {
            this.myFreezeFolder = "threadDumps-freeze-" + PerformanceWatcher.formatTime(System.currentTimeMillis()) + "-" + PerformanceWatcher.buildName();
            if (this.myState.compareAndSet(CheckerState.CHECKING, CheckerState.FREEZE)) {
                PerformanceWatcher.getPublisher().uiFreezeStarted();
                this.myDumpTask = new SamplingTask(PerformanceWatcher.getDumpInterval(), PerformanceWatcher.getMaxDumpDuration()){

                    @Override
                    protected void dumpedThreads(ThreadInfo[] infos) {
                        if (FreezeCheckerTask.this.myState.get() == CheckerState.FINISHED) {
                            this.stop();
                        } else {
                            PerformanceWatcher.this.dumpThreads(FreezeCheckerTask.this.myFreezeFolder + "/", false, infos, FreezeCheckerTask.this);
                        }
                    }
                };
            }
        }

        private void edtResponds(long current2) {
            this.stopDumping();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(current2 - this.myFreezeStart);
            File dir = new File(PerformanceWatcher.this.myLogDir, this.myFreezeFolder);
            File reportDir = null;
            if (dir.exists()) {
                PerformanceWatcher.cleanup(dir);
                reportDir = new File(PerformanceWatcher.this.myLogDir, dir.getName() + this.getFreezePlaceSuffix() + "-" + TimeUnit.MILLISECONDS.toSeconds(durationMs) + "sec");
                if (!dir.renameTo(reportDir)) {
                    LOG.warn("Unable to create freeze folder " + reportDir);
                    reportDir = dir;
                }
                String message2 = "UI was frozen for " + durationMs + "ms, details saved to " + reportDir;
                if (PluginManagerCore.isRunningFromSources()) {
                    LOG.info(message2);
                } else {
                    LOG.warn(message2);
                }
            }
            PerformanceWatcher.getPublisher().uiFreezeFinished(durationMs, reportDir);
        }

        void stopDumping() {
            SamplingTask task2 = this.myDumpTask;
            if (task2 != null) {
                task2.stop();
                this.myDumpTask = null;
            }
        }

        private String getFreezePlaceSuffix() {
            List<StackTraceElement> stacktraceCommonPart = null;
            SamplingTask task2 = this.myDumpTask;
            if (task2 == null) {
                return "";
            }
            for (Object[] objectArray : task2.getThreadInfos()) {
                Object[] edtStack;
                ThreadInfo edt = (ThreadInfo)ContainerUtil.find((Object[])objectArray, ThreadDumper::isEDT);
                if (edt == null || (edtStack = edt.getStackTrace()) == null) continue;
                if (stacktraceCommonPart == null) {
                    stacktraceCommonPart = ContainerUtil.newArrayList((Object[])edtStack);
                    continue;
                }
                stacktraceCommonPart = PerformanceWatcher.getStacktraceCommonPart(stacktraceCommonPart, (StackTraceElement[])edtStack);
            }
            if (!ContainerUtil.isEmpty(stacktraceCommonPart)) {
                StackTraceElement element2 = (StackTraceElement)stacktraceCommonPart.get(0);
                return "-" + FileUtil.sanitizeFileName((String)StringUtil.getShortName((String)element2.getClassName())) + "." + FileUtil.sanitizeFileName((String)element2.getMethodName());
            }
            return "";
        }
    }

    private static enum CheckerState {
        CHECKING,
        FREEZE,
        FINISHED;

    }

    public final class Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private Snapshot() {
            this.myStartGeneralSnapshot = PerformanceWatcher.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcher.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NonNls @NotNull String activityName) {
            if (activityName == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            LOG.info(this.getLogResponsivenessSinceCreationMessage(activityName));
        }

        @NotNull
        public String getLogResponsivenessSinceCreationMessage(@NonNls @NotNull String activityName) {
            if (activityName == null) {
                Snapshot.$$$reportNull$$$0(1);
            }
            String string = activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms; general responsiveness: " + PerformanceWatcher.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcher.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot);
            if (string == null) {
                Snapshot.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcher$Snapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcher$Snapshot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogResponsivenessSinceCreationMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "logResponsivenessSinceCreation";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLogResponsivenessSinceCreationMessage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

