/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Freeze;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeaFreezeReporter
implements IdePerformanceListener {
    private static final int FREEZE_THRESHOLD = ApplicationManager.getApplication().isInternal() ? 15 : 25;
    private static final String REPORT_PREFIX = "report";
    private static final String DUMP_PREFIX = "dump";
    private static final String MESSAGE_FILE_NAME = ".message";
    private static final String THROWABLE_FILE_NAME = ".throwable";
    public static final String APPINFO_FILE_NAME = ".appinfo";
    private static final double COMMON_SUB_STACK_WEIGHT = 0.25;
    private static boolean DEBUG = false;
    private SamplingTask myDumpTask;
    private final List<ThreadDump> myCurrentDumps = new ArrayList<ThreadDump>();
    private List<StackTraceElement> myStacktraceCommonPart = null;
    private volatile boolean myAppClosing;

    IdeaFreezeReporter() {
        Application app = ApplicationManager.getApplication();
        if (!DEBUG && PluginManagerCore.isRunningFromSources() || !app.isEAP() && !app.isInternal()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            app.getMessageBus().simpleConnect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                @Override
                public void appWillBeClosed(boolean isRestart) {
                    IdeaFreezeReporter.this.myAppClosing = true;
                }
            });
            PerformanceWatcher.getInstance().processUnfinishedFreeze((dir, duration) -> {
                block21: {
                    try {
                        File[] files2 = dir.listFiles();
                        if (files2 == null) break block21;
                        if (duration > FREEZE_THRESHOLD) {
                            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                            String message2 = null;
                            String appInfo = null;
                            Throwable throwable = null;
                            ArrayList<String> dumps = new ArrayList<String>();
                            for (File file2 : files2) {
                                String text2 = FileUtil.loadFile((File)file2);
                                String name = file2.getName();
                                if (MESSAGE_FILE_NAME.equals(name)) {
                                    message2 = text2;
                                    continue;
                                }
                                if (THROWABLE_FILE_NAME.equals(name)) {
                                    try (FileInputStream fis = new FileInputStream(file2);
                                         ObjectInputStream ois = new ObjectInputStream(fis);){
                                        throwable = (Throwable)ois.readObject();
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                                if (APPINFO_FILE_NAME.equals(name)) {
                                    appInfo = text2;
                                    continue;
                                }
                                if (name.startsWith(REPORT_PREFIX)) {
                                    attachments.add(IdeaFreezeReporter.createReportAttachment(duration, text2));
                                    continue;
                                }
                                if (!name.startsWith("threadDump-")) continue;
                                dumps.add(text2);
                            }
                            IdeaFreezeReporter.addDumpsAttachments(dumps, Function.identity(), attachments);
                            if (message2 != null && throwable != null && !attachments.isEmpty()) {
                                IdeaLoggingEvent event = LogMessage.createEvent(throwable, message2, attachments.toArray(Attachment.EMPTY_ARRAY));
                                IdeaFreezeReporter.setAppInfo(event, appInfo);
                                IdeaFreezeReporter.report(event);
                            }
                        }
                        IdeaFreezeReporter.cleanup(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        });
    }

    static void setAppInfo(IdeaLoggingEvent event, String appInfo) {
        Object data2 = event.getData();
        if (data2 instanceof AbstractMessage) {
            ((AbstractMessage)data2).setAppInfo(appInfo);
        }
    }

    private static Attachment createReportAttachment(int lengthInSeconds, String text2) {
        Attachment res2 = new Attachment("report-" + lengthInSeconds + "s.txt", text2);
        res2.setIncluded(true);
        return res2;
    }

    private static <T> void addDumpsAttachments(List<T> from2, Function<? super T, String> textMapper, List<? super Attachment> container) {
        int size = Math.min(from2.size(), 20);
        int step = from2.size() / size;
        for (int i2 = 0; i2 < size; ++i2) {
            Attachment attachment = new Attachment("dump-" + i2 + ".txt", textMapper.apply(from2.get(i2 * step)));
            attachment.setIncluded(true);
            container.add((Attachment)attachment);
        }
    }

    private static void cleanup(@Nullable File dir) {
        if (dir != null) {
            FileUtil.delete((File)new File(dir, MESSAGE_FILE_NAME));
            FileUtil.delete((File)new File(dir, THROWABLE_FILE_NAME));
            FileUtil.delete((File)new File(dir, APPINFO_FILE_NAME));
        }
    }

    public void uiFreezeStarted() {
        if (DEBUG || !DebugAttachDetector.isAttached()) {
            if (this.myDumpTask != null) {
                this.myDumpTask.stop();
            }
            this.reset();
            this.myDumpTask = new SamplingTask(Registry.intValue((String)"freeze.reporter.dump.interval.ms"), Registry.intValue((String)"freeze.reporter.dump.duration.s") * 1000);
        }
    }

    public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
        if (toFile == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(0);
        }
        if (dump == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(1);
        }
        if (this.myDumpTask != null) {
            this.myCurrentDumps.add(dump);
            Object[] edtStack = dump.getEDTStackTrace();
            if (edtStack != null) {
                this.myStacktraceCommonPart = this.myStacktraceCommonPart == null ? ContainerUtil.newArrayList((Object[])edtStack) : PerformanceWatcher.getStacktraceCommonPart(this.myStacktraceCommonPart, (StackTraceElement[])edtStack);
            }
            File dir = toFile.getParentFile();
            IdeaLoggingEvent event = this.createEvent((int)((this.myDumpTask.getTotalTime() + (long)PerformanceWatcher.getUnresponsiveInterval()) / 1000L), Collections.emptyList(), this.myDumpTask, dir, false);
            if (event != null) {
                try {
                    FileUtil.writeToFile((File)new File(dir, MESSAGE_FILE_NAME), (String)event.getMessage());
                    try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(dir, THROWABLE_FILE_NAME)));){
                        oos.writeObject(event.getThrowable());
                    }
                    IdeaFreezeReporter.saveAppInfo(dir, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static void saveAppInfo(File dir, boolean overwrite) throws IOException {
        File appInfoFile = new File(dir, APPINFO_FILE_NAME);
        if (overwrite || !appInfoFile.exists()) {
            FileUtil.writeToFile((File)appInfoFile, (String)ITNProxy.getAppInfoString());
        }
    }

    public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
        if (this.myDumpTask == null) {
            return;
        }
        this.myDumpTask.stop();
        IdeaFreezeReporter.cleanup(reportDir);
        if (Registry.is((String)"freeze.reporter.enabled")) {
            int lengthInSeconds = (int)(durationMs / 1000L);
            long dumpingDuration = durationMs - (long)PerformanceWatcher.getUnresponsiveInterval();
            if (lengthInSeconds > FREEZE_THRESHOLD && (this.myDumpTask.isValid(dumpingDuration) || (long)this.myCurrentDumps.size() >= Math.max(3L, Math.min((long)PerformanceWatcher.getMaxDumpDuration(), dumpingDuration / 2L) / (long)PerformanceWatcher.getDumpInterval())) && !ContainerUtil.isEmpty(this.myStacktraceCommonPart)) {
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                IdeaFreezeReporter.addDumpsAttachments(this.myCurrentDumps, ThreadDump::getRawDump, attachments);
                IdeaFreezeReporter.report(this.createEvent(lengthInSeconds, attachments, this.myDumpTask, reportDir, true));
            }
        }
        this.myDumpTask = null;
        this.reset();
    }

    static void report(IdeaLoggingEvent event) {
        Throwable t;
        if (event != null && IdeErrorsDialog.getSubmitter(t = event.getThrowable(), PluginUtil.getInstance().findPluginId(t)) instanceof ITNReporter) {
            MessagePool.getInstance().addIdeFatalMessage(event);
        }
    }

    private void reset() {
        this.myCurrentDumps.clear();
        this.myStacktraceCommonPart = null;
    }

    private static ThreadInfo getCauseThread(ThreadInfo[] threadInfos) {
        ThreadDumper.sort((ThreadInfo[])threadInfos);
        ThreadInfo edt = (ThreadInfo)ContainerUtil.find((Object[])threadInfos, ThreadDumper::isEDT);
        if (edt != null && edt.getThreadState() != Thread.State.RUNNABLE) {
            String lockName;
            long id2 = edt.getLockOwnerId();
            if (id2 != -1L) {
                for (ThreadInfo info : threadInfos) {
                    if (info.getThreadId() != id2) continue;
                    return info;
                }
            }
            if ((lockName = edt.getLockName()) != null && lockName.contains("ReadMostlyRWLock")) {
                ThreadInfo readLockNotRunnable = null;
                for (ThreadInfo info : threadInfos) {
                    if (!IdeaFreezeReporter.isWithReadLock(info)) continue;
                    if (info.getThreadState() == Thread.State.RUNNABLE) {
                        return info;
                    }
                    if (readLockNotRunnable != null) continue;
                    readLockNotRunnable = info;
                }
                if (readLockNotRunnable != null) {
                    return readLockNotRunnable;
                }
            }
        }
        return edt;
    }

    private static boolean isWithReadLock(ThreadInfo thread) {
        boolean read = false;
        for (StackTraceElement s : thread.getStackTrace()) {
            String methodName = s.getMethodName();
            if ("runReadAction".equals(methodName) || "tryRunReadAction".equals(methodName) || "insideReadAction".equals(methodName)) {
                read = true;
            }
            if (!"waitABit".equals(methodName)) continue;
            return false;
        }
        return read;
    }

    @Nullable
    private IdeaLoggingEvent createEvent(int lengthInSeconds, List<Attachment> attachments, @NotNull SamplingTask dumpTask, @Nullable File reportDir, boolean finished2) {
        if (dumpTask == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(2);
        }
        List infos = dumpTask.getThreadInfos();
        long dumpInterval = dumpTask.getDumpInterval();
        long sampledTime = dumpTask.getSampledTime();
        if (infos.isEmpty()) {
            infos = ContainerUtil.map(this.myCurrentDumps, ThreadDump::getThreadInfos);
            dumpInterval = PerformanceWatcher.getDumpInterval();
            sampledTime = (long)infos.size() * dumpInterval;
        }
        List causeThreads = ContainerUtil.mapNotNull(infos, IdeaFreezeReporter::getCauseThread);
        boolean allInEdt = causeThreads.stream().allMatch(ThreadDumper::isEDT);
        CallTreeNode root = CallTreeNode.buildTree(causeThreads, dumpInterval);
        int classLoadingRatio = IdeaFreezeReporter.countClassLoading(causeThreads) * 100 / causeThreads.size();
        CallTreeNode commonStackNode = root.findDominantCommonStack((long)((double)((long)causeThreads.size() * dumpInterval) * 0.25));
        List<StackTraceElement> commonStack = commonStackNode != null ? commonStackNode.getStack() : null;
        boolean nonEdtCause = false;
        if (ContainerUtil.isEmpty(commonStack)) {
            commonStack = this.myStacktraceCommonPart;
        } else {
            nonEdtCause = !ThreadDumper.isEDT((ThreadInfo)commonStackNode.myThreadInfo);
        }
        String reportText = root.dump();
        try {
            if (reportDir != null) {
                FileUtil.writeToFile((File)new File(reportDir, "report.txt"), (String)reportText);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!ContainerUtil.isEmpty(commonStack)) {
            double averageLoad;
            String edtNote;
            if (commonStack.stream().anyMatch(IdeaFreezeReporter::skippedFrame)) {
                return null;
            }
            String string = edtNote = allInEdt ? "in EDT " : "";
            String message2 = "Freeze " + edtNote + "for " + lengthInSeconds + " seconds\n" + (finished2 ? "" : (this.myAppClosing ? "IDE is closing. " : "IDE KILLED! ")) + "Sampled time: " + sampledTime + "ms, sampling rate: " + dumpInterval + "ms";
            String jitProblem = PerformanceWatcher.getInstance().getJitProblem();
            if (jitProblem != null) {
                message2 = message2 + ", " + jitProblem;
            }
            long total = dumpTask.getTotalTime();
            long gcTime = dumpTask.getGcTime();
            if (total > 0L) {
                message2 = message2 + ", GC time: " + gcTime + "ms (" + gcTime * 100L / total + "%), Class loading: " + classLoadingRatio + "%";
            }
            if (DebugAttachDetector.isDebugEnabled()) {
                message2 = message2 + ", debug agent: on";
            }
            if ((averageLoad = dumpTask.getOsAverageLoad()) > 0.0) {
                message2 = message2 + ", load average: " + String.format("%.2f", averageLoad);
            }
            if (nonEdtCause) {
                message2 = message2 + "\n\nThe stack is from the thread that was blocking EDT";
            }
            Attachment report2 = IdeaFreezeReporter.createReportAttachment(lengthInSeconds, reportText);
            return LogMessage.createEvent(new Freeze(commonStack), message2, ContainerUtil.append(attachments, (Object[])new Attachment[]{report2}).toArray(Attachment.EMPTY_ARRAY));
        }
        return null;
    }

    private static boolean skippedFrame(StackTraceElement e) {
        return ApplicationImpl.class.getName().equals(e.getClassName()) && "runEdtProgressWriteAction".equals(e.getMethodName());
    }

    private static int countClassLoading(List<? extends ThreadInfo> causeThreads) {
        return (int)causeThreads.stream().filter(t -> Arrays.stream(t.getStackTrace()).anyMatch(IdeaFreezeReporter::isClassLoading)).count();
    }

    private static boolean isClassLoading(StackTraceElement stackTraceElement) {
        return "loadClass".equals(stackTraceElement.getMethodName()) && "java.lang.ClassLoader".equals(stackTraceElement.getClassName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = DUMP_PREFIX;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpTask";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/IdeaFreezeReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpedThreads";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CallTreeNode {
        private final StackTraceElement myStackTraceElement;
        private final CallTreeNode myParent;
        private final List<CallTreeNode> myChildren = new SmartList();
        private final int myDepth;
        private long myTime;
        private final ThreadInfo myThreadInfo;
        static final Comparator<CallTreeNode> TIME_COMPARATOR = Comparator.comparingLong(n -> n.myTime).reversed();

        private CallTreeNode(StackTraceElement element2, CallTreeNode parent, long time, ThreadInfo info) {
            this.myStackTraceElement = element2;
            this.myParent = parent;
            this.myDepth = parent != null ? parent.myDepth + 1 : 0;
            this.myTime = time;
            this.myThreadInfo = info;
        }

        @NotNull
        public static CallTreeNode buildTree(List<? extends ThreadInfo> threadInfos, long time) {
            CallTreeNode root = new CallTreeNode(null, null, 0L, null);
            for (ThreadInfo threadInfo : threadInfos) {
                CallTreeNode node = root;
                StackTraceElement[] stack = threadInfo.getStackTrace();
                for (int i2 = stack.length - 1; i2 >= 0; --i2) {
                    node = node.addCallee(stack[i2], time, threadInfo);
                }
            }
            CallTreeNode callTreeNode = root;
            if (callTreeNode == null) {
                CallTreeNode.$$$reportNull$$$0(0);
            }
            return callTreeNode;
        }

        CallTreeNode addCallee(StackTraceElement e, long time, ThreadInfo threadInfo) {
            for (CallTreeNode child2 : this.myChildren) {
                if (!PerformanceWatcher.compareStackTraceElements(child2.myStackTraceElement, e)) continue;
                child2.myTime += time;
                return child2;
            }
            CallTreeNode child3 = new CallTreeNode(e, this, time, threadInfo);
            this.myChildren.add(child3);
            return child3;
        }

        @Nullable
        CallTreeNode getMostHitChild() {
            CallTreeNode currentMax = null;
            for (CallTreeNode child2 : this.myChildren) {
                if (currentMax != null && child2.myTime <= currentMax.myTime) continue;
                currentMax = child2;
            }
            return currentMax;
        }

        public String toString() {
            return this.myTime + " " + this.myStackTraceElement;
        }

        public void appendIndentedString(StringBuilder builder2) {
            StringUtil.repeatSymbol((Appendable)builder2, (char)' ', (int)this.myDepth);
            builder2.append(this.myStackTraceElement.getClassName()).append(".").append(this.myStackTraceElement.getMethodName()).append(" ").append(this.myTime).append("ms").append("\n");
        }

        String dump() {
            StringBuilder sb = new StringBuilder();
            LinkedList<CallTreeNode> nodes = new LinkedList<CallTreeNode>(this.myChildren);
            while (!nodes.isEmpty()) {
                CallTreeNode node = nodes.removeFirst();
                node.appendIndentedString(sb);
                nodes.addAll(0, ContainerUtil.sorted(node.myChildren, TIME_COMPARATOR));
            }
            return sb.toString();
        }

        private List<StackTraceElement> getStack() {
            ArrayList<StackTraceElement> res2 = new ArrayList<StackTraceElement>();
            CallTreeNode node = this;
            while (node != null && node.myStackTraceElement != null) {
                res2.add(node.myStackTraceElement);
                node = node.myParent;
            }
            return res2;
        }

        @Nullable
        private CallTreeNode findDominantCommonStack(long threshold) {
            CallTreeNode mostHitChild;
            CallTreeNode node = this.getMostHitChild();
            if (node == null) {
                return null;
            }
            while (!node.myChildren.isEmpty() && (mostHitChild = node.getMostHitChild()) != null && mostHitChild.myTime > threshold) {
                node = mostHitChild;
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeaFreezeReporter$CallTreeNode", "buildTree"));
        }
    }
}

