/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

final class IdeHeartbeatEventReporter
implements Disposable {
    private static final int UI_RESPONSE_LOGGING_INTERVAL_MS = 100000;
    private static final int TOLERABLE_UI_LATENCY = 100;
    @Nullable
    private final ScheduledExecutorService myExecutor;
    @Nullable
    private final ScheduledFuture<?> myThread;
    private volatile long myPreviousLoggedUIResponse = 0L;

    IdeHeartbeatEventReporter() {
        final boolean isDebugEnabled = DebugAttachDetector.isDebugEnabled();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(){

            public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
                if (!isDebugEnabled) {
                    LifecycleUsageTriggerCollector.onFreeze(durationMs);
                }
            }

            public void uiResponded(long latencyMs) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - IdeHeartbeatEventReporter.this.myPreviousLoggedUIResponse >= 100000L) {
                    IdeHeartbeatEventReporter.this.myPreviousLoggedUIResponse = currentTime;
                    UILatencyLogger.LATENCY.log((Object)latencyMs);
                }
                if (latencyMs >= 100L && !isDebugEnabled) {
                    UILatencyLogger.LAGGING.log((Object)latencyMs);
                }
            }
        });
        boolean isEap = ApplicationManager.getApplication().isEAP();
        if (isEap) {
            this.myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"IDE Heartbeat", (int)1);
            this.myThread = this.myExecutor.scheduleWithFixedDelay(IdeHeartbeatEventReporter::recordHeartbeat, 0L, 100000L, TimeUnit.MILLISECONDS);
        } else {
            this.myExecutor = null;
            this.myThread = null;
        }
    }

    private static void recordHeartbeat() {
        OperatingSystemMXBean mxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        int systemCpuLoad2 = (int)Math.round(mxBean.getSystemCpuLoad() * 100.0);
        systemCpuLoad2 = systemCpuLoad2 >= 0 ? systemCpuLoad2 : -1;
        double swapSize = mxBean.getTotalSwapSpaceSize();
        int swapLoad = swapSize > 0.0 ? (int)((1.0 - (double)mxBean.getFreeSwapSpaceSize() / swapSize) * 100.0) : 0;
        UILatencyLogger.HEARTBEAT.log((Object)systemCpuLoad2, (Object)swapLoad);
    }

    public void dispose() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
        if (this.myExecutor != null) {
            this.myExecutor.shutdownNow();
        }
    }

    public static final class UILatencyLogger
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("performance", 60);
        private static final EventId2<Integer, Integer> HEARTBEAT = GROUP.registerEvent("heartbeat", (EventField)EventFields.Int((String)"system_cpu_load"), (EventField)EventFields.Int((String)"swap_load"));
        private static final EventId1<Long> LATENCY = GROUP.registerEvent("ui.latency", (EventField)EventFields.DurationMs);
        private static final EventId1<Long> LAGGING = GROUP.registerEvent("ui.lagging", (EventField)EventFields.DurationMs);

        public EventLogGroup getGroup() {
            return GROUP;
        }
    }
}

