/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.ExtensionPoints;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Developer;
import com.intellij.diagnostic.DeveloperList;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.Freeze;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.diagnostic.JBRCrash;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.diagnostic.PrivacyNoticeComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.CRC32;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeErrorsDialog
extends DialogWrapper
implements MessagePoolListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance(IdeErrorsDialog.class);
    public static final DataKey<String> CURRENT_TRACE_KEY = DataKey.create("current_stack_trace_key");
    private static final String STACKTRACE_ATTACHMENT = "stacktrace.txt";
    private static final String ACCEPTED_NOTICES_KEY = "exception.accepted.notices";
    private static final String ACCEPTED_NOTICES_SEPARATOR = ":";
    private static final String DISABLE_PLUGIN_URL = "#disable";
    private static final String EA_PLUGIN_ID = "com.intellij.sisyphus";
    private final MessagePool myMessagePool;
    private final Project myProject;
    private final boolean myAssigneeVisible;
    private final Set<String> myAcceptedNotices;
    private final List<MessageCluster> myMessageClusters;
    private int myIndex;
    private int myLastIndex;
    private Long myDevelopersTimestamp;
    private JLabel myCountLabel;
    private JTextComponent myInfoLabel;
    private JLabel myDetailsLabel;
    private JTextComponent myForeignPluginWarningLabel;
    private JBTextArea myCommentArea;
    private AttachmentsList myAttachmentsList;
    private JTextArea myAttachmentArea;
    private JPanel myAssigneePanel;
    private PrivacyNoticeComponent myPrivacyNotice;
    private ComboBox<Developer> myAssigneeCombo;
    private JTextComponent myCredentialsLabel;

    IdeErrorsDialog(@NotNull MessagePool messagePool, @Nullable Project project, @Nullable LogMessage defaultMessage) {
        if (messagePool == null) {
            IdeErrorsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myMessageClusters = new ArrayList<MessageCluster>();
        this.myLastIndex = -1;
        this.myMessagePool = messagePool;
        this.myProject = project;
        this.myAssigneeVisible = (ApplicationManager.getApplication().isInternal() || PluginManagerCore.isPluginInstalled(PluginId.getId((String)EA_PLUGIN_ID))) && Registry.is((String)"ea.enable.developers.list", (boolean)true);
        this.setTitle(DiagnosticBundle.message("error.list.title", new Object[0]));
        this.setModal(false);
        this.getOKAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        if (this.myAssigneeVisible) {
            this.loadDevelopersList();
        }
        String rawValue = PropertiesComponent.getInstance().getValue(ACCEPTED_NOTICES_KEY, "");
        this.myAcceptedNotices = new LinkedHashSet<String>(StringUtil.split((String)rawValue, (String)ACCEPTED_NOTICES_SEPARATOR));
        this.updateMessages();
        this.myIndex = this.selectMessage(defaultMessage);
        this.updateControls();
        messagePool.addListener(this);
    }

    private void loadDevelopersList() {
        final ErrorReportConfigurable configurable2 = ErrorReportConfigurable.getInstance();
        final DeveloperList developers = configurable2.getDeveloperList();
        if (developers.isUpToDateAt()) {
            this.setDevelopers(developers);
        } else {
            new Task.Backgroundable(null, DiagnosticBundle.message("progress.title.loading.developers.list", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        DeveloperList updatedDevelopers = new DeveloperList(ITNProxy.fetchDevelopers(indicator));
                        UIUtil.invokeLaterIfNeeded(() -> {
                            configurable2.setDeveloperList(updatedDevelopers);
                            if (IdeErrorsDialog.this.isShowing()) {
                                IdeErrorsDialog.this.setDevelopers(updatedDevelopers);
                            }
                        });
                    }
                    catch (UnknownHostException e) {
                        LOG.debug((Throwable)e);
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (IdeErrorsDialog.this.isShowing()) {
                                IdeErrorsDialog.this.setDevelopers(developers);
                            }
                        });
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/IdeErrorsDialog$1", "run"));
                }
            }.queue();
        }
    }

    private void setDevelopers(@Nullable DeveloperList developers) {
        if (developers != null) {
            this.myAssigneeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(developers.getDevelopers()));
            this.myDevelopersTimestamp = developers.getTimestamp();
        }
    }

    private int selectMessage(@Nullable LogMessage defaultMessage) {
        if (defaultMessage != null) {
            for (int i2 = 0; i2 < this.myMessageClusters.size(); ++i2) {
                if (!this.myMessageClusters.get((int)i2).messages.contains(defaultMessage)) continue;
                return i2;
            }
        } else {
            int i3;
            for (i3 = 0; i3 < this.myMessageClusters.size(); ++i3) {
                if (this.myMessageClusters.get((int)i3).messages.get(0).isRead()) continue;
                return i3;
            }
            for (i3 = 0; i3 < this.myMessageClusters.size(); ++i3) {
                for (AbstractMessage message2 : this.myMessageClusters.get((int)i3).messages) {
                    if (message2.isRead()) continue;
                    return i3;
                }
            }
            for (i3 = 0; i3 < this.myMessageClusters.size(); ++i3) {
                if (this.myMessageClusters.get((int)i3).messages.get(0).isSubmitted()) continue;
                return i3;
            }
        }
        return 0;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        this.myCountLabel = new JBLabel();
        this.myInfoLabel = ComponentsKt.htmlComponent("", null, null, null, false, e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && DISABLE_PLUGIN_URL.equals(e.getDescription())) {
                this.disablePlugin();
            } else {
                BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
            }
        });
        this.myDetailsLabel = new JBLabel();
        this.myDetailsLabel.setForeground(UIUtil.getContextHelpForeground());
        this.myForeignPluginWarningLabel = ComponentsKt.htmlComponent();
        JPanel controls = new JPanel(new BorderLayout());
        controls.add((Component)IdeErrorsDialog.actionToolbar("IdeErrorsBack", new BackAction()), "West");
        controls.add((Component)IdeErrorsDialog.actionToolbar("IdeErrorsForward", new ForwardAction()), "East");
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)controls, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)3, (int)0), 0, 0));
        panel2.add((Component)this.myCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)3, (int)10), 0, 0));
        panel2.add((Component)this.myInfoLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)3, (int)0), 0, 0));
        panel2.add((Component)this.myDetailsLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)3, (int)0), 0, 0));
        panel2.add((Component)this.myForeignPluginWarningLabel, new GridBagConstraints(2, 1, 3, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    private static JComponent actionToolbar(@NonNls String id2, AnAction action2) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(id2, (ActionGroup)new DefaultActionGroup(new AnAction[]{action2}), true);
        toolbar.setLayoutPolicy(0);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        ((ActionToolbarImpl)toolbar).setForceMinimumSize(true);
        return toolbar.getComponent();
    }

    protected JComponent createCenterPanel() {
        this.myCommentArea = new JBTextArea(5, 0);
        this.myCommentArea.getEmptyText().setText(DiagnosticBundle.message("error.dialog.comment.prompt", new Object[0]));
        this.myCommentArea.setMargin((Insets)JBUI.insets((int)2));
        this.myCommentArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                IdeErrorsDialog.this.selectedMessage().setAdditionalInfo(IdeErrorsDialog.this.myCommentArea.getText().trim());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/IdeErrorsDialog$2", "textChanged"));
            }
        });
        this.myAttachmentsList = new AttachmentsList();
        this.myAttachmentsList.addListSelectionListener(e -> {
            int index2 = this.myAttachmentsList.getSelectedIndex();
            if (index2 < 0) {
                this.myAttachmentArea.setText("");
                this.myAttachmentArea.setEditable(false);
            } else if (index2 == 0) {
                MessageCluster cluster = this.selectedCluster();
                this.myAttachmentArea.setText(cluster.detailsText);
                this.myAttachmentArea.setEditable(cluster.isUnsent());
            } else {
                this.myAttachmentArea.setText(this.selectedMessage().getAllAttachments().get(index2 - 1).getDisplayText());
                this.myAttachmentArea.setEditable(false);
            }
            this.myAttachmentArea.setCaretPosition(0);
        });
        this.myAttachmentsList.setCheckBoxListListener((index2, value2) -> {
            if (index2 > 0) {
                this.selectedMessage().getAllAttachments().get(index2 - 1).setIncluded(value2);
            }
        });
        this.myAttachmentArea = new JTextArea();
        this.myAttachmentArea.setMargin((Insets)JBUI.insets((int)2));
        this.myAttachmentArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (IdeErrorsDialog.this.myAttachmentsList.getSelectedIndex() == 0) {
                    String detailsText = IdeErrorsDialog.this.myAttachmentArea.getText();
                    MessageCluster cluster = IdeErrorsDialog.this.selectedCluster();
                    cluster.detailsText = detailsText;
                    IdeErrorsDialog.this.setOKActionEnabled(cluster.canSubmit() && !StringUtil.isEmptyOrSpaces((String)detailsText));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/IdeErrorsDialog$3", "textChanged"));
            }
        });
        if (this.myAssigneeVisible) {
            this.myAssigneeCombo = new ComboBox();
            this.myAssigneeCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DiagnosticBundle.message("errors.dialog.assignee.none", new Object[0]), Developer::getDisplayText));
            this.myAssigneeCombo.setPrototypeDisplayValue((Object)new Developer(0, StringUtil.repeatSymbol((char)'-', (int)30)));
            this.myAssigneeCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Developer developer = (Developer)e.getItem();
                    this.selectedMessage().setAssigneeId(developer == null ? null : developer.getId());
                }
            });
            this.myAssigneeCombo.setSwingPopup(false);
            this.myAssigneePanel = new JPanel();
            this.myAssigneePanel.add((Component)new JBLabel(DiagnosticBundle.message("label.assignee", new Object[0])));
            this.myAssigneePanel.add((Component)this.myAssigneeCombo);
        }
        this.myCredentialsLabel = ComponentsKt.htmlComponent("height sample", null, null, null, false, e -> {
            ErrorReportSubmitter submitter;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (submitter = this.selectedCluster().submitter) != null) {
                submitter.changeReporterAccount((Component)this.getRootPane());
                this.updateControls();
            }
        });
        if (this.myAssigneeVisible) {
            int topOffset = (this.myAssigneePanel.getPreferredSize().height - this.myCredentialsLabel.getPreferredSize().height) / 2;
            this.myCredentialsLabel.setBorder((Border)JBUI.Borders.emptyTop((int)topOffset));
        }
        this.myPrivacyNotice = new PrivacyNoticeComponent(DiagnosticBundle.message("error.dialog.notice.label", new Object[0]), DiagnosticBundle.message("error.dialog.notice.label.expanded", new Object[0]));
        JPanel commentPanel = new JPanel(new BorderLayout());
        commentPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        commentPanel.add((Component)IdeErrorsDialog.scrollPane((JComponent)this.myCommentArea, 0, 0), "Center");
        JPanel attachmentsPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)5), 0));
        attachmentsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        attachmentsPanel.add((Component)IdeErrorsDialog.scrollPane((JComponent)((Object)this.myAttachmentsList), 150, 350), "West");
        attachmentsPanel.add((Component)IdeErrorsDialog.scrollPane(this.myAttachmentArea, 500, 350), "Center");
        JPanel accountRow = new JPanel(new GridBagLayout());
        accountRow.setBorder((Border)JBUI.Borders.empty((int)6, (int)0));
        accountRow.add((Component)this.myCredentialsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        if (this.myAssigneeVisible) {
            accountRow.add((Component)this.myAssigneePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        JPanel bottomRow = new JPanel(new BorderLayout());
        bottomRow.add((Component)accountRow, "North");
        bottomRow.add((Component)this.myPrivacyNotice, "Center");
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)400));
        rootPanel.setMinimumSize((Dimension)JBUI.size((int)680, (int)400));
        rootPanel.add((Component)commentPanel, "North");
        rootPanel.add((Component)attachmentsPanel, "Center");
        rootPanel.add((Component)bottomRow, "South");
        return rootPanel;
    }

    private static JScrollPane scrollPane(JComponent component2, int width, int height) {
        JBScrollPane scrollPane = new JBScrollPane((Component)component2);
        if (width > 0 && height > 0) {
            scrollPane.setMinimumSize((Dimension)JBUI.size((int)width, (int)height));
        }
        return scrollPane;
    }

    protected Action @NotNull [] createActions() {
        if (SystemInfo.isWindows) {
            Action[] actionArray = new Action[]{this.getOKAction(), new ClearErrorsAction(), this.getCancelAction()};
            if (actionArray == null) {
                IdeErrorsDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{new ClearErrorsAction(), this.getCancelAction(), this.getOKAction()};
        if (actionArray == null) {
            IdeErrorsDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected Action @NotNull [] createLeftSideActions() {
        AnAction action2;
        if (this.myAssigneeVisible && this.myProject != null && !this.myProject.isDefault() && (action2 = ActionManager.getInstance().getAction("Unscramble")) != null) {
            Action[] actionArray = new Action[]{new AnalyzeAction(action2)};
            if (actionArray == null) {
                IdeErrorsDialog.$$$reportNull$$$0(3);
            }
            return actionArray;
        }
        return new Action[0];
    }

    protected String getDimensionServiceKey() {
        return "IDE.errors.dialog";
    }

    public void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            boolean closeDialog = this.myMessageClusters.size() == 1;
            boolean reportingStarted = this.reportMessage(this.selectedCluster(), closeDialog);
            if (!closeDialog) {
                this.updateControls();
            } else if (reportingStarted) {
                super.doOKAction();
            }
        }
    }

    protected void dispose() {
        this.myMessagePool.removeListener(this);
        super.dispose();
    }

    private MessageCluster selectedCluster() {
        return this.myMessageClusters.get(this.myIndex);
    }

    private AbstractMessage selectedMessage() {
        return this.selectedCluster().first;
    }

    private void updateMessages() {
        List<AbstractMessage> messages = this.myMessagePool.getFatalErrors(true, true);
        LinkedHashMap<Long, MessageCluster> clusters = new LinkedHashMap<Long, MessageCluster>();
        for (AbstractMessage message2 : messages) {
            CRC32 digest = new CRC32();
            digest.update(ExceptionUtil.getThrowableText((Throwable)message2.getThrowable()).getBytes(StandardCharsets.UTF_8));
            clusters.computeIfAbsent(Long.valueOf((long)digest.getValue()), (Function<Long, MessageCluster>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateMessages$5(com.intellij.diagnostic.AbstractMessage java.lang.Long ), (Ljava/lang/Long;)Lcom/intellij/diagnostic/IdeErrorsDialog$MessageCluster;)((AbstractMessage)message2)).messages.add(message2);
        }
        this.myMessageClusters.clear();
        this.myMessageClusters.addAll(clusters.values());
    }

    private void updateControls() {
        MessageCluster cluster = this.selectedCluster();
        ErrorReportSubmitter submitter = cluster.submitter;
        cluster.messages.forEach(m -> m.setRead(true));
        this.updateLabels(cluster);
        this.updateDetails(cluster);
        if (this.myAssigneeVisible) {
            this.updateAssigneePanel(cluster);
        }
        this.updateCredentialsPanel(submitter);
        this.setOKActionEnabled(cluster.canSubmit());
        this.setOKButtonText(submitter != null ? submitter.getReportActionText() : DiagnosticBundle.message("error.report.impossible.action", new Object[0]));
        this.setOKButtonTooltip(submitter != null ? null : DiagnosticBundle.message("error.report.impossible.tooltip", new Object[0]));
    }

    private void updateLabels(@NotNull MessageCluster cluster) {
        String notice;
        if (cluster == null) {
            IdeErrorsDialog.$$$reportNull$$$0(4);
        }
        AbstractMessage message2 = cluster.first;
        this.myCountLabel.setText(DiagnosticBundle.message("error.list.message.index.count", this.myIndex + 1, this.myMessageClusters.size()));
        Throwable t = message2.getThrowable();
        if (t instanceof MessagePool.TooManyErrorsException) {
            this.myInfoLabel.setText(t.getMessage());
            this.myDetailsLabel.setVisible(false);
            this.myForeignPluginWarningLabel.setVisible(false);
            this.myPrivacyNotice.setVisible(false);
            return;
        }
        PluginId pluginId = cluster.pluginId;
        IdeaPluginDescriptor plugin2 = cluster.plugin;
        StringBuilder info = new StringBuilder();
        if (pluginId != null) {
            String name;
            String string = name = plugin2 != null ? plugin2.getName() : pluginId.toString();
            if (plugin2 != null && (!plugin2.isBundled() || plugin2.allowBundledUpdate())) {
                info.append(DiagnosticBundle.message("error.list.message.blame.plugin.version", name, plugin2.getVersion()));
            } else {
                info.append(DiagnosticBundle.message("error.list.message.blame.plugin", name));
            }
        } else if (t instanceof AbstractMethodError) {
            info.append(DiagnosticBundle.message("error.list.message.blame.unknown.plugin", new Object[0]));
        } else if (t instanceof Freeze) {
            info.append(DiagnosticBundle.message("error.list.message.blame.freeze", new Object[0]));
        } else if (t instanceof JBRCrash) {
            info.append(DiagnosticBundle.message("error.list.message.blame.jbr.crash", new Object[0]));
        } else {
            info.append(DiagnosticBundle.message("error.list.message.blame.core", ApplicationNamesInfo.getInstance().getProductName()));
        }
        if (pluginId != null && !ApplicationInfoEx.getInstanceEx().isEssentialPlugin(pluginId)) {
            info.append(' ').append("<a style=\"white-space: nowrap;\" href=\"#disable\">").append(DiagnosticBundle.message("error.list.disable.plugin", new Object[0])).append("</a>");
        }
        if (message2.isSubmitting()) {
            info.append(' ').append(DiagnosticBundle.message("error.list.message.submitting", new Object[0]));
        } else if (message2.getSubmissionInfo() != null) {
            info.append(' ').append("<span style=\"white-space: nowrap;\">");
            IdeErrorsDialog.appendSubmissionInformation(message2.getSubmissionInfo(), info);
            info.append("</span>");
        }
        this.myInfoLabel.setText(info.toString());
        int count = cluster.messages.size();
        String date = DateFormatUtil.formatPrettyDateTime((Date)cluster.messages.get(count - 1).getDate());
        this.myDetailsLabel.setText(DiagnosticBundle.message("error.list.message.info", date, count));
        ErrorReportSubmitter submitter = cluster.submitter;
        if (submitter == null && plugin2 != null && !PluginManager.getInstance().isDevelopedByJetBrains((PluginDescriptor)plugin2)) {
            String vendorEmail;
            this.myForeignPluginWarningLabel.setVisible(true);
            String vendor = plugin2.getVendor();
            Object vendorUrl = plugin2.getVendorUrl();
            if (StringUtil.isEmptyOrSpaces((String)vendorUrl) && !StringUtil.isEmptyOrSpaces((String)(vendorEmail = plugin2.getVendorEmail()))) {
                vendorUrl = "mailto:" + StringUtil.trimStart((String)vendorEmail, (String)"mailto:");
            }
            if (!StringUtil.isEmpty((String)vendor) && !StringUtil.isEmpty((String)vendorUrl)) {
                this.myForeignPluginWarningLabel.setText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning", vendor, vendorUrl));
            } else if (!StringUtil.isEmptyOrSpaces((String)vendorUrl)) {
                this.myForeignPluginWarningLabel.setText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.unnamed", vendorUrl));
            } else {
                this.myForeignPluginWarningLabel.setText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.unknown", new Object[0]));
            }
        } else {
            this.myForeignPluginWarningLabel.setVisible(false);
        }
        String string = notice = submitter != null ? submitter.getPrivacyNoticeText() : null;
        if (notice != null) {
            this.myPrivacyNotice.setVisible(true);
            String hash = Integer.toHexString(StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)notice));
            this.myPrivacyNotice.setExpanded(!this.myAcceptedNotices.contains(hash));
            this.myPrivacyNotice.setPrivacyPolicy(notice);
        } else {
            this.myPrivacyNotice.setVisible(false);
        }
    }

    private void updateDetails(MessageCluster cluster) {
        AbstractMessage message2 = cluster.first;
        boolean canReport = cluster.canSubmit();
        if (this.myLastIndex != this.myIndex) {
            this.myCommentArea.setText(message2.getAdditionalInfo());
            this.myAttachmentsList.clear();
            this.myAttachmentsList.addItem(STACKTRACE_ATTACHMENT, true);
            for (Attachment attachment : message2.getAllAttachments()) {
                this.myAttachmentsList.addItem(attachment.getName(), attachment.isIncluded());
            }
            this.myAttachmentsList.setSelectedIndex(0);
            this.myLastIndex = this.myIndex;
        }
        this.myCommentArea.setEditable(canReport);
        this.myCommentArea.putClientProperty((Object)"StatusVisibleFunction", (Object)(canReport ? null : c -> false));
        this.myAttachmentsList.setEditable(canReport);
    }

    private void updateAssigneePanel(MessageCluster cluster) {
        if (cluster.submitter instanceof ITNReporter) {
            this.myAssigneePanel.setVisible(true);
            this.myAssigneeCombo.setEnabled(cluster.isUnsent());
            Integer assignee = cluster.first.getAssigneeId();
            if (assignee == null) {
                this.myAssigneeCombo.setSelectedIndex(-1);
            } else {
                int assigneeIndex = this.getAssigneeIndex(assignee);
                if (assigneeIndex != -1) {
                    this.myAssigneeCombo.setSelectedIndex(assigneeIndex);
                } else {
                    cluster.first.setAssigneeId(null);
                }
            }
        } else {
            this.myAssigneePanel.setVisible(false);
        }
    }

    private int getAssigneeIndex(Integer assigneeId) {
        for (int index2 = 0; index2 < this.myAssigneeCombo.getItemCount(); ++index2) {
            if (!Objects.equals(assigneeId, ((Developer)this.myAssigneeCombo.getItemAt(index2)).getId())) continue;
            return index2;
        }
        return -1;
    }

    private void updateCredentialsPanel(@Nullable ErrorReportSubmitter submitter) {
        String account;
        String string = account = submitter != null ? submitter.getReporterAccount() : null;
        if (account != null) {
            this.myCredentialsLabel.setVisible(true);
            if (!account.isEmpty()) {
                this.myCredentialsLabel.setText(DiagnosticBundle.message("error.dialog.submit.named", account));
            } else {
                this.myCredentialsLabel.setText(DiagnosticBundle.message("error.dialog.submit.anonymous", new Object[0]));
            }
        } else {
            this.myCredentialsLabel.setVisible(false);
        }
    }

    private boolean reportMessage(MessageCluster cluster, boolean dialogClosed) {
        boolean accepted;
        String hash;
        ErrorReportSubmitter submitter = cluster.submitter;
        if (submitter == null) {
            return false;
        }
        AbstractMessage message2 = cluster.first;
        message2.setAssigneeVisible(this.myAssigneeVisible);
        message2.setDevelopersTimestamp(this.myDevelopersTimestamp);
        message2.setSubmitting(true);
        String notice = submitter.getPrivacyNoticeText();
        if (notice != null && this.myAcceptedNotices.add(hash = Integer.toHexString(StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)notice)))) {
            PropertiesComponent.getInstance().setValue(ACCEPTED_NOTICES_KEY, StringUtil.join(this.myAcceptedNotices, (String)ACCEPTED_NOTICES_SEPARATOR));
        }
        Pair<String, String> pair = cluster.decouple();
        IdeaLoggingEvent[] events = new IdeaLoggingEvent[]{new IdeaReportingEvent(message2, (String)pair.first, (String)pair.second, cluster.plugin)};
        Container parentComponent = this.getRootPane();
        if (dialogClosed) {
            IdeFrame frame = (IdeFrame)ComponentUtil.getParentOfType(IdeFrame.class, (Component)parentComponent);
            parentComponent = Objects.requireNonNullElse(frame != null ? frame.getComponent() : WindowManager.getInstance().findVisibleFrame(), parentComponent);
        }
        if (!(accepted = submitter.submit(events, message2.getAdditionalInfo(), (Component)parentComponent, reportInfo -> {
            message2.setSubmitted((SubmittedReportInfo)reportInfo);
            UIUtil.invokeLaterIfNeeded(this::updateOnSubmit);
        }))) {
            message2.setSubmitting(false);
        }
        return accepted;
    }

    private void disablePlugin() {
        IdeaPluginDescriptor plugin2 = this.selectedCluster().plugin;
        if (plugin2 != null) {
            IdeErrorsDialog.confirmDisablePlugins(this.myProject, Collections.singleton(plugin2));
        }
    }

    public static void confirmDisablePlugins(@Nullable Project project, @NotNull Set<IdeaPluginDescriptor> pluginsToDisable) {
        boolean doRestart;
        boolean doDisable;
        String message2;
        if (pluginsToDisable == null) {
            IdeErrorsDialog.$$$reportNull$$$0(5);
        }
        boolean hasDependents = IdeErrorsDialog.morePluginsAffected(pluginsToDisable);
        boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
        if (pluginsToDisable.size() == 1) {
            IdeaPluginDescriptor plugin2 = pluginsToDisable.iterator().next();
            message2 = "<html>" + DiagnosticBundle.message("error.dialog.disable.prompt", plugin2.getName()) + "<br/>" + DiagnosticBundle.message(hasDependents ? "error.dialog.disable.prompt.deps" : "error.dialog.disable.prompt.lone", new Object[0]) + "<br/><br/>" + DiagnosticBundle.message(canRestart ? "error.dialog.disable.plugin.can.restart" : "error.dialog.disable.plugin.no.restart", new Object[0]) + "</html>";
        } else {
            message2 = "<html>" + DiagnosticBundle.message("error.dialog.disable.prompt.multiple", new Object[0]) + "<br/>" + DiagnosticBundle.message(hasDependents ? "error.dialog.disable.prompt.deps.multiple" : "error.dialog.disable.prompt.lone.multiple", new Object[0]) + "<br/><br/>" + DiagnosticBundle.message(canRestart ? "error.dialog.disable.plugin.can.restart" : "error.dialog.disable.plugin.no.restart", new Object[0]) + "</html>";
        }
        String title = DiagnosticBundle.message("error.dialog.disable.plugin.title", new Object[0]);
        String disable = DiagnosticBundle.message("error.dialog.disable.plugin.action.disable", new Object[0]);
        String cancel = IdeBundle.message((String)"button.cancel", (Object[])new Object[0]);
        if (canRestart) {
            String restart = DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
            int result2 = Messages.showYesNoCancelDialog((Project)project, (String)message2, (String)title, (String)disable, (String)restart, (String)cancel, (Icon)Messages.getQuestionIcon());
            doDisable = result2 == 0 || result2 == 1;
            doRestart = result2 == 1;
        } else {
            int result3 = Messages.showYesNoDialog((Project)project, (String)message2, (String)title, (String)disable, (String)cancel, (Icon)Messages.getQuestionIcon());
            doDisable = result3 == 0;
            doRestart = false;
        }
        if (doDisable) {
            for (IdeaPluginDescriptor plugin3 : pluginsToDisable) {
                PluginManagerCore.disablePlugin(plugin3.getPluginId());
            }
            if (doRestart) {
                ApplicationManager.getApplication().restart();
            }
        }
    }

    private static boolean morePluginsAffected(@NotNull Set<IdeaPluginDescriptor> pluginsToDisable) {
        if (pluginsToDisable == null) {
            IdeErrorsDialog.$$$reportNull$$$0(6);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        for (IdeaPluginDescriptor rootDescriptor : PluginManagerCore.getPlugins()) {
            if (!rootDescriptor.isEnabled() || pluginsToDisable.contains(rootDescriptor) || PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, false, pluginIdMap, descriptor2 -> {
                if (!descriptor2.isEnabled()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return pluginsToDisable.contains(descriptor2) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            })) continue;
            return true;
        }
        return false;
    }

    protected void updateOnSubmit() {
        if (this.isShowing()) {
            this.updateControls();
        }
    }

    @Override
    public void newEntryAdded() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.isShowing()) {
                this.updateMessages();
                this.updateControls();
            }
        });
    }

    @Override
    public void poolCleared() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.isShowing()) {
                this.doCancelAction();
            }
        });
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IdeErrorsDialog.$$$reportNull$$$0(7);
        }
        return CURRENT_TRACE_KEY.is(dataId) ? this.selectedMessage().getThrowableText() : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public static Pair<String, String> getPluginInfo(@NotNull IdeaLoggingEvent event) {
        IdeaPluginDescriptor plugin2;
        if (event == null) {
            IdeErrorsDialog.$$$reportNull$$$0(8);
        }
        return (plugin2 = IdeErrorsDialog.getPlugin(event)) != null && (!plugin2.isBundled() || plugin2.allowBundledUpdate()) ? Pair.pair((Object)plugin2.getName(), (Object)plugin2.getVersion()) : null;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@NotNull IdeaLoggingEvent event) {
        if (event == null) {
            IdeErrorsDialog.$$$reportNull$$$0(9);
        }
        IdeaPluginDescriptor plugin2 = null;
        if (event instanceof IdeaReportingEvent) {
            plugin2 = ((IdeaReportingEvent)event).getPlugin();
        } else {
            Throwable t = event.getThrowable();
            if (t != null) {
                plugin2 = PluginManagerCore.getPlugin(PluginUtil.getInstance().findPluginId(t));
            }
        }
        return plugin2;
    }

    @Deprecated
    @Nullable
    public static PluginId findPluginId(@NotNull Throwable t) {
        if (t == null) {
            IdeErrorsDialog.$$$reportNull$$$0(10);
        }
        return PluginUtil.getInstance().findPluginId(t);
    }

    @Nullable
    static ErrorReportSubmitter getSubmitter(@NotNull Throwable t, @Nullable PluginId pluginId) {
        if (t == null) {
            IdeErrorsDialog.$$$reportNull$$$0(11);
        }
        return IdeErrorsDialog.getSubmitter(t, PluginManagerCore.getPlugin(pluginId));
    }

    private static ErrorReportSubmitter getSubmitter(Throwable t, @Nullable IdeaPluginDescriptor plugin2) {
        PluginDescriptor descriptor2;
        List reporters;
        if (t instanceof MessagePool.TooManyErrorsException || t instanceof AbstractMethodError) {
            return null;
        }
        try {
            reporters = ExtensionPoints.ERROR_HANDLER_EP.getExtensionList();
        }
        catch (Throwable ignored) {
            return null;
        }
        if (plugin2 != null) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor2 = reporter.getPluginDescriptor();
                if (descriptor2 == null || plugin2.getPluginId() != descriptor2.getPluginId()) continue;
                return reporter;
            }
        }
        if (plugin2 == null || PluginManager.getInstance().isDevelopedByJetBrains((PluginDescriptor)plugin2)) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor2 = reporter.getPluginDescriptor();
                if (descriptor2 != null && PluginId.getId((String)"com.intellij") != descriptor2.getPluginId()) continue;
                return reporter;
            }
        }
        return null;
    }

    public static void appendSubmissionInformation(@NotNull SubmittedReportInfo info, @NotNull StringBuilder out) {
        if (info == null) {
            IdeErrorsDialog.$$$reportNull$$$0(12);
        }
        if (out == null) {
            IdeErrorsDialog.$$$reportNull$$$0(13);
        }
        if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.FAILED) {
            String details = info.getLinkText();
            out.append(details != null ? DiagnosticBundle.message("error.list.message.submission.failed.details", details) : DiagnosticBundle.message("error.list.message.submission.failed", new Object[0]));
        } else if (info.getURL() != null && info.getLinkText() != null) {
            out.append(DiagnosticBundle.message("error.list.message.submitted.as.link", info.getURL(), info.getLinkText()));
            if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE) {
                out.append(DiagnosticBundle.message("error.list.message.duplicate", new Object[0]));
            }
        } else {
            out.append(DiagnosticBundle.message("error.list.message.submitted", new Object[0]));
        }
    }

    private static /* synthetic */ MessageCluster lambda$updateMessages$5(AbstractMessage message2, Long k) {
        return new MessageCluster(message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeErrorsDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToDisable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeErrorsDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLabels";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "confirmDisablePlugins";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "morePluginsAffected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPluginInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPluginId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubmitter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendSubmissionInformation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MessageCluster {
        private final AbstractMessage first;
        @Nullable
        private final PluginId pluginId;
        @Nullable
        private final IdeaPluginDescriptor plugin;
        @Nullable
        private final ErrorReportSubmitter submitter;
        private String detailsText;
        private final List<AbstractMessage> messages = new ArrayList<AbstractMessage>();

        private MessageCluster(AbstractMessage message2) {
            this.first = message2;
            this.pluginId = PluginUtil.getInstance().findPluginId(message2.getThrowable());
            this.plugin = PluginManagerCore.getPlugin(this.pluginId);
            this.submitter = IdeErrorsDialog.getSubmitter(message2.getThrowable(), this.plugin);
            this.detailsText = this.detailsText();
        }

        private String detailsText() {
            Throwable t = this.first.getThrowable();
            if (t instanceof MessagePool.TooManyErrorsException) {
                return t.getMessage();
            }
            String userMessage = this.first.getMessage();
            String stacktrace = this.first.getThrowableText();
            return StringUtil.isEmptyOrSpaces((String)userMessage) ? stacktrace : userMessage + "\n\n" + stacktrace;
        }

        private boolean isUnsent() {
            return !this.first.isSubmitted() && !this.first.isSubmitting();
        }

        private boolean canSubmit() {
            return this.submitter != null && this.isUnsent();
        }

        private Pair<String, String> decouple() {
            String className = this.first.getThrowable().getClass().getName();
            int p = this.detailsText.indexOf(className);
            if (p == 0) {
                return Pair.pair(null, (Object)this.detailsText);
            }
            if (p > 0 && this.detailsText.charAt(p - 1) == '\n') {
                return Pair.pair((Object)this.detailsText.substring(0, p).trim(), (Object)this.detailsText.substring(p));
            }
            return Pair.pair((Object)"*** exception class was changed or removed", (Object)this.detailsText);
        }
    }

    private static class AttachmentsList
    extends CheckBoxList<String> {
        private boolean myEditable = true;

        private AttachmentsList() {
        }

        private void addItem(@NlsContexts.Checkbox String item, boolean selected2) {
            this.addItem(item, item + "  ", selected2);
        }

        public void setEditable(boolean editable) {
            this.myEditable = editable;
        }

        protected boolean isEnabled(int index2) {
            return this.myEditable && index2 > 0;
        }
    }

    private final class AnalyzeAction
    extends AbstractAction {
        private final AnAction myAnalyze;

        private AnalyzeAction(AnAction analyze) {
            super(ActionsBundle.actionText((String)ActionManager.getInstance().getId(analyze)));
            this.putValue("MnemonicKey", analyze.getTemplatePresentation().getMnemonic());
            this.myAnalyze = analyze;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext ctx = DataManager.getInstance().getDataContext((Component)e.getSource());
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this.myAnalyze, null, (String)"unknown", (DataContext)ctx);
            this.myAnalyze.actionPerformed(event);
            IdeErrorsDialog.this.doCancelAction();
        }
    }

    private final class ClearErrorsAction
    extends AbstractAction {
        private ClearErrorsAction() {
            super(DiagnosticBundle.message("error.dialog.clear.all.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.myMessagePool.clearErrors();
            IdeErrorsDialog.this.doCancelAction();
        }
    }

    private class ForwardAction
    extends AnAction
    implements DumbAware,
    LightEditCompatible {
        ForwardAction() {
            super(IdeBundle.message((String)"button.next", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
            AnAction action2 = ActionManager.getInstance().getAction("NextTab");
            if (action2 != null) {
                this.registerCustomShortcutSet(action2.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(IdeErrorsDialog.this.myIndex < IdeErrorsDialog.this.myMessageClusters.size() - 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            IdeErrorsDialog.this.myLastIndex = IdeErrorsDialog.this.myIndex++;
            IdeErrorsDialog.this.updateControls();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diagnostic/IdeErrorsDialog$ForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BackAction
    extends AnAction
    implements DumbAware,
    LightEditCompatible {
        BackAction() {
            super(IdeBundle.message((String)"button.previous", (Object[])new Object[0]), null, AllIcons.Actions.Back);
            AnAction action2 = ActionManager.getInstance().getAction("PreviousTab");
            if (action2 != null) {
                this.registerCustomShortcutSet(action2.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(IdeErrorsDialog.this.myIndex > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            IdeErrorsDialog.this.myLastIndex = IdeErrorsDialog.this.myIndex--;
            IdeErrorsDialog.this.updateControls();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diagnostic/IdeErrorsDialog$BackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

