/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Restarter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/FixWSLFirewallAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
public final class FixWSLFirewallAction
extends DumbAwareAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        ProcessOutput output2;
        ProcessOutput processOutput;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = ActionsBundle.actionText((String)"FixWSLFirewall");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ActionsBundle.actionText(\"FixWSLFirewall\")");
        String string2 = DiagnosticBundle.message("wsl.firewall.settings.prompt", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DiagnosticBundle.message\u2026irewall.settings.prompt\")");
        boolean result2 = MessageDialogBuilder.Companion.okCancel(string, string2).ask(e.getProject());
        if (!result2) {
            return;
        }
        File starter2 = Restarter.getIdeStarter();
        String powershellCommand = "Get-NetFirewallApplicationFilter -Program \"" + starter2 + "\" | Get-NetFirewallRule | Where-Object Profile -eq \"Public\" | Get-NetFirewallPortFilter | Where-Object Protocol -eq \"TCP\" | Get-NetFirewallRule | Set-NetFirewallRule -Action Allow";
        try {
            processOutput = (ProcessOutput)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<ProcessOutput, Exception>(powershellCommand, e, e.getProject(), ActionsBundle.actionText((String)"FixWSLFirewall"), false){
                final /* synthetic */ String $powershellCommand;
                final /* synthetic */ AnActionEvent $e;

                @NotNull
                protected ProcessOutput compute(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-Command", this.$powershellCommand}), (String)"");
                }
                {
                    this.$powershellCommand = $captured_local_variable$0;
                    this.$e = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            });
        }
        catch (Exception e2) {
            processOutput = null;
        }
        ProcessOutput processOutput2 = output2 = processOutput;
        if (processOutput2 != null) {
            if (processOutput2.getExitCode() == 0) {
                Messages.showMessageDialog((Project)e.getProject(), (String)DiagnosticBundle.message("wsl.firewall.settings.success", new Object[0]), (String)ActionsBundle.actionText((String)"FixWSLFirewall"), null);
                return;
            }
        }
        Messages.showErrorDialog((Project)e.getProject(), (String)DiagnosticBundle.message("wsl.firewall.settings.failure", new Object[0]), (String)ActionsBundle.actionText((String)"FixWSLFirewall"));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(SystemInfo.isWindows && Restarter.getIdeStarter() != null);
    }
}

