/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.OutOfMemoryDialog;
import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.MappingFailedException;
import com.intellij.util.system.CpuArch;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DefaultIdeaErrorLogger
implements ErrorLogger {
    private static boolean ourOomOccurred = false;
    private static boolean ourLoggerBroken = false;
    private static boolean ourMappingFailedNotificationPosted = false;
    @NonNls
    private static final String FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    @NonNls
    private static final String DISABLED_VALUE = "disabled";
    @NonNls
    private static final String ENABLED_VALUE = "enabled";

    public boolean canHandle(IdeaLoggingEvent event) {
        if (ourLoggerBroken) {
            return false;
        }
        try {
            Application app = ApplicationManager.getApplication();
            if (app.isDisposed()) {
                return false;
            }
            UpdateChecker.checkForUpdate(event);
            boolean notificationEnabled = !DISABLED_VALUE.equals(System.getProperty(FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
            Throwable t = event.getThrowable();
            PluginId pluginId = PluginUtil.getInstance().findPluginId(t);
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(t, pluginId);
            boolean showPluginError = !(submitter instanceof ITNReporter) || ((ITNReporter)submitter).showErrorInRelease(event);
            VMOptions.MemoryKind kind = DefaultIdeaErrorLogger.getOOMErrorKind(event.getThrowable());
            boolean isOOM = kind != null;
            boolean isMappingFailed = !isOOM && event.getThrowable() instanceof MappingFailedException;
            LifecycleUsageTriggerCollector.onError(pluginId, t, kind);
            return notificationEnabled || showPluginError || ApplicationManager.getApplication().isInternal() || isOOM || isMappingFailed;
        }
        catch (LinkageError e) {
            if (e.getMessage().contains("Could not initialize class com.intellij.diagnostic.IdeErrorsDialog")) {
                ourLoggerBroken = true;
            }
            throw e;
        }
    }

    public void handle(IdeaLoggingEvent event) {
        block8: {
            if (ourLoggerBroken) {
                return;
            }
            try {
                Throwable throwable = event.getThrowable();
                VMOptions.MemoryKind kind = DefaultIdeaErrorLogger.getOOMErrorKind(throwable);
                if (kind != null && System.getProperty("testscript.filename") == null) {
                    ourOomOccurred = true;
                    SwingUtilities.invokeAndWait(() -> new OutOfMemoryDialog(kind).show());
                } else if (throwable instanceof MappingFailedException) {
                    DefaultIdeaErrorLogger.processMappingFailed(event);
                } else if (!ourOomOccurred) {
                    MessagePool.getInstance().addIdeFatalMessage(event);
                }
            }
            catch (Throwable e) {
                String message2 = e.getMessage();
                if ((message2 == null || !message2.contains("Could not initialize class com.intellij.diagnostic.MessagePool")) && (!(e instanceof NullPointerException) || ApplicationManager.getApplication() != null)) break block8;
                ourLoggerBroken = true;
            }
        }
    }

    @Nullable
    static VMOptions.MemoryKind getOOMErrorKind(Throwable t) {
        String message2 = t.getMessage();
        if (t instanceof OutOfMemoryError) {
            if (message2 != null && message2.contains("unable to create") && message2.contains("native thread")) {
                return null;
            }
            if (message2 != null && message2.contains("Metaspace")) {
                return VMOptions.MemoryKind.METASPACE;
            }
            return VMOptions.MemoryKind.HEAP;
        }
        if (t instanceof VirtualMachineError && message2 != null && message2.contains("CodeCache")) {
            return VMOptions.MemoryKind.CODE_CACHE;
        }
        return null;
    }

    private static void processMappingFailed(IdeaLoggingEvent event) {
        if (!ourMappingFailedNotificationPosted && SystemInfo.isWindows && CpuArch.isIntel32()) {
            ourMappingFailedNotificationPosted = true;
            String exceptionMessage = event.getThrowable().getMessage();
            String text2 = DiagnosticBundle.message("notification.content.0.br.possible.cause.unable.to.allocate.memory", exceptionMessage);
            Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Memory", (String)DiagnosticBundle.message("notification.group.memory", new Object[0])), DiagnosticBundle.message("notification.title.memory.mapping.failed", new Object[0]), text2, NotificationType.WARNING), null);
        }
    }
}

