/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00110\u0011H\u0000\u001a0\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DB_FILE_NAME", "", "copyTo", "", "from", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "store", "Lcom/intellij/credentialStore/CredentialStore;", "generateRandomMasterKey", "Lcom/intellij/credentialStore/keePass/MasterKey;", "masterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Ljava/security/SecureRandom;", "getDefaultKeePassBaseDirectory", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultMasterPasswordFile", "kotlin.jvm.PlatformType", "saveDatabase", "dbFile", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "masterKey", "masterKeyStorage", "Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "intellij.platform.credentialStore"})
public final class KeePassCredentialStoreKt {
    @NotNull
    public static final String DB_FILE_NAME = "c.kdbx";

    @NotNull
    public static final Path getDefaultKeePassBaseDirectory() {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir()");
        return path;
    }

    public static final Path getDefaultMasterPasswordFile() {
        return KeePassCredentialStoreKt.getDefaultKeePassBaseDirectory().resolve("c.pwd");
    }

    @NotNull
    public static final MasterKey generateRandomMasterKey(@NotNull EncryptionSpec masterKeyEncryptionSpec, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkNotNullParameter((Object)masterKeyEncryptionSpec, (String)"masterKeyEncryptionSpec");
        Intrinsics.checkNotNullParameter((Object)secureRandom2, (String)"secureRandom");
        byte[] bytes = CredentialStoreKt.generateBytes(secureRandom2, 512);
        byte[] byArray = Base64.getEncoder().withoutPadding().encode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getEncoder().withoutPadding().encode(bytes)");
        return new MasterKey(byArray, true, masterKeyEncryptionSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveDatabase(@NotNull Path dbFile, @NotNull KeePassDatabase db, @NotNull MasterKey masterKey, @NotNull MasterKeyFileStorage masterKeyStorage, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)masterKeyStorage, (String)"masterKeyStorage");
        Intrinsics.checkNotNullParameter((Object)secureRandom2, (String)"secureRandom");
        byte[] byArray = masterKey.getValue();
        Intrinsics.checkNotNull((Object)byArray);
        KdbxPassword kdbxPassword = new KdbxPassword(byArray);
        masterKeyStorage.save(masterKey);
        Closeable closeable = PathKt.safeOutputStream((Path)dbFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl3 = false;
            db.save$intellij_platform_credentialStore(kdbxPassword, it, secureRandom2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyTo(@NotNull Map<CredentialAttributes, Credentials> from2, @NotNull CredentialStore store) {
        Intrinsics.checkNotNullParameter(from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        CredentialAttributes credentialAttributes = from2;
        boolean bl = false;
        Iterator<Map.Entry<CredentialAttributes, Credentials>> iterator2 = credentialAttributes.entrySet().iterator();
        while (iterator2.hasNext()) {
            void k;
            Map.Entry<CredentialAttributes, Credentials> entry;
            Map.Entry<CredentialAttributes, Credentials> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            credentialAttributes = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Credentials v = entry2.getValue();
            store.set((CredentialAttributes)k, v);
        }
    }
}

