/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ProtectedValue;
import com.intellij.credentialStore.kdbx.ProtectedValueKt;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/kdbx/XmlProtectedValueTransformer;", "", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "(Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "position", "", "processEntries", "", "parentElement", "Lorg/jdom/Element;", "intellij.platform.credentialStore"})
public final class XmlProtectedValueTransformer {
    private int position;
    private final SkippingStreamCipher streamCipher;

    public final void processEntries(@NotNull Element parentElement) {
        Intrinsics.checkNotNullParameter((Object)parentElement, (String)"parentElement");
        for (Content element2 : parentElement.getContent()) {
            if (!(element2 instanceof Element)) continue;
            if (Intrinsics.areEqual((Object)((Element)element2).getName(), (Object)"Group")) {
                this.processEntries((Element)element2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Element)element2).getName(), (Object)"Entry")) continue;
            for (Element container : ((Element)element2).getChildren("String")) {
                Element valueElement;
                if (container.getChild("Value") == null) {
                    continue;
                }
                if (!ProtectedValueKt.isValueProtected(valueElement)) continue;
                byte[] value2 = Base64.getDecoder().decode(valueElement.getText());
                Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                valueElement.setContent((Content)new ProtectedValue(value2, this.position, this.streamCipher));
                this.position += value2.length;
            }
        }
    }

    public XmlProtectedValueTransformer(@NotNull SkippingStreamCipher streamCipher) {
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        this.streamCipher = streamCipher;
    }
}

