/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.HashedBlockInputStream;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.XmlProtectedValueTransformer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"SALSA20_IV", "", "createSalsa20StreamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "key", "loadKdbx", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "file", "Ljava/nio/file/Path;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "readKeePassDatabase", "inputStream", "Ljava/io/InputStream;", "intellij.platform.credentialStore"})
public final class KdbxKt {
    private static final byte[] SALSA20_IV = new byte[]{-24, 48, 9, 75, -105, 32, 93, 42};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeePassDatabase loadKdbx(@NotNull Path file2, @NotNull KeePassCredentials credentials2) throws IncorrectMasterPasswordException {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)credentials2, (String)"credentials");
        Closeable closeable = PathKt.inputStream((Path)file2);
        int n = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl2 = false;
            keePassDatabase = KdbxKt.readKeePassDatabase(credentials2, it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return keePassDatabase;
    }

    private static final KeePassDatabase readKeePassDatabase(KeePassCredentials credentials2, InputStream inputStream2) {
        KdbxHeader kdbxHeader = new KdbxHeader(inputStream2);
        InputStream decryptedInputStream = kdbxHeader.createDecryptedStream(credentials2.getKey(), inputStream2);
        byte[] byArray = FileUtilRt.loadBytes((InputStream)decryptedInputStream, (int)32);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"FileUtilRt.loadBytes(decryptedInputStream, 32)");
        byte[] startBytes = byArray;
        if (!Arrays.equals(startBytes, kdbxHeader.getStreamStartBytes())) {
            throw (Throwable)new IncorrectMasterPasswordException(false, 1, null);
        }
        InputStream resultInputStream = new HashedBlockInputStream(decryptedInputStream);
        if (kdbxHeader.getCompressionFlags() == KdbxHeader.CompressionFlags.GZIP) {
            resultInputStream = new GZIPInputStream(resultInputStream);
        }
        Element element2 = JDOMUtil.load((InputStream)resultInputStream);
        Element element3 = element2.getChild("Root");
        if (element3 != null) {
            Element element4 = element3;
            boolean bl = false;
            boolean bl2 = false;
            Element rootElement = element4;
            boolean bl3 = false;
            new XmlProtectedValueTransformer(KdbxKt.createSalsa20StreamCipher(kdbxHeader.getProtectedStreamKey())).processEntries(rootElement);
        }
        Element element5 = element2;
        Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"element");
        return new KeePassDatabase(element5);
    }

    @NotNull
    public static final SkippingStreamCipher createSalsa20StreamCipher(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Salsa20Engine streamCipher = new Salsa20Engine();
        KeyParameter keyParameter = new KeyParameter(DigestUtil.sha256().digest(key));
        streamCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, SALSA20_IV));
        return (SkippingStreamCipher)streamCipher;
    }
}

