/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.HashedBlockOutputStream;
import com.intellij.credentialStore.kdbx.KdbxException;
import com.intellij.credentialStore.kdbx.KdbxHeader$WhenMappings;
import com.intellij.credentialStore.kdbx.KdbxHeaderKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.DigestUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u000e\u0010+\u001a\u00020(2\u0006\u0010&\u001a\u00020%R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader;", "", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "random", "Ljava/security/SecureRandom;", "(Ljava/security/SecureRandom;)V", "()V", "cipherUuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "<set-?>", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "compressionFlags", "getCompressionFlags", "()Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "encryptionIv", "", "headerHash", "getHeaderHash", "()[B", "setHeaderHash", "([B)V", "masterSeed", "protectedStreamAlgorithm", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "protectedStreamKey", "getProtectedStreamKey", "streamStartBytes", "getStreamStartBytes", "transformRounds", "", "transformSeed", "createDecryptedStream", "digest", "createEncryptedStream", "Ljava/io/OutputStream;", "outputStream", "readKdbxHeader", "", "setCipherUuid", "uuid", "writeKdbxHeader", "CompressionFlags", "ProtectedStreamAlgorithm", "intellij.platform.credentialStore"})
public final class KdbxHeader {
    private UUID cipherUuid;
    @NotNull
    private CompressionFlags compressionFlags;
    private byte[] masterSeed;
    private byte[] transformSeed;
    private long transformRounds;
    private byte[] encryptionIv;
    @NotNull
    private byte[] protectedStreamKey;
    private ProtectedStreamAlgorithm protectedStreamAlgorithm;
    @NotNull
    private byte[] streamStartBytes;
    @Nullable
    private byte[] headerHash;

    @NotNull
    public final CompressionFlags getCompressionFlags() {
        return this.compressionFlags;
    }

    @NotNull
    public final byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    @NotNull
    public final byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    @Nullable
    public final byte[] getHeaderHash() {
        return this.headerHash;
    }

    public final void setHeaderHash(@Nullable byte[] byArray) {
        this.headerHash = byArray;
    }

    @NotNull
    public final InputStream createDecryptedStream(@NotNull byte[] digest, @NotNull InputStream inputStream2) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.masterSeed, this.transformSeed, this.transformRounds);
        return KdbxHeaderKt.access$getDecryptedInputStream(inputStream2, finalKeyDigest, this.encryptionIv);
    }

    @NotNull
    public final OutputStream createEncryptedStream(@NotNull byte[] digest, @NotNull OutputStream outputStream) {
        OutputStream outputStream2;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.masterSeed, this.transformSeed, this.transformRounds);
        OutputStream out = KdbxHeaderKt.access$getEncryptedOutputStream(outputStream, finalKeyDigest, this.encryptionIv);
        out.write(this.streamStartBytes);
        out = new HashedBlockOutputStream(out);
        switch (KdbxHeader$WhenMappings.$EnumSwitchMapping$0[this.compressionFlags.ordinal()]) {
            case 1: {
                outputStream2 = new GZIPOutputStream(out, 8192);
                break;
            }
            default: {
                outputStream2 = out;
            }
        }
        return outputStream2;
    }

    private final void setCipherUuid(byte[] uuid) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = ByteBuffer.wrap(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"b");
        UUID incoming = new UUID(byteBuffer.getLong(), b.getLong(8));
        if (Intrinsics.areEqual((Object)incoming, (Object)KdbxHeaderKt.access$getAES_CIPHER$p()) ^ true) {
            throw (Throwable)new IllegalStateException("Unknown Cipher UUID " + incoming);
        }
        this.cipherUuid = incoming;
    }

    private final void readKdbxHeader(InputStream inputStream2) {
        byte headerType;
        MessageDigest digest = DigestUtil.sha256();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream2, digest);
        LittleEndianDataInputStream input = new LittleEndianDataInputStream((InputStream)digestInputStream);
        if (!KdbxHeaderKt.access$readSignature(input)) {
            throw (Throwable)new KdbxException("Bad signature");
        }
        if (!KdbxHeaderKt.access$verifyFileVersion(input)) {
            throw (Throwable)new IllegalStateException("File version did not match");
        }
        block12: while ((headerType = input.readByte()) != 0) {
            switch (headerType) {
                case 1: {
                    KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 2: {
                    this.setCipherUuid(KdbxHeaderKt.access$readHeaderData(input));
                    continue block12;
                }
                case 3: {
                    this.compressionFlags = CompressionFlags.values()[KdbxHeaderKt.access$readIntHeaderData(input)];
                    continue block12;
                }
                case 4: {
                    this.masterSeed = KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 5: {
                    this.transformSeed = KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 6: {
                    this.transformRounds = KdbxHeaderKt.access$readLongHeaderData(input);
                    continue block12;
                }
                case 7: {
                    this.encryptionIv = KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 8: {
                    this.protectedStreamKey = KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 9: {
                    this.streamStartBytes = KdbxHeaderKt.access$readHeaderData(input);
                    continue block12;
                }
                case 10: {
                    this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.values()[KdbxHeaderKt.access$readIntHeaderData(input)];
                    continue block12;
                }
            }
            throw (Throwable)new IllegalStateException("Unknown File Header");
        }
        KdbxHeaderKt.access$readHeaderData(input);
        this.headerHash = digest.digest();
    }

    public final void writeKdbxHeader(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        MessageDigest messageDigest = DigestUtil.sha256();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream, messageDigest);
        LittleEndianDataOutputStream output2 = new LittleEndianDataOutputStream((OutputStream)digestOutputStream);
        output2.writeInt(-1700603645);
        output2.writeInt(-1253311641);
        output2.writeInt(196609);
        output2.writeByte(2);
        output2.writeShort(16);
        byte[] b = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(b);
        UUID uUID = this.cipherUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"cipherUuid");
        bb.putLong(uUID.getMostSignificantBits());
        UUID uUID2 = this.cipherUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"cipherUuid");
        bb.putLong(8, uUID2.getLeastSignificantBits());
        output2.write(b);
        output2.writeByte(3);
        output2.writeShort(4);
        output2.writeInt(this.compressionFlags.ordinal());
        output2.writeByte(4);
        output2.writeShort(this.masterSeed.length);
        output2.write(this.masterSeed);
        output2.writeByte(5);
        output2.writeShort(this.transformSeed.length);
        output2.write(this.transformSeed);
        output2.writeByte(6);
        output2.writeShort(8);
        output2.writeLong(this.transformRounds);
        output2.writeByte(7);
        output2.writeShort(this.encryptionIv.length);
        output2.write(this.encryptionIv);
        output2.writeByte(8);
        output2.writeShort(this.protectedStreamKey.length);
        output2.write(this.protectedStreamKey);
        output2.writeByte(9);
        output2.writeShort(this.streamStartBytes.length);
        output2.write(this.streamStartBytes);
        output2.writeByte(10);
        output2.writeShort(4);
        output2.writeInt(this.protectedStreamAlgorithm.ordinal());
        output2.writeByte(0);
        output2.writeShort(0);
        this.headerHash = digestOutputStream.getMessageDigest().digest();
    }

    public KdbxHeader() {
        this.cipherUuid = KdbxHeaderKt.access$getAES_CIPHER$p();
        this.compressionFlags = CompressionFlags.GZIP;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"ArrayUtilRt.EMPTY_BYTE_ARRAY");
        this.masterSeed = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"ArrayUtilRt.EMPTY_BYTE_ARRAY");
        this.transformSeed = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.transformRounds = 6000L;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"ArrayUtilRt.EMPTY_BYTE_ARRAY");
        this.encryptionIv = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"ArrayUtilRt.EMPTY_BYTE_ARRAY");
        this.protectedStreamKey = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.SALSA_20;
        this.streamStartBytes = new byte[32];
    }

    public KdbxHeader(@NotNull InputStream inputStream2) {
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        this();
        this.readKdbxHeader(inputStream2);
    }

    public KdbxHeader(@NotNull SecureRandom random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this();
        this.masterSeed = CredentialStoreKt.generateBytes(random, 32);
        this.transformSeed = CredentialStoreKt.generateBytes(random, 32);
        this.encryptionIv = CredentialStoreKt.generateBytes(random, 16);
        this.protectedStreamKey = KdbxHeaderKt.createProtectedStreamKey(random);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "", "(Ljava/lang/String;I)V", "NONE", "GZIP", "intellij.platform.credentialStore"})
    public static final class CompressionFlags
    extends Enum<CompressionFlags> {
        public static final /* enum */ CompressionFlags NONE;
        public static final /* enum */ CompressionFlags GZIP;
        private static final /* synthetic */ CompressionFlags[] $VALUES;

        static {
            CompressionFlags[] compressionFlagsArray = new CompressionFlags[2];
            CompressionFlags[] compressionFlagsArray2 = compressionFlagsArray;
            compressionFlagsArray[0] = NONE = new CompressionFlags();
            compressionFlagsArray[1] = GZIP = new CompressionFlags();
            $VALUES = compressionFlagsArray;
        }

        public static CompressionFlags[] values() {
            return (CompressionFlags[])$VALUES.clone();
        }

        public static CompressionFlags valueOf(String string) {
            return Enum.valueOf(CompressionFlags.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "", "(Ljava/lang/String;I)V", "NONE", "ARC_FOUR", "SALSA_20", "intellij.platform.credentialStore"})
    public static final class ProtectedStreamAlgorithm
    extends Enum<ProtectedStreamAlgorithm> {
        public static final /* enum */ ProtectedStreamAlgorithm NONE;
        public static final /* enum */ ProtectedStreamAlgorithm ARC_FOUR;
        public static final /* enum */ ProtectedStreamAlgorithm SALSA_20;
        private static final /* synthetic */ ProtectedStreamAlgorithm[] $VALUES;

        static {
            ProtectedStreamAlgorithm[] protectedStreamAlgorithmArray = new ProtectedStreamAlgorithm[3];
            ProtectedStreamAlgorithm[] protectedStreamAlgorithmArray2 = protectedStreamAlgorithmArray;
            protectedStreamAlgorithmArray[0] = NONE = new ProtectedStreamAlgorithm();
            protectedStreamAlgorithmArray[1] = ARC_FOUR = new ProtectedStreamAlgorithm();
            protectedStreamAlgorithmArray[2] = SALSA_20 = new ProtectedStreamAlgorithm();
            $VALUES = protectedStreamAlgorithmArray;
        }

        public static ProtectedStreamAlgorithm[] values() {
            return (ProtectedStreamAlgorithm[])$VALUES.clone();
        }

        public static ProtectedStreamAlgorithm valueOf(String string) {
            return Enum.valueOf(ProtectedStreamAlgorithm.class, string);
        }
    }
}

