/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.KWallet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.errors.NoReply;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J%\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0082\bJ\u001b\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/credentialStore/KWalletCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "Ljava/io/Closeable;", "connection", "Lorg/freedesktop/dbus/connections/impl/DBusConnection;", "kWallet", "Lcom/intellij/credentialStore/KWallet;", "(Lorg/freedesktop/dbus/connections/impl/DBusConnection;Lcom/intellij/credentialStore/KWallet;)V", "appId", "", "cachedWalletId", "", "cachedWalletName", "suggestedCreation", "close", "", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getWalletId", "handleError", "run", "Lkotlin/Function0;", "handle", "set", "credentials", "Companion", "intellij.platform.credentialStore"})
public final class KWalletCredentialStore
implements CredentialStore,
Closeable {
    private final String appId;
    private int cachedWalletId;
    private String cachedWalletName;
    private String suggestedCreation;
    private final DBusConnection connection;
    private final KWallet kWallet;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final int getWalletId() {
        boolean isNew;
        String walletName;
        if (this.cachedWalletId != -1 && this.kWallet.isOpen(this.cachedWalletId)) {
            String string = this.cachedWalletName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (this.kWallet.users(it).contains(this.appId)) {
                    return this.cachedWalletId;
                }
            }
        }
        this.cachedWalletName = walletName = this.kWallet.localWallet();
        List<String> wallets = this.kWallet.wallets();
        boolean bl = isNew = !CollectionsKt.contains((Iterable)wallets, (Object)walletName);
        if (walletName == null || isNew && Intrinsics.areEqual((Object)this.suggestedCreation, (Object)walletName)) {
            return -1;
        }
        this.cachedWalletId = this.kWallet.open(walletName, 0L, this.appId);
        if (isNew) {
            this.suggestedCreation = walletName;
        }
        return this.cachedWalletId;
    }

    private final void handleError(Function0<Unit> run2, Function0<Unit> handle2) {
        int $i$f$handleError = 0;
        try {
            run2.invoke();
        }
        catch (NoReply e) {
            handle2.invoke();
        }
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        KWalletCredentialStore this_$iv = this;
        boolean $i$f$handleError = false;
        try {
            boolean bl = false;
            int walletId = this.getWalletId();
            if (walletId == -1) {
                return CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED();
            }
            String userName = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            String string = attributes.getServiceName();
            String string2 = userName;
            if (string2 == null) {
                string2 = "*";
            }
            Map<String, Variant<String>> passwords = this.kWallet.readPasswordList(walletId, string, string2, this.appId);
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)passwords.entrySet());
            if (entry == null) {
                return null;
            }
            Map.Entry e = entry;
            return new Credentials((String)e.getKey(), (String)((Variant)e.getValue()).getValue());
        }
        catch (NoReply e$iv) {
            boolean bl = false;
            return CredentialStoreKt.getCANNOT_UNLOCK_KEYCHAIN();
        }
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials2) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        KWalletCredentialStore this_$iv = this;
        boolean $i$f$handleError = false;
        try {
            String accountName;
            boolean bl = false;
            int walletId = this.getWalletId();
            if (walletId == -1) {
                return;
            }
            String string = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            if (string == null) {
                Credentials credentials3 = credentials2;
                string = accountName = credentials3 != null ? credentials3.getUserName() : null;
            }
            if (CredentialAttributesKt.isEmpty((Credentials)credentials2)) {
                this.kWallet.removeFolder(walletId, attributes.getServiceName(), this.appId);
            } else {
                Object object;
                String string2 = attributes.getServiceName();
                String string3 = accountName;
                if (string3 == null) {
                    string3 = "";
                }
                if ((object = credentials2) == null || (object = object.getPassword()) == null || (object = object.toString()) == null) {
                    object = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"credentials?.password?.toString() ?: \"\"");
                this.kWallet.writePassword(walletId, string2, string3, (String)object, this.appId);
            }
        }
        catch (NoReply e$iv) {
            boolean bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = (Closeable)this.connection;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DBusConnection it = (DBusConnection)closeable;
            boolean bl3 = false;
            if (this.cachedWalletId != -1) {
                this.kWallet.close(this.cachedWalletId, false, this.appId);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private KWalletCredentialStore(DBusConnection connection, KWallet kWallet) {
        this.connection = connection;
        this.kWallet = kWallet;
        this.appId = KWalletCredentialStore.Companion.appName();
        this.cachedWalletId = -1;
    }

    public /* synthetic */ KWalletCredentialStore(DBusConnection connection, KWallet kWallet, DefaultConstructorMarker $constructor_marker) {
        this(connection, kWallet);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/credentialStore/KWalletCredentialStore$Companion;", "", "()V", "appName", "", "create", "Lcom/intellij/credentialStore/KWalletCredentialStore;", "intellij.platform.credentialStore"})
    public static final class Companion {
        private final String appName() {
            String appName;
            String string;
            String string2;
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isUnitTestMode()) {
                string2 = null;
            } else {
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                string2 = applicationInfo.getFullApplicationName();
            }
            if ((string = (appName = string2)) == null) {
                string = "IDEA tests";
            }
            return string;
        }

        @Nullable
        public final KWalletCredentialStore create() {
            try {
                DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
                try {
                    KWallet wallet = (KWallet)connection.getRemoteObject("org.kde.kwalletd5", "/modules/kwalletd5", KWallet.class, true);
                    wallet.localWallet();
                    DBusConnection dBusConnection = connection;
                    Intrinsics.checkNotNullExpressionValue((Object)dBusConnection, (String)"connection");
                    KWallet kWallet = wallet;
                    Intrinsics.checkNotNullExpressionValue((Object)kWallet, (String)"wallet");
                    return new KWalletCredentialStore(dBusConnection, kWallet, null);
                }
                catch (ServiceUnknown e) {
                    CredentialStoreKt.getLOG().info("No KWallet service", (Throwable)e);
                }
                catch (DBusException e) {
                    CredentialStoreKt.getLOG().warn("Failed to connect to KWallet", (Throwable)e);
                }
                catch (RuntimeException e) {
                    CredentialStoreKt.getLOG().warn("Failed to connect to KWallet", (Throwable)e);
                }
                connection.close();
            }
            catch (DBusException e) {
                CredentialStoreKt.getLOG().warn("Failed to connect to D-Bus", (Throwable)e);
            }
            catch (RuntimeException e) {
                CredentialStoreKt.getLOG().warn("Failed to connect to D-Bus", (Throwable)e);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

