/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.AesEncryptionSupport;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.EncryptionSupportKt$WhenMappings;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PgpKeyEncryptionSupport;
import com.intellij.credentialStore.WindowsCrypt32EncryptionSupport;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0019\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\b\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"builtInEncryptionKey", "Ljavax/crypto/spec/SecretKeySpec;", "createBuiltInOrCrypt32EncryptionSupport", "Lcom/intellij/credentialStore/EncryptionSupport;", "isCrypt32", "", "createEncryptionSupport", "spec", "Lcom/intellij/credentialStore/EncryptionSpec;", "getDefaultEncryptionType", "Lcom/intellij/credentialStore/EncryptionType;", "toByteArrayAndClear", "", "", "intellij.platform.credentialStore"})
public final class EncryptionSupportKt {
    private static final SecretKeySpec builtInEncryptionKey = new SecretKeySpec(new byte[]{80, 114, (byte)111, (byte)120, (byte)121, (byte)32, (byte)67, (byte)111, (byte)110, (byte)102, (byte)105, (byte)103, (byte)32, (byte)83, (byte)101, (byte)99}, "AES");

    @NotNull
    public static final EncryptionType getDefaultEncryptionType() {
        return SystemInfo.isWindows ? EncryptionType.CRYPT_32 : EncryptionType.BUILT_IN;
    }

    @NotNull
    public static final EncryptionSupport createEncryptionSupport(@NotNull EncryptionSpec spec) {
        EncryptionSupport encryptionSupport;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        switch (EncryptionSupportKt$WhenMappings.$EnumSwitchMapping$0[spec.getType().ordinal()]) {
            case 1: {
                encryptionSupport = EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(false);
                break;
            }
            case 2: {
                encryptionSupport = EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(true);
                break;
            }
            case 3: {
                encryptionSupport = new PgpKeyEncryptionSupport(spec);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return encryptionSupport;
    }

    @NotNull
    public static final EncryptionSupport createBuiltInOrCrypt32EncryptionSupport(boolean isCrypt32) {
        if (isCrypt32) {
            if (!SystemInfo.isWindows) {
                throw (Throwable)new IllegalArgumentException("Crypt32 encryption is supported only on Windows");
            }
            if (JnaLoader.isLoaded()) {
                return new WindowsCrypt32EncryptionSupport(builtInEncryptionKey);
            }
        }
        return new AesEncryptionSupport(builtInEncryptionKey);
    }

    @NotNull
    public static final byte[] toByteArrayAndClear(@NotNull char[] $this$toByteArrayAndClear) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArrayAndClear, (String)"$this$toByteArrayAndClear");
        CharBuffer charBuffer = CharBuffer.wrap($this$toByteArrayAndClear);
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(charBuffer);
        ArraysKt.fill$default((char[])$this$toByteArrayAndClear, (char)((char)0), (int)0, (int)0, (int)6, null);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"byteBuffer");
        return IoKt.toByteArray((ByteBuffer)byteBuffer2, (boolean)true);
    }
}

