/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProjectConversionUtil {
    @NonNls
    public static final String PROJECT_FILES_BACKUP = "projectFilesBackup";
    @NonNls
    private static final String BACKUP_EXTENSION = "backup";

    private ProjectConversionUtil() {
    }

    public static File backupFile(@NotNull Path file2) throws IOException {
        if (file2 == null) {
            ProjectConversionUtil.$$$reportNull$$$0(0);
        }
        String fileName = FileUtil.createSequentFileName((File)file2.getParent().toFile(), (String)file2.getFileName().toString(), (String)BACKUP_EXTENSION);
        File backup = file2.getParent().resolve(fileName).toFile();
        FileUtil.copy((File)file2.toFile(), (File)backup);
        return backup;
    }

    @NotNull
    public static Path backupFiles(@NotNull Collection<? extends Path> files2, @NotNull Path parentDir) throws IOException {
        if (files2 == null) {
            ProjectConversionUtil.$$$reportNull$$$0(1);
        }
        if (parentDir == null) {
            ProjectConversionUtil.$$$reportNull$$$0(2);
        }
        Path backupDir = ProjectConversionUtil.getBackupDir(parentDir);
        ProjectConversionUtil.backupFiles(files2, parentDir, backupDir);
        Path path = backupDir;
        if (path == null) {
            ProjectConversionUtil.$$$reportNull$$$0(3);
        }
        return path;
    }

    public static void backupFiles(@NotNull Collection<? extends Path> files2, @NotNull Path parentDir, @NotNull Path backupDir) throws IOException {
        if (files2 == null) {
            ProjectConversionUtil.$$$reportNull$$$0(4);
        }
        if (parentDir == null) {
            ProjectConversionUtil.$$$reportNull$$$0(5);
        }
        if (backupDir == null) {
            ProjectConversionUtil.$$$reportNull$$$0(6);
        }
        Files.createDirectories(backupDir, new FileAttribute[0]);
        for (Path path : files2) {
            Path targetFile;
            if (path.startsWith(parentDir)) {
                targetFile = backupDir.resolve(parentDir.relativize(path));
                Path parent = targetFile.getParent();
                if (parent != backupDir) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
            } else {
                targetFile = backupDir.resolve(path.getFileName());
            }
            try {
                Files.copy(path, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
    }

    @NotNull
    public static Path getBackupDir(@NotNull Path parentDir) {
        if (parentDir == null) {
            ProjectConversionUtil.$$$reportNull$$$0(7);
        }
        String dirName = FileUtil.createSequentFileName((File)parentDir.toFile(), (String)PROJECT_FILES_BACKUP, (String)"");
        Path path = parentDir.resolve(dirName);
        if (path == null) {
            ProjectConversionUtil.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ProjectConversionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backupDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ProjectConversionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backupFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackupDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "backupFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "backupFiles";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBackupDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

