/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventScheduler;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventSchedulerKt;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEvents;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a,\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a<\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"EDT_EXECUTOR", "Ljava/util/concurrent/Executor;", "INITIAL_DELAY", "", "PERIOD_DELAY", "logConfigStateEvents", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "logInitializedComponent", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/configurationStore/ComponentInfo;", "name", "", "logInitializedComponentsAndContinue", "components", "", "names", "Ljava/util/ArrayDeque;", "logInitializedProjectComponents", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "logProjectInitializedComponentsAndContinue", "projects", "intellij.platform.configurationStore.impl"})
public final class FeatureUsageSettingsEventSchedulerKt {
    private static final int PERIOD_DELAY = 1440;
    private static final int INITIAL_DELAY = 1440;
    private static final Executor EDT_EXECUTOR = EDT_EXECUTOR.1.INSTANCE;

    private static final CompletableFuture<Void> logConfigStateEvents() {
        ProjectManagerEx projectManager;
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        CompletableFuture<Void> applicationCompletableFuture = FeatureUsageSettingsEventSchedulerKt.logInitializedProjectComponents((ComponentManager)application);
        ProjectManagerEx projectManagerEx = projectManager = ProjectManagerEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)projectManagerEx), (String)"projectManager");
        Object[] objectArray = projectManagerEx.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"projectManager.openProjects");
        ArrayDeque<Project> projects = new ArrayDeque<Project>(ArraysKt.toList((Object[])objectArray));
        if (projectManager.isDefaultProjectInitialized()) {
            projects.addFirst(projectManager.getDefaultProject());
        }
        CompletableFuture<Void> projectCompletableFuture = FeatureUsageSettingsEventSchedulerKt.logProjectInitializedComponentsAndContinue(projects);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(applicationCompletableFuture, projectCompletableFuture);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.allOf(\u2026projectCompletableFuture)");
        return completableFuture;
    }

    private static final CompletableFuture<Void> logProjectInitializedComponentsAndContinue(ArrayDeque<Project> projects) {
        Project project = projects.pollFirst();
        if (project == null || !project.isInitialized() || project.isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        CompletionStage completionStage = FeatureUsageSettingsEventSchedulerKt.logInitializedProjectComponents((ComponentManager)project).thenCompose(new Function<Void, CompletionStage<Void>>(projects){
            final /* synthetic */ ArrayDeque $projects;

            public final CompletionStage<Void> apply(@Nullable Void it) {
                return FeatureUsageSettingsEventSchedulerKt.access$logProjectInitializedComponentsAndContinue(this.$projects);
            }
            {
                this.$projects = arrayDeque;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"logInitializedProjectCom\u2026ontinue(projects)\n      }");
        return completionStage;
    }

    private static final CompletableFuture<Void> logInitializedProjectComponents(ComponentManager componentManager) {
        IComponentStore iComponentStore = ServiceKt.getStateStore(componentManager);
        if (!(iComponentStore instanceof ComponentStoreImpl)) {
            iComponentStore = null;
        }
        ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
        if (componentStoreImpl == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        ComponentStoreImpl stateStore = componentStoreImpl;
        Map<String, ComponentInfo> components = stateStore.getComponents$intellij_platform_configurationStore_impl();
        ComponentManager componentManager2 = componentManager;
        if (!(componentManager2 instanceof Project)) {
            componentManager2 = null;
        }
        return FeatureUsageSettingsEventSchedulerKt.logInitializedComponentsAndContinue((Project)componentManager2, components, new ArrayDeque<String>((Collection)components.keySet()));
    }

    private static final CompletableFuture<Void> logInitializedComponentsAndContinue(Project project, Map<String, ? extends ComponentInfo> components, ArrayDeque<String> names2) {
        CompletableFuture<Void> completableFuture;
        while (true) {
            String nextComponentName;
            if (names2.pollFirst() == null) {
                CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.completedFuture(null)");
                return completableFuture2;
            }
            ComponentInfo componentInfo = components.get(nextComponentName);
            if (componentInfo == null) {
                continue;
            }
            completableFuture = FeatureUsageSettingsEventSchedulerKt.logInitializedComponent(project, componentInfo, nextComponentName);
            if (completableFuture != null) break;
        }
        CompletableFuture<Void> future2 = completableFuture;
        CompletionStage completionStage = future2.thenCompose(new Function<Void, CompletionStage<Void>>(project, components, names2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Map $components;
            final /* synthetic */ ArrayDeque $names;

            public final CompletionStage<Void> apply(@Nullable Void it) {
                return FeatureUsageSettingsEventSchedulerKt.access$logInitializedComponentsAndContinue(this.$project, this.$components, this.$names);
            }
            {
                this.$project = project;
                this.$components = map2;
                this.$names = arrayDeque;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"future\n      .thenCompos\u2026omponents, names)\n      }");
        return completionStage;
    }

    private static final CompletableFuture<Void> logInitializedComponent(Project project, ComponentInfo info, String name) {
        State stateSpec = info.getStateSpec();
        if (stateSpec == null || !stateSpec.reportStatistic()) {
            return null;
        }
        Object object = info.getComponent();
        if (!(object instanceof PersistentStateComponent)) {
            object = null;
        }
        PersistentStateComponent persistentStateComponent = (PersistentStateComponent)object;
        if (persistentStateComponent == null) {
            return null;
        }
        PersistentStateComponent component2 = persistentStateComponent;
        return CompletableFuture.runAsync(new Runnable(component2, name, project){
            final /* synthetic */ PersistentStateComponent $component;
            final /* synthetic */ String $name;
            final /* synthetic */ Project $project;

            public final void run() {
                try {
                    Object object = this.$component.getState();
                    if (object != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        FeatureUsageSettingsEvents.INSTANCE.logConfigurationState(this.$name, it, this.$project);
                    }
                }
                catch (Exception e) {
                    FeatureUsageSettingsEventScheduler.Companion.getLOG().warn("Error during configuration recording", (Throwable)e);
                }
            }
            {
                this.$component = persistentStateComponent;
                this.$name = string;
                this.$project = project;
            }
        }, EDT_EXECUTOR);
    }

    public static final /* synthetic */ CompletableFuture access$logConfigStateEvents() {
        return FeatureUsageSettingsEventSchedulerKt.logConfigStateEvents();
    }

    public static final /* synthetic */ CompletableFuture access$logProjectInitializedComponentsAndContinue(ArrayDeque projects) {
        return FeatureUsageSettingsEventSchedulerKt.logProjectInitializedComponentsAndContinue(projects);
    }

    public static final /* synthetic */ CompletableFuture access$logInitializedComponentsAndContinue(Project project, Map components, ArrayDeque names2) {
        return FeatureUsageSettingsEventSchedulerKt.logInitializedComponentsAndContinue(project, components, names2);
    }
}

