/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u00020\u0002B=\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007J(\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002J\u0017\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\"\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u001d\u0010%\u001a\u00020\f2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+\u00a2\u0006\u0002\u0010,J\u0013\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00028\u0001\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\nH\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "T", "", "MUTABLE_SCHEME", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "oldSchemes", "", "preScheduledFilesToDelete", "", "", "isDuringLoad", "", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Ljava/util/List;Ljava/util/Set;Z)V", "digest", "Ljava/security/MessageDigest;", "filesToDelete", "isApplied", "Ljava/util/concurrent/atomic/AtomicBoolean;", "newSchemesOffset", "", "schemeToInfo", "Ljava/util/IdentityHashMap;", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "schemes", "", "apply", "checkExisting", "schemeKey", "fileName", "fileNameWithoutExtension", "extension", "getDigest", "getInfoForExistingScheme", "existingScheme", "(Ljava/lang/Object;)Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "isFileScheduledForDeleteInThisLoadSession", "isFromFileWithNewExtension", "(Ljava/lang/Object;Ljava/lang/String;)Z", "loadScheme", "input", "Ljava/io/InputStream;", "preloadedBytes", "", "(Ljava/lang/String;Ljava/io/InputStream;[B)Ljava/lang/Object;", "removeUpdatedScheme", "", "changedScheme", "(Ljava/lang/Object;)V", "retainProbablyScheduledForDeleteFile", "intellij.platform.configurationStore.impl"})
public final class SchemeLoader<T, MUTABLE_SCHEME extends T> {
    private final Set<String> filesToDelete;
    private final List<T> schemes;
    private int newSchemesOffset;
    private final IdentityHashMap<T, ExternalInfo> schemeToInfo;
    private final AtomicBoolean isApplied;
    private MessageDigest digest;
    private final SchemeManagerImpl<T, MUTABLE_SCHEME> schemeManager;
    private final List<T> oldSchemes;
    private final Set<String> preScheduledFilesToDelete;
    private final boolean isDuringLoad;

    private final ExternalInfo getInfoForExistingScheme(T existingScheme) {
        ExternalInfo externalInfo = this.schemeToInfo.get(existingScheme);
        if (externalInfo == null) {
            externalInfo = (ExternalInfo)this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl().get(existingScheme);
        }
        return externalInfo;
    }

    private final boolean isFromFileWithNewExtension(T existingScheme, String fileNameWithoutExtension) {
        ExternalInfo externalInfo = this.getInfoForExistingScheme(existingScheme);
        return Intrinsics.areEqual((Object)(externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null), (Object)fileNameWithoutExtension);
    }

    @NotNull
    public final List<T> apply() {
        block8: {
            block7: {
                ComponentStoreImplKt.getLOG().assertTrue(this.isApplied.compareAndSet(false, true));
                Collection collection = this.filesToDelete;
                boolean bl = false;
                if (!collection.isEmpty()) break block7;
                collection = this.preScheduledFilesToDelete;
                bl = false;
                if (!(!collection.isEmpty())) break block8;
            }
            Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Schedule to delete: " + CollectionsKt.joinToString$default((Iterable)this.filesToDelete, null, null, null, (int)0, null, null, (int)63, null) + " (and preScheduledFilesToDelete: " + CollectionsKt.joinToString$default((Iterable)this.preScheduledFilesToDelete, null, null, null, (int)0, null, null, (int)63, null) + ')';
                logger.debug(string, (Throwable)e$iv);
            }
            this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl().addAll((Collection<String>)this.filesToDelete);
            this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl().addAll((Collection<String>)this.preScheduledFilesToDelete);
        }
        this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl().putAll((Map)this.schemeToInfo);
        List<T> result2 = this.schemes.subList(this.newSchemesOffset, this.schemes.size());
        this.schemeManager.getSchemeListManager$intellij_platform_configurationStore_impl().replaceSchemeList(this.oldSchemes, this.schemes);
        if (!this.isDuringLoad) {
            Iterator<T> iterator2 = result2.iterator();
            while (iterator2.hasNext()) {
                T newScheme;
                T t = newScheme = iterator2.next();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type MUTABLE_SCHEME");
                }
                this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onSchemeAdded(t);
            }
        }
        return result2;
    }

    private final MessageDigest getDigest() {
        MessageDigest result2 = this.digest;
        if (result2 == null) {
            this.digest = result2 = Scheme_implKt.createDataDigest();
        } else {
            result2.reset();
        }
        return result2;
    }

    private final boolean checkExisting(String schemeKey, String fileName, String fileNameWithoutExtension, String extension2) {
        ExternalInfo existingInfo;
        int n;
        int index$iv;
        int $i$f$indexOfFirst;
        SchemeProcessor processor2;
        block10: {
            processor2 = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
            List<T> $this$indexOfFirst$iv = this.schemes;
            $i$f$indexOfFirst = 0;
            index$iv = 0;
            Iterator<T> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                T item$iv;
                T it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)processor2.getSchemeKey(it), (Object)schemeKey)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = -1;
        }
        int existingSchemeIndex = n;
        T t = existingSchemeIndex == -1 ? null : (T)this.schemes.get(existingSchemeIndex);
        if (t == null) {
            return true;
        }
        T existingScheme = t;
        if (this.schemeManager.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(processor2.getSchemeKey(existingScheme)) == existingScheme) {
            this.schemes.remove(existingSchemeIndex);
            if (existingSchemeIndex < this.newSchemesOffset) {
                $i$f$indexOfFirst = this.newSchemesOffset;
                this.newSchemesOffset = $i$f$indexOfFirst + -1;
            }
            return true;
        }
        if (processor2.isExternalizable(existingScheme) && (existingInfo = this.getInfoForExistingScheme(existingScheme)) != null && Intrinsics.areEqual((Object)this.schemeManager.getSchemeExtension$intellij_platform_configurationStore_impl(), (Object)existingInfo.getFileExtension()) ^ true) {
            this.schemeToInfo.remove(existingScheme);
            existingInfo.scheduleDelete(this.filesToDelete, "from file with old extension");
            this.schemes.remove(existingSchemeIndex);
            if (existingSchemeIndex < this.newSchemesOffset) {
                index$iv = this.newSchemesOffset;
                this.newSchemesOffset = index$iv + -1;
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)this.schemeManager.getSchemeExtension$intellij_platform_configurationStore_impl(), (Object)extension2) ^ true && this.isFromFileWithNewExtension(existingScheme, fileNameWithoutExtension)) {
            Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Schedule to delete: " + fileName + " (reason: extension mismatch)";
                logger.debug(string, (Throwable)e$iv);
            }
            this.filesToDelete.add(fileName);
        } else {
            ComponentStoreImplKt.getLOG().warn("Scheme file \"" + fileName + "\" is not loaded because defines duplicated name \"" + schemeKey + '\"');
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MUTABLE_SCHEME loadScheme(@NotNull String fileName, @Nullable InputStream input, @Nullable byte[] preloadedBytes) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String extension2 = this.schemeManager.getFileExtension$intellij_platform_configurationStore_impl(fileName, false);
        if (this.isFileScheduledForDeleteInThisLoadSession(fileName)) {
            ComponentStoreImplKt.getLOG().warn("Scheme file \"" + fileName + "\" is not loaded because marked to delete");
            return null;
        }
        SchemeProcessor processor2 = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        String string = fileName;
        int n = 0;
        int n2 = fileName.length() - extension2.length();
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String fileNameWithoutExtension = string2;
        Function2<String, Element, ExternalInfo> $fun$createInfo$1 = new Function2<String, Element, ExternalInfo>(this, fileNameWithoutExtension, extension2){
            final /* synthetic */ SchemeLoader this$0;
            final /* synthetic */ String $fileNameWithoutExtension;
            final /* synthetic */ String $extension;

            @NotNull
            public final ExternalInfo invoke(@NotNull String schemeName, @Nullable Element element2) {
                Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
                ExternalInfo info = new ExternalInfo(this.$fileNameWithoutExtension, this.$extension);
                if (element2 != null) {
                    info.setDigest(Scheme_implKt.digest(element2, SchemeLoader.access$getDigest(this.this$0)));
                }
                info.setSchemeKey(schemeName);
                return info;
            }
            {
                this.this$0 = schemeLoader;
                this.$fileNameWithoutExtension = string;
                this.$extension = string2;
                super(2);
            }
        };
        Object scheme2 = null;
        if (processor2 instanceof LazySchemeProcessor) {
            void parser;
            byte[] byArray = preloadedBytes;
            if (preloadedBytes == null) {
                InputStream inputStream2 = input;
                Intrinsics.checkNotNull((Object)inputStream2);
                byArray = ByteStreamsKt.readBytes((InputStream)inputStream2);
            }
            byte[] bytes = byArray;
            boolean isOldSchemeNaming$iv = this.schemeManager.isOldSchemeNaming$intellij_platform_configurationStore_impl();
            boolean $i$f$lazyPreloadScheme = false;
            MXParser parser$iv = new MXParser();
            Object object = bytes;
            boolean bl2 = false;
            object = new ByteArrayInputStream((byte[])object);
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            parser$iv.setInput((Reader)new InputStreamReader((InputStream)object, charset));
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            boolean bl4 = false;
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(String it) {
                    return this.$parser.getEventType() == 2 ? this.$parser.getAttributeValue(null, it) : null;
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string3 = name;
            if (string3 == null) {
                string3 = ((LazySchemeProcessor)processor2).getSchemeKey(attributeProvider2, fileNameWithoutExtension);
            }
            if (string3 == null) {
                throw (Throwable)SchemeManagerUtilKt.nameIsMissed(bytes);
            }
            String schemeKey = string3;
            if (!this.checkExisting(schemeKey, fileName, fileNameWithoutExtension, extension2)) {
                return null;
            }
            ExternalInfo externalInfo = $fun$createInfo$1.invoke(schemeKey, null);
            Object object2 = scheme2 = LazySchemeProcessor.createScheme$default((LazySchemeProcessor)processor2, new SchemeDataHolderImpl(processor2, bytes, externalInfo), schemeKey, attributeProvider2, false, 8, null);
            Intrinsics.checkNotNull((Object)object2);
            this.schemeToInfo.put(object2, externalInfo);
            this.retainProbablyScheduledForDeleteFile(fileName);
        } else {
            Element element2;
            int n3;
            Object object;
            byte[] isOldSchemeNaming$iv = preloadedBytes;
            if (isOldSchemeNaming$iv == null) {
                InputStream inputStream3 = input;
                Intrinsics.checkNotNull((Object)inputStream3);
                object = inputStream3;
                n3 = 8192;
                boolean bl5 = false;
                element2 = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n3))));
            } else {
                object = preloadedBytes;
                n3 = 0;
                element2 = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)new ByteArrayInputStream((byte[])object)));
            }
            Element element3 = element2;
            SchemeProcessor schemeProcessor = processor2;
            if (schemeProcessor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.options.NonLazySchemeProcessor<T, MUTABLE_SCHEME>");
            }
            NonLazySchemeProcessor nonLazySchemeProcessor = (NonLazySchemeProcessor)schemeProcessor;
            Element element4 = element3;
            Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"element");
            Object MUTABLE_SCHEME = nonLazySchemeProcessor.readScheme(element4, this.isDuringLoad);
            if (MUTABLE_SCHEME == null) {
                return null;
            }
            Object object3 = scheme2 = (Object)MUTABLE_SCHEME;
            Intrinsics.checkNotNull(object3);
            String schemeKey = processor2.getSchemeKey(object3);
            if (!this.checkExisting(schemeKey, fileName, fileNameWithoutExtension, extension2)) {
                return null;
            }
            this.schemeToInfo.put(scheme2, $fun$createInfo$1.invoke(schemeKey, element3));
            this.retainProbablyScheduledForDeleteFile(fileName);
        }
        this.schemes.add(scheme2);
        return (MUTABLE_SCHEME)scheme2;
    }

    private final boolean isFileScheduledForDeleteInThisLoadSession(String fileName) {
        return this.filesToDelete.contains(fileName);
    }

    private final void retainProbablyScheduledForDeleteFile(String fileName) {
        this.filesToDelete.remove(fileName);
        this.preScheduledFilesToDelete.remove(fileName);
    }

    public final void removeUpdatedScheme(@NotNull MUTABLE_SCHEME changedScheme) {
        Intrinsics.checkNotNullParameter(changedScheme, (String)"changedScheme");
        int index2 = ContainerUtil.indexOfIdentity(this.schemes, changedScheme);
        if (ComponentStoreImplKt.getLOG().assertTrue(index2 >= 0)) {
            this.schemes.remove(index2);
            this.schemeToInfo.remove(changedScheme);
        }
    }

    public SchemeLoader(@NotNull SchemeManagerImpl<T, MUTABLE_SCHEME> schemeManager2, @NotNull List<? extends T> oldSchemes, @NotNull Set<String> preScheduledFilesToDelete, boolean isDuringLoad) {
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        Intrinsics.checkNotNullParameter(oldSchemes, (String)"oldSchemes");
        Intrinsics.checkNotNullParameter(preScheduledFilesToDelete, (String)"preScheduledFilesToDelete");
        this.schemeManager = schemeManager2;
        this.oldSchemes = oldSchemes;
        this.preScheduledFilesToDelete = preScheduledFilesToDelete;
        this.isDuringLoad = isDuringLoad;
        this.filesToDelete = new HashSet();
        this.schemes = CollectionsKt.toMutableList((Collection)this.oldSchemes);
        this.newSchemesOffset = this.schemes.size();
        this.schemeToInfo = new IdentityHashMap();
        this.isApplied = new AtomicBoolean();
    }

    public static final /* synthetic */ MessageDigest access$getDigest(SchemeLoader $this) {
        return $this.getDigest();
    }
}

