/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreReloadManagerImpl;
import com.intellij.configurationStore.schemeManager.AddScheme;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.UpdateScheme;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/openapi/project/Project;)V", "applicator", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "handleDirectoryCreated", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCreateEvent;", "list", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "handleDirectoryDeleted", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/util/SmartList;", "isMyDirectory", "", "parent", "isMyFileWithoutParentCheck", "intellij.platform.configurationStore.impl"})
public final class SchemeFileTracker
implements BulkFileListener {
    private final SchemeChangeApplicator applicator;
    private final SchemeManagerImpl<Object, Object> schemeManager;
    private final Project project;

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        SmartList list2 = new SmartList();
        for (VFileEvent collection : events) {
            VirtualFile file2;
            String string;
            boolean bl;
            Logger logger;
            boolean $i$f$debug;
            Exception e$iv;
            Logger $this$debug$iv;
            if (collection.getRequestor() instanceof SchemeManagerImpl) continue;
            VFileEvent vFileEvent = collection;
            if (vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file22;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileContentChangeEvent)collection).getFile(), (String)"event.file");
                if (!this.isMyFileWithoutParentCheck(file22) || file22.getParent() == null) continue;
                VirtualFile virtualFile = file22.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
                if (!this.isMyDirectory(virtualFile)) continue;
                $this$debug$iv = ComponentStoreImplKt.getLOG();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    logger = $this$debug$iv;
                    bl = false;
                    string = "CHANGED " + file22.getPath();
                    logger.debug(string, (Throwable)e$iv);
                }
                list2.add((Object)new UpdateScheme(file22));
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                if (((VFileCreateEvent)collection).isDirectory()) {
                    this.handleDirectoryCreated((VFileCreateEvent)collection, (List)list2);
                    continue;
                }
                String string2 = ((VFileCreateEvent)collection).getChildName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.childName");
                if (!this.schemeManager.canRead(string2)) continue;
                VirtualFile virtualFile = ((VFileCreateEvent)collection).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.parent");
                if (!this.isMyDirectory(virtualFile)) continue;
                VirtualFile virtualFile2 = ((VFileCreateEvent)collection).getFile();
                $this$debug$iv = ComponentStoreImplKt.getLOG();
                Exception e$iv22 = null;
                $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    logger = $this$debug$iv;
                    bl = false;
                    string = "CREATED " + ((VFileCreateEvent)collection).getPath() + " (virtualFile: " + (virtualFile2 == null ? "not " : "") + "found)";
                    logger.debug(string, (Throwable)e$iv22);
                }
                VirtualFile virtualFile3 = virtualFile2;
                if (virtualFile3 != null) {
                    $this$debug$iv = virtualFile3;
                    boolean e$iv22 = false;
                    $i$f$debug = false;
                    Logger it = $this$debug$iv;
                    bl = false;
                    list2.add((Object)new AddScheme((VirtualFile)it));
                }
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((VFileDeleteEvent)collection).getFile(), (String)"event.file");
            if (file2.isDirectory()) {
                this.handleDirectoryDeleted(file2, (SmartList<SchemeChangeEvent>)list2);
                continue;
            }
            if (!this.isMyFileWithoutParentCheck(file2)) continue;
            VirtualFile virtualFile = file2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
            if (!this.isMyDirectory(virtualFile)) continue;
            $this$debug$iv = ComponentStoreImplKt.getLOG();
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                bl = false;
                string = "DELETED " + file2.getPath();
                logger.debug(string, (Throwable)e$iv);
            }
            String string3 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            list2.add((Object)new RemoveScheme(string3));
        }
        Collection collection = (Collection)list2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StoreReloadManager storeReloadManager = StoreReloadManager.Companion.getInstance();
            if (storeReloadManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.StoreReloadManagerImpl");
            }
            ((StoreReloadManagerImpl)storeReloadManager).registerChangedSchemes$intellij_platform_configurationStore_impl((List)list2, this.applicator, this.project);
        }
    }

    private final boolean isMyFileWithoutParentCheck(VirtualFile file2) {
        CharSequence charSequence = file2.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"file.nameSequence");
        return this.schemeManager.canRead(charSequence);
    }

    private final boolean isMyDirectory(VirtualFile parent) {
        VirtualFile virtualDirectory = this.schemeManager.getCachedVirtualDirectory$intellij_platform_configurationStore_impl();
        VirtualFile virtualFile = virtualDirectory;
        return virtualFile == null ? Intrinsics.areEqual((Object)PathKt.getSystemIndependentPath((Path)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl()), (Object)parent.getPath()) : Intrinsics.areEqual((Object)virtualDirectory, (Object)parent);
    }

    private final void handleDirectoryDeleted(VirtualFile file2, SmartList<SchemeChangeEvent> list2) {
        if (!StringUtil.equals((CharSequence)file2.getNameSequence(), (CharSequence)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString())) {
            return;
        }
        Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "DIR DELETED " + file2.getPath();
            logger.debug(string, (Throwable)e$iv);
        }
        if (Intrinsics.areEqual((Object)file2, (Object)this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.READ))) {
            list2.add((Object)new RemoveAllSchemes());
        }
    }

    private final void handleDirectoryCreated(VFileCreateEvent event, List<SchemeChangeEvent> list2) {
        if (Intrinsics.areEqual((Object)event.getChildName(), (Object)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString()) ^ true) {
            return;
        }
        VirtualFile dir = this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.READ);
        VirtualFile virtualFile = event.getFile();
        if (Intrinsics.areEqual((Object)virtualFile, (Object)dir) ^ true) {
            return;
        }
        Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            VirtualFile virtualFile2 = virtualFile;
            String string = "DIR CREATED " + (virtualFile2 != null ? virtualFile2.getPath() : null);
            logger.debug(string, (Throwable)e$iv);
        }
        VirtualFile virtualFile3 = dir;
        Intrinsics.checkNotNull((Object)virtualFile3);
        VirtualFile[] virtualFileArray = virtualFile3.getChildren();
        int n = virtualFileArray.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile file2;
            VirtualFile virtualFile4 = file2 = virtualFileArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"file");
            if (!this.isMyFileWithoutParentCheck(virtualFile4)) continue;
            list2.add(new AddScheme(file2));
        }
    }

    public SchemeFileTracker(@NotNull SchemeManagerImpl<Object, Object> schemeManager2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.schemeManager = schemeManager2;
        this.project = project;
        this.applicator = new SchemeChangeApplicator(this.schemeManager);
    }
}

