/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeAddOrUpdateEvent;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicatorKt;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002\u001a&\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002\u001a3\u0010\u000b\u001a\u00020\u0005\"\b\b\u0000\u0010\f*\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010\r\u001a\u0002H\fH\u0000\u00a2\u0006\u0002\u0010\u000e\u001aI\u0010\u000f\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\f0\u00112\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\f0\tH\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u00a8\u0006\u0017"}, d2={"callSchemeContentChangedIfSupported", "", "changedScheme", "", "fileName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "findExternalizableSchemeByFileName", "getSchemeFileName", "T", "scheme", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Ljava/lang/Object;)Ljava/lang/String;", "readSchemeFromFile", "schemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/configurationStore/schemeManager/SchemeLoader;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Ljava/lang/Object;", "sortSchemeChangeEvents", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "inputEvents", "intellij.platform.configurationStore.impl"})
public final class SchemeChangeApplicatorKt {
    private static final Object findExternalizableSchemeByFileName(String fileName, SchemeManagerImpl<Object, Object> schemeManager2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = schemeManager2.getSchemes$intellij_platform_configurationStore_impl();
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)fileName, (Object)SchemeChangeApplicatorKt.getSchemeFileName(schemeManager2, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final <T> String getSchemeFileName(@NotNull SchemeManagerImpl<T, T> schemeManager2, @NotNull T scheme2) {
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        return schemeManager2.getFileName$intellij_platform_configurationStore_impl(scheme2) + schemeManager2.getSchemeExtension$intellij_platform_configurationStore_impl();
    }

    @Nullable
    public static final <T> T readSchemeFromFile(@NotNull VirtualFile file2, @NotNull SchemeLoader<T, T> schemeLoader, @NotNull SchemeManagerImpl<T, T> schemeManager2) {
        T t;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(schemeLoader, (String)"schemeLoader");
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        String fileName = string;
        if (file2.isDirectory() || !schemeManager2.canRead(fileName)) {
            return null;
        }
        boolean $i$f$catchAndLog = false;
        try {
            boolean bl = false;
            t = schemeLoader.loadScheme(fileName, null, file2.contentsToByteArray());
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
            Logger logger = ComponentStoreImplKt.getLOG();
            boolean bl = false;
            String string2 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            String string3 = string2;
            logger.error(stringBuilder.append(string3).toString(), e$iv);
            t = null;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<SchemeChangeEvent> sortSchemeChangeEvents(@NotNull Collection<? extends SchemeChangeEvent> inputEvents) {
        Intrinsics.checkNotNullParameter(inputEvents, (String)"inputEvents");
        if (inputEvents.size() < 2) {
            return inputEvents;
        }
        boolean isThereSomeRemoveEvent = false;
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026oryFootprintSet<String>()");
        Set existingAddOrUpdate = set2;
        Set set3 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"CollectionFactory.create\u2026oryFootprintSet<String>()");
        Set removedFileNames = set3;
        ArrayList<SchemeChangeEvent> result2 = new ArrayList<SchemeChangeEvent>(inputEvents);
        int n = result2.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i2;
            SchemeChangeEvent event = result2.get((int)i2);
            if (event instanceof RemoveAllSchemes) {
                void var8_10 = i2 - true;
                boolean bl2 = false;
                while (var8_10 >= 0) {
                    void j;
                    result2.remove((int)j);
                    --j;
                }
                break;
            }
            if (event instanceof SchemeAddOrUpdateEvent) {
                String fileName;
                Intrinsics.checkNotNullExpressionValue((Object)((SchemeAddOrUpdateEvent)((Object)event)).getFile().getName(), (String)"event.file.name");
                if (removedFileNames.contains(fileName)) {
                    result2.remove((int)i2);
                } else {
                    existingAddOrUpdate.add(fileName);
                }
            } else if (event instanceof RemoveScheme) {
                if (existingAddOrUpdate.contains(((RemoveScheme)event).getFileName())) {
                    result2.remove((int)i2);
                } else {
                    isThereSomeRemoveEvent = true;
                    removedFileNames.add(((RemoveScheme)event).getFileName());
                }
            }
            --i2;
        }
        sortSchemeChangeEvents.1 $fun$weight$1 = sortSchemeChangeEvents.1.INSTANCE;
        if (isThereSomeRemoveEvent) {
            CollectionsKt.sortWith((List)result2, (Comparator)sortSchemeChangeEvents.2.INSTANCE);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean callSchemeContentChangedIfSupported(Object changedScheme, String fileName, VirtualFile file2, SchemeManagerImpl<Object, Object> schemeManager2) {
        if (changedScheme == null || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof SchemeContentChangedHandler) || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor)) {
            return false;
        }
        ExternalInfo externalInfo = (ExternalInfo)schemeManager2.getSchemeToInfo$intellij_platform_configurationStore_impl().get(changedScheme);
        if (externalInfo == null) {
            return false;
        }
        ExternalInfo externalInfo2 = externalInfo;
        boolean $i$f$catchAndLog = false;
        try {
            void parser;
            void bytes$iv;
            boolean bl = false;
            byte[] bytes = file2.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            byte[] byArray = bytes;
            boolean isOldSchemeNaming$iv = schemeManager2.isOldSchemeNaming$intellij_platform_configurationStore_impl();
            boolean $i$f$lazyPreloadScheme = false;
            MXParser parser$iv = new MXParser();
            InputStream inputStream2 = bytes$iv;
            boolean bl2 = false;
            inputStream2 = new ByteArrayInputStream((byte[])inputStream2);
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            parser$iv.setInput((Reader)new InputStreamReader(inputStream2, charset));
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            boolean bl4 = false;
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(String it) {
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string = name;
            if (string == null) {
                LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
                String string2 = FileUtilRt.getNameWithoutExtension((String)fileName);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtilRt.getNameWithoutExtension(fileName)");
                string = lazySchemeProcessor.getSchemeKey(attributeProvider2, string2);
            }
            if (string == null) {
                throw (Throwable)SchemeManagerUtilKt.nameIsMissed(bytes);
            }
            String schemeName = string;
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(schemeManager2.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo2);
            SchemeProcessor schemeProcessor = schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeContentChangedHandler<kotlin.Any>");
            }
            ((SchemeContentChangedHandler)((Object)schemeProcessor)).schemeContentChanged(changedScheme, schemeName, dataHolder);
            return true;
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
            Logger logger = ComponentStoreImplKt.getLOG();
            boolean bl = false;
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String string3 = string;
            logger.error(stringBuilder.append(string3).toString(), e$iv);
            return false;
        }
    }

    public static final /* synthetic */ Object access$findExternalizableSchemeByFileName(String fileName, SchemeManagerImpl schemeManager2) {
        return SchemeChangeApplicatorKt.findExternalizableSchemeByFileName(fileName, schemeManager2);
    }

    public static final /* synthetic */ boolean access$callSchemeContentChangedIfSupported(Object changedScheme, String fileName, VirtualFile file2, SchemeManagerImpl schemeManager2) {
        return SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported(changedScheme, fileName, file2, schemeManager2);
    }
}

