/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ModuleStoreImpl;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/TestModuleStore;", "Lcom/intellij/configurationStore/ModuleStoreImpl;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "moduleComponentLoadPolicy", "setPath", "", "path", "Ljava/nio/file/Path;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isNew", "", "intellij.platform.configurationStore.impl"})
final class TestModuleStore
extends ModuleStoreImpl {
    private StateLoadPolicy moduleComponentLoadPolicy;

    @Override
    public void setPath(@NotNull Path path, @Nullable VirtualFile virtualFile, boolean isNew) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super.setPath(path, virtualFile, isNew);
        if (!isNew && PathKt.exists((Path)path)) {
            this.moduleComponentLoadPolicy = StateLoadPolicy.LOAD;
        }
    }

    @Override
    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        StateLoadPolicy stateLoadPolicy = this.moduleComponentLoadPolicy;
        if (stateLoadPolicy == null) {
            Project project = this.getProject();
            if (project == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.project.ProjectStoreOwner");
            }
            IProjectStore iProjectStore = ((ProjectStoreOwner)project).getComponentStore();
            if (iProjectStore == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            stateLoadPolicy = ((ComponentStoreImpl)((Object)iProjectStore)).getLoadPolicy();
        }
        return stateLoadPolicy;
    }

    public TestModuleStore(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(module);
    }
}

