/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/RestoreDefaultSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmRestoreSettings", "", "backupPath", "Ljava/nio/file/Path;", "intellij.platform.configurationStore.impl"})
final class RestoreDefaultSettingsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir()");
        if (!this.confirmRestoreSettings(e, ConfigBackup.Companion.getNextBackupPath(path))) {
            return;
        }
        CustomConfigMigrationOption.StartWithCleanConfig.INSTANCE.writeConfigMarkerFile();
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(){

            public final void run() {
                boolean bl = false;
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                }
                ((ApplicationEx)application).restart(true);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
    }

    private final boolean confirmRestoreSettings(AnActionEvent e, Path backupPath) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        String string = application.isRestartCapable() ? ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.restart", new Object[0]) : ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.shutdown", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (ApplicationManager.g\u2026rmation.button.shutdown\")");
        String restartButtonText = string;
        return Messages.showYesNoDialog((Project)e.getProject(), (String)ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", backupPath), (String)ConfigurationStoreBundle.message("restore.default.settings.confirmation.title", new Object[0]), (String)restartButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0;
    }
}

