/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DirectoryBasedSaveSessionProducer;
import com.intellij.configurationStore.DirectoryBasedStorageBase;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0017\u0010\u0017\u001a\u00020\u00142\b\u0010\u0002\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorageBase;", "dir", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/PathMacroSubstitutor;)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDir", "()Ljava/nio/file/Path;", "isUseVfsForWrite", "", "()Z", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "getVirtualFile", "setStorageData", "", "newStates", "Lcom/intellij/configurationStore/StateMap;", "setVirtualDir", "setVirtualDir$intellij_platform_configurationStore_impl", "toString", "", "MySaveSession", "intellij.platform.configurationStore.impl"})
public class DirectoryBasedStorage
extends DirectoryBasedStorageBase {
    private volatile VirtualFile cachedVirtualFile;
    @NotNull
    private final Path dir;

    @Override
    public boolean isUseVfsForWrite() {
        return true;
    }

    private final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            this.cachedVirtualFile = result2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.getDir());
        }
        return result2;
    }

    public final void setVirtualDir$intellij_platform_configurationStore_impl(@Nullable VirtualFile dir) {
        this.cachedVirtualFile = dir;
    }

    @Override
    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : (SaveSessionProducer)new MySaveSession(this, (StateMap)this.getStorageData());
    }

    private final void setStorageData(StateMap newStates) {
        this.getStorageDataRef().set(newStates);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(dir=" + this.getDir() + ", componentName=" + this.getComponentName() + ')';
    }

    @Override
    @NotNull
    protected Path getDir() {
        return this.dir;
    }

    public DirectoryBasedStorage(@NotNull Path dir, @NotNull StateSplitter splitter, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)splitter, (String)"splitter");
        super(splitter, pathMacroSubstitutor);
        this.dir = dir;
    }

    public /* synthetic */ DirectoryBasedStorage(Path path, StateSplitter stateSplitter, PathMacroSubstitutor pathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        this(path, stateSplitter, pathMacroSubstitutor);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000ej\b\u0012\u0004\u0012\u00020\u000b`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage$MySaveSession;", "Lcom/intellij/configurationStore/SaveSessionBase;", "Lcom/intellij/configurationStore/SaveSession;", "Lcom/intellij/configurationStore/DirectoryBasedSaveSessionProducer;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "dirtyFileNames", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "isSomeFileRemoved", "", "createSaveSession", "deleteFiles", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSetState", "fileName", "subState", "Lorg/jdom/Element;", "removeFileData", "save", "saveStates", "states", "setFileState", "componentName", "element", "setSerializedState", "intellij.platform.configurationStore.impl"})
    private static final class MySaveSession
    extends SaveSessionBase
    implements SaveSession,
    DirectoryBasedSaveSessionProducer {
        private Map<String, Object> copiedStorageData;
        private final HashSet<String> dirtyFileNames;
        private boolean isSomeFileRemoved;
        private final DirectoryBasedStorage storage;
        private final StateMap originalStates;

        @Override
        public void setSerializedState(@NotNull String componentName, @Nullable Element element2) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            this.storage.setComponentName(componentName);
            if (JdomKt.isEmpty((Element)element2)) {
                list2 = CollectionsKt.emptyList();
            } else {
                StateSplitter stateSplitter = this.storage.getSplitter();
                Element element3 = element2;
                Intrinsics.checkNotNull((Object)element3);
                List list3 = stateSplitter.splitState(element3);
                list2 = list3;
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"storage.splitter.splitState(element!!)");
            }
            List stateAndFileNameList = list2;
            if (stateAndFileNameList.isEmpty()) {
                if (this.copiedStorageData != null) {
                    Map<String, Object> map2 = this.copiedStorageData;
                    Intrinsics.checkNotNull(map2);
                    map2.clear();
                } else if (!this.originalStates.isEmpty()) {
                    this.copiedStorageData = new HashMap();
                }
                return;
            }
            HashSet<Object> existingFiles = new HashSet<Object>(stateAndFileNameList.size());
            for (com.intellij.openapi.util.Pair pair : stateAndFileNameList) {
                Object object = pair.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
                String string = (String)object;
                Object object2 = pair.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pair.first");
                this.doSetState(string, (Element)object2);
                existingFiles.add(pair.second);
            }
            for (String key : this.originalStates.keys()) {
                if (existingFiles.contains(key)) continue;
                this.removeFileData(key);
            }
        }

        @Override
        public void setFileState(@NotNull String fileName, @NotNull String componentName, @Nullable Element element2) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            this.storage.setComponentName(componentName);
            if (element2 != null) {
                this.doSetState(fileName, element2);
            } else {
                this.removeFileData(fileName);
            }
        }

        private final void removeFileData(String fileName) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = this.originalStates.toMutableMap();
            }
            this.isSomeFileRemoved = true;
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            map2.remove(fileName);
        }

        private final void doSetState(String fileName, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeeded$default(fileName, subState, this.originalStates, null, 8, null);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add(fileName);
                }
            } else {
                Map<String, Object> map2 = this.copiedStorageData;
                Intrinsics.checkNotNull(map2);
                if (StateMapKt.updateState$default(map2, fileName, subState, null, 8, null)) {
                    this.dirtyFileNames.add(fileName);
                }
            }
        }

        @Nullable
        public MySaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? null : this;
        }

        public void save() {
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            StateMap stateMap = StateMap.Companion.fromMap(map2);
            Map<String, Object> map3 = this.copiedStorageData;
            Intrinsics.checkNotNull(map3);
            if (map3.isEmpty()) {
                VirtualFile dir = this.storage.getVirtualFile();
                if (dir != null && dir.exists()) {
                    dir.delete((Object)this);
                }
                this.storage.setStorageData(stateMap);
                return;
            }
            Collection dir = this.dirtyFileNames;
            boolean bl = false;
            if (!dir.isEmpty()) {
                this.saveStates(stateMap);
            }
            if (this.isSomeFileRemoved && (dir = this.storage.getVirtualFile()) != null && dir.exists()) {
                this.deleteFiles((VirtualFile)dir);
            }
            this.storage.setStorageData(stateMap);
        }

        private final void saveStates(StateMap states) {
            VirtualFile dir = this.storage.cachedVirtualFile;
            for (String fileName : states.keys()) {
                if (!this.dirtyFileNames.contains(fileName)) continue;
                if (StateMap.getElement$default(states, fileName, null, 2, null) == null) {
                    continue;
                }
                if (!(dir != null && dir.exists() || (dir = this.storage.getVirtualFile()) != null && dir.exists())) {
                    dir = SchemeLoaderKt.createDir(this.storage.getDir(), (StorageManagerFileWriteRequestor)this);
                    this.storage.cachedVirtualFile = dir;
                }
                try {
                    Element element2;
                    PathMacroManager pathMacroManager;
                    VirtualFile file2 = SchemeLoaderKt.getOrCreateChild(dir, fileName, (StorageManagerFileWriteRequestor)this);
                    if (this.storage.getPathMacroSubstitutor() == null) {
                        pathMacroManager = null;
                    } else {
                        PathMacroSubstitutor pathMacroSubstitutor = this.storage.getPathMacroSubstitutor();
                        if (pathMacroSubstitutor == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl");
                        }
                        pathMacroManager = ((TrackingPathMacroSubstitutorImpl)pathMacroSubstitutor).getMacroManager$intellij_platform_configurationStore_impl();
                    }
                    PathMacroManager macroManager = pathMacroManager;
                    List list2 = CollectionsKt.listOf((Object)element2);
                    String string = this.storage.getComponentName();
                    Intrinsics.checkNotNull((Object)string);
                    Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)string));
                    String string2 = dir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dir.path");
                    XmlDataWriter xmlDataWriter = new XmlDataWriter("component", list2, map2, macroManager, string2);
                    StorageManagerFileWriteRequestor storageManagerFileWriteRequestor = (StorageManagerFileWriteRequestor)this;
                    DataWriter dataWriter = xmlDataWriter;
                    LineSeparator lineSeparator = DirectoryBasedStorageKt.access$getOrDetectLineSeparator(file2);
                    if (lineSeparator == null) {
                        LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
                        lineSeparator = lineSeparator2;
                        Intrinsics.checkNotNullExpressionValue((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
                    }
                    FileBasedStorageKt.writeFile(null, storageManagerFileWriteRequestor, file2, dataWriter, lineSeparator, false);
                }
                catch (IOException e) {
                    ComponentStoreImplKt.getLOG().error((Throwable)e);
                }
            }
        }

        private final void deleteFiles(VirtualFile dir) {
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            Map<String, Object> copiedStorageData = map2;
            VirtualFile[] virtualFileArray = dir.getChildren();
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                String fileName;
                VirtualFile file2;
                VirtualFile virtualFile = file2 = virtualFileArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getName(), (String)"file.name");
                if (!StringsKt.endsWith$default((String)fileName, (String)".xml", (boolean)false, (int)2, null) || copiedStorageData.containsKey(fileName)) continue;
                if (file2.isWritable()) {
                    file2.delete((Object)this);
                    continue;
                }
                throw (Throwable)new ReadOnlyModificationException(file2, null);
            }
        }

        public MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull StateMap originalStates) {
            Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)originalStates, (String)"originalStates");
            this.storage = storage2;
            this.originalStates = originalStates;
            this.dirtyFileNames = new HashSet();
        }
    }
}

