/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import java.io.OutputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/DigestOutputStream;", "Ljava/io/OutputStream;", "digest", "Ljava/security/MessageDigest;", "(Ljava/security/MessageDigest;)V", "", "toString", "", "write", "", "b", "off", "", "len", "intellij.platform.projectModel.impl"})
final class DigestOutputStream
extends OutputStream {
    private final MessageDigest digest;

    @Override
    public void write(int b) {
        this.digest.update((byte)b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.digest.update(b, off, len);
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.digest.update(b);
    }

    @NotNull
    public String toString() {
        return "[Digest Output Stream] " + this.digest;
    }

    @NotNull
    public final byte[] digest() {
        byte[] byArray = this.digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return byArray;
    }

    public DigestOutputStream(@NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        this.digest = digest;
    }
}

