/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.targets;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.AsyncInspectionToolResultWriter;
import com.intellij.codeInspection.InspectionApplication;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ReportConverterUtil;
import com.intellij.codeInspection.targets.QodanaConfig;
import com.intellij.codeInspection.targets.QodanaKt;
import com.intellij.codeInspection.targets.QodanaKt$sam$java_lang_Runnable$0;
import com.intellij.codeInspection.targets.QodanaRunner;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J.\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0006\u00102\u001a\u000203J \u00104\u001a\u0002032\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lcom/intellij/codeInspection/targets/QodanaRunner;", "", "application", "Lcom/intellij/codeInspection/InspectionApplication;", "projectPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "baseProfile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "scope", "Lcom/intellij/analysis/AnalysisScope;", "(Lcom/intellij/codeInspection/InspectionApplication;Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionProfileImpl;Lcom/intellij/analysis/AnalysisScope;)V", "getApplication", "()Lcom/intellij/codeInspection/InspectionApplication;", "getBaseProfile", "()Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "config", "Lcom/intellij/codeInspection/targets/QodanaConfig;", "getConfig", "()Lcom/intellij/codeInspection/targets/QodanaConfig;", "inspectionCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInspectionCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "getMacroManager", "()Lcom/intellij/openapi/components/PathMacroManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProjectPath", "()Ljava/nio/file/Path;", "getScope", "()Lcom/intellij/analysis/AnalysisScope;", "createProgressIndicator", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "launch", "", "converter", "Lcom/intellij/codeInspection/InspectionsReportConverter;", "launchInspections", "", "launchScope", "resultsPath", "context", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextEx;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "run", "", "writeProfile", "profile", "outPath", "intellij.platform.inspect"})
public final class QodanaRunner {
    @NotNull
    private final AtomicInteger inspectionCounter;
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final QodanaConfig config;
    @NotNull
    private final InspectionApplication application;
    @NotNull
    private final Path projectPath;
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionProfileImpl baseProfile;
    @NotNull
    private final AnalysisScope scope;

    @NotNull
    public final AtomicInteger getInspectionCounter() {
        return this.inspectionCounter;
    }

    @NotNull
    public final PathMacroManager getMacroManager() {
        return this.macroManager;
    }

    @NotNull
    public final QodanaConfig getConfig() {
        return this.config;
    }

    public final void run() {
        int n;
        InspectionsReportConverter converter = ReportConverterUtil.getReportConverter(this.application.myOutputFormat);
        if (converter == null) {
            QodanaKt.access$getLOG$p().error("Can't find converter " + this.application.myOutputFormat);
            return;
        }
        Path outPath = Paths.get(this.application.myOutPath, new String[0]);
        QodanaKt.writeDescriptions(this.application, this.baseProfile, converter);
        Path path = outPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outPath");
        this.writeProfile(this.baseProfile, path, this.project);
        if (!this.launch(converter)) {
            this.application.reportMessage(1, "Inspection run was stopped cause it's reached threshold: " + this.config.getStopThreshold() + ". Problems count: " + this.inspectionCounter.get());
        }
        if (0 <= (n = this.config.getFailThreshold()) && this.inspectionCounter.get() > n) {
            this.application.reportMessage(1, "Inspection run is terminating with exit code 255 cause it's reached fail threshold: " + this.config.getFailThreshold() + ". Problems count: " + this.inspectionCounter.get());
            n = 255;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeProfile(InspectionProfileImpl profile, Path outPath, Project project) {
        profile.initInspectionTools(project);
        Element profileElement = new Element("profile");
        profile.writeExternal(profileElement);
        profileElement.setAttribute("version", "1.0");
        Element rootElement = new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(profileElement);
        Path path = outPath.resolve("profile.xml");
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"Files.newBufferedWriter(\u2026_EXISTING, CREATE, WRITE)");
        Writer writer = bufferedWriter;
        Closeable closeable = writer;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Writer it = (Writer)closeable;
            boolean bl3 = false;
            Element element2 = rootElement;
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"rootElement");
            JbXmlOutputter.Companion.collapseMacrosAndWrite(element2, (ComponentManager)project, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean launch(@NotNull InspectionsReportConverter converter) {
        Path outputPath;
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        GlobalInspectionContextEx globalInspectionContextEx = this.application.createGlobalInspectionContext(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)globalInspectionContextEx), (String)"application.createGlobalInspectionContext(project)");
        GlobalInspectionContextEx context = globalInspectionContextEx;
        ProgressIndicatorBase progressIndicator = this.createProgressIndicator();
        Path path = outputPath = Paths.get(this.application.myOutPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputPath");
        AsyncInspectionToolResultWriter consumer2 = new AsyncInspectionToolResultWriter(this, progressIndicator, outputPath, path){
            final /* synthetic */ QodanaRunner this$0;
            final /* synthetic */ ProgressIndicatorBase $progressIndicator;
            final /* synthetic */ Path $outputPath;

            public void consume(@NotNull Element element2, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
                int count = this.this$0.getInspectionCounter().incrementAndGet();
                if (this.this$0.getConfig().isAboveStopThreshold(count)) {
                    this.$progressIndicator.cancel();
                }
                this.this$0.getMacroManager().collapsePathsRecursively(element2);
                super.consume(element2, toolWrapper);
            }
            {
                this.this$0 = this$0;
                this.$progressIndicator = $captured_local_variable$1;
                this.$outputPath = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        context.setProblemConsumer(consumer2);
        AnalysisScope afterScope = null;
        if (this.application.myAnalyzeChanges) {
            GlobalInspectionContextEx globalInspectionContextEx2 = this.application.createGlobalInspectionContext(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)globalInspectionContextEx2), (String)"application.createGlobalInspectionContext(project)");
            GlobalInspectionContextEx beforeContext = globalInspectionContextEx2;
            afterScope = this.application.runAnalysisOnCodeWithoutChanges(this.project, beforeContext, new Runnable(this, outputPath, beforeContext, progressIndicator){
                final /* synthetic */ QodanaRunner this$0;
                final /* synthetic */ Path $outputPath;
                final /* synthetic */ GlobalInspectionContextEx $beforeContext;
                final /* synthetic */ ProgressIndicatorBase $progressIndicator;

                public final void run() {
                    Path outPathBefore = this.$outputPath.resolve("before");
                    outPathBefore.toFile().mkdir();
                    AnalysisScope analysisScope = this.this$0.getScope();
                    Path path = outPathBefore;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outPathBefore");
                    QodanaRunner.access$launchInspections(this.this$0, analysisScope, path, this.$beforeContext, this.$progressIndicator);
                }
                {
                    this.this$0 = qodanaRunner;
                    this.$outputPath = path;
                    this.$beforeContext = globalInspectionContextEx;
                    this.$progressIndicator = progressIndicatorBase;
                }
            });
            this.application.setupSecondAnalysisHandler(this.project, context);
        }
        try {
            Collection<File> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AnalysisScope analysisScope = afterScope;
            if (analysisScope == null) {
                analysisScope = this.scope;
            }
            List<Path> syncResults = this.launchInspections(analysisScope, outputPath, context, progressIndicator);
            Iterable iterable = syncResults;
            Map map2 = MapsKt.emptyMap();
            String string = ((Object)outputPath).toString();
            String string2 = ((Object)outputPath).toString();
            InspectionsReportConverter inspectionsReportConverter = converter;
            boolean $i$f$map = false;
            void var10_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                File file2 = it.toFile();
                collection.add(file2);
            }
            collection = (List)destination$iv$iv;
            inspectionsReportConverter.convert(string2, string, map2, (List)collection);
        }
        finally {
            consumer2.close();
        }
        return !this.config.isAboveStopThreshold(this.inspectionCounter.get());
    }

    private final List<Path> launchInspections(AnalysisScope launchScope, Path resultsPath, GlobalInspectionContextEx context, ProgressIndicator progressIndicator) {
        Function0 inspectionProcess2;
        InspectionsReportConverter converter;
        this.application.configureProject(this.projectPath, this.project, launchScope);
        if (!GlobalInspectionContextUtil.canRunInspections(this.project, false, launchInspections.1.INSTANCE)) {
            this.application.gracefulExit();
            return CollectionsKt.emptyList();
        }
        InspectionsReportConverter inspectionsReportConverter = converter = ReportConverterUtil.getReportConverter(this.application.myOutputFormat);
        if (inspectionsReportConverter != null) {
            inspectionsReportConverter.projectData(this.project, resultsPath.resolve("projectStructure"));
        }
        boolean bl = false;
        List inspectionsResults = new ArrayList();
        Function0 function0 = inspectionProcess2 = (Function0)new Function0<Unit>(this, context, launchScope, resultsPath, inspectionsResults){
            final /* synthetic */ QodanaRunner this$0;
            final /* synthetic */ GlobalInspectionContextEx $context;
            final /* synthetic */ AnalysisScope $launchScope;
            final /* synthetic */ Path $resultsPath;
            final /* synthetic */ List $inspectionsResults;

            public final void invoke() {
                try {
                    this.$context.launchInspectionsOffline(this.$launchScope, this.$resultsPath, this.this$0.getApplication().myRunGlobalToolsOnly, this.$inspectionsResults);
                }
                catch (ProcessCanceledException e) {
                    QodanaKt.access$getLOG$p().warn("Inspection run was cancelled");
                }
            }
            {
                this.this$0 = qodanaRunner;
                this.$context = globalInspectionContextEx;
                this.$launchScope = analysisScope;
                this.$resultsPath = path;
                this.$inspectionsResults = list2;
                super(0);
            }
        };
        ProgressManager.getInstance().runProcess((Runnable)new QodanaKt$sam$java_lang_Runnable$0(function0), progressIndicator);
        return inspectionsResults;
    }

    private final ProgressIndicatorBase createProgressIndicator() {
        return new ProgressIndicatorBase(this){
            private int myLastPercent;
            final /* synthetic */ QodanaRunner this$0;

            public void setText(@Nullable String text2) {
                if (text2 == null) {
                    return;
                }
                if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                    int percent = (int)(this.getFraction() * (double)100);
                    if (this.myLastPercent == percent) {
                        return;
                    }
                    String prefix = InspectionApplication.getPrefix(text2);
                    this.myLastPercent = percent;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = prefix;
                    if (string == null) {
                        String string2 = InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0]);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"InspectionsBundle.messag\u2026inspection.display.name\")");
                    }
                    String msg = stringBuilder.append(string).append(" ").append(percent).append("%").toString();
                    this.this$0.getApplication().reportMessage(2, msg);
                }
            }
            {
                this.this$0 = this$0;
                this.myLastPercent = -1;
                this.setText("");
            }
        };
    }

    @NotNull
    public final InspectionApplication getApplication() {
        return this.application;
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionProfileImpl getBaseProfile() {
        return this.baseProfile;
    }

    @NotNull
    public final AnalysisScope getScope() {
        return this.scope;
    }

    public QodanaRunner(@NotNull InspectionApplication application, @NotNull Path projectPath, @NotNull Project project, @NotNull InspectionProfileImpl baseProfile, @NotNull AnalysisScope scope) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseProfile, (String)"baseProfile");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.application = application;
        this.projectPath = projectPath;
        this.project = project;
        this.baseProfile = baseProfile;
        this.scope = scope;
        this.inspectionCounter = new AtomicInteger();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
        this.macroManager = pathMacroManager;
        QodanaConfig qodanaConfig = this.application.myQodanaConfig;
        Intrinsics.checkNotNullExpressionValue((Object)qodanaConfig, (String)"application.myQodanaConfig");
        this.config = qodanaConfig;
    }

    public static final /* synthetic */ List access$launchInspections(QodanaRunner $this, AnalysisScope launchScope, Path resultsPath, GlobalInspectionContextEx context, ProgressIndicator progressIndicator) {
        return $this.launchInspections(launchScope, resultsPath, context, progressIndicator);
    }
}

