/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class HTMLExportUtil {
    public static void writeFile(@NotNull Path dir, @NotNull String fileName, @NotNull Project project, @NotNull ThrowableConsumer<? super Writer, ? extends IOException> writerConsumer) {
        if (dir == null) {
            HTMLExportUtil.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            HTMLExportUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            HTMLExportUtil.$$$reportNull$$$0(2);
        }
        if (writerConsumer == null) {
            HTMLExportUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        Path fullPath = dir.resolve(fileName);
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message((String)"inspection.export.generating.html.for", (Object[])new Object[]{fullPath.toString()}));
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            HTMLExportUtil.showErrorMessage("Can't create dir", dir, project);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(fullPath, new OpenOption[0]);){
            writerConsumer.consume((Object)writer);
        }
        catch (AccessDeniedException e) {
            HTMLExportUtil.showErrorMessage("Permission denied", fullPath, project);
        }
        catch (IOException e) {
            HTMLExportUtil.showErrorMessage(String.valueOf(e.getCause()), fullPath, project);
        }
    }

    private static void showErrorMessage(@NotNull String message2, @NotNull Path file2, @NotNull Project project) {
        if (message2 == null) {
            HTMLExportUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            HTMLExportUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            HTMLExportUtil.$$$reportNull$$$0(6);
        }
        Runnable showError2 = () -> Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{file2.toString(), message2}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        ApplicationManager.getApplication().invokeLater(showError2, ModalityState.NON_MODAL);
        throw new ProcessCanceledException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writerConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/export/HTMLExportUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

