/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase
implements DataProvider {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);
    private final String myPredefinedText;

    public RunInspectionAction() {
        this(null);
    }

    public RunInspectionAction(String predefinedText) {
        this.myPredefinedText = predefinedText;
        this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RunInspectionAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        final PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        final VirtualFile[] virtualFiles = (VirtualFile[])ObjectUtils.notNull((Object)((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)), (Object)VirtualFile.EMPTY_ARRAY);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model2 = new GotoInspectionModel(project);
        this.showNavigationPopup(e, model2, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                popup2.setSearchInAnyPlace(true);
                return super.createFilter(popup2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element2) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project, ((InspectionElement)element2).getToolWrapper().getShortName(), virtualFiles, psiElement, psiFile));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
            }
        }, false);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            RunInspectionAction.$$$reportNull$$$0(1);
        }
        return PlatformDataKeys.PREDEFINED_TEXT.is(dataId) ? this.myPredefinedText : null;
    }

    public static void runInspection(@NotNull Project project, @NotNull String shortName, @Nullable VirtualFile virtualFile, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        VirtualFile[] virtualFileArray;
        if (project == null) {
            RunInspectionAction.$$$reportNull$$$0(2);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        RunInspectionAction.runInspection(project, shortName, virtualFileArray, psiElement, psiFile);
    }

    public static void runInspection(final @NotNull Project project, @NotNull String shortName, VirtualFile @NotNull [] virtualFiles, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        if (project == null) {
            RunInspectionAction.$$$reportNull$$$0(4);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(5);
        }
        if (virtualFiles == null) {
            RunInspectionAction.$$$reportNull$$$0(6);
        }
        PsiElement element2 = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element2 != null ? currentProfile.getInspectionTool(shortName, element2) : currentProfile.getInspectionTool(shortName, project);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Module module = RunInspectionAction.findModuleForFiles(project, virtualFiles);
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFiles.length == 1 && virtualFiles[0].isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFiles.length != 0) {
                analysisScope = new AnalysisScope(project, (Collection)ContainerUtil.newHashSet((Object[])virtualFiles));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project);
            }
        }
        AnalysisUIOptions options2 = AnalysisUIOptions.getInstance(project);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options2);
        final AnalysisScope initialAnalysisScope = analysisScope;
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, analysisScope, module, psiElement);
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog(IdeBundle.message((String)"goto.inspection.action.dialog.title", (Object[])new Object[]{toolWrapper.getDisplayName()}), CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, items, options2, true){
            private InspectionToolWrapper<?, ?> myUpdatedSettingsToolWrapper;

            @Override
            @NotNull
            protected JComponent getAdditionalActionSettings(Project project2) {
                JPanel panel2 = new JPanel(new GridBagLayout());
                boolean hasOptionsPanel = toolWrapper.getTool().createOptionsPanel() != null;
                GridBagConstraints constraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, hasOptionsPanel ? 0.0 : 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0);
                panel2.add((Component)fileFilterPanel.getPanel(), constraints2);
                if (hasOptionsPanel) {
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    JComponent optionsPanel = this.myUpdatedSettingsToolWrapper.getTool().createOptionsPanel();
                    LOGGER.assertTrue(optionsPanel != null);
                    TitledSeparator separator = new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0]));
                    separator.setBorder((Border)JBUI.Borders.empty());
                    ++constraints2.gridy;
                    panel2.add((Component)separator, constraints2);
                    optionsPanel.setBorder(InspectionUiUtilKt.getBordersForOptions(optionsPanel));
                    ++constraints2.gridy;
                    constraints2.weighty = 1.0;
                    panel2.add((Component)InspectionUiUtilKt.addScrollPaneIfNecessary(optionsPanel), constraints2);
                }
                JPanel jPanel2 = panel2;
                if (jPanel2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel2;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
                if (defaultScope == null) {
                    2.$$$reportNull$$$0(1);
                }
                AnalysisScope scope = super.getScope(defaultScope);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    2.$$$reportNull$$$0(3);
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(initialAnalysisScope);
            }

            private InspectionToolWrapper<?, ?> getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            protected Action @NotNull [] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? CodeInsightBundle.message((String)"action.analyze.verb", (Object[])new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(arg0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnalysisScope scope = this.getScope();
                        InspectionToolWrapper<?, ?> wrapper2 = this.getToolWrapper();
                        DumbService.getInstance((Project)project).smartInvokeLater(() -> RunInspectionIntention.rerunInspection(wrapper2, managerEx, scope, null));
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction(IdeBundle.message((String)"goto.inspection.action.fix.all", (Object[])new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper<?, ?> wrapper2 = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper2, managerEx, null);
                            managerEx.createNewGlobalContext().codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper2.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[0]);
                if (actionArray == null) {
                    2.$$$reportNull$$$0(4);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalActionSettings";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getScope";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        dialog2.setShowInspectInjectedCode(true);
        dialog2.showAndGet();
    }

    @Nullable
    private static Module findModuleForFiles(@NotNull Project project, VirtualFile @NotNull [] files2) {
        if (project == null) {
            RunInspectionAction.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            RunInspectionAction.$$$reportNull$$$0(8);
        }
        Set modules2 = ContainerUtil.map2Set((Object[])files2, f -> ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)project));
        return (Module)ContainerUtil.getFirstItem((Collection)modules2);
    }

    private static InspectionToolWrapper<?, ?> copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            RunInspectionAction.$$$reportNull$$$0(9);
        }
        Element options2 = new Element("copy");
        tool.getTool().writeSettings(options2);
        InspectionToolWrapper copiedTool = tool.createCopy();
        copiedTool.getTool().readSettings(options2);
        return copiedTool;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "gotoActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleForFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToolWithSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

