/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtilCore;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuppressionUtil
extends SuppressionUtilCore {
    @NonNls
    public static final String FILE_PREFIX = "file:";
    @NonNls
    public static final String COMMON_SUPPRESS_REGEXP = "\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*";
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("//\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*.*");
    public static final Pattern SUPPRESS_IN_FILE_LINE_COMMENT_PATTERN = Pattern.compile("//file:\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*.*");
    @NonNls
    public static final String ALL = "ALL";

    private SuppressionUtil() {
    }

    public static boolean isInspectionToolIdMentioned(@NotNull String inspectionsList, @NotNull String inspectionToolID) {
        if (inspectionsList == null) {
            SuppressionUtil.$$$reportNull$$$0(0);
        }
        if (inspectionToolID == null) {
            SuppressionUtil.$$$reportNull$$$0(1);
        }
        Iterable ids = StringUtil.tokenize((String)inspectionsList, (String)"[, ]");
        for (String id2 : ids) {
            @NonNls String trim = id2.trim();
            if (!trim.equals(inspectionToolID) && !trim.equalsIgnoreCase(ALL)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (place == null) {
            SuppressionUtil.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            SuppressionUtil.$$$reportNull$$$0(3);
        }
        if (statementClass == null) {
            SuppressionUtil.$$$reportNull$$$0(4);
        }
        return SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass, SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass, @NotNull Pattern suppressInLineCommentPattern) {
        String text2;
        Matcher matcher;
        PsiElement prev2;
        PsiElement statement;
        if (place == null) {
            SuppressionUtil.$$$reportNull$$$0(5);
        }
        if (toolId == null) {
            SuppressionUtil.$$$reportNull$$$0(6);
        }
        if (statementClass == null) {
            SuppressionUtil.$$$reportNull$$$0(7);
        }
        if (suppressInLineCommentPattern == null) {
            SuppressionUtil.$$$reportNull$$$0(8);
        }
        if ((statement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{statementClass})) != null && (prev2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement)) instanceof PsiComment && (matcher = suppressInLineCommentPattern.matcher(text2 = prev2.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned(matcher.group(1), toolId)) {
            return prev2;
        }
        return null;
    }

    public static boolean isSuppressedInStatement(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (place == null) {
            SuppressionUtil.$$$reportNull$$$0(9);
        }
        if (toolId == null) {
            SuppressionUtil.$$$reportNull$$$0(10);
        }
        if (statementClass == null) {
            SuppressionUtil.$$$reportNull$$$0(11);
        }
        return ReadAction.compute(() -> SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass)) != null;
    }

    @NotNull
    public static PsiComment createComment(@NotNull Project project, @NotNull String commentText, @NotNull Language language) {
        if (project == null) {
            SuppressionUtil.$$$reportNull$$$0(12);
        }
        if (commentText == null) {
            SuppressionUtil.$$$reportNull$$$0(13);
        }
        if (language == null) {
            SuppressionUtil.$$$reportNull$$$0(14);
        }
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        PsiComment psiComment = parserFacade.createLineOrBlockCommentFromText(language, commentText);
        if (psiComment == null) {
            SuppressionUtil.$$$reportNull$$$0(15);
        }
        return psiComment;
    }

    @Nullable
    private static Couple<String> getBlockPrefixSuffixPair(@NotNull PsiElement comment) {
        Commenter commenter;
        if (comment == null) {
            SuppressionUtil.$$$reportNull$$$0(16);
        }
        if ((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage())) != null) {
            String prefix = commenter.getBlockCommentPrefix();
            String suffix = commenter.getBlockCommentSuffix();
            if (prefix != null || suffix != null) {
                return Couple.of((Object)StringUtil.notNullize((String)prefix), (Object)StringUtil.notNullize((String)suffix));
            }
        }
        return null;
    }

    @Nullable
    public static String getLineCommentPrefix(@NotNull PsiElement comment) {
        Commenter commenter;
        if (comment == null) {
            SuppressionUtil.$$$reportNull$$$0(17);
        }
        return (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage())) == null ? null : commenter.getLineCommentPrefix();
    }

    public static boolean isSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            SuppressionUtil.$$$reportNull$$$0(18);
        }
        String prefix = SuppressionUtil.getLineCommentPrefix(comment);
        String commentText = comment.getText();
        if (prefix != null) {
            return SuppressionUtil.startsWithSuppressionTag(commentText, prefix);
        }
        Couple<String> prefixSuffixPair = SuppressionUtil.getBlockPrefixSuffixPair(comment);
        return prefixSuffixPair != null && SuppressionUtil.startsWithSuppressionTag(commentText, (String)prefixSuffixPair.first) && commentText.endsWith((String)prefixSuffixPair.second);
    }

    private static boolean startsWithSuppressionTag(String commentText, String prefix) {
        if (!commentText.startsWith(prefix)) {
            return false;
        }
        int index2 = CharArrayUtil.shiftForward((CharSequence)commentText, (int)prefix.length(), (String)" ");
        return index2 < commentText.length() && commentText.startsWith("noinspection", index2);
    }

    public static void replaceSuppressionComment(@NotNull PsiElement comment, @NotNull String id2, boolean replaceOtherSuppressionIds, @NotNull Language commentLanguage) {
        if (comment == null) {
            SuppressionUtil.$$$reportNull$$$0(19);
        }
        if (id2 == null) {
            SuppressionUtil.$$$reportNull$$$0(20);
        }
        if (commentLanguage == null) {
            SuppressionUtil.$$$reportNull$$$0(21);
        }
        String oldSuppressionCommentText = comment.getText();
        String lineCommentPrefix = SuppressionUtil.getLineCommentPrefix(comment);
        Couple<String> blockPrefixSuffix = null;
        if (lineCommentPrefix == null) {
            blockPrefixSuffix = SuppressionUtil.getBlockPrefixSuffixPair(comment);
        }
        assert (blockPrefixSuffix != null && oldSuppressionCommentText.startsWith((String)blockPrefixSuffix.first) && oldSuppressionCommentText.endsWith((String)blockPrefixSuffix.second) || lineCommentPrefix != null && oldSuppressionCommentText.startsWith(lineCommentPrefix)) : "Unexpected suppression comment " + oldSuppressionCommentText;
        String newText = replaceOtherSuppressionIds ? "noinspection " + id2 : (lineCommentPrefix == null ? oldSuppressionCommentText.substring(((String)blockPrefixSuffix.first).length(), oldSuppressionCommentText.length() - ((String)blockPrefixSuffix.second).length()) + "," + id2 : oldSuppressionCommentText.substring(lineCommentPrefix.length()) + "," + id2);
        comment.replace((PsiElement)SuppressionUtil.createComment(comment.getProject(), newText, commentLanguage));
    }

    public static void createSuppression(@NotNull Project project, @NotNull PsiElement container, @NotNull String id2, @NotNull Language commentLanguage) {
        if (project == null) {
            SuppressionUtil.$$$reportNull$$$0(22);
        }
        if (container == null) {
            SuppressionUtil.$$$reportNull$$$0(23);
        }
        if (id2 == null) {
            SuppressionUtil.$$$reportNull$$$0(24);
        }
        if (commentLanguage == null) {
            SuppressionUtil.$$$reportNull$$$0(25);
        }
        String text2 = "noinspection " + id2;
        PsiComment comment = SuppressionUtil.createComment(project, text2, commentLanguage);
        container.getParent().addBefore((PsiElement)comment, container);
    }

    public static boolean isSuppressed(@NotNull PsiElement psiElement, @NotNull String id2) {
        if (psiElement == null) {
            SuppressionUtil.$$$reportNull$$$0(26);
        }
        if (id2 == null) {
            SuppressionUtil.$$$reportNull$$$0(27);
        }
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            if (factory2.isToCheckMember(psiElement, id2)) continue;
            return true;
        }
        return false;
    }

    public static boolean inspectionResultSuppressed(@NotNull PsiElement place, @NotNull LocalInspectionTool tool) {
        if (place == null) {
            SuppressionUtil.$$$reportNull$$$0(28);
        }
        if (tool == null) {
            SuppressionUtil.$$$reportNull$$$0(29);
        }
        return SuppressionUtil.inspectionResultSuppressed(place, (InspectionProfileEntry)tool);
    }

    public static boolean inspectionResultSuppressed(@NotNull PsiElement place, @NotNull InspectionProfileEntry tool) {
        if (place == null) {
            SuppressionUtil.$$$reportNull$$$0(30);
        }
        if (tool == null) {
            SuppressionUtil.$$$reportNull$$$0(31);
        }
        return tool.isSuppressedFor(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolID";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressInLineCommentPattern";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuppressionUtil";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLanguage";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuppressionUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInspectionToolIdMentioned";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStatementToolSuppressedIn";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createComment";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBlockPrefixSuffixPair";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressionComment";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceSuppressionComment";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "inspectionResultSuppressed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

